/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerFactory;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerImpl;
import be.iminds.ilabt.jfed.highlevel.jobs.JobFactory;
import be.iminds.ilabt.jfed.highlevel.util.SliceRegistryUtil;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedCorePreferences;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ExperimentControllerFactoryImpl
implements ExperimentControllerFactory {
    private final JobFactory jobFactory;
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final JFedCorePreferences jFedPreferences;
    private final GeniUserProvider geniUserProvider;
    private final SliceRegistryUtil sliceRegistryUtil;

    @Inject
    public ExperimentControllerFactoryImpl(JobFactory jobFactory, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, JFedCorePreferences jFedPreferences, GeniUserProvider geniUserProvider, SliceRegistryUtil sliceRegistryUtil) {
        this.jobFactory = jobFactory;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.jFedPreferences = jFedPreferences;
        this.geniUserProvider = geniUserProvider;
        this.sliceRegistryUtil = sliceRegistryUtil;
    }

    @Override
    public ExperimentController createExperimentController(Experiment experiment) {
        return new ExperimentControllerImpl(experiment, this.jobFactory, this.testbedInfoSource, this.authorityFinder, this.jFedPreferences, this.geniUserProvider, this.sliceRegistryUtil);
    }
}

