/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.SshConnectionPool;
import be.iminds.ilabt.jfed.highlevel.util.ProxyServiceUtil;
import be.iminds.ilabt.jfed.highlevel.util.ProxySocketFactoryProvider;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import java.util.Map;
import java.util.WeakHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SshConnectionPoolFactory {
    private final Map<Experiment, SshConnectionPool> connectionPoolMap = new WeakHashMap<Experiment, SshConnectionPool>();
    private final GeniUserProvider geniUserProvider;
    private final ProxySocketFactoryProvider proxySocketFactoryProvider;
    private final ProxyPreferencesManager proxyPreferencesManager;
    private final ProxyServiceUtil proxyServiceUtil;

    @Inject
    SshConnectionPoolFactory(GeniUserProvider geniUserProvider, ProxySocketFactoryProvider proxySocketFactoryProvider, ProxyPreferencesManager proxyPreferencesManager, ProxyServiceUtil proxyServiceUtil) {
        this.geniUserProvider = geniUserProvider;
        this.proxySocketFactoryProvider = proxySocketFactoryProvider;
        this.proxyPreferencesManager = proxyPreferencesManager;
        this.proxyServiceUtil = proxyServiceUtil;
    }

    public SshConnectionPool getSshConnectionPool(Experiment experiment) {
        return this.connectionPoolMap.computeIfAbsent(experiment, exp -> new SshConnectionPool((Experiment)exp, this.geniUserProvider.getLoggedInGeniUser(), this.proxySocketFactoryProvider, this.proxyPreferencesManager, this.proxyServiceUtil));
    }
}

