/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment.setup.config;

import be.iminds.ilabt.jfed.experiment.setup.config.ESpecLogStorageDetails;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(value={"@context"})
public class ESpec {
    @Nonnull
    private final ESpecSource source;
    @Nullable
    private final String providedContentSource;
    @Nullable
    private final List<ESpecLogStorageDetails> logStorage;

    public ESpec() {
        this.source = ESpecSource.PROVIDE_DIR;
        this.providedContentSource = null;
        this.logStorage = null;
    }

    @JsonCreator
    public ESpec(@Nullable @JsonProperty(value="source") ESpecSource source, @Nullable @JsonProperty(value="providedContentSource") String providedContentSource, @Nullable @JsonProperty(value="logStorage") List<ESpecLogStorageDetails> logStorage) {
        this.source = source == null ? new ESpec().getSource() : source;
        this.providedContentSource = providedContentSource;
        this.logStorage = logStorage;
    }

    @JsonIgnore
    public boolean isValid() {
        switch (this.source.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.providedContentSource == null) {
                    throw new IllegalArgumentException("Config Error: rspec.providedContentSource may not be null if espec.source == " + String.valueOf((Object)this.source));
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Config Error: unsupported espec.source == " + String.valueOf((Object)this.source));
    }

    @JsonProperty
    @Nonnull
    public ESpecSource getSource() {
        return this.source;
    }

    @JsonProperty
    @Nullable
    public String getProvidedContentSource() {
        return this.providedContentSource;
    }

    @JsonProperty
    @Nullable
    public List<ESpecLogStorageDetails> getLogStorage() {
        return this.logStorage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ESpec)) {
            return false;
        }
        ESpec eSpec = (ESpec)o;
        return this.source == eSpec.source && Objects.equals(this.providedContentSource, eSpec.providedContentSource) && Objects.equals(this.logStorage, eSpec.logStorage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.providedContentSource, this.logStorage});
    }

    public static enum ESpecSource {
        PROVIDE_ARCHIVE_URL,
        PROVIDE_ARCHIVE_FILE,
        PROVIDE_DIR,
        PROVIDE_GIT_REPO_DIR,
        DIRECT;

    }
}

