/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.call_log_output;

import be.iminds.ilabt.jfed.call_log_output.HtmlLogOutput;
import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import be.iminds.ilabt.jfed.util.common.Slf4jHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import org.rendersnake.HtmlCanvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallReport
extends HtmlLogOutput {
    private static final Logger LOG = LoggerFactory.getLogger(HtmlLogOutput.class);
    private final ApiCallDetailsCache cache;
    @XmlTransient
    protected State curState;
    @XmlElementWrapper(name="states")
    @XmlElement(name="state")
    protected final ObservableList<State> states = FXCollections.observableArrayList();
    private final String reportObject;

    protected CallReport(String initialStateName, String reportTitle, String reportObject, ApiCallDetailsCache cache) {
        super(reportTitle);
        this.reportObject = reportObject;
        this.cache = cache;
        this.curState = new State(initialStateName, new Date(), cache);
        this.states.add((Object)this.curState);
    }

    protected CallReport(String reportTitle, String reportObject, ApiCallDetailsCache cache) {
        this("Initial State", reportTitle, reportObject, cache);
    }

    protected CallReport(String reportTitle, String reportObject, Collection<State> states, ApiCallDetailsCache cache) {
        super(reportTitle);
        this.reportObject = reportObject;
        this.states.addAll(states);
        this.cache = cache;
    }

    public synchronized State getCurState() {
        return this.curState;
    }

    public synchronized State changeState(String newStateName) {
        LOG.debug("changeState(" + newStateName + ")");
        if (Objects.equals(newStateName, this.curState.name)) {
            return this.curState;
        }
        Date now = new Date();
        State newState = new State(newStateName, now, this.cache);
        this.curState.end.set((Object)now);
        this.states.add((Object)newState);
        this.curState = newState;
        return newState;
    }

    public String getReportObject() {
        return this.reportObject;
    }

    public synchronized ObservableList<State> getStates() {
        return this.states;
    }

    public synchronized State getLastState(String stateName) {
        State res = null;
        for (State state : this.states) {
            if (!Objects.equals(state.name, stateName)) continue;
            res = state;
        }
        return res;
    }

    public synchronized List<ApiCallDetailsRef> getAllStateCalls(String stateName) {
        return this.states.stream().filter(state -> Objects.equals(state.name, stateName)).flatMap(state -> state.getCalls().stream()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void htmlContent(HtmlCanvas html) throws IOException {
        if (this.curState != null && this.curState.end.get() == null) {
            this.curState.end.set((Object)new Date());
        }
        CallReport.addClassVisibleToggle((HtmlCanvas)html, (String)"logline-DEBUG", (String)"Debug Log Lines");
        int index = 0;
        for (State state : this.states) {
            ArrayList<LogOutput.LogEntry> logsCopy;
            List callsCopy;
            ObservableList<ApiCallDetailsRef> observableList = state.calls;
            synchronized (observableList) {
                callsCopy = state.calls.stream().map(this.cache::getApiCallDetails).filter(Objects::nonNull).collect(Collectors.toList());
            }
            observableList = state.logs;
            synchronized (observableList) {
                logsCopy = new ArrayList<LogOutput.LogEntry>((Collection<LogOutput.LogEntry>)state.logs);
            }
            CallReport.writeGroup((HtmlCanvas)html, (int)index++, (LogOutput.TestResultState)state.getState(), (String)(state.name + " calls"), (String)(this.reportObject + " state \"" + state.name + "\" calls"), (long)state.getDurationMs(), (Date)state.start, (Date)((Date)state.end.get()), (String)null, callsCopy, logsCopy);
        }
    }

    public synchronized List<ApiCallDetailsRef> getCalls() {
        ArrayList<ApiCallDetailsRef> res = new ArrayList<ApiCallDetailsRef>();
        for (State state : this.states) {
            res.addAll(state.getCalls());
        }
        return res;
    }

    public static class State
    extends Slf4jHelper.AbstractSlf4JLoggerImpl
    implements ResultListener {
        private final Date start;
        private final ObjectProperty<Date> end = new SimpleObjectProperty();
        private final String name;
        private final ObservableList<LogOutput.LogEntry> logs = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
        private final ObservableList<ApiCallDetailsRef> calls = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
        private final ObjectProperty<LogOutput.TestResultState> testResultState = new SimpleObjectProperty((Object)LogOutput.TestResultState.SUCCESS);
        private final ApiCallDetailsCache cache;

        State(String name, Date start, ApiCallDetailsCache cache) {
            super(Slf4jHelper.Level.TRACE);
            this.start = start;
            this.name = name;
            this.cache = cache;
        }

        public long getDurationMs() {
            if (this.end.get() == null || this.start == null) {
                return 0L;
            }
            return ((Date)this.end.get()).getTime() - this.start.getTime();
        }

        protected void handle(Slf4jHelper.Level level, String message, Throwable t) {
            switch (level) {
                case TRACE: {
                    this.log(message, LogOutput.LogLineType.DEBUG, t);
                    break;
                }
                case DEBUG: {
                    this.log(message, LogOutput.LogLineType.DEBUG, t);
                    break;
                }
                case INFO: {
                    this.log(message, LogOutput.LogLineType.NOTE, t);
                    break;
                }
                case WARN: {
                    this.log(message, LogOutput.LogLineType.WARN, t);
                    break;
                }
                case ERROR: {
                    this.log(message, LogOutput.LogLineType.ERROR, t);
                    break;
                }
                default: {
                    throw new RuntimeException("unsupported Slf4jHelper.Level " + String.valueOf(level));
                }
            }
        }

        protected void log(String message, LogOutput.LogLineType logLineType, Throwable e) {
            assert (logLineType != null);
            assert (message != null);
            this.log(new LogOutput.LogEntry(logLineType, message, e));
        }

        protected void log(LogOutput.LogEntry logLine) {
            this.logs.add((Object)logLine);
        }

        public void onResult(ApiCallDetails result) {
            this.logCall(this.cache.registerApiCallDetails(result));
        }

        public void logCall(ApiCallDetailsRef callDetails) {
            this.calls.add((Object)callDetails);
        }

        @XmlElement(name="statestate")
        public LogOutput.TestResultState getState() {
            return (LogOutput.TestResultState)this.testResultState.get();
        }

        public void setState(LogOutput.TestResultState state) {
            this.testResultState.set((Object)state);
        }

        public String toString() {
            return "State{" + this.name + "'}";
        }

        public List<ApiCallDetailsRef> getCalls() {
            return this.calls;
        }

        public ObservableList<LogOutput.LogEntry> getLogLines() {
            return this.logs;
        }

        public String getName() {
            return this.name;
        }

        public Date getStateStart() {
            return this.start;
        }

        @XmlElement(name="end")
        public Date getEnd() {
            return (Date)this.end.get();
        }

        void setEnd(Date d) {
            this.end.setValue((Object)d);
        }

        public ObjectProperty<Date> endProperty() {
            return this.end;
        }

        public ObjectProperty<LogOutput.TestResultState> stateProperty() {
            return this.testResultState;
        }
    }
}

