/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.controller;

import be.iminds.ilabt.jfed.highlevel.controller.JavaFXTaskThread;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecutionFactory;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecutionFinishedCallback;
import be.iminds.ilabt.jfed.highlevel.controller.TaskFinishedCallback;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Singleton
public class TaskThread {
    private static final Marker TASKTHREAD_MARKER = MarkerFactory.getMarker((String)"TASKTHREAD");
    private static final Marker ADD_TASK_MARKER = MarkerFactory.getMarker((String)"ADD_TASK");
    private static final Marker ADD_FUTURE_TASK_MARKER = MarkerFactory.getMarker((String)"ADD_FUTURE_TASK");
    private static final Marker TASKTHREAD_LOOP_MARKER = MarkerFactory.getMarker((String)"TASKTHREAD_LOOP");
    private static final Marker PROCESS_NEW_TASK_EXECUTION_MARKER = MarkerFactory.getMarker((String)"processNewTaskExecution");
    private static final Logger LOG = LoggerFactory.getLogger(TaskThread.class);
    private final List<TaskThreadThread> taskThreads = new ArrayList<TaskThreadThread>();
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, ThreadFactoryUtil.getFactory((String)"TaskThreadShedExServ"));
    private final BlockingDeque<TaskExecution> queuedTasks = new LinkedBlockingDeque<TaskExecution>();
    private final BlockingDeque<TaskExecution> blockedTasks = new LinkedBlockingDeque<TaskExecution>();
    final List<TaskExecution> allTasks = Collections.synchronizedList(new ArrayList());
    private final TaskExecutionFactory taskExecutionFactory;

    @Inject
    TaskThread(TaskExecutionFactory taskExecutionFactory) {
        this.taskExecutionFactory = taskExecutionFactory;
        for (int threadNum = 0; threadNum < 3; ++threadNum) {
            TaskThreadThread t = new TaskThreadThread(threadNum, this.stopRequested);
            t.setDaemon(true);
            t.setName("TaskThread-" + threadNum);
            this.taskThreads.add(t);
            t.start();
        }
    }

    public void requestStop() {
        this.stopRequested.set(true);
        this.scheduledExecutorService.shutdownNow();
    }

    public boolean isStopRequested() {
        return this.stopRequested.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkStateCorrectness(TaskExecution taskExecution) {
        if (taskExecution == null) {
            throw new NullPointerException("taskExecution cannot be null");
        }
        TaskExecution taskExecution2 = taskExecution;
        synchronized (taskExecution2) {
            try {
                TaskExecution.TaskState state = taskExecution.getState();
                if (state == null) {
                    throw new NullPointerException("taskExecution state cannot be null");
                }
                if (state == TaskExecution.TaskState.BLOCKED ? !$assertionsDisabled && !this.blockedTasks.contains(taskExecution) : !$assertionsDisabled && this.blockedTasks.contains(taskExecution)) {
                    throw new AssertionError();
                }
                if (state != TaskExecution.TaskState.QUEUED) assert (!this.queuedTasks.contains(taskExecution));
            }
            catch (AssertionError | Exception e) {
                LOG.error("checkStateCorrectness failed for taskExecution '{}'\n taskExecution.getState()={}\n      queuedTasks={}\n     blockedTasks={}\n  THIS POTENTIALLY FATAL ERROR WILL BE IGNORED!", new Object[]{taskExecution, taskExecution.getState(), this.queuedTasks, this.blockedTasks, e});
            }
        }
    }

    public void cancel(List<? extends Task> tasks) {
        for (Task task : tasks) {
            this.cancel(task);
        }
    }

    public void cancel(Task task) {
        for (TaskExecution st : task.getCurrentActiveTaskExecutionsCopy()) {
            this.cancel(st);
        }
        for (FutureTask ft : task.getFuturesCopy()) {
            ft.tryCancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(TaskExecution task) {
        TaskExecution taskExecution = task;
        synchronized (taskExecution) {
            if (task.state == TaskExecution.TaskState.RUNNING) {
                task.setCanceledByUser(true);
                if (task.getThread() != null) {
                    task.getThread().interrupt();
                }
                return;
            }
            if (task.state == TaskExecution.TaskState.BLOCKED) {
                this.blockedTasks.remove(task);
            }
            if (task.state == TaskExecution.TaskState.QUEUED) {
                this.queuedTasks.remove(task);
            }
            task.setCanceledByUser(true);
            task.state = TaskExecution.TaskState.CANCELLED;
            ((Task)task.task).removeActiveTaskExecution(task);
        }
        this.checkStateCorrectness(task);
        this.updateBlocking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStateAndDoCallback(TaskExecution<?> currentlyRunningTaskExecution, TaskExecution.TaskState completedState) {
        ArrayList<TaskFinishedCallback> taskFinishedCallbackList;
        TaskExecution<?> taskExecution = currentlyRunningTaskExecution;
        synchronized (taskExecution) {
            taskFinishedCallbackList = new ArrayList<TaskFinishedCallback>();
            taskFinishedCallbackList.addAll(((Task)currentlyRunningTaskExecution.task).getCallbacks());
            taskFinishedCallbackList.addAll(currentlyRunningTaskExecution.getTaskExecutionFinishedCallbacks());
            currentlyRunningTaskExecution.setState(completedState);
            currentlyRunningTaskExecution.setThread(null);
            ((Task)currentlyRunningTaskExecution.task).setLastCompletedTaskExecution(currentlyRunningTaskExecution);
            ((Task)currentlyRunningTaskExecution.task).removeActiveTaskExecution(currentlyRunningTaskExecution);
            if (completedState == TaskExecution.TaskState.SUCCESS && ((Task)currentlyRunningTaskExecution.task).newExecutionNeeded()) {
                LOG.error("The task " + currentlyRunningTaskExecution.getName() + " just ran successfully, however, it still says that it is needed! That means something has gone wrong. This is most likely a bug in the Task code.");
            }
        }
        for (TaskFinishedCallback callback : taskFinishedCallbackList) {
            try {
                callback.onTaskExecutionFinished(currentlyRunningTaskExecution.task, currentlyRunningTaskExecution, completedState);
            }
            catch (AssertionError | Exception t) {
                LOG.error(TASKTHREAD_LOOP_MARKER, "runTask() Callback failed: " + ((Throwable)t).getMessage(), (Throwable)t);
            }
        }
    }

    public void updateBlocking() {
        ArrayList toCheck = new ArrayList();
        boolean keepChecking = true;
        while (keepChecking) {
            toCheck.clear();
            this.blockedTasks.drainTo(toCheck);
            int prevBlockedCount = toCheck.size();
            if (!toCheck.isEmpty()) {
                LOG.debug(TASKTHREAD_LOOP_MARKER, "updateBlocking() Assigning blocked tasks count=" + toCheck.size());
                for (TaskExecution blockedCall : toCheck) {
                    this.processTaskExection(blockedCall);
                }
            }
            keepChecking = this.blockedTasks.size() != prevBlockedCount;
        }
        LOG.debug(TASKTHREAD_LOOP_MARKER, "updateBlocking() updateAfterTaskrun done, will unlock\n\t" + this.queuedTasks.size() + " queuedTasks= " + String.valueOf(this.queuedTasks) + "\n\t" + this.blockedTasks.size() + " blockedTasks=" + String.valueOf(this.blockedTasks));
    }

    private synchronized void processNewTaskExecution(TaskExecution origTaskExecution) {
        if (origTaskExecution == null) {
            return;
        }
        ArrayList<TaskExecution<Object>> taskExecutionsToAssign = new ArrayList<TaskExecution<Object>>();
        LinkedList<TaskExecution<Object>> newTaskExecutionsToProcess = new LinkedList<TaskExecution<Object>>();
        newTaskExecutionsToProcess.offer(origTaskExecution);
        taskExecutionsToAssign.add(origTaskExecution);
        LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution() origTaskExecution=" + String.valueOf(origTaskExecution) + " (id=" + origTaskExecution.id + ")");
        while (!newTaskExecutionsToProcess.isEmpty()) {
            TaskExecution<Object> depTaskExecution;
            LOG.trace("assigning calls: " + String.valueOf(newTaskExecutionsToProcess));
            TaskExecution taskExecution = (TaskExecution)newTaskExecutionsToProcess.poll();
            Object task = taskExecution.task;
            LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution()   PROCESS task=" + String.valueOf(task) + " (id=" + ((Task)task).getId() + ")  taskExecution=" + String.valueOf(taskExecution) + " (id=" + taskExecution.id + ")");
            for (Task dep : ((Task)task).getDependsOn()) {
                assert (dep != null) : "Got a null DependsOn-dependency for task " + ((Task)task).getName();
                LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution()     DEP=" + String.valueOf(dep) + " (id=" + dep.getId() + ")");
                depTaskExecution = null;
                for (TaskExecution<Object> taskExecution2 : dep.getCurrentActiveTaskExecutionsCopy()) {
                    LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution()         found in currentActiveSingleTasks activeTaskExecution=" + String.valueOf(taskExecution2));
                    if (taskExecution2.getState() == TaskExecution.TaskState.FUTURE) continue;
                    depTaskExecution = taskExecution2;
                }
                for (TaskExecution<Object> taskExecution3 : taskExecutionsToAssign) {
                    if (taskExecution3.task != dep) continue;
                    LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution()         found in taskExecutionsToAssign newlyCreatedTask=" + String.valueOf(taskExecution3));
                    depTaskExecution = taskExecution3;
                }
                if (depTaskExecution == null && !dep.newExecutionNeeded()) {
                    LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution()         found in dep.lastCompletedSingleTask=" + String.valueOf(dep.getLastCompletedTaskExecution()));
                    depTaskExecution = dep.getLastCompletedTaskExecution();
                }
                if (depTaskExecution == null) {
                    depTaskExecution = this.taskExecutionFactory.createTaskExecution(dep);
                    newTaskExecutionsToProcess.offer(depTaskExecution);
                    taskExecutionsToAssign.add(depTaskExecution);
                    ((Task)depTaskExecution.task).addActiveTaskExecution(depTaskExecution);
                    LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution()         creating new: " + String.valueOf(depTaskExecution));
                }
                taskExecution.getDependsOn().add(depTaskExecution);
                depTaskExecution.getDependingOnThis().add(taskExecution);
            }
            for (Task dep : ((Task)task).getAlwaysDependsOn()) {
                assert (dep != null) : "Got a null AlwaysDependsOn-dependency for task " + ((Task)task).getName();
                LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution()         ALWAYSDEP=" + String.valueOf(dep) + " (id=" + dep.getId() + ")");
                depTaskExecution = null;
                LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution()         dep.currentActiveSingleTasks=" + String.valueOf(dep.getCurrentActiveTaskExecutionsCopy()));
                for (TaskExecution<Object> taskExecution4 : dep.getCurrentActiveTaskExecutionsCopy()) {
                    LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution()             found in currentActiveSingleTasks activeTaskExecution=" + String.valueOf(taskExecution4));
                    if (taskExecution4.getState() == TaskExecution.TaskState.FUTURE) continue;
                    depTaskExecution = taskExecution4;
                }
                for (TaskExecution<Object> taskExecution5 : taskExecutionsToAssign) {
                    if (taskExecution5.task != dep) continue;
                    LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution()             found in taskExecutionsToAssign newlyCreatedTask=" + String.valueOf(taskExecution5));
                    depTaskExecution = taskExecution5;
                }
                if (depTaskExecution == null) {
                    depTaskExecution = this.taskExecutionFactory.createTaskExecution(dep);
                    newTaskExecutionsToProcess.offer(depTaskExecution);
                    taskExecutionsToAssign.add(depTaskExecution);
                    ((Task)depTaskExecution.task).addActiveTaskExecution(depTaskExecution);
                    LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution()             creating new: " + String.valueOf(depTaskExecution));
                }
                taskExecution.getDependsOn().add(depTaskExecution);
                depTaskExecution.getDependingOnThis().add(taskExecution);
            }
            assert (!this.allTasks.contains(taskExecution)) : "task was already added: " + taskExecution.getName();
            this.allTasks.add(taskExecution);
        }
        LOG.debug(PROCESS_NEW_TASK_EXECUTION_MARKER, "processNewTaskExecution() finished recursivly adding deps to for new FXTaskExecution. Will now call processTaskExection() for all new TaskExecutions");
        while (!taskExecutionsToAssign.isEmpty()) {
            ArrayList<TaskExecution> assignedTasks = new ArrayList<TaskExecution>();
            for (TaskExecution taskExecution : taskExecutionsToAssign) {
                boolean assigned = this.processTaskExection(taskExecution);
                if (!assigned) continue;
                assignedTasks.add(taskExecution);
            }
            taskExecutionsToAssign.removeAll(assignedTasks);
            if (!assignedTasks.isEmpty()) continue;
            throw new RuntimeException("Infinite loop while assigning: " + String.valueOf(taskExecutionsToAssign));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTaskExection(TaskExecution<?> taskExecution) {
        TaskExecution<?> taskExecution2 = taskExecution;
        synchronized (taskExecution2) {
            block22: {
                assert (taskExecution.getState() == TaskExecution.TaskState.BLOCKED || taskExecution.getState() == TaskExecution.TaskState.QUEUED || taskExecution.getState() == TaskExecution.TaskState.UNSUBMITTED) : "did not expect task given as argument to processTaskExection to be in state: " + String.valueOf((Object)taskExecution.getState());
                LOG.debug(TASKTHREAD_MARKER, "processTaskExection(" + String.valueOf(taskExecution) + ")");
                boolean allDepsOk = true;
                TaskExecution<?> taskExecution3 = taskExecution.getDependsOn().iterator();
                while (taskExecution3.hasNext()) {
                    TaskExecution<?> taskExecutionDep;
                    TaskExecution<?> taskExecution4 = taskExecutionDep = taskExecution3.next();
                    synchronized (taskExecution4) {
                        if (taskExecutionDep.getState() == TaskExecution.TaskState.FAILED || taskExecutionDep.getState() == TaskExecution.TaskState.CANCELLED) {
                            this.setStateAndDoCallback(taskExecution, taskExecutionDep.getState());
                            ((Task)taskExecution.task).onCancelledDueToDependencyFailed();
                            this.checkStateCorrectness(taskExecution);
                            LOG.debug(TASKTHREAD_MARKER, "processTaskExection taskExecutionDep(" + String.valueOf(taskExecutionDep) + ")  DEP FAILED! cancelling task!");
                            return true;
                        }
                        assert (!taskExecutionDep.isCanceledByUser()) : "Inconsistent canceledByUser-state";
                        if (taskExecutionDep.getState() == TaskExecution.TaskState.UNSUBMITTED) {
                            LOG.debug(TASKTHREAD_MARKER, "processTaskExection taskExecutionDep(" + String.valueOf(taskExecutionDep) + ")  DEP unsubmitted.");
                            return false;
                        }
                        if (((Task)taskExecutionDep.task).newExecutionNeeded()) {
                            LOG.debug(TASKTHREAD_MARKER, "processTaskExection taskExecutionDep(" + String.valueOf(taskExecutionDep) + ").task.needed=" + ((Task)taskExecutionDep.task).newExecutionNeeded() + " state=" + String.valueOf((Object)taskExecutionDep.getState()) + ", so allDepsOk = false");
                            if (taskExecutionDep.state == TaskExecution.TaskState.SUCCESS) {
                                throw new RuntimeException("BUG in Task dependencies! Task \"" + taskExecutionDep.getName() + "\" success, even though newExecutionNeeded() says true! (might hang task " + taskExecution.getName() + ")");
                            }
                            allDepsOk = false;
                        }
                    }
                }
                LOG.debug(TASKTHREAD_MARKER, "processTaskExection allDepsOk=" + allDepsOk);
                try {
                    if (allDepsOk) {
                        taskExecution3 = taskExecution;
                        synchronized (taskExecution3) {
                            taskExecution.setState(TaskExecution.TaskState.QUEUED);
                            this.queuedTasks.putFirst(taskExecution);
                        }
                        LOG.debug(TASKTHREAD_MARKER, "processTaskExection registered as QUEUED");
                        break block22;
                    }
                    taskExecution3 = taskExecution;
                    synchronized (taskExecution3) {
                        taskExecution.setState(TaskExecution.TaskState.BLOCKED);
                        this.blockedTasks.putFirst(taskExecution);
                    }
                    LOG.debug(TASKTHREAD_MARKER, "processTaskExection registered as BLOCKED");
                }
                catch (InterruptedException e) {
                    LOG.error("Did not expect InterruptedException could occur in processTaskExecution. This is possibly a problem. It will be ignored.", (Throwable)e);
                }
            }
        }
        this.checkStateCorrectness(taskExecution);
        return true;
    }

    public <T extends Task> TaskExecution<T> addTask(T task) {
        return this.addTask(task, Collections.emptySet());
    }

    public <T extends Task> TaskExecution<T> addTask(T task, @Nonnull TaskExecutionFinishedCallback<T> callback) {
        return this.addTask(task, Collections.singleton(callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Task> TaskExecution<T> addTask(T task, @Nonnull Collection<TaskExecutionFinishedCallback<T>> callbacks) {
        LOG.debug(ADD_TASK_MARKER, "addTask() Adding task: \"" + String.valueOf(task) + "\"");
        List<TaskExecution> currentTaskExecutions = task.getCurrentActiveTaskExecutionsCopy();
        if (!currentTaskExecutions.isEmpty()) {
            TaskExecution lastTaskExecution;
            LOG.error("trying to add active task: " + String.valueOf(task.getCurrentActiveTaskExecutionsCopy()) + " -> task will not be added.");
            TaskExecution taskExecution = lastTaskExecution = currentTaskExecutions.get(currentTaskExecutions.size() - 1);
            synchronized (taskExecution) {
                if (!lastTaskExecution.isCompleted()) {
                    lastTaskExecution.getTaskExecutionFinishedCallbacks().addAll(callbacks);
                    return lastTaskExecution;
                }
            }
        }
        LOG.debug(ADD_TASK_MARKER, "addTask() {} queuedTasks= {}", (Object)this.queuedTasks.size(), this.queuedTasks);
        LOG.debug(ADD_TASK_MARKER, "addTask() {} blockedTasks= {}", (Object)this.blockedTasks.size(), this.blockedTasks);
        TaskExecution<T> taskExecution = this.taskExecutionFactory.createTaskExecution(task, callbacks);
        task.addActiveTaskExecution(taskExecution);
        this.processNewTaskExecution(taskExecution);
        LOG.debug(ADD_TASK_MARKER, "addTask() Added task: \"{}\"", task);
        LOG.debug(ADD_TASK_MARKER, "addTask() {} queuedTasks= {}", (Object)this.queuedTasks.size(), this.queuedTasks);
        LOG.debug(ADD_TASK_MARKER, "addTask() {} blockedTasks= {}", (Object)this.blockedTasks.size(), this.blockedTasks);
        return taskExecution;
    }

    public <T extends Task> TaskExecution scheduleTask(T task, long delayMs) {
        return this.scheduleTask(task, delayMs, Collections.emptySet());
    }

    public <T extends Task> TaskExecution scheduleTask(T task, long delayMs, @Nonnull TaskExecutionFinishedCallback<T> callback) {
        return this.scheduleTask(task, delayMs, Collections.singleton(callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Task> TaskExecution scheduleTask(T task, long delayMs, @Nonnull Collection<TaskExecutionFinishedCallback<T>> callbacks) {
        LOG.debug("Scheduled task '{}' in {} ms", (Object)task.getName(), (Object)delayMs);
        T t = task;
        synchronized (t) {
            TaskExecution<T> taskExecution = this.taskExecutionFactory.createTaskExecution(task, callbacks);
            taskExecution.setState(TaskExecution.TaskState.FUTURE);
            task.addActiveTaskExecution(taskExecution);
            FutureTask futureTask = new FutureTask(taskExecution);
            task.addFuture(futureTask);
            ScheduledFuture<?> scheduledFuture = this.scheduledExecutorService.schedule(futureTask, delayMs, TimeUnit.MILLISECONDS);
            futureTask.setScheduledFuture(scheduledFuture);
            return taskExecution;
        }
    }

    public class TaskThreadThread
    extends Thread {
        private final int threadNum;
        private final AtomicBoolean stopRequested;
        public final List<String> interruptStacktraces = new ArrayList<String>();

        private TaskThreadThread(int threadNum, AtomicBoolean stopRequested) {
            this.threadNum = threadNum;
            this.stopRequested = stopRequested;
        }

        @Override
        public void run() {
            try {
                while (!this.stopRequested.get()) {
                    this.runTask();
                }
            }
            catch (AssertionError | Exception t) {
                LOG.error("Fatal error in jFed Experimenter Task Thread nr" + this.threadNum + ": " + ((Throwable)t).getMessage(), (Throwable)t);
                throw t;
            }
            finally {
                LOG.info("jFed Experimenter Task Thread nr" + this.threadNum + " is shutting down.");
            }
        }

        @Override
        public void interrupt() {
            String interruptStacktrace = IOUtils.currentStackToStacktraceString();
            this.interruptStacktraces.add(interruptStacktrace);
            LOG.warn("TaskThread was interrupted by: " + interruptStacktrace);
            super.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runTask() {
            TaskExecution currentlyRunningTaskExecution;
            LOG.trace(TASKTHREAD_LOOP_MARKER, "runTask() Fetching task from queue");
            try {
                currentlyRunningTaskExecution = TaskThread.this.queuedTasks.takeFirst();
            }
            catch (InterruptedException e) {
                LOG.warn("runTask() for InterruptedException: stopping");
                return;
            }
            TaskExecution e = currentlyRunningTaskExecution;
            synchronized (e) {
                if (currentlyRunningTaskExecution.isCanceledByUser()) {
                    TaskThread.this.setStateAndDoCallback(currentlyRunningTaskExecution, TaskExecution.TaskState.CANCELLED);
                    return;
                }
                currentlyRunningTaskExecution.setState(TaskExecution.TaskState.RUNNING);
            }
            currentlyRunningTaskExecution.setThread(Thread.currentThread());
            Thread.currentThread().setName("TaskThread-" + this.threadNum + "-" + currentlyRunningTaskExecution.getName());
            TaskExecution.TaskState completedState = TaskExecution.TaskState.FAILED;
            try {
                LOG.trace(TASKTHREAD_LOOP_MARKER, "runTask() Starting: " + String.valueOf(currentlyRunningTaskExecution));
                currentlyRunningTaskExecution.registerRunStart();
                ((Task)currentlyRunningTaskExecution.task).doTask(currentlyRunningTaskExecution);
                currentlyRunningTaskExecution.registerRunStop();
                LOG.trace(TASKTHREAD_LOOP_MARKER, "runTask() Run Successfully: " + String.valueOf(currentlyRunningTaskExecution));
                completedState = TaskExecution.TaskState.SUCCESS;
            }
            catch (InterruptedException e2) {
                completedState = TaskExecution.TaskState.CANCELLED;
                currentlyRunningTaskExecution.exception = e2;
                LOG.warn("Run cancelled: " + String.valueOf(currentlyRunningTaskExecution) + "  -> Exception=\"" + String.valueOf(e2) + "\"", (Throwable)e2);
            }
            catch (AssertionError | Exception t) {
                completedState = TaskExecution.TaskState.FAILED;
                currentlyRunningTaskExecution.exception = t;
                LOG.error("Run failed: " + String.valueOf(currentlyRunningTaskExecution) + "  -> Exception=\"" + String.valueOf(t) + "\"", (Throwable)t);
            }
            finally {
                TaskThread.this.setStateAndDoCallback(currentlyRunningTaskExecution, completedState);
                Thread.currentThread().setName("TaskThread-" + this.threadNum);
            }
            currentlyRunningTaskExecution = null;
            TaskThread.this.updateBlocking();
        }
    }

    public class FutureTask
    implements Runnable {
        private final TaskExecution task;
        JavaFXTaskThread.FutureTask javafx;
        private ScheduledFuture scheduledFuture;
        private boolean cancel = false;

        FutureTask(TaskExecution task) {
            this.task = task;
        }

        public TaskExecution getTask() {
            return this.task;
        }

        public ScheduledFuture getScheduledFuture() {
            return this.scheduledFuture;
        }

        void setScheduledFuture(ScheduledFuture scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        public void tryCancel() {
            boolean wasCancelled;
            this.cancel = true;
            if (this.scheduledFuture != null && (wasCancelled = this.scheduledFuture.cancel(false))) {
                TaskThread.this.setStateAndDoCallback(this.task, TaskExecution.TaskState.CANCELLED);
            }
        }

        public long getTimeLeftMs() {
            if (this.scheduledFuture != null) {
                return this.scheduledFuture.getDelay(TimeUnit.MILLISECONDS);
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.cancel) {
                TaskThread.this.setStateAndDoCallback(this.task, TaskExecution.TaskState.CANCELLED);
                return;
            }
            try {
                LOG.debug("Adding future task: \"" + String.valueOf(this.task) + "\"");
                Object t = this.task.task;
                synchronized (t) {
                    boolean wasRemoved = ((Task)this.task.task).removeFuture(this);
                    assert (wasRemoved);
                }
                this.task.setState(TaskExecution.TaskState.UNSUBMITTED);
                TaskThread.this.processNewTaskExecution(this.task);
                LOG.debug(ADD_FUTURE_TASK_MARKER, "Added future task: \"" + String.valueOf(this.task) + "\"");
                LOG.debug(ADD_FUTURE_TASK_MARKER, "{} queuedTasks= {}", (Object)TaskThread.this.queuedTasks.size(), TaskThread.this.queuedTasks);
                LOG.debug(ADD_FUTURE_TASK_MARKER, "{} blockedTasks= {}", (Object)TaskThread.this.blockedTasks.size(), TaskThread.this.blockedTasks);
            }
            catch (AssertionError | Exception e) {
                LOG.error(ADD_FUTURE_TASK_MARKER, "Exception while running addCall on future task. This is a bug. " + ((Throwable)e).getMessage(), (Throwable)e);
            }
        }
    }
}

