/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.jobs.AllocationDirector;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingCallData;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingDirector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BasicAllocationDirector
implements AllocationDirector {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAllocationDirector.class);
    private final Experiment experiment;
    private boolean gaveUp = false;
    private final HashMap<SfaExperimentPart, StitchingCallData.State> experimentPartStates = new HashMap();

    BasicAllocationDirector(Experiment experiment) {
        this.experiment = experiment;
    }

    @Override
    public void reportGiveUp() {
        this.gaveUp = true;
    }

    @Override
    public boolean isGaveUp() {
        return this.gaveUp;
    }

    @Override
    public boolean areAnyActionsLeft() {
        if (this.gaveUp) {
            return false;
        }
        this.updateExperimentParts();
        for (StitchingCallData.State state : this.experimentPartStates.values()) {
            if (state == StitchingCallData.State.ALLOCATED) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public synchronized List<StitchingDirector.StitchAction> getStitchActions() {
        if (this.gaveUp) {
            return Collections.emptyList();
        }
        this.updateExperimentParts();
        ArrayList<StitchingDirector.StitchAction> actions = new ArrayList<StitchingDirector.StitchAction>();
        for (Map.Entry<SfaExperimentPart, StitchingCallData.State> entry : this.experimentPartStates.entrySet()) {
            if (entry.getValue() == StitchingCallData.State.NONE) {
                actions.add(new StitchingDirector.StitchAction(StitchingDirector.StichActionType.ALLOCATE, entry.getKey().getConnectSfaAuthority(), null, null, null));
                entry.setValue(StitchingCallData.State.ALLOCATING);
            }
            if (entry.getValue() != StitchingCallData.State.MUST_DELETE) continue;
            actions.add(new StitchingDirector.StitchAction(StitchingDirector.StichActionType.DELETE, entry.getKey().getConnectSfaAuthority(), null, null, null));
        }
        LOG.debug("Returning {} actions: {}", (Object)actions.size(), actions);
        return actions;
    }

    @Override
    @Nonnull
    public StitchingDirector.AllocateVerdict processAllocateResult(@Nonnull StitchingDirector.StitchAction stitchAction, @Nullable AbstractGeniAggregateManager.AggregateManagerReply reply) {
        if (reply == null) {
            this.gaveUp = true;
            return StitchingDirector.AllocateVerdict.GIVEUP;
        }
        if (this.gaveUp) {
            return StitchingDirector.AllocateVerdict.GIVEUP;
        }
        SfaExperimentPart experimentPart = this.experiment.getPart(stitchAction.getServer());
        if (reply.getGeniResponseCode().isSuccess()) {
            this.experimentPartStates.put(experimentPart, StitchingCallData.State.ALLOCATED);
            return StitchingDirector.AllocateVerdict.OK;
        }
        this.experimentPartStates.put(experimentPart, StitchingCallData.State.NONE);
        this.gaveUp = true;
        return StitchingDirector.AllocateVerdict.GIVEUP;
    }

    @Override
    public void processListResourcesResult(@Nonnull Server auth, @Nullable String advertisementRspec) {
        LOG.warn("Received list resources, but this is unexpected!");
    }

    @Override
    public void processDeleteResult(@Nonnull Server auth) {
        SfaExperimentPart experimentPart = this.experiment.getPart(auth);
        this.experimentPartStates.put(experimentPart, StitchingCallData.State.NONE);
    }

    @Override
    public void reportReadyForRetry(@Nonnull Server auth) {
        SfaExperimentPart experimentPart = this.experiment.getPart(auth);
        this.experimentPartStates.put(experimentPart, StitchingCallData.State.NONE);
    }

    private void updateExperimentParts() {
        for (ExperimentPart experimentPart : this.experiment.getPartsListCopy()) {
            SfaExperimentPart sfaExperimentPart;
            if (this.experimentPartStates.containsKey(experimentPart) || !(experimentPart instanceof SfaExperimentPart) || (sfaExperimentPart = (SfaExperimentPart)experimentPart).getConnectSfaAuthority().isEdgeVlan()) continue;
            this.experimentPartStates.put(sfaExperimentPart, StitchingCallData.State.NONE);
        }
    }
}

