/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.espec.model.ESpecStep;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.WaitForReadyTimeoutHandler;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.DesiredStatus;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.AllocateExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.CreateDiskImageJob;
import be.iminds.ilabt.jfed.highlevel.jobs.EditSshKeysJob;
import be.iminds.ilabt.jfed.highlevel.jobs.FetchSliceMemberSshKeysJob;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.OpenConsoleJob;
import be.iminds.ilabt.jfed.highlevel.jobs.ProvisionExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.RebootJob;
import be.iminds.ilabt.jfed.highlevel.jobs.RegisterExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.ReloadOSJob;
import be.iminds.ilabt.jfed.highlevel.jobs.RenewJob;
import be.iminds.ilabt.jfed.highlevel.jobs.RestoreExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.ShareLanJob;
import be.iminds.ilabt.jfed.highlevel.jobs.ShareSliceJob;
import be.iminds.ilabt.jfed.highlevel.jobs.StopExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.UnshareSliceJob;
import be.iminds.ilabt.jfed.highlevel.jobs.UpdateExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.WaitForOpStatusExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.ProxySocketFactoryProvider;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public final class JobFactory {
    private final Provider<JFedPreferences> jFedPreferences;
    private final Provider<HighLevelTaskFactory> hltfProvider;
    private final Provider<TaskThread> ttProvider;
    private final Provider<AuthorityFinder> authorityFinderProvider;
    private final Provider<TestbedInfoSource> testbedInfoSourceProvider;
    private final Provider<AggregateManagerWrapperFactory> aggregateManagerWrapperFactoryProvider;
    private final Provider<GeniUserProvider> geniUserProviderProvider;
    private final Provider<SfaModel> sfaModelProvider;
    private final Provider<JobStateFactory> jobStateFactoryProvider;
    private final Provider<ExperimentPartControllerManager> epcManagerProvider;
    private final Provider<ProxySocketFactoryProvider> proxySocketFactoryProvider;

    @Inject
    public JobFactory(Provider<HighLevelTaskFactory> hltfProvider, Provider<JFedPreferences> jFedPreferences, Provider<TaskThread> ttProvider, Provider<AuthorityFinder> authorityFinderProvider, Provider<TestbedInfoSource> testbedInfoSourceProvider, Provider<AggregateManagerWrapperFactory> aggregateManagerWrapperFactoryProvider, Provider<GeniUserProvider> geniUserProviderProvider, Provider<SfaModel> sfaModelProvider, Provider<JobStateFactory> jobStateFactoryProvider, Provider<ExperimentPartControllerManager> epcManagerProvider, Provider<ProxySocketFactoryProvider> proxySocketFactoryProvider) {
        this.hltfProvider = hltfProvider;
        this.jFedPreferences = jFedPreferences;
        this.ttProvider = ttProvider;
        this.authorityFinderProvider = authorityFinderProvider;
        this.testbedInfoSourceProvider = testbedInfoSourceProvider;
        this.aggregateManagerWrapperFactoryProvider = aggregateManagerWrapperFactoryProvider;
        this.geniUserProviderProvider = geniUserProviderProvider;
        this.sfaModelProvider = sfaModelProvider;
        this.jobStateFactoryProvider = jobStateFactoryProvider;
        this.epcManagerProvider = epcManagerProvider;
        this.proxySocketFactoryProvider = proxySocketFactoryProvider;
    }

    public RestoreExperimentJob createRestoreExperimentJob(Experiment experiment) {
        return new RestoreExperimentJob(experiment, (JFedPreferences)this.jFedPreferences.get(), (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (AuthorityFinder)this.authorityFinderProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get());
    }

    public UpdateExperimentJob createUpdateExperimentJob(Experiment experiment) {
        return new UpdateExperimentJob(experiment, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get());
    }

    public StopExperimentJob createStopExperimentJob(Experiment experiment) {
        return new StopExperimentJob(experiment, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get());
    }

    public StopExperimentJob createStopExperimentJob(Experiment experiment, Collection<ExperimentPart> experimentParts) {
        return new StopExperimentJob(experiment, experimentParts, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get());
    }

    public ShareSliceJob createShareSliceJob(@Nonnull Experiment experiment, @Nonnull Collection<GeniUrn> usersToShareWith, boolean registerSshKeys) {
        return new ShareSliceJob(experiment, usersToShareWith, registerSshKeys, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get());
    }

    public UnshareSliceJob createUnshareSliceJob(@Nonnull Experiment experiment, @Nonnull Collection<GeniUrn> usersToShareWith, boolean unregisterSshKeys) {
        return new UnshareSliceJob(experiment, usersToShareWith, unregisterSshKeys, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get());
    }

    public EditSshKeysJob createEditSshKeysJob(@Nonnull Experiment experiment, @Nonnull List<UserSpec> userspec) {
        return new EditSshKeysJob(experiment, userspec, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get());
    }

    public ReloadOSJob createReloadOSJob(Experiment experiment, Sliver sliver) {
        return new ReloadOSJob(experiment, sliver, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get());
    }

    public CreateDiskImageJob createCreateDiskImageJob(Experiment experiment, FXRspecNode node, String imageName, boolean global, boolean updatePrepare) {
        return new CreateDiskImageJob(experiment, node, imageName, global, updatePrepare, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get());
    }

    public RegisterExperimentJob createRegisterExperimentJob(Experiment experiment) {
        return new RegisterExperimentJob(experiment, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get());
    }

    public RebootJob createRebootJob(Experiment experiment, Sliver sliver) {
        return new RebootJob(experiment, sliver, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get());
    }

    public RebootJob createRebootJob(ExperimentPart experimentPart) {
        return new RebootJob(experimentPart, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get());
    }

    public OpenConsoleJob createOpenConsoleJob(Experiment experiment, Sliver sliver) {
        return new OpenConsoleJob(experiment, sliver, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get());
    }

    public ShareLanJob createShareLanJob(Experiment experiment, FXRspecLink link, String sharedLanName) {
        return new ShareLanJob(experiment, link, sharedLanName, true, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (AuthorityFinder)this.authorityFinderProvider.get());
    }

    public ShareLanJob createUnshareLanJob(Experiment experiment, FXRspecLink link, String sharedLanName) {
        return new ShareLanJob(experiment, link, sharedLanName, false, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (AuthorityFinder)this.authorityFinderProvider.get());
    }

    public FetchSliceMemberSshKeysJob createFetchSliceMemberSshKeysJob(Experiment experiment) {
        return new FetchSliceMemberSshKeysJob(experiment, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get());
    }

    public RenewJob createRenewSliceJob(Experiment experiment, Instant newExpirationTime) {
        return new RenewJob(experiment, newExpirationTime, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get(), true);
    }

    public RenewJob createRenewExperimentJob(Experiment experiment, Instant newExpirationTime) {
        return new RenewJob(experiment, newExpirationTime, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get(), false);
    }

    public RenewJob createRenewExperimentJob(Experiment experiment, Instant newExpirationTime, Collection<ExperimentPart> experimentParts) {
        return new RenewJob(experiment, newExpirationTime, experimentParts, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get());
    }

    public AllocateExperimentJob createAllocateExperimentJob(@Nonnull Experiment experiment, @Nullable Server scsServer) {
        return new AllocateExperimentJob(experiment, scsServer, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get(), (TestbedInfoSource)this.testbedInfoSourceProvider.get(), (AuthorityFinder)this.authorityFinderProvider.get(), (AggregateManagerWrapperFactory)this.aggregateManagerWrapperFactoryProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get());
    }

    public ProvisionExperimentJob createProvisionExperimentJob(@Nonnull Experiment experiment) {
        return new ProvisionExperimentJob(experiment, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get(), (AggregateManagerWrapperFactory)this.aggregateManagerWrapperFactoryProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get());
    }

    public WaitForOpStatusExperimentJob createWaitForReadyExperimentJob(@Nonnull Experiment experiment) {
        return new WaitForOpStatusExperimentJob(experiment, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get(), (AggregateManagerWrapperFactory)this.aggregateManagerWrapperFactoryProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get(), DesiredStatus.GENI_READY);
    }

    public WaitForOpStatusExperimentJob createWaitForNotReadyExperimentJob(@Nonnull Experiment experiment) {
        return new WaitForOpStatusExperimentJob(experiment, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get(), (AggregateManagerWrapperFactory)this.aggregateManagerWrapperFactoryProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get(), DesiredStatus.GENI_NOTREADY);
    }

    public SetupSoftwareExperimentJob createSetupSoftwareExperimentJob(@Nonnull Experiment experiment) {
        return new SetupSoftwareExperimentJob(experiment, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get(), (AggregateManagerWrapperFactory)this.aggregateManagerWrapperFactoryProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get(), (ProxySocketFactoryProvider)this.proxySocketFactoryProvider.get(), (GeniUserProvider)this.geniUserProviderProvider.get(), null, null);
    }

    public SetupSoftwareExperimentJob createRerunEspecJob(@Nonnull Experiment experiment, @Nullable ESpecStep startPosition, @Nullable ESpecStep stopPosition) {
        return new SetupSoftwareExperimentJob(experiment, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get(), (AggregateManagerWrapperFactory)this.aggregateManagerWrapperFactoryProvider.get(), (ExperimentPartControllerManager)this.epcManagerProvider.get(), (ProxySocketFactoryProvider)this.proxySocketFactoryProvider.get(), (GeniUserProvider)this.geniUserProviderProvider.get(), startPosition, stopPosition);
    }

    public Job<Boolean> createWaitForReadyTimeoutHandlerJob(@Nonnull Experiment experiment, final @Nonnull WaitForReadyTimeoutHandler waitForReadyTimeoutHandler) {
        return new AbstractJob<Boolean>("Handle Timeout", experiment, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get()){

            @Override
            public Boolean execute() throws Exception {
                try {
                    waitForReadyTimeoutHandler.onWaitForReadyTimeout(this.experiment);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        };
    }
}

