/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleTaskJob;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.OpenConsoleTask;
import java.net.URL;
import javax.annotation.Nullable;

public class OpenConsoleJob
extends SingleTaskJob<OpenConsoleTask, URL> {
    private final Sliver sliver;
    private URL result = null;

    public OpenConsoleJob(Experiment experiment, Sliver sliver, HighLevelTaskFactory hltf, TaskThread tt) {
        super("Open Console for sliver " + sliver.getUrn().toString(), experiment, hltf, tt);
        this.sliver = sliver;
    }

    @Override
    public OpenConsoleTask createTask() {
        return this.hltf.openConsole(this.sliver);
    }

    @Override
    protected void onFinished(OpenConsoleTask task, TaskExecution<OpenConsoleTask> taskExecution) {
        if (taskExecution.getState() == TaskExecution.TaskState.SUCCESS) {
            assert (task.getUrl() != null);
            this.result = task.getUrl();
            this.updateMessage(task.getUrl().toExternalForm());
        }
    }

    @Override
    @Nullable
    public URL getResult() {
        return this.result;
    }
}

