/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.MultipleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.OtherUserSshKeysTask;
import be.iminds.ilabt.jfed.highlevel.tasks.UnshareSliceTask;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnshareSliceJob
extends AbstractJob<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(UnshareSliceJob.class);
    private final Experiment experiment;
    private final Collection<GeniUrn> usersToUnshareWith;
    private final boolean unregisterSshKey;
    private final JobStateFactory jobStateFactory;

    public UnshareSliceJob(Experiment experiment, Collection<GeniUrn> usersToUnshareWith, boolean unregisterSshKey, HighLevelTaskFactory hltf, TaskThread tt, JobStateFactory jobStateFactory) {
        super(String.format("Unshare slice %s with %d users", experiment.getName(), usersToUnshareWith.size()), experiment, hltf, tt);
        this.experiment = experiment;
        this.usersToUnshareWith = usersToUnshareWith;
        this.unregisterSshKey = unregisterSshKey;
        this.jobStateFactory = jobStateFactory;
    }

    @Override
    public Void execute() throws Exception {
        this.setAndRunState(new UnshareSliceWithUsersState());
        if (this.unregisterSshKey) {
            List<UserSpec> userSpecs = this.usersToUnshareWith.stream().map(user -> new UserSpec(user.toString())).collect(Collectors.toList());
            this.setAndRunState(this.jobStateFactory.createUpdateSshKeysState(this, userSpecs));
        }
        return null;
    }

    public class UnshareSliceWithUsersState
    extends MultipleCallState<UnshareSliceTask> {
        UnshareSliceWithUsersState() {
            super(String.format("Unshare slice %s with %d users", UnshareSliceJob.this.experiment.getName(), UnshareSliceJob.this.usersToUnshareWith.size()), UnshareSliceJob.this);
        }

        @Override
        public Collection<UnshareSliceTask> getTasks() {
            return UnshareSliceJob.this.usersToUnshareWith.stream().map(user -> UnshareSliceJob.this.hltf.getUnshareSliceTask(UnshareSliceJob.this.experiment.getSlice(), (GeniUrn)user)).collect(Collectors.toList());
        }
    }

    public class FetchUserKeysState
    extends MultipleCallState<OtherUserSshKeysTask> {
        private final List<UserSpec> newUserSpecs;
        private final IntegerProperty successfulCalls;
        private final IntegerProperty failedCalls;

        protected FetchUserKeysState() {
            super(String.format("Fetching SSH keys of %d users", UnshareSliceJob.this.usersToUnshareWith.size()), UnshareSliceJob.this);
            this.newUserSpecs = Collections.synchronizedList(new ArrayList());
            this.successfulCalls = new SimpleIntegerProperty(0);
            this.failedCalls = new SimpleIntegerProperty(0);
        }

        @Override
        public Collection<OtherUserSshKeysTask> getTasks() {
            return UnshareSliceJob.this.usersToUnshareWith.stream().map(UnshareSliceJob.this.hltf::getOtherUserSshKeys).collect(Collectors.toList());
        }

        @Override
        protected void onTaskExecutionFinished(OtherUserSshKeysTask task, TaskExecution<OtherUserSshKeysTask> taskExecution, TaskExecution.TaskState state) {
            if (taskExecution.getState() == TaskExecution.TaskState.SUCCESS) {
                this.newUserSpecs.add(new UserSpec(task.getUserUrn().toString(), task.getKeys()));
                this.successfulCalls.set(this.successfulCalls.get() + 1);
            } else {
                this.failedCalls.set(this.failedCalls.get() + 1);
            }
        }

        public List<UserSpec> getUserSpecs() {
            return this.newUserSpecs;
        }
    }
}

