/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts;

import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.DesiredStatus;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts.UpdateSfaExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.jobs.states.UpdateUntilFinalOpStateTaskState;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.SliceManifestForAuthorityTask;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreSfaExperimentPartStateSlice
extends ExperimentPartStateSlice<SfaExperimentPart> {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreSfaExperimentPartStateSlice.class);
    private final HighLevelTaskFactory hltf;
    private final JobStateFactory jobStateFactory;

    public RestoreSfaExperimentPartStateSlice(Job<?> job, SfaExperimentPart experimentPart, HighLevelTaskFactory hltf, JobStateFactory jobStateFactory) {
        super(job, experimentPart);
        this.hltf = hltf;
        this.jobStateFactory = jobStateFactory;
    }

    @Override
    public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
        if (((SfaExperimentPart)this.experimentPart).getConnectSfaAuthority().isEdgeVlan()) {
            LOG.debug("Skipping restore of fake authority {}", (Object)((SfaExperimentPart)this.experimentPart).getConnectSfaAuthority().getName());
            return ExperimentTaskStatus.SUCCESS;
        }
        FetchSliceManifestForAuthorityState fetchManifestState = new FetchSliceManifestForAuthorityState((SfaExperimentPart)this.experimentPart);
        this.setAndRunState(fetchManifestState);
        if (fetchManifestState.getTaskExecution().getState() != TaskExecution.TaskState.SUCCESS || this.experiment.getRequestedStartTime() != null && this.experiment.getRequestedStartTime().isAfter(Instant.now())) {
            return ExperimentTaskStatus.WARNING;
        }
        UpdateSfaExperimentPartStateSlice.UpdateExperimentPartState updateStatusState = new UpdateSfaExperimentPartStateSlice.UpdateExperimentPartState(this.experiment, this.hltf, (SfaExperimentPart)this.experimentPart);
        this.setAndRunState(updateStatusState);
        if (((SfaExperimentPart)this.experimentPart).getStatusDetails().getGlobalStatus() == StatusDetails.SliverStatus.READY) {
            return ExperimentTaskStatus.SUCCESS;
        }
        if (((SfaExperimentPart)this.experimentPart).getStatusDetails().getGlobalStatus() == StatusDetails.SliverStatus.CHANGING) {
            return ExperimentTaskStatus.SUCCESS;
        }
        UpdateUntilFinalOpStateTaskState updateUntilReadyOrFailTaskState = this.jobStateFactory.createGetStatusUntilReadyOrFailTaskState(this.job, LOG, this.experiment.getCheckReadyInterval(), this.experiment.getMaxWaitUntilReady(), (SfaExperimentPart)this.experimentPart, DesiredStatus.GENI_READY);
        updateUntilReadyOrFailTaskState.setWaitForFirstCheck(false);
        this.setAndRunState(updateUntilReadyOrFailTaskState);
        return updateUntilReadyOrFailTaskState.getStatus();
    }

    private class FetchSliceManifestForAuthorityState
    extends SingleCallState<SliceManifestForAuthorityTask> {
        public FetchSliceManifestForAuthorityState(SfaExperimentPart experimentPart) {
            super(String.format("Requesting experiment information at %s", experimentPart.getName()), RestoreSfaExperimentPartStateSlice.this.hltf.getSliceManifest(RestoreSfaExperimentPartStateSlice.this.experiment.getSlice(), experimentPart.getConnectSfaAuthority()));
        }
    }
}

