/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts;

import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts.EditSshKeysOnSfaExperimentPartJobSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts.RenewSfaExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts.RestoreSfaExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts.StopSfaExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts.UpdateSfaExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticAggregateManagerWrapper;
import java.time.Instant;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class SfaExperimentPartController
implements ExperimentPartController<SfaExperimentPart> {
    private final Provider<HighLevelTaskFactory> hltfProvider;
    private final Provider<JobStateFactory> jobStateFactoryProvider;
    private final Provider<AggregateManagerWrapperFactory> aggregateManagerWrapperFactoryProvider;
    private final AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory;

    @Inject
    public SfaExperimentPartController(Provider<HighLevelTaskFactory> hltfProvider, Provider<JobStateFactory> jobStateFactoryProvider, Provider<AggregateManagerWrapperFactory> aggregateManagerWrapperFactoryProvider, AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory) {
        this.hltfProvider = hltfProvider;
        this.jobStateFactoryProvider = jobStateFactoryProvider;
        this.aggregateManagerWrapperFactoryProvider = aggregateManagerWrapperFactoryProvider;
        this.automaticAggregateManagerWrapperFactory = automaticAggregateManagerWrapperFactory;
    }

    @Override
    public boolean supportsRestore(SfaExperimentPart experimentPart) {
        return true;
    }

    @Override
    public ExperimentPartStateSlice<SfaExperimentPart> restore(Job<?> job, SfaExperimentPart experimentPart) {
        return new RestoreSfaExperimentPartStateSlice(job, experimentPart, (HighLevelTaskFactory)this.hltfProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get());
    }

    @Override
    public boolean supportsRenew(SfaExperimentPart experimentPart) {
        return true;
    }

    @Override
    public ExperimentPartStateSlice<SfaExperimentPart> renew(Job<?> job, SfaExperimentPart experimentPart, Instant newExpirationTime) {
        return new RenewSfaExperimentPartStateSlice(job, experimentPart, newExpirationTime, (HighLevelTaskFactory)this.hltfProvider.get());
    }

    @Override
    public boolean supportsEditSshKeys(SfaExperimentPart experimentPart) {
        return !experimentPart.getConnectSfaAuthority().isEdgeVlan() && this.automaticAggregateManagerWrapperFactory.create(experimentPart.getConnectSfaAuthority()).isEditSshKeysSupported();
    }

    @Override
    public ExperimentPartStateSlice<SfaExperimentPart> editSshKeys(Job<?> job, SfaExperimentPart experimentPart, Collection<UserSpec> userSpecs) {
        return new EditSshKeysOnSfaExperimentPartJobSlice(job, experimentPart, userSpecs, (HighLevelTaskFactory)this.hltfProvider.get(), (AggregateManagerWrapperFactory)this.aggregateManagerWrapperFactoryProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get());
    }

    public UpdateSfaExperimentPartStateSlice update(Job<?> job, SfaExperimentPart experimentPart) {
        return new UpdateSfaExperimentPartStateSlice(job, experimentPart, (HighLevelTaskFactory)this.hltfProvider.get());
    }

    @Override
    public ExperimentPartStateSlice<SfaExperimentPart> stop(Job<?> job, SfaExperimentPart experimentPart) {
        return new StopSfaExperimentPartStateSlice(job, experimentPart, (HighLevelTaskFactory)this.hltfProvider.get(), (JobStateFactory)this.jobStateFactoryProvider.get());
    }
}

