/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.JobWithSshConnectionManager;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSlice;
import be.iminds.ilabt.jfed.highlevel.util.ExternalFileUtil;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.highlevel.util.StringMemorySourceFile;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.AnsibleService;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.util.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ExecuteAnsibleServicesState
extends SlicedState<ExecuteAnsibleServiceStateSlice> {
    private static final Logger ACTUAL_LOG = LoggerFactory.getLogger(ExecuteAnsibleServicesState.class);
    private final Logger LOG;
    @Nonnull
    private final SetupSoftwareExperimentJob job;
    @Nonnull
    private final Experiment experiment;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final List<ExecuteAnsibleServiceStateSlice> slices;

    protected ExecuteAnsibleServicesState(@Nonnull SetupSoftwareExperimentJob job, @Nonnull GeniUserProvider geniUserProvider) {
        super("Execute ansible services");
        this.job = job;
        this.LOG = new LogEntryGeneratorWrappingLogger(ACTUAL_LOG, job.getJobReport());
        this.geniUserProvider = geniUserProvider;
        this.experiment = job.getExperiment();
        this.experiment.requireSlice();
        List<Pair<RspecNode, AnsibleService>> ansibleServices = ExecuteAnsibleServicesState.getRelevantAnsibleServices(this.experiment);
        this.slices = ansibleServices.stream().map(p -> new ExecuteAnsibleServiceStateSlice(job, (RspecNode)p.getKey(), (AnsibleService)p.getValue())).collect(Collectors.toList());
    }

    @Nonnull
    private static List<Pair<RspecNode, AnsibleService>> getRelevantAnsibleServices(@Nonnull Experiment experiment) {
        ImmutableModelRspec model;
        RequestRspecSource requestRspecSource = experiment.getSlice().getRequestRspec();
        ImmutableModelRspec immutableModelRspec = model = requestRspecSource == null ? null : requestRspecSource.getImmutableModelRspec();
        assert (model != null);
        if (model == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<RspecNode, AnsibleService>> res = new ArrayList<Pair<RspecNode, AnsibleService>>();
        for (RspecNode node : model.getNodes()) {
            if (node.getAnsibleServices() == null) continue;
            res.addAll(node.getAnsibleServices().stream().filter(Objects::nonNull).filter(as -> as.getInventory() != null || as.getExecutePlaybook() != null).map(as -> new Pair((Object)node, as)).collect(Collectors.toList()));
        }
        return res;
    }

    public static boolean hasAnsibleServices(Experiment experiment) {
        return !ExecuteAnsibleServicesState.getRelevantAnsibleServices(experiment).isEmpty();
    }

    @Override
    public Collection<ExecuteAnsibleServiceStateSlice> getSlices() {
        return this.slices;
    }

    public class ExecuteAnsibleServiceStateSlice
    extends StateSlice {
        @Nonnull
        protected final RspecNode node;
        @Nonnull
        protected final AnsibleService ansibleService;
        @Nonnull
        protected final SetupSoftwareExperimentJob setupSoftwareExperimentJob;
        @Nullable
        private SSHClient ssh;
        @Nullable
        private ExternalFileUtil externalFileUtil;

        public ExecuteAnsibleServiceStateSlice(@Nonnull SetupSoftwareExperimentJob job, @Nonnull RspecNode node, AnsibleService ansibleService) {
            super(job);
            this.ssh = null;
            this.setupSoftwareExperimentJob = job;
            this.node = node;
            this.ansibleService = ansibleService;
        }

        @Override
        public String getName() {
            return "Execute ansible-playbook " + this.ansibleService.getExecutePlaybook() + " on " + this.node.getClientId();
        }

        @Override
        public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
            try {
                this.ssh = this.setupSoftwareExperimentJob.getSSHClient(this.node, this);
            }
            catch (JobWithSshConnectionManager.SshException e) {
                ExecuteAnsibleServicesState.this.LOG.warn("Aborting ExecuteAnsibleServiceStateSlice.statefulRun due to SSH comnection problem", (Throwable)e);
                return ExperimentTaskStatus.FAILED;
            }
            assert (this.ssh != null);
            this.externalFileUtil = new ExternalFileUtil(this.ssh);
            if (this.ansibleService.getInventory() != null) {
                this.setAndRunState(new UploadInventoryState());
            } else {
                ExecuteAnsibleServicesState.this.LOG.debug("No inventory-path specified. Skipping upload inventory");
            }
            ExecuteAnsibleServiceState executeAnsibleServiceState = new ExecuteAnsibleServiceState();
            this.setAndRunState(executeAnsibleServiceState);
            this.setupSoftwareExperimentJob.closeSSH(this.node);
            return executeAnsibleServiceState.getStatus();
        }

        public class UploadInventoryState
        extends State {
            @Nonnull
            private final ModelRspec request;
            @Nonnull
            private final ModelRspec manifest;

            protected UploadInventoryState() {
                ImmutableModelRspec manifest;
                ImmutableModelRspec request;
                super("Uploading inventory on " + ExecuteAnsibleServiceStateSlice.this.node.getClientId());
                assert (ExecuteAnsibleServiceStateSlice.this.experiment.getNewRequestRspecSource() != null);
                ImmutableModelRspec immutableModelRspec = request = ExecuteAnsibleServiceStateSlice.this.experiment.getNewRequestRspecSource() == null ? null : ExecuteAnsibleServiceStateSlice.this.experiment.getNewRequestRspecSource().getImmutableModelRspec();
                if (request == null) {
                    ExecuteAnsibleServicesState.this.LOG.error("Cannot create inventory file because parsing request rspec failed");
                    throw new RuntimeException("Cannot create inventory file because parsing request rspec failed");
                }
                this.request = request;
                assert (ExecuteAnsibleServiceStateSlice.this.experiment.getSliceOrNull() != null);
                ImmutableModelRspec immutableModelRspec2 = manifest = ExecuteAnsibleServiceStateSlice.this.experiment.getSliceOrNull() == null || ExecuteAnsibleServiceStateSlice.this.experiment.getSliceOrNull().getManifestRspec() == null ? null : ExecuteAnsibleServiceStateSlice.this.experiment.getSliceOrNull().getManifestRspec().getImmutableModelRspec();
                if (manifest == null) {
                    ExecuteAnsibleServicesState.this.LOG.error("Cannot create inventory file because parsing manifest rspec failed");
                    throw new RuntimeException("Cannot create inventory file because parsing manifest rspec failed");
                }
                this.manifest = manifest;
                if (ExecuteAnsibleServiceStateSlice.this.experiment.getSliceOrNull().getManifestRspec().getStringRspec() == null) {
                    ExecuteAnsibleServicesState.this.LOG.error("Cannot create inventory file because parsing manifest rspec failed");
                    throw new RuntimeException("Cannot create inventory file because parsing manifest rspec failed");
                }
            }

            public String createInventoryFile() {
                HashMultimap nodesPerGroup = HashMultimap.create();
                for (RspecNode node2 : this.request.getNodes()) {
                    if (!node2.getAnsibleGroups().isEmpty()) {
                        node2.getAnsibleGroups().forEach(arg_0 -> UploadInventoryState.lambda$createInventoryFile$0((Multimap)nodesPerGroup, node2, arg_0));
                        continue;
                    }
                    nodesPerGroup.put(null, (Object)node2);
                }
                StringBuilder inventory = new StringBuilder();
                if (nodesPerGroup.containsKey(null)) {
                    Collection grouplessNodes = nodesPerGroup.removeAll(null);
                    grouplessNodes.forEach(node -> this.writeNodeToInventory((RspecNode)node, inventory));
                    inventory.append('\n');
                }
                for (String groupName : nodesPerGroup.keySet()) {
                    inventory.append("[").append(groupName).append("]\n");
                    nodesPerGroup.get((Object)groupName).forEach(node -> this.writeNodeToInventory((RspecNode)node, inventory));
                    inventory.append('\n');
                }
                return inventory.toString();
            }

            private void writeNodeToInventory(RspecNode node, StringBuilder inventory) {
                BasicStringRspec.LoginService loginService = ExecuteAnsibleServiceStateSlice.this.setupSoftwareExperimentJob.getBestNodeLoginFinder().findBestLogin(node.getUniqueId());
                if (loginService != null) {
                    inventory.append(node.getClientId()).append("\tansible_host=").append(loginService.getHostname());
                    if (loginService.getPort() != 22) {
                        inventory.append("\tansible_port=").append(loginService.getPort());
                    }
                    if (!Objects.equals(loginService.getUsername(), ExecuteAnsibleServicesState.this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getResourceName())) {
                        inventory.append("\tansible_user=").append(loginService.getUsername());
                    }
                    inventory.append('\n');
                }
            }

            @Override
            @Nonnull
            protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
                String inventoryFilename = ExecuteAnsibleServiceStateSlice.this.ansibleService.getInventory() != null ? ExecuteAnsibleServiceStateSlice.this.ansibleService.getInventory() : "/etc/ansible/hosts";
                try {
                    String inventory = this.createInventoryFile();
                    ExternalFileUtil cfr_ignored_0 = ExecuteAnsibleServiceStateSlice.this.externalFileUtil;
                    ExecuteAnsibleServiceStateSlice.this.ssh.newSCPFileTransfer().upload((LocalSourceFile)new StringMemorySourceFile(ExternalFileUtil.getBasename(inventoryFilename), inventory), ExecuteAnsibleServiceStateSlice.this.externalFileUtil.getFolder(inventoryFilename));
                }
                catch (IOException ex) {
                    ExecuteAnsibleServicesState.this.LOG.error("Error while uploading inventory-file to {} on {}", new Object[]{inventoryFilename, ExecuteAnsibleServiceStateSlice.this.node.getClientId(), ex});
                    this.updateMessage(String.format("Error while uploading inventory-file to %s on %s: %s", inventoryFilename, ExecuteAnsibleServiceStateSlice.this.node.getClientId(), ex.getMessage()));
                    return ExperimentTaskStatus.FAILED;
                }
                return ExperimentTaskStatus.SUCCESS;
            }

            private static /* synthetic */ void lambda$createInventoryFile$0(Multimap nodesPerGroup, RspecNode node, String groupName) {
                nodesPerGroup.put((Object)groupName, (Object)node);
            }
        }

        public class ExecuteAnsibleServiceState
        extends State {
            private final StringProperty galaxyInputStream;
            private final StringProperty galaxyErrorStream;
            private final StringProperty playbookInputStream;
            private final StringProperty playbookErrorStream;

            protected ExecuteAnsibleServiceState() {
                super("Executing ansible-playbook '" + ExecuteAnsibleServiceStateSlice.this.ansibleService.getExecutePlaybook() + "' on " + ExecuteAnsibleServiceStateSlice.this.node.getClientId());
                this.galaxyInputStream = new SimpleStringProperty("");
                this.galaxyErrorStream = new SimpleStringProperty("");
                this.playbookInputStream = new SimpleStringProperty("");
                this.playbookErrorStream = new SimpleStringProperty("");
            }

            @Override
            @Nonnull
            protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
                try {
                    String filename;
                    String folder;
                    int dividerPosition;
                    if (ExecuteAnsibleServiceStateSlice.this.ansibleService.getInstallRequirements() != null) {
                        dividerPosition = ExecuteAnsibleServiceStateSlice.this.ansibleService.getInstallRequirements().lastIndexOf(47);
                        folder = ExecuteAnsibleServiceStateSlice.this.ansibleService.getInstallRequirements().substring(0, dividerPosition);
                        filename = ExecuteAnsibleServiceStateSlice.this.ansibleService.getInstallRequirements().substring(dividerPosition + 1);
                        String galaxyCommand = ExecuteAnsibleServiceStateSlice.this.ansibleService.getGalaxyCommand();
                        if (galaxyCommand == null) {
                            galaxyCommand = "ansible-galaxy";
                        }
                        String galaxyCommandString = String.format("cd %s && %s install -r %s", folder, galaxyCommand, filename);
                        ExecuteAnsibleServicesState.this.LOG.debug("Executing galaxy command: " + galaxyCommandString);
                        Session.Command c = ExecuteAnsibleServiceStateSlice.this.ssh.startSession().exec(galaxyCommandString);
                        new InputStreamToStringPropertyReaderThread(c.getInputStream(), this.galaxyInputStream, Level.INFO, "GALAXY-OUTPUT: ").start();
                        new InputStreamToStringPropertyReaderThread(c.getErrorStream(), this.galaxyErrorStream, Level.WARN, "GALAXY-ERROR: ").start();
                        c.join();
                        if (c.getExitStatus() != 0) {
                            this.updateMessage("ansible-galaxy execution was unsuccessful. Aborting");
                            return ExperimentTaskStatus.FAILED;
                        }
                    }
                    assert (ExecuteAnsibleServiceStateSlice.this.ansibleService.getExecutePlaybook() != null);
                    dividerPosition = ExecuteAnsibleServiceStateSlice.this.ansibleService.getExecutePlaybook().lastIndexOf(47);
                    folder = ExecuteAnsibleServiceStateSlice.this.ansibleService.getExecutePlaybook().substring(0, dividerPosition);
                    filename = ExecuteAnsibleServiceStateSlice.this.ansibleService.getExecutePlaybook().substring(dividerPosition + 1);
                    String playbookCommand = ExecuteAnsibleServiceStateSlice.this.ansibleService.getPlaybookCommand();
                    if (playbookCommand == null) {
                        playbookCommand = "ansible-playbook";
                    }
                    Object arguments = "";
                    arguments = (String)arguments + filename;
                    if (Objects.equals(ExecuteAnsibleServiceStateSlice.this.ansibleService.getDebug(), Boolean.TRUE)) {
                        arguments = (String)arguments + " -v";
                    }
                    if (ExecuteAnsibleServiceStateSlice.this.ansibleService.getInventory() != null) {
                        arguments = (String)arguments + " -i '" + ExecuteAnsibleServiceStateSlice.this.ansibleService.getInventory() + "'";
                    }
                    if (ExecuteAnsibleServiceStateSlice.this.ansibleService.getLogfile() != null) {
                        arguments = (String)arguments + " 2>&1 | tee '" + ExecuteAnsibleServiceStateSlice.this.ansibleService.getLogfile() + "'";
                    }
                    String playbookCommandString = String.format("cd %s && %s %s", folder, playbookCommand, arguments);
                    ExecuteAnsibleServicesState.this.LOG.debug("Executing playbook command: " + playbookCommandString);
                    Session.Command c = ExecuteAnsibleServiceStateSlice.this.ssh.startSession().exec(playbookCommandString);
                    new InputStreamToStringPropertyReaderThread(c.getInputStream(), this.playbookInputStream, Level.INFO, "PLAYBOOK-OUTPUT: ").start();
                    new InputStreamToStringPropertyReaderThread(c.getErrorStream(), this.playbookErrorStream, Level.WARN, "PLAYBOOK-ERROR: ").start();
                    c.join();
                    if (c.getExitStatus() != 0) {
                        this.updateMessage("ansible-playbook execution was unsuccessful.");
                        return ExperimentTaskStatus.FAILED;
                    }
                }
                catch (ConnectionException | TransportException ex) {
                    throw new JFedException("SSH-exception while executing ansible: " + ex.getMessage(), ex);
                }
                return ExperimentTaskStatus.SUCCESS;
            }

            public StringProperty getGalaxyInputStream() {
                return this.galaxyInputStream;
            }

            public StringProperty getGalaxyErrorStream() {
                return this.galaxyErrorStream;
            }

            public StringProperty getPlaybookInputStream() {
                return this.playbookInputStream;
            }

            public StringProperty getPlaybookErrorStream() {
                return this.playbookErrorStream;
            }

            public RspecNode getNode() {
                return ExecuteAnsibleServiceStateSlice.this.node;
            }

            public AnsibleService getAnsibleService() {
                return ExecuteAnsibleServiceStateSlice.this.ansibleService;
            }
        }
    }

    private class InputStreamToStringPropertyReaderThread
    extends Thread {
        private final InputStream inputStream;
        private final StringProperty output;
        private final String logPrefix;
        private final LogFunction logFunction;

        private InputStreamToStringPropertyReaderThread(InputStream inputStream, @Nullable StringProperty output, Level logLevel, String logPrefix) {
            this.inputStream = inputStream;
            this.output = output;
            this.logPrefix = logPrefix;
            if (logLevel != null) {
                switch (logLevel) {
                    case TRACE: {
                        this.logFunction = arg_0 -> ((Logger)ExecuteAnsibleServicesState.this.LOG).trace(arg_0);
                        break;
                    }
                    case DEBUG: {
                        this.logFunction = arg_0 -> ((Logger)ExecuteAnsibleServicesState.this.LOG).debug(arg_0);
                        break;
                    }
                    case INFO: {
                        this.logFunction = arg_0 -> ((Logger)ExecuteAnsibleServicesState.this.LOG).info(arg_0);
                        break;
                    }
                    case WARN: {
                        this.logFunction = arg_0 -> ((Logger)ExecuteAnsibleServicesState.this.LOG).warn(arg_0);
                        break;
                    }
                    case ERROR: {
                        this.logFunction = arg_0 -> ((Logger)ExecuteAnsibleServicesState.this.LOG).error(arg_0);
                        break;
                    }
                    default: {
                        this.logFunction = null;
                        break;
                    }
                }
            } else {
                this.logFunction = null;
            }
        }

        @Override
        public void run() {
            try {
                String s;
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.inputStream));
                while ((s = stdInput.readLine()) != null) {
                    System.out.println(s);
                    String str = s;
                    if (this.logFunction != null) {
                        this.logFunction.log(this.logPrefix + str);
                    }
                    Platform.runLater(() -> this.output.setValue((String)this.output.get() + "\n" + str));
                }
                this.inputStream.close();
            }
            catch (IOException ex) {
                ExecuteAnsibleServicesState.this.LOG.error("Error while reading from InputStream to StringProperty", (Throwable)ex);
            }
        }
    }

    private static interface LogFunction {
        public void log(String var1);
    }
}

