/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.espec.ESpecLogic;
import be.iminds.ilabt.jfed.espec.model.AnsibleGalaxySpec;
import be.iminds.ilabt.jfed.espec.model.AnsibleHostSpec;
import be.iminds.ilabt.jfed.espec.model.AnsiblePlaybookSpec;
import be.iminds.ilabt.jfed.espec.model.AnsibleSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.model.UploadLikeWithLogSpec;
import be.iminds.ilabt.jfed.espec.parser.ESpecConstants;
import be.iminds.ilabt.jfed.espec.parser.ESpecDefaults;
import be.iminds.ilabt.jfed.espec.util.ChModPermissionsUtil;
import be.iminds.ilabt.jfed.espec.util.ESpecLogger;
import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import be.iminds.ilabt.jfed.espec.util.LimitedLiveLogImpl;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.JobWithSshConnectionManager;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.jobs.states.ExperimentSpecificationServicesSingleExecuteState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.RemotePathResolver;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.util.ExternalFileUtil;
import be.iminds.ilabt.jfed.highlevel.util.InputStreamToLogsThread;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.highlevel.util.StringMemorySourceFile;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.util.lib.AnsibleFileWriter;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ExperimentSpecificationServicesAnsibleState
extends SlicedState<ExperimentSpecificationServicesAnsibleStateSlice> {
    private static final Logger ACTUAL_LOG = LoggerFactory.getLogger(ExperimentSpecificationServicesAnsibleState.class);
    private final Logger LOG;
    @Nonnull
    private final SetupSoftwareExperimentJob job;
    @Nonnull
    private final Experiment experiment;
    @Nonnull
    private final ExperimentSpecification experimentSpecification;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final Provider<SfaModel> sfaModelProvider;
    @Nonnull
    private final Provider<ExperimentPartControllerManager> epcManagerProvider;
    @Nonnull
    private final RemotePathResolver remotePathResolver;
    @Nonnull
    private final AnsibleSpec ansibleSpec;
    @Nonnull
    private final ESpecLogger eSpecLogger;
    private final boolean useRemoteAnsibleNode;
    @Nonnull
    private final String ansibleNodeClientId;
    @Nonnull
    private final RspecNode ansibleNode;
    @Nonnull
    private final List<ExperimentSpecificationServicesAnsibleStateSlice> slices;

    protected ExperimentSpecificationServicesAnsibleState(@Nonnull SetupSoftwareExperimentJob job, @Nonnull GeniUserProvider geniUserProvider, @Nonnull RemotePathResolver remotePathResolver, @Nonnull AnsibleSpec ansibleSpec, @Nonnull Provider<SfaModel> sfaModelProvider, @Nonnull Provider<ExperimentPartControllerManager> epcManagerProvider) {
        super("Execute ansible services");
        ImmutableModelRspec request;
        this.job = job;
        this.LOG = new LogEntryGeneratorWrappingLogger(ACTUAL_LOG, job.getJobReport());
        this.geniUserProvider = geniUserProvider;
        this.sfaModelProvider = sfaModelProvider;
        this.epcManagerProvider = epcManagerProvider;
        this.remotePathResolver = remotePathResolver;
        this.ansibleSpec = ansibleSpec;
        this.experiment = job.getExperiment();
        if (job.getExperiment().getExperimentSpecification() == null) {
            throw new IllegalStateException("job.getExperiment().getExperimentSpecification() is null");
        }
        this.experimentSpecification = job.getExperiment().getExperimentSpecification();
        this.eSpecLogger = this.experiment.getExperimentSpecificationLogger();
        this.experiment.requireSlice();
        assert (ESpecLogic.hasAnsibleNode((ExperimentSpecification)this.experimentSpecification));
        boolean bl = this.useRemoteAnsibleNode = ansibleSpec.getAnsibleHostSpec().getHostType() != AnsibleHostSpec.HostType.LOCAL;
        if (!this.useRemoteAnsibleNode) {
            throw new RuntimeException("LOCAL ansible execute is not yet implemented.");
        }
        if (ansibleSpec.getAnsibleHostSpec().getNodeName() == null) {
            throw new IllegalStateException("ansible node name should be set");
        }
        ImmutableModelRspec immutableModelRspec = request = this.experiment.getNewRequestRspecSource() == null ? null : this.experiment.getNewRequestRspecSource().getImmutableModelRspec();
        if (request == null) {
            ImmutableModelRspec immutableModelRspec2 = request = this.experiment.getExistingRequestRspecSource() == null ? null : this.experiment.getExistingRequestRspecSource().getImmutableModelRspec();
        }
        if (request == null) {
            String err = "Cannot find ansible node because parsing request rspec failed. exp.getNewRequestRspecSource()=" + (this.experiment.getNewRequestRspecSource() == null ? "null" : "non-null") + " exp.getExistingRequestRspecSource()=" + (this.experiment.getExistingRequestRspecSource() == null ? "null" : "non-null") + " exp.getSlice().getRequestRspec()=" + (this.experiment.getSlice().getRequestRspec() == null ? "null" : "non-null") + " exp.getSlice().getManifestRspec()=" + (this.experiment.getSlice().getManifestRspec() == null ? "null" : "non-null") + " ";
            this.LOG.error(err);
            throw new RuntimeException(err);
        }
        this.LOG.info("ExperimentSpecificationServicesAnsibleState has request.");
        RspecNode ansibleNode = request.getNodeByClientId(ansibleSpec.getAnsibleHostSpec().getNodeName());
        if (ansibleNode == null || ansibleNode.getClientId() == null) {
            String err = "Cannot find ansible node \"" + ansibleSpec.getAnsibleHostSpec().getNodeName() + "\" in request rspec";
            this.LOG.error(err);
            throw new RuntimeException(err);
        }
        this.ansibleNode = ansibleNode;
        this.ansibleNodeClientId = ansibleNode.getClientId();
        this.slices = Collections.singletonList(new ExperimentSpecificationServicesAnsibleStateSlice(job, ansibleNode, ansibleSpec));
    }

    @Override
    public Collection<ExperimentSpecificationServicesAnsibleStateSlice> getSlices() {
        return this.slices;
    }

    @Nonnull
    private static String ensureEndsWithSlash(@Nonnull String p) {
        if (p.endsWith("/")) {
            return p;
        }
        return p + "/";
    }

    @Nonnull
    private static String ensureStartsWithSlash(@Nonnull String p) {
        if (p.startsWith("/")) {
            return p;
        }
        return "/" + p;
    }

    public class ExperimentSpecificationServicesAnsibleStateSlice
    extends StateSlice {
        @Nonnull
        protected final SetupSoftwareExperimentJob setupSoftwareExperimentJob;
        @Nonnull
        protected final RspecNode ansibleNode;
        @Nonnull
        protected final AnsibleSpec ansibleSpec;
        @Nonnull
        private String galaxyCommand;
        @Nonnull
        private String galaxyInstallTemplate;
        @Nonnull
        private String playbookCommand;
        @Nonnull
        private String playbookRunTemplate;
        private String ansibleRemoteDirPath;

        public ExperimentSpecificationServicesAnsibleStateSlice(@Nonnull SetupSoftwareExperimentJob job, @Nonnull RspecNode ansibleNode, AnsibleSpec ansibleSpec) {
            super(job);
            this.setupSoftwareExperimentJob = job;
            this.ansibleNode = ansibleNode;
            this.ansibleSpec = ansibleSpec;
            this.galaxyCommand = ansibleSpec.getAnsibleHostSpec().getGalaxyCommand() == null ? "ansible-galaxy" : ansibleSpec.getAnsibleHostSpec().getGalaxyCommand();
            this.galaxyInstallTemplate = ansibleSpec.getAnsibleHostSpec().getGalaxyInstallTemplate() == null ? "%c collection install -r %r -p galaxy_collections" : ansibleSpec.getAnsibleHostSpec().getGalaxyInstallTemplate();
            this.playbookCommand = ansibleSpec.getAnsibleHostSpec().getPlaybookCommand() == null ? "ansible-playbook" : ansibleSpec.getAnsibleHostSpec().getPlaybookCommand();
            this.playbookRunTemplate = ansibleSpec.getAnsibleHostSpec().getPlaybookRunTemplate() == null ? "ANSIBLE_COLLECTIONS_PATH=galaxy_collections %c %x %p" : ansibleSpec.getAnsibleHostSpec().getPlaybookRunTemplate();
        }

        @Override
        public String getName() {
            return "Ansible on " + this.ansibleNode.getClientId();
        }

        @Override
        public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
            SSHClient ssh;
            try {
                ssh = this.setupSoftwareExperimentJob.getSSHClient(this.ansibleNode, this);
            }
            catch (JobWithSshConnectionManager.SshException e) {
                ExperimentSpecificationServicesAnsibleState.this.LOG.warn("Aborting ExecuteAnsibleServiceStateSlice.statefulRun due to SSH comnection problem", (Throwable)e);
                return ExperimentTaskStatus.FAILED;
            }
            assert (ssh != null);
            ExternalFileUtil externalFileUtil = new ExternalFileUtil(ssh);
            String ansibleDirContentPath = ExperimentSpecificationServicesAnsibleState.this.remotePathResolver.getRemotePath(ESpecConstants.DirContent.ANSIBLE, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId);
            if (ansibleDirContentPath == null) {
                throw new IllegalStateException("Unknown ansible content dir");
            }
            this.ansibleRemoteDirPath = ExperimentSpecificationServicesAnsibleState.ensureEndsWithSlash(ansibleDirContentPath);
            ExperimentSpecificationServicesAnsibleState.this.eSpecLogger.firePreAnsible();
            PrepareAnsibleDirState prepareAnsibleDirState = new PrepareAnsibleDirState(ssh);
            this.setAndRunState(prepareAnsibleDirState);
            ExperimentTaskStatus worstStatus = prepareAnsibleDirState.getStatus();
            for (AnsibleGalaxySpec gs : this.ansibleSpec.getAnsibleGalaxySpecs()) {
                RunGalaxyState executeGalaxyState = new RunGalaxyState(gs, ssh);
                this.setAndRunState(executeGalaxyState);
                worstStatus = ExperimentTaskStatus.worstOf(worstStatus, executeGalaxyState.getStatus());
            }
            for (AnsiblePlaybookSpec pbs : this.ansibleSpec.getAnsiblePlaybookSpecs()) {
                ExecutePlayBookState executePlayBookState = new ExecutePlayBookState(pbs, ssh);
                this.setAndRunState(executePlayBookState);
                worstStatus = ExperimentTaskStatus.worstOf(worstStatus, executePlayBookState.getStatus());
            }
            this.setupSoftwareExperimentJob.closeSSH(this.ansibleNode);
            ExperimentSpecificationServicesAnsibleState.this.eSpecLogger.firePostAnsibleAll(worstStatus == ExperimentTaskStatus.SUCCESS);
            return worstStatus;
        }

        public class PrepareAnsibleDirState
        extends State {
            @Nonnull
            private final SSHClient ssh;

            protected PrepareAnsibleDirState(SSHClient ssh) {
                super("Preparing ansible dir '" + ExperimentSpecificationServicesAnsibleStateSlice.this.ansibleRemoteDirPath + "'");
                this.ssh = ssh;
                if (ExperimentSpecificationServicesAnsibleStateSlice.this.experiment.getSlice().getManifestRspec() == null) {
                    throw new IllegalStateException("Cannot prepare ansible node because there is no manifest RSpec.");
                }
                String manifestString = ExperimentSpecificationServicesAnsibleStateSlice.this.experiment.getSlice().getManifestRspec().getRspecXmlString();
                if (manifestString == null || manifestString.isEmpty()) {
                    throw new IllegalStateException("Cannot prepare ansible node because there is an empty manifest RSpec.");
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            @Nonnull
            protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
                if (ExperimentSpecificationServicesAnsibleStateSlice.this.experiment.getKeypairs().isEmpty()) {
                    throw new RuntimeException("Experiment has no keypairs that ansible can use.");
                }
                KeyPair ansibleKeyPair = (KeyPair)ExperimentSpecificationServicesAnsibleStateSlice.this.experiment.getKeypairs().values().iterator().next();
                if (ExperimentSpecificationServicesAnsibleStateSlice.this.experiment.getSlice().getManifestRspec() == null) {
                    throw new IllegalStateException("Cannot prepare ansible node because there is no manifest RSpec.");
                }
                String manifestString = ExperimentSpecificationServicesAnsibleStateSlice.this.experiment.getSlice().getManifestRspec().getRspecXmlString();
                if (manifestString == null) throw new IllegalStateException("Cannot prepare ansible node because there is an empty manifest RSpec.");
                if (manifestString.isEmpty()) {
                    throw new IllegalStateException("Cannot prepare ansible node because there is an empty manifest RSpec.");
                }
                AnsibleFileWriter ansibleFileWriter = AnsibleFileWriter.createWithCopiedPrivateKey((BasicStringRspec)new BasicStringRspec(manifestString), (PrivateKey)ansibleKeyPair.getPrivate(), (PublicKey)ansibleKeyPair.getPublic(), (GeniUser)ExperimentSpecificationServicesAnsibleState.this.geniUserProvider.getLoggedInGeniUser(), null, (String)ExperimentSpecificationServicesAnsibleState.this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getResourceName());
                if (ExperimentSpecificationServicesAnsibleStateSlice.this.ansibleSpec.getGroups() != null) {
                    ansibleFileWriter.addExtraGroups(ExperimentSpecificationServicesAnsibleStateSlice.this.ansibleSpec.getGroups());
                }
                List ansibleFiles = ansibleFileWriter.getFilesToWrite(false);
                try (SFTPClient sftpClient = this.ssh.newSFTPClient();){
                    Iterator iterator = ansibleFiles.iterator();
                    while (iterator.hasNext()) {
                        AnsibleFileWriter.AnsibleFileInfo ansibleFileInfo = (AnsibleFileWriter.AnsibleFileInfo)iterator.next();
                        String fullPath = ExperimentSpecificationServicesAnsibleStateSlice.this.ansibleRemoteDirPath + ansibleFileInfo.getFilename();
                        try {
                            this.ssh.newSCPFileTransfer().upload((LocalSourceFile)new StringMemorySourceFile(ansibleFileInfo.getFilename(), ansibleFileInfo.getContent()), fullPath);
                            if (!ansibleFileInfo.isPrivateFile()) continue;
                            sftpClient.chmod(fullPath, ChModPermissionsUtil.toMask((String)"u=rw"));
                            this.ssh.startSession().exec("chmod u=rw " + fullPath);
                        }
                        catch (IOException ex) {
                            ExperimentSpecificationServicesAnsibleState.this.LOG.error("Error while uploading inventory-file to {} on {}", new Object[]{fullPath, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId, ex});
                            this.updateMessage(String.format("Error while uploading inventory-file to %s on %s: %s", fullPath, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId, ex.getMessage()));
                            ExperimentTaskStatus experimentTaskStatus = ExperimentTaskStatus.FAILED;
                            if (sftpClient == null) return experimentTaskStatus;
                            sftpClient.close();
                            return experimentTaskStatus;
                        }
                    }
                    return ExperimentTaskStatus.SUCCESS;
                }
                catch (IOException ex) {
                    ExperimentSpecificationServicesAnsibleState.this.LOG.error("Error while initialising SFTP client for ansible preparations", (Throwable)ex);
                    this.updateMessage(String.format("Error while initialising SFTP client for ansible preparations: %s", ex.getMessage()));
                    return ExperimentTaskStatus.FAILED;
                }
            }
        }

        public class RunGalaxyState
        extends State {
            @Nonnull
            private final AnsibleGalaxySpec galaxySpec;
            @Nonnull
            private final SSHClient ssh;

            protected RunGalaxyState(@Nonnull AnsibleGalaxySpec galaxySpec, SSHClient ssh) {
                super("Running galaxy requirements '" + galaxySpec.getDesc() + "'");
                this.galaxySpec = galaxySpec;
                this.ssh = ssh;
            }

            @Override
            @Nonnull
            protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
                try {
                    String remotePath = ExperimentSpecificationServicesAnsibleState.this.remotePathResolver.getRemotePath((UploadLikeSpec)this.galaxySpec, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId);
                    if (remotePath == null) {
                        String err = "Did not find remote path of ansible galaxy requirements. Bug in ansible step?";
                        ExperimentSpecificationServicesAnsibleState.this.LOG.error(err);
                        this.updateMessage(err);
                        throw new RuntimeException(err);
                    }
                    LimitedLiveLogImpl liveLog = new LimitedLiveLogImpl();
                    String logPath = this.galaxySpec.getLog() == null ? (ExperimentSpecificationServicesAnsibleState.this.experimentSpecification.getConfig().isStoreRemoteLogsByDefault() ? ESpecDefaults.deriveAutomaticGalaxyLogFile((String)remotePath) : null) : ExperimentSpecificationServicesAnsibleState.this.remotePathResolver.getRemoteLogPath((UploadLikeWithLogSpec)this.galaxySpec, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId);
                    String galaxyCommandString = ExperimentSpecificationServicesAnsibleStateSlice.this.galaxyInstallTemplate.replaceAll(Pattern.quote("%c"), ExperimentSpecificationServicesAnsibleStateSlice.this.galaxyCommand).replaceAll(Pattern.quote("%r"), remotePath);
                    ExperimentSpecificationServicesAnsibleState.this.LOG.debug("Executing galaxy command: " + galaxyCommandString);
                    String command = ExperimentSpecificationServicesSingleExecuteState.createSshCommand(galaxyCommandString, ExperimentSpecificationServicesAnsibleStateSlice.this.ansibleRemoteDirPath, logPath, false, ExperimentSpecificationServicesAnsibleState.this.experimentSpecification, ESpecDefaults.deriveAutomaticGalaxyScriptFile((String)remotePath));
                    ExperimentSpecificationServicesAnsibleState.this.LOG.debug("Actual SSH exec command: " + command);
                    Session.Command c = this.ssh.startSession().exec(command);
                    new InputStreamToLogsThread(c.getInputStream(), ExperimentSpecificationServicesAnsibleState.this.LOG, Level.INFO, "GALAXY-OUTPUT: ", (LimitedLiveLog)liveLog).start();
                    new InputStreamToLogsThread(c.getErrorStream(), ExperimentSpecificationServicesAnsibleState.this.LOG, Level.WARN, "GALAXY-ERROR: ", (LimitedLiveLog)liveLog).start();
                    c.join();
                    ExperimentSpecificationServicesAnsibleState.this.LOG.debug("Exit status of galaxy command: " + c.getExitStatus());
                    if (c.getExitStatus() != 0) {
                        this.updateMessage("ansible-galaxy execution was unsuccessful. Aborting");
                        return ExperimentTaskStatus.FAILED;
                    }
                }
                catch (ConnectionException | TransportException ex) {
                    throw new JFedException("SSH-exception while executing ansible: " + ex.getMessage(), ex);
                }
                return ExperimentTaskStatus.SUCCESS;
            }
        }

        public class ExecutePlayBookState
        extends State {
            @Nonnull
            private final AnsiblePlaybookSpec playbook;
            @Nonnull
            private final SSHClient ssh;

            protected ExecutePlayBookState(@Nonnull AnsiblePlaybookSpec playbook, SSHClient ssh) {
                super("Executing ansible-playbook '" + playbook.getDesc() + "'");
                this.playbook = playbook;
                this.ssh = ssh;
            }

            @Override
            @Nonnull
            protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
                String remotePath = ExperimentSpecificationServicesAnsibleState.this.remotePathResolver.getRemotePath((UploadLikeSpec)this.playbook, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId);
                ExperimentSpecificationServicesAnsibleState experimentSpecificationServicesAnsibleState = ExperimentSpecificationServicesAnsibleState.this;
                long logId = experimentSpecificationServicesAnsibleState.eSpecLogger.getNextLogId();
                if (remotePath == null) {
                    String err = "Did not find remote path of ansible playbook. Bug in ansible step?";
                    ExperimentSpecificationServicesAnsibleState.this.LOG.error(err);
                    this.updateMessage(err);
                    ExperimentSpecificationServicesAnsibleState.this.eSpecLogger.firePostAnsiblePlaybookFail(logId, this.playbook, "not found", null, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId, err, null);
                    throw new RuntimeException(err);
                }
                LimitedLiveLogImpl liveLog = new LimitedLiveLogImpl();
                ExperimentSpecificationServicesAnsibleState.this.eSpecLogger.firePreAnsiblePlaybook(logId, this.playbook, "not found", null, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId, (LimitedLiveLog)liveLog);
                String logPath = this.playbook.getLog() == null ? (ExperimentSpecificationServicesAnsibleState.this.experimentSpecification.getConfig().isStoreRemoteLogsByDefault() ? ESpecDefaults.deriveAutomaticPlaybookLogFile((String)remotePath) : null) : ExperimentSpecificationServicesAnsibleState.this.remotePathResolver.getRemoteLogPath((UploadLikeWithLogSpec)this.playbook, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId);
                try {
                    Object arguments = "";
                    if (this.playbook.isDebug()) {
                        arguments = (String)arguments + " -";
                        for (int i = 0; i < this.playbook.getDebug(); ++i) {
                            arguments = (String)arguments + "v";
                        }
                    }
                    if (this.playbook.hasExtraVarsString()) {
                        arguments = (String)arguments + " --extra-vars '" + this.playbook.getExtraVarsString() + "'";
                    }
                    if (this.playbook.hasExtraVarsJsonFileSpec()) {
                        AnsiblePlaybookSpec.ExtraVarsJsonFileSpec extraVarsJson = this.playbook.getExtraVarsJsonFileSpec();
                        if (extraVarsJson == null) {
                            throw new IllegalStateException("Illegal state of playbook related to extravars");
                        }
                        String extraVarsRemotePath = ExperimentSpecificationServicesAnsibleState.this.remotePathResolver.getRemotePath((UploadLikeSpec)extraVarsJson, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId);
                        arguments = (String)arguments + " --extra-vars '@" + extraVarsRemotePath + "'";
                    }
                    String playbookCommandString = ExperimentSpecificationServicesAnsibleStateSlice.this.playbookRunTemplate.replaceAll(Pattern.quote("%c"), ExperimentSpecificationServicesAnsibleStateSlice.this.playbookCommand).replaceAll(Pattern.quote("%p"), remotePath).replaceAll(Pattern.quote("%x"), (String)arguments);
                    String command = ExperimentSpecificationServicesSingleExecuteState.createSshCommand(playbookCommandString, ExperimentSpecificationServicesAnsibleStateSlice.this.ansibleRemoteDirPath, logPath, false, ExperimentSpecificationServicesAnsibleState.this.experimentSpecification, ESpecDefaults.deriveAutomaticPlaybookScriptFile((String)remotePath));
                    ExperimentSpecificationServicesAnsibleState.this.LOG.debug("Executing playbook command: " + playbookCommandString);
                    ExperimentSpecificationServicesAnsibleState.this.LOG.debug("Actual SSH exec command: " + command);
                    Session.Command c = this.ssh.startSession().exec(command);
                    new InputStreamToLogsThread(c.getInputStream(), ExperimentSpecificationServicesAnsibleState.this.LOG, Level.INFO, "PLAYBOOK-OUTPUT: ", (LimitedLiveLog)liveLog).start();
                    new InputStreamToLogsThread(c.getErrorStream(), ExperimentSpecificationServicesAnsibleState.this.LOG, Level.WARN, "PLAYBOOK-ERROR: ", (LimitedLiveLog)liveLog).start();
                    c.join();
                    ExperimentSpecificationServicesAnsibleState.this.LOG.debug("Exit status of playbook command: " + c.getExitStatus());
                    if (c.getExitStatus() != 0) {
                        this.updateMessage("ansible-playbook execution was unsuccessful.");
                        ExperimentSpecificationServicesAnsibleState.this.eSpecLogger.firePostAnsiblePlaybookFail(logId, this.playbook, remotePath, logPath, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId, "ansible-playbook execution was unsuccessful. exit status = " + c.getExitStatus(), null);
                        return ExperimentTaskStatus.FAILED;
                    }
                    ExperimentSpecificationServicesAnsibleState.this.eSpecLogger.firePostAnsiblePlaybookSuccess(logId, this.playbook, remotePath, logPath, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId);
                    return ExperimentTaskStatus.SUCCESS;
                }
                catch (ConnectionException | TransportException ex) {
                    ExperimentSpecificationServicesAnsibleState.this.eSpecLogger.firePostAnsiblePlaybookFail(logId, this.playbook, remotePath, logPath, ExperimentSpecificationServicesAnsibleState.this.ansibleNodeClientId, "SSH-exception while executing ansible", ex);
                    throw new JFedException("SSH-exception while executing ansible: " + ex.getMessage(), ex);
                }
            }
        }
    }
}

