/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.espec.ESpecLogic;
import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.model.UploadLikeWithLogSpec;
import be.iminds.ilabt.jfed.espec.util.ESpecLogger;
import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import be.iminds.ilabt.jfed.espec.util.LimitedLiveLogImpl;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.JobWithSshConnectionManager;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.states.RemotePathResolver;
import be.iminds.ilabt.jfed.highlevel.util.ExternalFileUtil;
import be.iminds.ilabt.jfed.highlevel.util.InputStreamToLogsThread;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class ExperimentSpecificationServicesSingleExecuteState
extends SlicedState<ExperimentSpecificationServicesSingleExecuteStateSlice> {
    private static final Logger ACTUAL_LOG = LoggerFactory.getLogger(ExperimentSpecificationServicesSingleExecuteState.class);
    private final Logger LOG;
    public static final int MAX_EXECUTE_FINISHED_FILE_DETECTION_TRIES = 60;
    public static final int TIME_BETWEEN_FINISHED_FILE_DETECTION_TRIES_MS = 10000;
    @Nonnull
    private final SetupSoftwareExperimentJob job;
    @Nonnull
    private final Experiment experiment;
    @Nonnull
    private final ExperimentSpecification experimentSpecification;
    @Nonnull
    private final ESpecBundle experimentSpecificationBundle;
    @Nonnull
    private final ESpecLogger eSpecLogger;
    @Nonnull
    private final List<ExperimentSpecificationServicesSingleExecuteStateSlice> slices;
    @Nonnull
    private final RemotePathResolver remotePathResolver;
    @Nonnull
    private final ExecuteSpec executeSpec;

    protected ExperimentSpecificationServicesSingleExecuteState(@Nonnull SetupSoftwareExperimentJob job, @Nonnull RemotePathResolver remotePathResolver, @Nonnull ExecuteSpec executeSpec, boolean isInAnsible) {
        super("ExperimentSpecification execute " + executeSpec.getDesc());
        FXModelRspec model;
        this.job = job;
        this.LOG = new LogEntryGeneratorWrappingLogger(ACTUAL_LOG, job.getJobReport());
        this.experiment = job.getExperiment();
        this.eSpecLogger = job.getExperiment().getExperimentSpecificationLogger();
        this.remotePathResolver = remotePathResolver;
        this.executeSpec = executeSpec;
        if (this.experiment.getExperimentSpecification() == null) {
            throw new RuntimeException("Internal error, ExperimentSpecificationServicesDirsAndUploadsState created for experiment without ExperimentSpecification");
        }
        if (this.experiment.getExperimentSpecificationBundle() == null) {
            throw new RuntimeException("Internal error, ExperimentSpecificationServicesDirsAndUploadsState created for experiment without ExperimentSpecification (bundle)");
        }
        this.experimentSpecification = this.experiment.getExperimentSpecification();
        this.experimentSpecificationBundle = this.experiment.getExperimentSpecificationBundle();
        this.experiment.requireSlice();
        this.slices = new ArrayList<ExperimentSpecificationServicesSingleExecuteStateSlice>();
        assert (!isInAnsible || this.experimentSpecification.getAnsible() != null);
        RequestRspecSource requestRspecSource = this.experiment.getSlice().getRequestRspec();
        FXModelRspec fXModelRspec = model = requestRspecSource == null ? null : (FXModelRspec)requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (model != null);
        if (model == null) {
            this.LOG.warn("ExperimentSpecificationServicesSingleExecuteState will do nothing because there is no usable request RSpec");
            return;
        }
        for (FXRspecNode node : model.getNodes()) {
            String nodeId;
            if (Objects.equals(node.getSliverTypeName(), "fake") || (nodeId = node.getClientId()) == null || !ESpecLogic.mustRunOn((String)nodeId, (Collection)node.getAnsibleGroups(), (ExperimentSpecification)this.experimentSpecification, (UploadLikeSpec)executeSpec)) continue;
            this.slices.add(new ExperimentSpecificationServicesSingleExecuteStateSlice(job, node));
        }
    }

    @Override
    @Nonnull
    protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
        ExperimentTaskStatus res = super.executeState(job);
        this.experiment.getExperimentSpecificationLogger().firePostExecuteStepAll(this.executeSpec, res == ExperimentTaskStatus.SUCCESS);
        return res;
    }

    @Override
    public Collection<ExperimentSpecificationServicesSingleExecuteStateSlice> getSlices() {
        return this.slices;
    }

    public static SshCommandAndLog createSshCommand(@Nonnull String remotePath, @Nullable String remoteLogPath, @Nonnull UploadLikeWithLogSpec executeSpec, @Nonnull ExperimentSpecification experimentSpecification, @Nonnull String clientId, @Nullable String pwd, @Nullable Boolean useSudo) throws JFedException, InterruptedException {
        if (pwd == null) {
            pwd = ExternalFileUtil.getPathOnly(remotePath);
        }
        return new SshCommandAndLog(ExperimentSpecificationServicesSingleExecuteState.createSshCommand(remotePath, pwd, remoteLogPath, useSudo, experimentSpecification, null), remoteLogPath);
    }

    public static String createSshCommand(@Nonnull String baseCommand, @Nullable String pwd, @Nullable String logPath, @Nullable Boolean useSudo, @Nonnull ExperimentSpecification experimentSpecification, @Nullable String executeInScriptWithPath) {
        boolean localLogs = experimentSpecification.getConfig().isStoreLocalLogsByDefault();
        Object sudoargs = "";
        if (experimentSpecification.getConfig().getDefaultSudoUser() != null) {
            sudoargs = (String)sudoargs + "-u " + experimentSpecification.getConfig().getDefaultSudoUser() + " ";
        }
        if (useSudo == null) {
            useSudo = experimentSpecification.getConfig().isUseSudoByDefault();
        }
        String hereDocCommand = "<<'EOF'";
        Object command = "";
        if (executeInScriptWithPath != null) {
            command = (String)command + "cat - " + hereDocCommand + " > " + executeInScriptWithPath + "\n";
            command = (String)command + "#!/bin/bash\n\n";
            command = (String)command + baseCommand + "\n";
            command = (String)command + "EOF\n";
            command = (String)command + "chmod u+x " + executeInScriptWithPath + "\n";
            baseCommand = executeInScriptWithPath;
        }
        command = useSudo != false ? (String)command + "sudo " + (String)sudoargs + " -- " : (String)command;
        command = localLogs ? (String)command + "bash " + hereDocCommand : (logPath != null ? (String)command + "bash " + hereDocCommand + " >'" + logPath + "' 2>'" + logPath + "'" : (String)command + "bash " + hereDocCommand + " > /dev/null 2>&1");
        command = (String)command + "\n";
        if (pwd != null) {
            command = (String)command + "cd '" + pwd + "'\n";
        }
        if (logPath != null && localLogs) {
            command = (String)command + "exec 3>&1 4>&2 5> >(tee '" + logPath + "' >&3) 1>&5 2>&5\n";
        }
        command = (String)command + baseCommand + "\n";
        command = (String)command + "EOF\n";
        return command;
    }

    public class ExperimentSpecificationServicesSingleExecuteStateSlice
    extends StateSlice {
        @Nonnull
        protected final SetupSoftwareExperimentJob setupSoftwareExperimentJob;
        @Nonnull
        protected final FXRspecNode node;
        @Nonnull
        protected final String clientId;

        public ExperimentSpecificationServicesSingleExecuteStateSlice(@Nonnull SetupSoftwareExperimentJob job, FXRspecNode node) {
            super(job);
            this.setupSoftwareExperimentJob = job;
            this.node = node;
            if (node.getClientId() == null) {
                throw new IllegalStateException("Only nodes with a client_id can be used in an ExperimentSpecification");
            }
            this.clientId = node.getClientId();
        }

        @Override
        public String getName() {
            return "ExperimentSpecification execute steps for node " + this.node.getClientId();
        }

        @Override
        public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
            SSHClient ssh;
            if (Objects.equals(this.node.getSliverTypeName(), "fake")) {
                ExperimentSpecificationServicesSingleExecuteState.this.LOG.warn("execute should NOT run on node with sliver type 'fake' clientId=" + this.clientId + "  (this is a bug in the code, and it will be handled by not running the execute statefulRun)");
                return ExperimentTaskStatus.SUCCESS;
            }
            try {
                ssh = this.setupSoftwareExperimentJob.getSSHClient((RspecNode)this.node, this);
            }
            catch (JobWithSshConnectionManager.SshException e) {
                throw new IllegalStateException("There is no SSH connection for node \"" + this.clientId + "\" available", e);
            }
            if (!ssh.isConnected()) {
                ExperimentSpecificationServicesSingleExecuteState.this.updateMessage("SSH connection is not connection: will abort execute.");
                return ExperimentTaskStatus.FAILED;
            }
            ExecuteState executeState = new ExecuteState(ssh);
            this.setAndRunState(executeState);
            if (executeState.getStatus() != ExperimentTaskStatus.SUCCESS) {
                return ExperimentTaskStatus.FAILED;
            }
            return ExperimentTaskStatus.SUCCESS;
        }

        public class ExecuteState
        extends State {
            @Nonnull
            private final SSHClient ssh;

            protected ExecuteState(SSHClient ssh) {
                super("Executing " + ExperimentSpecificationServicesSingleExecuteState.this.executeSpec.getDesc() + " on " + ExperimentSpecificationServicesSingleExecuteStateSlice.this.node.getClientId());
                this.ssh = ssh;
            }

            @Override
            @Nonnull
            protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
                if (this.ssh == null) {
                    throw new IllegalStateException("ssh == null");
                }
                String desc = ExperimentSpecificationServicesSingleExecuteState.this.executeSpec.getDesc();
                ExperimentSpecificationServicesSingleExecuteState experimentSpecificationServicesSingleExecuteState = ExperimentSpecificationServicesSingleExecuteState.this;
                long logId = experimentSpecificationServicesSingleExecuteState.eSpecLogger.getNextLogId();
                if (!ESpecLogic.mustRunOn((String)ExperimentSpecificationServicesSingleExecuteStateSlice.this.clientId, (Collection)ExperimentSpecificationServicesSingleExecuteStateSlice.this.node.getAnsibleGroups(), (ExperimentSpecification)ExperimentSpecificationServicesSingleExecuteState.this.experimentSpecification, (UploadLikeSpec)ExperimentSpecificationServicesSingleExecuteState.this.executeSpec)) {
                    throw new IllegalStateException("BUG: execute " + desc + " does not need to be executed on this node (\"" + ExperimentSpecificationServicesSingleExecuteStateSlice.this.clientId + "\") (nodes=" + String.valueOf(ExperimentSpecificationServicesSingleExecuteState.this.executeSpec.getNodes()) + ")");
                }
                String remotePath = ExperimentSpecificationServicesSingleExecuteState.this.remotePathResolver.getRemotePath((UploadLikeSpec)ExperimentSpecificationServicesSingleExecuteState.this.executeSpec, ExperimentSpecificationServicesSingleExecuteStateSlice.this.clientId);
                if (remotePath == null) {
                    ExperimentSpecificationServicesSingleExecuteState.this.eSpecLogger.firePostExecuteFail(logId, ExperimentSpecificationServicesSingleExecuteState.this.executeSpec, "not found", null, ExperimentSpecificationServicesSingleExecuteStateSlice.this.clientId, -1, "Did not find remote path of executable. Bug in execute step?", null);
                    ExperimentSpecificationServicesSingleExecuteState.this.LOG.error("Did not find remote path of executable. Bug in execute step?");
                    this.updateMessage("Did not find remote path of executable. Bug in execute step?");
                    throw new RuntimeException("Did not find remote path of executable. Bug in execute step?");
                }
                String remoteLogPath = ExperimentSpecificationServicesSingleExecuteState.this.remotePathResolver.getRemoteLogPath((UploadLikeWithLogSpec)ExperimentSpecificationServicesSingleExecuteState.this.executeSpec, ExperimentSpecificationServicesSingleExecuteStateSlice.this.clientId);
                SshCommandAndLog commandAndLog = ExperimentSpecificationServicesSingleExecuteState.createSshCommand(remotePath, remoteLogPath, (UploadLikeWithLogSpec)ExperimentSpecificationServicesSingleExecuteState.this.executeSpec, ExperimentSpecificationServicesSingleExecuteState.this.experimentSpecification, ExperimentSpecificationServicesSingleExecuteStateSlice.this.clientId, ExperimentSpecificationServicesSingleExecuteState.this.executeSpec.getPwd(), ExperimentSpecificationServicesSingleExecuteState.this.executeSpec.isSudo());
                try {
                    ExperimentSpecificationServicesSingleExecuteState.this.LOG.debug("ExperimentSpecification.execute is executing {} on {}", (Object)remotePath, (Object)ExperimentSpecificationServicesSingleExecuteStateSlice.this.node.getClientId());
                    ExperimentSpecificationServicesSingleExecuteState.this.LOG.debug("      command: {}", (Object)commandAndLog.getCommand());
                    LimitedLiveLogImpl log = new LimitedLiveLogImpl(1000000);
                    ExperimentSpecificationServicesSingleExecuteState.this.eSpecLogger.firePreExecute(logId, ExperimentSpecificationServicesSingleExecuteState.this.executeSpec, remotePath, commandAndLog.getLogPath(), ExperimentSpecificationServicesSingleExecuteStateSlice.this.clientId, (LimitedLiveLog)log);
                    Session.Command c = this.ssh.startSession().exec(commandAndLog.getCommand());
                    new InputStreamToLogsThread(c.getInputStream(), ExperimentSpecificationServicesSingleExecuteState.this.LOG, Level.TRACE, desc + "-OUTPUT+" + ExperimentSpecificationServicesSingleExecuteStateSlice.this.node.getClientId() + ": ", (LimitedLiveLog)log).start();
                    new InputStreamToLogsThread(c.getErrorStream(), ExperimentSpecificationServicesSingleExecuteState.this.LOG, Level.DEBUG, desc + "-ERROR" + ExperimentSpecificationServicesSingleExecuteStateSlice.this.node.getClientId() + ": ", (LimitedLiveLog)log).start();
                    c.join();
                    int exitStatus = c.getExitStatus();
                    if (exitStatus != 0) {
                        ExperimentSpecificationServicesSingleExecuteState.this.eSpecLogger.firePostExecuteFail(logId, ExperimentSpecificationServicesSingleExecuteState.this.executeSpec, remotePath, commandAndLog.getLogPath(), ExperimentSpecificationServicesSingleExecuteStateSlice.this.clientId, exitStatus, desc + " execution was unsuccessful. Aborting", null);
                        this.updateMessage(desc + " execution was unsuccessful. Aborting");
                        ExperimentSpecificationServicesSingleExecuteState.this.LOG.error("ExperimentSpecification.execute {} on {} FAILURE: exitstatus = {}", new Object[]{remotePath, ExperimentSpecificationServicesSingleExecuteStateSlice.this.node.getClientId(), exitStatus});
                        return ExperimentTaskStatus.FAILED;
                    }
                    ExperimentSpecificationServicesSingleExecuteState.this.LOG.debug("ExperimentSpecification.execute {} on {} success: exitstatus = {}", new Object[]{remotePath, ExperimentSpecificationServicesSingleExecuteStateSlice.this.node.getClientId(), exitStatus});
                    ExperimentSpecificationServicesSingleExecuteState.this.eSpecLogger.firePostExecuteSuccess(logId, ExperimentSpecificationServicesSingleExecuteState.this.executeSpec, remotePath, commandAndLog.getLogPath(), ExperimentSpecificationServicesSingleExecuteStateSlice.this.clientId, exitStatus);
                    return ExperimentTaskStatus.SUCCESS;
                }
                catch (IOException ex) {
                    ExperimentSpecificationServicesSingleExecuteState.this.eSpecLogger.firePostExecuteFail(logId, ExperimentSpecificationServicesSingleExecuteState.this.executeSpec, remotePath, commandAndLog.getLogPath(), ExperimentSpecificationServicesSingleExecuteStateSlice.this.clientId, -1, "IOException while executing " + remotePath + " on " + ExperimentSpecificationServicesSingleExecuteStateSlice.this.node.getClientId(), (Throwable)ex);
                    ExperimentSpecificationServicesSingleExecuteState.this.LOG.error(String.format("IOException while executing %s on %s", remotePath, ExperimentSpecificationServicesSingleExecuteStateSlice.this.node.getClientId()), (Throwable)ex);
                    this.updateMessage(String.format("Error while executing %s on %s: %s", remotePath, ExperimentSpecificationServicesSingleExecuteStateSlice.this.node.getClientId(), ex.getMessage()));
                    return ExperimentTaskStatus.FAILED;
                }
            }
        }
    }

    private static class SshCommandAndLog {
        @Nonnull
        private final String command;
        @Nullable
        private final String logPath;

        public SshCommandAndLog(@Nonnull String command, @Nullable String logPath) {
            this.command = command;
            this.logPath = logPath;
        }

        @Nonnull
        public String getCommand() {
            return this.command;
        }

        @Nullable
        public String getLogPath() {
            return this.logPath;
        }
    }
}

