/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.model;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModelAbstractListener;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.ErrorDetails;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfaModelAggregateManager2Listener
extends SfaModelAbstractListener {
    private static final Logger LOG = LoggerFactory.getLogger(SfaModelAggregateManager2Listener.class);
    private final TestbedInfoSource testbedInfoSource;

    public SfaModelAggregateManager2Listener(SfaModel sfaModel, TestbedInfoSource testbedInfoSource) {
        super(sfaModel);
        this.testbedInfoSource = testbedInfoSource;
    }

    private List<String> getSliceUrns(List<String> urns) {
        ArrayList<String> res = new ArrayList<String>();
        for (String u : urns) {
            GeniUrn geniUrn = GeniUrn.parse((String)u);
            if (geniUrn == null || !Objects.equals(geniUrn.getEncodedResourceType(), "slice")) continue;
            res.add(u);
        }
        return res;
    }

    private List<String> getSliverUrns(List<String> urn) {
        ArrayList<String> res = new ArrayList<String>();
        for (String u : urn) {
            GeniUrn geniUrn = GeniUrn.parse((String)u);
            if (geniUrn == null || !Objects.equals(geniUrn.getEncodedResourceType(), "sliver")) continue;
            res.add(u);
        }
        return res;
    }

    private void onGetVersionResult(ApiCallDetails result) {
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            // empty if block
        }
    }

    public void onStatusResult(String sliceUrnStr, AggregateManager2.SliverStatus statusInfo, Integer serverId) {
        List notMentionedSlivers;
        GeniUrn sliceUrn;
        Server auth = this.sfaModel.getTestbedInfoSource().getServerById(serverId);
        try {
            sliceUrn = new GeniUrn(sliceUrnStr);
        }
        catch (GeniUrn.GeniUrnParseException e) {
            LOG.error("Cannot process StatusResult with invalid slice-urn {}", (Object)sliceUrnStr, (Object)e);
            return;
        }
        Slice slice = this.getModel().logExistSlice(sliceUrn);
        assert (slice != null);
        this.getModel().logExistAtLeastOneSliver(sliceUrn, auth, Sliver.Source.AGGREGATE_MANAGER_STATUS);
        assert (statusInfo.getStatus() != null);
        HashSet<GeniUrn> mentionedSliverUrns = new HashSet<GeniUrn>();
        List<Object> slivers = new ArrayList();
        StatusDetails globalStatus = new StatusDetails(StatusDetails.SliverStatus.READY);
        for (AggregateManager2.SliverStatus.ResourceStatus resourceStatus : statusInfo.getResources()) {
            Sliver sliver2;
            String componentUrn;
            String sliverUrn;
            StatusDetails resourceStatusDetails = new StatusDetails(resourceStatus.getStatus());
            globalStatus.mergeGlobalStatus(resourceStatusDetails.getGlobalStatus());
            GeniUrn urn = GeniUrn.parse((String)resourceStatus.getUrn());
            if (urn != null && Objects.equals(urn.getEncodedResourceType(), "sliver")) {
                mentionedSliverUrns.add(urn);
                sliverUrn = resourceStatus.getUrn();
                componentUrn = null;
                globalStatus.addSliverStatus(sliverUrn, resourceStatus.getStatus());
                resourceStatusDetails.addSliverStatus(sliverUrn, resourceStatus.getStatus());
            } else {
                sliverUrn = null;
                componentUrn = resourceStatus.getUrn();
                globalStatus.addComponentStatus(componentUrn, resourceStatus.getStatus());
                resourceStatusDetails.addComponentStatus(componentUrn, resourceStatus.getStatus());
            }
            if (resourceStatus.getError() != null && !resourceStatus.getError().isEmpty()) {
                globalStatus.addError(new ErrorDetails(resourceStatus.getError(), sliverUrn, componentUrn));
                resourceStatusDetails.addError(new ErrorDetails(resourceStatus.getError(), sliverUrn, componentUrn));
            }
            if (statusInfo.getAnyExtExpires() != null) {
                resourceStatusDetails.addKnownExpires(statusInfo.getAnyExtExpires());
            }
            if (sliverUrn != null) {
                sliver2 = this.getModel().logExistSliver(sliceUrn, urn, auth, Sliver.Source.AGGREGATE_MANAGER_STATUS);
                if (sliver2 == null) continue;
                sliver2.setStatusString(resourceStatus.getStatus());
                sliver2.setStatus(resourceStatusDetails);
                if (statusInfo.getAnyExtExpires() != null) {
                    sliver2.setExpirationDate(statusInfo.getAnyExtExpires().toInstant());
                }
                slivers.add(sliver2);
                continue;
            }
            sliver2 = null;
            for (Sliver s : slice.findSlivers(auth)) {
                if (!s.containsComponent(componentUrn)) continue;
                sliver2 = s;
            }
            if (sliver2 == null) continue;
            sliver2.getStatus().add(resourceStatusDetails);
            slivers.add(sliver2);
        }
        LOG.debug("Found slivers in SliverStatus: " + String.valueOf(slivers));
        if (slivers.isEmpty()) {
            slivers = slice.findSlivers(auth);
            if (slivers.size() == 1) {
                Sliver sliver3 = (Sliver)slivers.get(0);
                sliver3.setStatusString(statusInfo.getStatus());
                sliver3.setStatus(globalStatus);
            } else {
                LOG.warn("Got more than one sliver, while we were expecting to find only one! Status wil NOT be updated!");
            }
        }
        if (!(notMentionedSlivers = slice.findSlivers(auth).stream().filter(sliver -> !mentionedSliverUrns.contains(sliver.getUrn())).filter(sliver -> sliver.getSource() == Sliver.Source.SLICE_AUTHORITY).collect(Collectors.toList())).isEmpty()) {
            LOG.trace("The following slivers were not mentioned in the SliverStatus of {}: {}", (Object)auth.getName(), (Object)notMentionedSlivers.stream().map(Sliver::getUrnString).collect(Collectors.joining(", ")));
        } else {
            LOG.trace("No unmentioned slivers in SliverStatus for authority {}", (Object)auth);
        }
        for (Sliver notMentionedSliver : notMentionedSlivers) {
            this.getModel().logNotExistSliver(sliceUrn, notMentionedSliver.getUrn(), Sliver.Source.AGGREGATE_MANAGER_STATUS);
        }
        if (globalStatus.getGlobalStatus() == StatusDetails.SliverStatus.READY) {
            slice.findSlivers(auth).stream().filter(sliver -> sliver.getStatus().getGlobalStatus() != StatusDetails.SliverStatus.UNALLOCATED).filter(sliver -> sliver.getStatus().getGlobalStatus() != StatusDetails.SliverStatus.READY).forEach(sliver -> {
                LOG.info("{} reported all resources as READY in its StatusDetails-call, but we found sliver {} which is registered in the SfaModel, but is not ready. We force it to READY now.", (Object)auth, (Object)sliver.getUrnString());
                sliver.setStatus(new StatusDetails(StatusDetails.SliverStatus.READY));
            });
        }
        if (globalStatus.getGlobalStatus() != StatusDetails.SliverStatus.parse((String)statusInfo.getStatus())) {
            LOG.warn("The computed global status {} does not match the received status {}! Please check if this is a testbed issue or not.", (Object)globalStatus.getGlobalStatus(), (Object)statusInfo.getStatus());
        }
    }

    public void onAl2sStatusResult(@Nonnull String requestParamSliceUrn, @Nonnull AggregateManager2.SliverStatus statusInfo, @Nonnull Integer serverId) {
        GeniUrn sliceUrn;
        Server auth = this.sfaModel.getTestbedInfoSource().getServerById(serverId);
        LOG.debug("Using special processing for AL2S SliverStatus reply.");
        try {
            sliceUrn = new GeniUrn(requestParamSliceUrn);
        }
        catch (GeniUrn.GeniUrnParseException e) {
            LOG.error("Could not parse slice-urn {} from Al2s result", (Object)requestParamSliceUrn);
            return;
        }
        this.getModel().logExistAtLeastOneSliver(sliceUrn, auth, Sliver.Source.AGGREGATE_MANAGER_STATUS);
        assert (statusInfo.getStatus() != null);
        ArrayList<Sliver> slivers = new ArrayList<Sliver>();
        StatusDetails globalStatus = new StatusDetails(statusInfo.getStatus());
        for (AggregateManager2.SliverStatus.ResourceStatus resourceStatus : statusInfo.getResources()) {
            Sliver sliver;
            GeniUrn sliverUrn;
            StatusDetails resourceStatusDetails = new StatusDetails(resourceStatus.getStatus());
            GeniUrn urn = GeniUrn.parse((String)resourceStatus.getUrn());
            if (urn != null && (urn.getEncodedResourceType().equals("sliver") || urn.getEncodedResourceType().equals("slice"))) {
                if (Objects.equals(urn.getEncodedResourceType(), "slice")) {
                    sliverUrn = GeniUrn.createGeniUrnFromEncodedParts((String)auth.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority(), (String)"sliver", (String)urn.getEncodedResourceName());
                    LOG.debug("Fixed sliver urn URN in AL2S SliverStatus reply: " + String.valueOf(sliverUrn));
                } else {
                    sliverUrn = urn;
                }
            } else {
                LOG.error("Reply from AL2S is unsupported: resource urn = " + String.valueOf(urn));
                return;
            }
            globalStatus.addSliverStatus(sliverUrn, resourceStatus.getStatus());
            resourceStatusDetails.addSliverStatus(sliverUrn, resourceStatus.getStatus());
            if (resourceStatus.getError() != null && !resourceStatus.getError().isEmpty()) {
                globalStatus.addError(new ErrorDetails(resourceStatus.getError(), sliverUrn, null));
                resourceStatusDetails.addError(new ErrorDetails(resourceStatus.getError(), sliverUrn, null));
            }
            if (statusInfo.getAnyExtExpires() != null) {
                resourceStatusDetails.addKnownExpires(statusInfo.getAnyExtExpires());
            }
            if ((sliver = this.getModel().logExistSliver(sliceUrn, sliverUrn, auth, Sliver.Source.AGGREGATE_MANAGER_STATUS)) == null) continue;
            sliver.setStatusString(resourceStatus.getStatus());
            sliver.setStatus(resourceStatusDetails);
            if (statusInfo.getAnyExtExpires() != null) {
                sliver.setExpirationDate(statusInfo.getAnyExtExpires().toInstant());
            }
            slivers.add(sliver);
        }
        assert (!slivers.isEmpty());
    }

    public void seeAdvertisementRspec(Integer serverId, boolean available, String rspec) {
        this.seeAdvertisementRspec(this.sfaModel.getTestbedInfoSource().getServerById(serverId), available, rspec);
    }

    public void seeAdvertisementRspec(Server server, boolean available, String rspec) {
        LOG.trace("SfaModelAggregateManager2Listener.seeAdvertisementRspec(" + server.getName() + ", " + available + ", rspec.length=" + rspec.length() + ")");
        this.getModel().setAdvertisementRspec(server, available, rspec);
    }

    public List<Sliver> seeManifestRspec(@Nonnull Integer serverId, @Nonnull String sliceUrnStr, @Nonnull String manifestRspecString) {
        GeniUrn sliceUrn;
        Server auth = this.sfaModel.getTestbedInfoSource().getServerById(serverId);
        try {
            sliceUrn = new GeniUrn(sliceUrnStr);
        }
        catch (GeniUrn.GeniUrnParseException e) {
            LOG.error("Could not process manifest, as the given slice-urn '{}' is invalid", (Object)sliceUrnStr, (Object)e);
            return Collections.emptyList();
        }
        Slice slice = this.getModel().getSlice(sliceUrn);
        if (slice == null) {
            return Collections.emptyList();
        }
        List<Sliver> sliverList = manifestRspecString != null ? this.findSliversInManifest(auth, sliceUrn, new ManifestRspecSource(manifestRspecString, ModelRspecType.FX)) : null;
        if (sliverList == null || sliverList.isEmpty()) {
            this.getModel().logExistAtLeastOneSliver(sliceUrn, auth, Sliver.Source.AGGREGATE_MANAGER_STATUS);
            sliverList = slice.findSlivers(auth);
        }
        if (manifestRspecString.contains("component_manager_id=\"urn:publicid:IDN+ple+authority+cm\"")) {
            LOG.warn("Using PLE hack in SfaModelAggregateManager2Listener#seeManifestRspec. successfully applied: " + !(manifestRspecString = manifestRspecString.replaceAll(Pattern.quote("urn:publicid:IDN+ple+authority+cm"), Matcher.quoteReplacement("urn:publicid:IDN+ple:ibbtple+authority+cm"))).contains("component_manager_id=\"urn:publicid:IDN+ple+authority+cm\""));
            assert (!manifestRspecString.contains("component_manager_id=\"urn:publicid:IDN+ple+authority+cm\"")) : "HACK applied unsuccessfully to:\n" + manifestRspecString;
        }
        ManifestRspecSource manifestRspec = new ManifestRspecSource(manifestRspecString, ModelRspecType.FX);
        for (Sliver sliver : sliverList) {
            LOG.debug("SfaModelAggregateManager2Listener seeManifestRspec is setting manifest for " + String.valueOf(slice) + " -> " + String.valueOf(sliceUrn) + "  " + String.valueOf(sliver) + " -> " + String.valueOf(sliver.getUrn()));
            sliver.setManifestRspec(manifestRspec);
        }
        LOG.debug("SfaModelAggregateManager2Listener processed manifest");
        return sliverList;
    }

    public void onResult(ApiCallDetails details) {
        assert (Platform.isFxApplicationThread());
        this.onResultInJavaFXThread(details);
    }

    public void onResultInJavaFXThread(ApiCallDetails details) {
        block40: {
            if (details.getReply() == null || details.getJavaMethodName() == null) {
                return;
            }
            if (!Objects.equals(details.getApiName(), AggregateManager2.getApiName())) {
                return;
            }
            LOG.trace("SfaModelAggregateManager2Listener onResultInJavaFXThread callAuth=" + details.getServerComponentManagerUrnString() + " API=" + details.getApiName() + " SfaCommand=\"" + details.getGeniMethodName() + "\" javaCommand=\"" + details.getJavaMethodName() + "\"");
            try {
                Boolean reply;
                List<Sliver> slivers;
                String sliceUrn;
                if (Objects.equals(details.getJavaMethodName(), "getVersion")) {
                    this.onGetVersionResult(details);
                }
                if (Objects.equals(details.getJavaMethodName(), "listResources") && !details.getMethodParameters().containsKey("sliceUrn") && details.getReply().getGeniResponseCode().isSuccess()) {
                    String rspec = (String)details.getReply().getValue();
                    boolean available = false;
                    if (details.getMethodParameters().get("available") != null) {
                        available = (Boolean)details.getMethodParameters().get("available");
                    }
                    this.seeAdvertisementRspec(details.getServerId(), available, rspec);
                }
                if (Objects.equals(details.getJavaMethodName(), "listResources") && details.getMethodParameters().containsKey("sliceUrn")) {
                    sliceUrn = (String)details.getMethodParameters().get("sliceUrn");
                    if (details.getReply().getGeniResponseCode().isSuccess()) {
                        LOG.trace("SfaModelAggregateManager2Listener sees successful ListResources call with sliceUrn " + sliceUrn);
                        String rspec = (String)details.getReply().getValue();
                        assert (rspec != null);
                        assert (!rspec.isEmpty());
                        this.getModel().logExistSlice(sliceUrn);
                        this.getModel().logExistAtLeastOneSliver(sliceUrn, details.getServerId(), Sliver.Source.AGGREGATE_MANAGER_STATUS);
                        this.seeManifestRspec(details.getServerId(), sliceUrn, rspec);
                    } else {
                        LOG.debug("SfaModelAggregateManager2Listener sees failed ListResources call with sliceUrn");
                        if (Objects.equals(details.getReply().getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED)) {
                            this.getModel().logNotExistSliverInSliceOnAuth(sliceUrn, details.getServerId());
                        }
                    }
                }
                if (Objects.equals(details.getJavaMethodName(), "createSliver")) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("onResultInJavaFXThread CreateSliver success=" + details.getReply().getGeniResponseCode().isSuccess());
                    }
                    sliceUrn = (String)details.getMethodParameters().get("sliceUrn");
                    if (details.getReply().getGeniResponseCode().isSuccess()) {
                        Slice slice = this.getModel().logExistSlice(sliceUrn);
                        String manifestRspec = (String)details.getReply().getValue();
                        LOG.trace("SfaModelAggregateManager2Listener sets manifest Rspec on CreateSliver");
                        slivers = this.seeManifestRspec(details.getServerId(), sliceUrn, manifestRspec);
                        this.getModel().logExistAtLeastOneSliver(sliceUrn, details.getServerId(), Sliver.Source.AGGREGATE_MANAGER_STATUS);
                        for (Sliver sliver : slivers) {
                            sliver.setStatus(new StatusDetails(StatusDetails.SliverStatus.UNKNOWN, sliver.getUrn()));
                            sliver.setStatusString("CreateSliver successful");
                        }
                    }
                }
                if (Objects.equals(details.getJavaMethodName(), "sliverStatus")) {
                    sliceUrn = (String)details.getMethodParameters().get("sliceUrn");
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("onResultInJavaFXThread sliverStatus slice=" + sliceUrn + " at " + details.getServerName() + " success=" + details.getReply().getGeniResponseCode().isSuccess());
                    }
                    if (details.getReply().getGeniResponseCode().isSuccess()) {
                        assert (sliceUrn != null);
                        if (details.getServerId() != null && Objects.equals(details.getServerUrnString(), "urn:publicid:IDN+al2s.internet2.edu+authority+am")) {
                            this.onAl2sStatusResult(sliceUrn, (AggregateManager2.SliverStatus)details.getReply().getValue(), details.getServerId());
                        } else {
                            this.onStatusResult(sliceUrn, (AggregateManager2.SliverStatus)details.getReply().getValue(), details.getServerId());
                        }
                    } else if (Objects.equals(details.getReply().getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED)) {
                        this.getModel().logNotExistSliverInSliceOnAuth(sliceUrn, details.getServerId());
                    }
                }
                if (details.getGeniMethodName().equals("DeleteSliver") || details.getGeniMethodName().equals("Shutdown")) {
                    sliceUrn = (String)details.getMethodParameters().get("sliceUrn");
                    if (details.getReply().getGeniResponseCode().isSuccess()) {
                        Boolean isDeleted = null;
                        if (details.getReply().getValue() instanceof Boolean) {
                            isDeleted = (Boolean)details.getReply().getValue();
                        }
                        if (details.getReply().getValue() instanceof Integer) {
                            isDeleted = (Integer)details.getReply().getValue() != 0;
                        }
                        if (details.getReply().getValue() instanceof String) {
                            String isDeletedString = (String)details.getReply().getValue();
                            if (isDeletedString.trim().equalsIgnoreCase("true") || isDeletedString.trim().equalsIgnoreCase("yes") || isDeletedString.trim().equalsIgnoreCase("1")) {
                                isDeleted = true;
                            }
                            if (isDeletedString.trim().equalsIgnoreCase("false") || isDeletedString.trim().equalsIgnoreCase("no") || isDeletedString.trim().equalsIgnoreCase("0")) {
                                isDeleted = false;
                            }
                        }
                        if (isDeleted == null) {
                            LOG.error("call \"" + details.getGeniMethodName() + "\" returned unrecognized value. class=" + details.getReply().getValue().getClass().getName() + " value=\"" + details.getReply().getValue().toString() + "\"");
                        }
                        if (isDeleted != null && isDeleted.booleanValue()) {
                            this.getModel().logNotExistSliverInSliceOnAuth(sliceUrn, details.getServerId());
                        }
                    }
                    if (Objects.equals(details.getReply().getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED)) {
                        this.getModel().logNotExistSliverInSliceOnAuth(sliceUrn, details.getServerId());
                    }
                }
                if (!Objects.equals(details.getJavaMethodName(), "renewSliver")) break block40;
                sliceUrn = (String)details.getMethodParameters().get("sliceUrn");
                String newExpiration = (String)details.getMethodParameters().get("expirationTimeRfc3339");
                if (details.getReply().getGeniResponseCode().isSuccess() && sliceUrn != null && newExpiration != null && (reply = (Boolean)details.getReply().getValue()) != null && reply.booleanValue()) {
                    slivers = this.getModel().logExistSlice(sliceUrn).findSlivers(GeniUrn.parse((String)details.getServerUrnString()));
                    try {
                        Date newExpirationDate = RFC3339Util.rfc3339StringToDate((String)newExpiration);
                        for (Sliver sliver : slivers) {
                            sliver.setExpirationDate(newExpirationDate.toInstant());
                        }
                    }
                    catch (ParseException e) {
                        LOG.warn("RenewSliver call \"expirationTime\" parameter failed to parse as RFC3339");
                    }
                }
                if (Objects.equals(details.getReply().getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED)) {
                    this.getModel().logNotExistSliverInSliceOnAuth(sliceUrn, details.getServerId());
                }
            }
            catch (Exception e) {
                LOG.error("WARNING: Exception when processing AggregateManager2 reply for SfaModel. This will be ignored, but it is most likely a bug. ", (Throwable)e);
            }
        }
    }
}

