/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.model;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.credential.AbacCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.Gid;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecMerger;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slice {
    private static final Logger LOG = LoggerFactory.getLogger(Slice.class);
    private static final String SLICE_RESOURCE_TYPE = "slice";
    final ChangeListener<StatusDetails> statusChangeListener = (observableValue, oldStatus, newStatus) -> this.updateStatus();
    final ChangeListener<ManifestRspecSource> manifestRspecChangeListener = (observableValue, oldRSpecInfo, newRSpecInfo) -> {
        LOG.debug("Change in sliver manifest rspec: joining manifests");
        this.joinManifestRspecs();
    };
    final ListChangeListener<Sliver> sliverListChangeListener = new ListChangeListener<Sliver>(){

        public void onChanged(ListChangeListener.Change<? extends Sliver> change) {
            while (change.next()) {
                for (Sliver sliver : change.getRemoved()) {
                    sliver.statusProperty().removeListener(Slice.this.statusChangeListener);
                    sliver.manifestRspecProperty().removeListener(Slice.this.manifestRspecChangeListener);
                    boolean authHasOtherSliversInSlice = false;
                    for (Sliver otherSliver : Slice.this.slivers) {
                        if (otherSliver.getServer() != sliver.getServer()) continue;
                        authHasOtherSliversInSlice = true;
                    }
                    if (authHasOtherSliversInSlice) continue;
                    Slice.this.manifestComponentManagers.remove((Object)sliver.getServer());
                }
                for (Sliver sliver : change.getAddedSubList()) {
                    sliver.statusProperty().addListener(Slice.this.statusChangeListener);
                    sliver.manifestRspecProperty().addListener(Slice.this.manifestRspecChangeListener);
                    Slice.this.manifestComponentManagers.add((Object)sliver.getServer());
                }
            }
            Slice.this.updateStatus();
            LOG.debug("Sliver added or removed: joining manifests");
            Slice.this.joinManifestRspecs();
        }
    };
    private final GeniUrn urn;
    private final StringProperty uuid = new SimpleStringProperty();
    private final StringProperty creator_uuid = new SimpleStringProperty();
    private final StringProperty creator_urn = new SimpleStringProperty();
    private final ObjectProperty<StatusDetails> status = new SimpleObjectProperty((Object)new StatusDetails(StatusDetails.SliverStatus.UNINITIALISED));
    private final Set<GeniUrn> users = new HashSet<GeniUrn>();
    private final ObjectProperty<Boolean> hasActiveSlivers = new SimpleObjectProperty();
    private final ObservableSet<Server> manifestComponentManagers = FXCollections.observableSet(new HashSet());
    private final ObservableSet<Server> connectAuthorities = FXCollections.observableSet(new HashSet());
    private final ObjectProperty<RequestRspecSource> requestRspec = new SimpleObjectProperty();
    private final ObjectProperty<ManifestRspecSource> manifestRspec = new SimpleObjectProperty();
    private final ObjectProperty<Gid> gid = new SimpleObjectProperty();
    private final ReadOnlyObjectWrapper<Instant> reservationStartTime = new ReadOnlyObjectWrapper();
    private final ReadOnlyObjectWrapper<Instant> expirationDate = new ReadOnlyObjectWrapper();
    private final ReadOnlyObjectWrapper<Instant> creationDate = new ReadOnlyObjectWrapper();
    private final ObjectProperty<List<AnyCredential>> credentials = new SimpleObjectProperty();
    private final List<String> allReceivedRspecString = new ArrayList<String>();
    private final ObservableMap<Server, InternalState> authorityStates = FXCollections.observableHashMap();
    private final ObservableList<Sliver> slivers = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final ManifestRspecMerger manifestRspecMerger = new ManifestRspecMerger(ModelRspecType.FX);

    Slice(@Nonnull GeniUrn urn, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull AuthorityFinder authorityFinder) {
        assert (Objects.equals(urn.getResourceType(), SLICE_RESOURCE_TYPE));
        this.urn = urn;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.slivers.addListener(this.sliverListChangeListener);
    }

    @Nonnull
    public Collection<GeniUrn> getUsers() {
        return Collections.unmodifiableCollection(this.users);
    }

    public void setUsers(@Nonnull Collection<GeniUrn> userUrns) {
        this.users.clear();
        this.users.addAll(userUrns);
    }

    public void addUsers(@Nonnull Collection<GeniUrn> userUrns) {
        this.users.addAll(userUrns);
    }

    public void addUser(@Nonnull GeniUrn userUrn) {
        this.users.add(userUrn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus() {
        ObservableList<Sliver> observableList = this.slivers;
        synchronized (observableList) {
            if (this.slivers.isEmpty()) {
                LOG.trace("No slivers in slice. Setting status to UNINITIALISED");
                StatusDetails newStatus = new StatusDetails(StatusDetails.SliverStatus.UNINITIALISED);
                this.status.set((Object)newStatus);
                return;
            }
        }
        StatusDetails newStatus = new StatusDetails(StatusDetails.SliverStatus.READY);
        ObservableList<Sliver> observableList2 = this.slivers;
        synchronized (observableList2) {
            for (Sliver sliver : this.slivers) {
                newStatus.add(sliver.getStatus());
            }
        }
        this.status.set((Object)newStatus);
    }

    @Nonnull
    public String getName() {
        return this.urn.getEncodedResourceName();
    }

    @Nonnull
    public GeniUrn getUrn() {
        return this.urn;
    }

    @Nonnull
    public String getUrnString() {
        return this.urn.toString();
    }

    @Nullable
    public String getSubAuthorityName() {
        return this.urn.getEncodedSubAuthName();
    }

    @Nullable
    public GeniUrn getProjectUrn() {
        if (this.urn == null || this.urn.getEncodedSubAuthName() == null) {
            return null;
        }
        return GeniUrn.createGeniUrnFromEncodedParts((String)this.urn.getEncodedTopLevelAuthority_withoutSubAuth(), (String)"project", (String)this.urn.getEncodedSubAuthName());
    }

    @Nullable
    public String getProjectName() {
        if (this.urn == null || this.urn.getEncodedSubAuthName() == null) {
            return null;
        }
        return this.urn.getEncodedSubAuthName();
    }

    @Nullable
    public Boolean getHasActiveSlivers() {
        return (Boolean)this.hasActiveSlivers.get();
    }

    public ObjectProperty<Boolean> hasActiveSliversProperty() {
        return this.hasActiveSlivers;
    }

    public void setHasActiveSlivers(Boolean hasActiveSlivers) {
        this.hasActiveSlivers.set((Object)hasActiveSlivers);
    }

    public boolean hasCredential() {
        return this.credentials.get() != null && !((List)this.credentials.get()).isEmpty();
    }

    @Nonnull
    public List<AnyCredential> getCredentials() {
        return this.credentials.get() == null ? Collections.emptyList() : (List)this.credentials.get();
    }

    public void setCredentials(@Nonnull List<AnyCredential> credentials) throws JFedHighLevelException {
        for (AnyCredential credential : credentials) {
            if (credential == null) {
                throw new NullPointerException("credential in credential list is null");
            }
            if (credential instanceof SfaCredential) {
                SfaCredential sc = (SfaCredential)credential;
                try {
                    GeniUrn sliceUrn = new GeniUrn(sc.getTargetUrn());
                    if (!Objects.equals(sliceUrn.getEncodedResourceType(), SLICE_RESOURCE_TYPE)) {
                        throw new JFedHighLevelException("This is not a slice credential!");
                    }
                    if (this.urn.getValue() != null && !Objects.equals(sliceUrn, this.urn)) {
                        throw new JFedHighLevelException("This credential is for another slice. this slice=" + this.urn.getValue() + ", while slice urn in credential=" + sliceUrn.toString());
                    }
                    if (this.getExpirationDate() != null || sc.getExpiresDate() == null) continue;
                    this.setExpirationDate(sc.getExpiresDate().toInstant());
                    continue;
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    LOG.error("Credential target is invalid URN: '{}'", (Object)sc.getTargetUrn());
                    throw new JFedHighLevelException("Credential target is invalid URN: '" + sc.getTargetUrn() + "'", e);
                }
            }
            if (credential instanceof AbacCredential) {
                LOG.info("Cannot process credential of type {}", (Object)credential.getClass().getName());
                continue;
            }
            LOG.warn("Cannot process credential of type {}", (Object)credential.getClass().getName());
        }
        this.credentials.set(credentials);
    }

    public ObjectProperty<List<AnyCredential>> credentialsProperty() {
        return this.credentials;
    }

    @Nullable
    public String getUuid() {
        return (String)this.uuid.get();
    }

    public StringProperty uuidProperty() {
        return this.uuid;
    }

    @Nullable
    public String getCreator_uuid() {
        return (String)this.creator_uuid.get();
    }

    public StringProperty creator_uuidProperty() {
        return this.creator_uuid;
    }

    @Nullable
    public String getCreator_urn() {
        return (String)this.creator_urn.get();
    }

    public StringProperty creator_urnProperty() {
        return this.creator_urn;
    }

    @Nullable
    public Gid getGid() {
        return (Gid)this.gid.get();
    }

    public void setGid(Gid gid) {
        this.gid.set((Object)gid);
    }

    public ObjectProperty<Gid> gidProperty() {
        return this.gid;
    }

    @Nonnull
    public ObservableSet<Server> getManifestComponentManagers() {
        return this.manifestComponentManagers;
    }

    @Nonnull
    public ObservableSet<Server> getConnectAuthorities() {
        return this.connectAuthorities;
    }

    @Nullable
    public StatusDetails getStatus() {
        return (StatusDetails)this.status.get();
    }

    public void setStatus(StatusDetails status) {
        this.status.set((Object)status);
    }

    public ObjectProperty<StatusDetails> statusProperty() {
        return this.status;
    }

    @Nonnull
    public List<String> getAllLastReceivedRspecString() {
        return this.allReceivedRspecString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void joinManifestRspecs() {
        ManifestRspecSource joined;
        ObservableList<Sliver> observableList;
        LOG.trace("joinManifestRspecs()");
        if (this.getRequestRspec() != null) {
            this.manifestRspecMerger.setRequest(this.getRequestRspec());
        } else {
            observableList = this.slivers;
            synchronized (observableList) {
                for (Sliver sliver : this.slivers) {
                    if (sliver.getRequestRspec() == null) continue;
                    this.manifestRspecMerger.setRequest(sliver.getRequestRspec());
                    break;
                }
            }
        }
        observableList = this.slivers;
        synchronized (observableList) {
            for (Sliver sliver : this.slivers) {
                Server auth = sliver.getServer();
                ManifestRspecSource sliverManifestRspec = sliver.getManifestRspec();
                this.manifestRspecMerger.setManifest(auth.getDefaultComponentManagerAsGeniUrn(), sliverManifestRspec);
            }
        }
        try {
            joined = this.manifestRspecMerger.getMergedManifest();
        }
        catch (Exception e) {
            String inputDebugOverview = this.manifestRspecMerger.makeInputDebugOverview();
            LOG.error("Failed to merge manifests. inputDebugOverview=" + inputDebugOverview, (Throwable)e);
            throw new RuntimeException("Failed to merge manifests. inputDebugOverview=" + inputDebugOverview, e);
        }
        LOG.trace("updating manifestRequest property");
        if (LOG.isDebugEnabled()) {
            if (joined != null && joined.getImmutableModelRspec() != null && joined.getImmutableModelRspec().getNodes() != null) {
                LOG.debug("   nodes in joined rspec: ");
                for (RspecNode node : joined.getImmutableModelRspec().getNodes()) {
                    LOG.debug("       - node id=\"" + node.getUniqueId() + "\" client_id=\"" + node.getClientId() + "\" comp_id=\"" + String.valueOf(node.getComponentId()) + "\" manager=\"" + String.valueOf(node.getComponentManagerId()) + "\" loginservices=" + node.getLoginServices().size());
                }
            } else if (joined != null && joined.getImmutableModelRspec() != null) {
                LOG.debug("   no nodes in joined rspec: ptr->null");
            } else {
                LOG.debug("   no nodes in joined rspec");
            }
        }
        this.manifestRspec.set((Object)joined);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSliver(Sliver sliver) {
        ObservableList<Sliver> observableList = this.slivers;
        synchronized (observableList) {
            this.slivers.add((Object)sliver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSliver(Sliver sliver) {
        ObservableList<Sliver> observableList = this.slivers;
        synchronized (observableList) {
            this.slivers.remove((Object)sliver);
        }
    }

    @Nonnull
    public ObservableList<Sliver> getObservableSlivers() {
        return this.slivers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<Sliver> getSliversCopy() {
        ObservableList<Sliver> observableList = this.slivers;
        synchronized (observableList) {
            return new ArrayList<Sliver>((Collection<Sliver>)this.slivers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Stream<Sliver> getSliversStream() {
        ObservableList<Sliver> observableList = this.slivers;
        synchronized (observableList) {
            return new ArrayList<Sliver>((Collection<Sliver>)this.slivers).stream();
        }
    }

    @Nonnull
    public Collection<Server> getAuthorities() {
        return this.authorityStates.keySet();
    }

    public List<Sliver> findSlivers(@Nonnull Server auth) {
        return this.findSlivers(auth.getDefaultComponentManagerAsGeniUrn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Sliver> findSlivers(@Nonnull GeniUrn cmUrn) {
        ObservableList<Sliver> observableList = this.slivers;
        synchronized (observableList) {
            return this.slivers.stream().filter(sliver -> sliver.getServer().getDefaultComponentManagerAsGeniUrn().hasCompatibleAuthority(cmUrn)).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Sliver findSliver(@Nonnull GeniUrn urn) {
        ObservableList<Sliver> observableList = this.slivers;
        synchronized (observableList) {
            return this.slivers.stream().filter(sliver -> Objects.equals(urn, sliver.getUrn())).findFirst().orElse(null);
        }
    }

    @Nullable
    public Instant getReservationStartTime() {
        return (Instant)this.reservationStartTime.get();
    }

    public ReadOnlyObjectWrapper<Instant> reservationStartTimeProperty() {
        return this.reservationStartTime;
    }

    public void setReservationStartTime(Instant reservationStartTime) {
        this.reservationStartTime.set((Object)reservationStartTime);
    }

    @Nullable
    public Instant getExpirationDate() {
        return (Instant)this.expirationDate.get();
    }

    public void setExpirationDate(Instant expirationDate) {
        this.expirationDate.set((Object)expirationDate);
    }

    public ReadOnlyObjectProperty<Instant> expirationDateProperty() {
        return this.expirationDate.getReadOnlyProperty();
    }

    public ObjectProperty<RequestRspecSource> requestRspecProperty() {
        return this.requestRspec;
    }

    @Nullable
    public RequestRspecSource getRequestRspec() {
        return (RequestRspecSource)this.requestRspec.get();
    }

    public void setRequestRspec(RequestRspecSource rspec) {
        this.requestRspec.set((Object)rspec);
        if (rspec != null) {
            for (GeniUrn cmUrn : rspec.getAllComponentManagerUrns()) {
                if (!this.findSlivers(cmUrn).isEmpty()) continue;
                Server auth = this.authorityFinder.findByUrn(cmUrn, AuthorityFinder.Purpose.REQUEST_RSPEC);
                if (auth != null) {
                    this.authorityStates.put((Object)auth, (Object)InternalState.UNALLOCATED);
                    continue;
                }
                LOG.warn("Could not find Server for urn '{}'. This will be ignored, but will cause problems w.r.t. determining the slice status, etc.!", (Object)cmUrn);
            }
        }
    }

    @Nullable
    public ManifestRspecSource getManifestRspec() {
        return (ManifestRspecSource)this.manifestRspec.get();
    }

    public ReadOnlyObjectProperty<ManifestRspecSource> manifestRspecProperty() {
        return this.manifestRspec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ManifestRspecSource getSpecificManifestRspec(@Nonnull Server auth) {
        ObservableList<Sliver> observableList = this.slivers;
        synchronized (observableList) {
            for (Sliver sliver : this.slivers) {
                Server sliverAuth = sliver.getServer();
                ManifestRspecSource sliverManifestRspec = sliver.getManifestRspec();
                if (!Objects.equals(auth.getDefaultComponentManagerUrn(), sliverAuth.getDefaultComponentManagerUrn())) continue;
                if (sliverManifestRspec != null) {
                    return sliverManifestRspec;
                }
                LOG.warn("Looking for specific manifest of authority {} in slice {}, but sliver {} does not have a manifest. Skipping", new Object[]{auth.getName(), this.getName(), sliver.getUrnString()});
            }
        }
        return null;
    }

    public String toString() {
        return "SfaModel Slice Info {urn=" + String.valueOf(this.urn) + ", credentials.size()=" + (String)(this.credentials.get() == null ? "null" : "" + ((List)this.credentials.get()).size()) + ", hasCredential=" + this.hasCredential() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInactiveSlivers() {
        ObservableList<Sliver> observableList = this.slivers;
        synchronized (observableList) {
            this.slivers.removeIf(sliver -> sliver.getStatus().getGlobalStatus() == StatusDetails.SliverStatus.UNALLOCATED || sliver.getStatus().getGlobalStatus() == StatusDetails.SliverStatus.UNINITIALISED);
        }
        this.authorityStates.entrySet().removeIf(entry -> entry.getValue() == InternalState.DELETED);
    }

    public boolean isExpired() {
        return this.getExpirationDate() != null && this.getExpirationDate().isBefore(Instant.now());
    }

    public void setAuthorityInternalState(Server auth, InternalState state) {
        this.authorityStates.put((Object)auth, (Object)state);
    }

    @Nullable
    public InternalState getAuthorityInternalState(Server authority) {
        return (InternalState)((Object)this.authorityStates.get((Object)authority));
    }

    @Nonnull
    public ObservableMap<Server, InternalState> getAuthorityStates() {
        return this.authorityStates;
    }

    public void setUuid(String uuid) {
        this.uuid.set((Object)uuid);
    }

    @Nullable
    public Instant getCreationDate() {
        return (Instant)this.creationDate.get();
    }

    public ReadOnlyObjectProperty<Instant> creationDateProperty() {
        return this.creationDate.getReadOnlyProperty();
    }

    public void setCreationDate(Instant creationDate) {
        this.creationDate.set((Object)creationDate);
    }
}

