/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.model;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.model.ComponentInfo;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sliver {
    private static final Logger LOG = LoggerFactory.getLogger(Sliver.class);
    private final ObjectProperty<Source> source = new SimpleObjectProperty();
    private final StringProperty statusString = new SimpleStringProperty("<no status known>");
    private final ObjectProperty<StatusDetails> status = new SimpleObjectProperty((Object)new StatusDetails(StatusDetails.SliverStatus.UNINITIALISED));
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final GeniUrn urn;
    @Nonnull
    private final Server authority;
    private final ObjectProperty<RequestRspecSource> requestRspec = new SimpleObjectProperty();
    private final ObjectProperty<ManifestRspecSource> manifestRspec = new SimpleObjectProperty();
    private String allocationStatus;
    private String operationalStatus;
    private final ObjectProperty<Instant> expirationDate = new SimpleObjectProperty();
    private final SetProperty<ComponentInfo> componentInfo = new SimpleSetProperty(FXCollections.observableSet((Object[])new ComponentInfo[0]));

    public Sliver(@Nonnull GeniUrn urn, @Nonnull Source source, @Nonnull Slice slice, @Nullable RequestRspecSource requestRspec, @Nullable ManifestRspecSource manifestRspec, @Nonnull Server authority) {
        this.urn = urn;
        this.source.set((Object)source);
        this.slice = slice;
        this.requestRspec.set((Object)requestRspec);
        this.manifestRspec.set((Object)manifestRspec);
        this.authority = authority;
    }

    public static Sliver createPartialCopy(@Nonnull Sliver orig) {
        Sliver res = new Sliver(orig.getUrn(), orig.getSource(), orig.getSlice(), null, null, orig.getServer());
        res.setExpirationDate(orig.getExpirationDate());
        res.setAllocationAndOperationalStatus(orig.getAllocationStatus(), orig.getOperationalStatus(), orig.getStatus());
        return res;
    }

    @Nonnull
    public Slice getSlice() {
        return this.slice;
    }

    @Nullable
    public ManifestRspecSource getManifestRspec() {
        return (ManifestRspecSource)this.manifestRspec.get();
    }

    public void setManifestRspec(@Nullable ManifestRspecSource manifestRspec) {
        this.manifestRspec.set((Object)manifestRspec);
    }

    @Nullable
    public RequestRspecSource getRequestRspec() {
        return (RequestRspecSource)this.requestRspec.get();
    }

    public void setRequestRspec(@Nullable RequestRspecSource requestRspec) {
        this.requestRspec.set((Object)requestRspec);
    }

    public ObjectProperty<ManifestRspecSource> manifestRspecProperty() {
        return this.manifestRspec;
    }

    @Nonnull
    public Server getServer() {
        return this.authority;
    }

    public String getStatusString() {
        return (String)this.statusString.get();
    }

    public void setStatusString(String statusString) {
        this.statusString.set((Object)statusString);
    }

    public StringProperty statusStringProperty() {
        return this.statusString;
    }

    public StatusDetails getStatus() {
        return (StatusDetails)this.status.get();
    }

    public boolean hasAnyFailStatus() {
        StatusDetails curStatus = (StatusDetails)this.status.get();
        if (curStatus == null) {
            return false;
        }
        if (curStatus.getGlobalStatus() == StatusDetails.SliverStatus.FAIL) {
            return true;
        }
        for (StatusDetails.SliverStatus sliverStatus : curStatus.getStatusBySliverUrn().values()) {
            if (sliverStatus != StatusDetails.SliverStatus.FAIL) continue;
            return true;
        }
        for (StatusDetails.SliverStatus sliverStatus : curStatus.getStatusByComponentUrn().values()) {
            if (sliverStatus != StatusDetails.SliverStatus.FAIL) continue;
            return true;
        }
        return false;
    }

    public void setStatus(StatusDetails newStatus) {
        this.status.set((Object)newStatus);
        if (LOG.isTraceEnabled()) {
            LOG.trace("New status of {} is {} ({})", new Object[]{this.getUrn(), this.status.get(), newStatus});
        }
    }

    public ObjectProperty<StatusDetails> statusProperty() {
        return this.status;
    }

    @Nonnull
    public GeniUrn getUrn() {
        return this.urn;
    }

    public void setAllocationAndOperationalStatus(String allocationStatus, String operationalStatus, StatusDetails statusDetails) {
        this.allocationStatus = allocationStatus;
        this.operationalStatus = operationalStatus;
        this.status.set((Object)statusDetails);
        this.statusString.set((Object)statusDetails.getGlobalStatus().toString());
    }

    public void setExpirationDate(Instant expirationDate) {
        this.expirationDate.set((Object)expirationDate);
    }

    @Nullable
    public Instant getExpirationDate() {
        return (Instant)this.expirationDate.get();
    }

    public ObjectProperty<Instant> expirationDateProperty() {
        return this.expirationDate;
    }

    public String getAllocationStatus() {
        return this.allocationStatus;
    }

    public String getOperationalStatus() {
        return this.operationalStatus;
    }

    private static String toStringHelper(String res, String objectName, Object objectValue) {
        if (objectValue == null) {
            return res;
        }
        return res + TextUtil.indent((int)4, (String)("\"" + objectName + "\" : \"" + String.valueOf(objectValue) + "\"")) + "\n";
    }

    public String toString() {
        Object res = "\"Sliver\" : {\n";
        res = Sliver.toStringHelper((String)res, "slice", this.slice.getUrn());
        res = Sliver.toStringHelper((String)res, "source", this.source.get());
        res = Sliver.toStringHelper((String)res, "urn", this.urn);
        res = Sliver.toStringHelper((String)res, "expirationDate", this.expirationDate.getValue());
        res = Sliver.toStringHelper((String)res, "auth", this.authority.getDefaultComponentManagerUrn());
        res = Sliver.toStringHelper((String)res, "allocationStatus", this.allocationStatus);
        res = Sliver.toStringHelper((String)res, "operationalStatus", this.operationalStatus);
        res = Sliver.toStringHelper((String)res, "statusString", this.statusString.getValue());
        res = Sliver.toStringHelper((String)res, "source", this.source.get() != null ? ((Source)((Object)this.source.get())).name() : null);
        res = (String)res + "}\n";
        return res;
    }

    public boolean logExistsComponent(String clientId, String componentId) {
        ComponentInfo ci = new ComponentInfo(clientId, componentId);
        return this.componentInfo.add((Object)ci);
    }

    public boolean containsComponent(String componentUrn) {
        for (ComponentInfo ci : this.componentInfo) {
            if (!Objects.equals(ci.getComponentId(), componentUrn)) continue;
            return true;
        }
        return false;
    }

    public ObservableSet<ComponentInfo> getComponentInfo() {
        return (ObservableSet)this.componentInfo.get();
    }

    public SetProperty<ComponentInfo> componentInfoProperty() {
        return this.componentInfo;
    }

    public String getUrnString() {
        return this.urn.toString();
    }

    public Source getSource() {
        return (Source)((Object)this.source.get());
    }

    public ObjectProperty<Source> sourceProperty() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source.set((Object)source);
    }

    @Nullable
    public Collection<RspecNode> getNodes() {
        if (this.manifestRspec.get() == null) {
            return null;
        }
        if (((ManifestRspecSource)this.manifestRspec.get()).getImmutableModelRspec() == null) {
            return null;
        }
        return ((ManifestRspecSource)this.manifestRspec.get()).getImmutableModelRspec().getNodes().stream().filter(node -> Objects.equals(this.urn, node.getSliverId())).collect(Collectors.toList());
    }

    public Collection<RspecLink> getLinks() {
        if (this.manifestRspec.get() == null) {
            return null;
        }
        if (((ManifestRspecSource)this.manifestRspec.get()).getImmutableModelRspec() == null) {
            return null;
        }
        return ((ManifestRspecSource)this.manifestRspec.get()).getImmutableModelRspec().getLinks().stream().filter(link -> Objects.equals(this.urn, link.getSliverId())).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sliver)) {
            return false;
        }
        Sliver sliver = (Sliver)o;
        return Objects.equals(this.urn, sliver.urn);
    }

    public int hashCode() {
        return this.urn.hashCode();
    }

    public boolean isFake() {
        return this.urn.getEncodedResourceName().startsWith("ip-pool-");
    }

    public boolean isVirtual() {
        return this.urn.getEncodedResourceName().endsWith(":vlan");
    }

    public static enum Source {
        REQUEST_RSPEC,
        SLICE_AUTHORITY,
        AGGREGATE_MANAGER_MANIFEST,
        AGGREGATE_MANAGER_STATUS;

    }
}

