/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateImageTask
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(CreateImageTask.class);
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final GeniUrn sliverUrn;
    @Nonnull
    private final String imageName;
    private final boolean global;
    private final boolean updatePrepare;
    private URL resultDiskImageUrl = null;
    private GeniUrn resultDiskImageUrn = null;
    @Nonnull
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;

    public CreateImageTask(@Nonnull Slice slice, @Nonnull GeniUrn sliverUrn, @Nonnull String imageName, boolean global, boolean updatePrepare, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super("Create Image on node " + String.valueOf(sliverUrn));
        this.slice = slice;
        this.sliverUrn = sliverUrn;
        this.imageName = imageName;
        this.global = global;
        this.updatePrepare = updatePrepare;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        Sliver sliver = this.slice.findSliver(this.sliverUrn);
        assert (sliver != null);
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, sliver.getServer());
        if (!amWrapper.areUserDiskImageFunctionsSupported()) {
            throw new JFedHighLevelException("Authority " + sliver.getServer().getDefaultComponentManagerUrn() + " does not support create image.");
        }
        AggregateManagerWrapper.ImageInfo imageInfo = amWrapper.createImage(this.slice.getUrn(), this.slice.getCredentials(), this.sliverUrn, this.imageName, this.global, this.updatePrepare);
        if (imageInfo != null) {
            try {
                this.resultDiskImageUrl = new URL(imageInfo.getUrl());
            }
            catch (MalformedURLException e) {
                LOG.warn("CreateImageTask createImage returned invalid URL: \"" + imageInfo.getUrl() + "\"", (Throwable)e);
                this.resultDiskImageUrl = null;
            }
        } else {
            throw new JFedHighLevelException("Did not receive a valid answer on CreateImage-call");
        }
        this.resultDiskImageUrn = GeniUrn.parse((String)imageInfo.getUrn());
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getSliceCredential(this.slice));
    }

    @Nullable
    public URL getResultDiskImageUrl() {
        return this.resultDiskImageUrl;
    }

    @Nullable
    public GeniUrn getResultDiskImageUrn() {
        return this.resultDiskImageUrn;
    }
}

