/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class EditSSHKeysTask
extends Task {
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final Server auth;
    @Nonnull
    private final Collection<UserSpec> userSpecs;
    @Nonnull
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;

    public EditSSHKeysTask(@Nonnull Slice slice, @Nonnull Server auth, @Nonnull Collection<UserSpec> userSpecs, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super("Edit SSH Keys");
        this.slice = slice;
        this.auth = auth;
        this.userSpecs = userSpecs;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.auth);
        if (!amWrapper.isEditSshKeysSupported()) {
            throw new JFedHighLevelException("Authority " + this.auth.getDefaultComponentManagerUrn() + " does not support edit of SSH keys.");
        }
        amWrapper.editSshKeys(this.slice.getUrn(), this.slice.getCredentials(), this.userSpecs);
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        ArrayList<Task> res = new ArrayList<Task>();
        res.add(this.highLevelTaskFactory.getSliceCredential(this.slice));
        return res;
    }
}

