/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationRegistryApi1;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import javax.annotation.Nonnull;

public class EmulabRegistryTask
extends Task {
    private final Server auth;
    private final JavaFXLogger logger;
    private final GeniUserProvider geniUserProvider;
    private final JFedPreferences jFedPreferences;
    private final JFedConnectionProvider connectionProvider;

    public EmulabRegistryTask(Server auth, JavaFXLogger logger, GeniUserProvider geniUserProvider, JFedPreferences jFedPreferences, JFedConnectionProvider connectionProvider) {
        super("Emulab Registry " + auth.getName());
        this.auth = auth;
        this.logger = logger;
        this.geniUserProvider = geniUserProvider;
        this.jFedPreferences = jFedPreferences;
        this.connectionProvider = connectionProvider;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        FederationRegistryApi1 registryApi = new FederationRegistryApi1((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.jFedPreferences);
        SfaConnection conn = (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.geniUserProvider.getLoggedInGeniUser(), this.auth, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH, 1));
        if (conn == null) {
            throw new JFedHighLevelException("No connection can be created. Perhaps the authority \"" + this.auth.getDefaultComponentManagerUrn() + "\" does not have a federation registry?");
        }
        AbstractFederationApi.FederationApiReply reply = registryApi.lookupAggregates(conn, null, null, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("reply not success");
        }
    }
}

