/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModelAbstractListener;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.model.UserSpecHelper;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.SliceRegistryUtil;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.security.PublicKey;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProvisionSliverTask
extends CreateTask {
    private static final Logger LOG = LoggerFactory.getLogger(ProvisionSliverTask.class);
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final Server auth;
    @Nonnull
    private final Instant expirationTime;
    @Nonnull
    private final List<UserSpec> userSpecs;
    private String manifestRspec;
    private Set<Sliver> provisionedSlivers = null;
    @Nonnull
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @Nonnull
    private final SfaModel sfaModel;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;
    @Nonnull
    private final SliceRegistryUtil sliceRegistryUtil;
    @Nonnull
    private final GeniUserProvider geniUserProvider;

    public ProvisionSliverTask(@Nonnull Slice slice, @Nonnull Instant expirationTime, @Nonnull Server auth, @Nonnull List<UserSpec> userSpecs, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull SfaModel sfaModel, @Nonnull HighLevelTaskFactory highLevelTaskFactory, @Nonnull SliceRegistryUtil sliceRegistryUtil, @Nonnull GeniUserProvider geniUserProvider) {
        super("Provision Sliver @ " + auth.getDefaultComponentManagerUrn());
        this.slice = slice;
        this.expirationTime = expirationTime;
        this.auth = auth;
        this.userSpecs = ProvisionSliverTask.generateUsedUserSpec(auth, userSpecs, geniUserProvider);
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.sfaModel = sfaModel;
        this.highLevelTaskFactory = highLevelTaskFactory;
        this.sliceRegistryUtil = sliceRegistryUtil;
        this.geniUserProvider = geniUserProvider;
    }

    private static List<UserSpec> generateUsedUserSpec(@Nonnull Server auth, @Nonnull List<UserSpec> userSpecs, GeniUserProvider geniUserProvider) {
        String userUrn;
        if (auth.hasFlag(Server.Flag.workaroundProvisionIgnoreSSHKey)) {
            LOG.info("OVERWRITING the Provision userSpecs list sent to " + auth.getName() + " because of flag workaroundProvisionIgnoreSSHKey");
            GeniUser user = geniUserProvider.getLoggedInGeniUser();
            return UserSpecHelper.getUserUserSpecList(user);
        }
        if (auth.hasFlag(Server.Flag.workaroundProvisionSingleSSHKey)) {
            LOG.info("OVERWRITING the Provision userSpecs list sent to " + auth.getName() + " because of flag workaroundProvisionSingleSSHKey");
            userUrn = geniUserProvider.getLoggedInGeniUser().getUserUrnString();
            Optional<UserSpec> res = userSpecs.stream().filter(us -> Objects.equals(us.getUrn(), userUrn)).findFirst();
            if (res.isPresent()) {
                UserSpec orig = res.get();
                GeniUser user = geniUserProvider.getLoggedInGeniUser();
                String sslCertSshKey = KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)user.getPublicKey());
                String singleSshKey = orig.getSshKey().stream().filter(k -> !k.equals(sslCertSshKey)).findFirst().orElse(sslCertSshKey);
                return Collections.singletonList(new UserSpec(orig.getUrn(), singleSshKey));
            }
        }
        if (auth.hasFlag(Server.Flag.workaroundProvisionSingleSSHAccount)) {
            LOG.info("OVERWRITING the Provision userSpecs list sent to " + auth.getName() + " because of flag workaroundProvisionSingleSSHAccount");
            userUrn = geniUserProvider.getLoggedInGeniUser().getUserUrnString();
            return userSpecs.stream().filter(us -> Objects.equals(us.getUrn(), userUrn)).collect(Collectors.toList());
        }
        return new ArrayList<UserSpec>(userSpecs);
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        List existingSlivers = this.slice.findSlivers(this.auth).stream().map(Sliver::createPartialCopy).collect(Collectors.toList());
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.auth);
        assert (amWrapper.hasSeperateAllocateAndProvision()) : "AM Wrapper does not support provisioning!";
        LOG.info("Provision Sliver(s) @ {}  with user SSH keys: {}", (Object)this.auth.getDefaultComponentManagerUrn(), this.sfaModel.getUserKeys());
        try {
            Instant usedExpirationDate = amWrapper.isExirationdateSetByCreateSliver() || this.auth.hasFlag(Server.Flag.workaroundForceRenewAfterCreateSliver) ? this.expirationTime : null;
            AggregateManagerWrapper.ProvisionReply provisionReply = amWrapper.provision(this.slice.getUrn(), this.slice.getCredentials(), this.userSpecs, usedExpirationDate != null ? Date.from(usedExpirationDate) : null);
            Instant provisionDate = Instant.now();
            this.manifestRspec = provisionReply.getManifest();
            this.sliceRegistryUtil.registerSliceAtSA(AbstractFederationApi.SliceRspecType.MANIFEST, this.slice, this.auth, this.manifestRspec, provisionDate, this, new ResultListener[0]);
            if (this.manifestRspec == null) {
                throw new JFedHighLevelException("Provision of the sliver failed.");
            }
            if (!this.isProvisioned(provisionReply.getSliverInfo())) {
                LOG.debug("Slivers are not yet Provisioned. Will wait before calling PerformOperationalAction geni_start until they are.");
                Thread.sleep(1000L);
                AggregateManager3.StatusInfo sliverInfos = amWrapper.status_v3(this.slice.getUrn(), this.slice.getCredentials());
                while (sliverInfos != null && !this.isProvisioned(sliverInfos.getSliverInfo())) {
                    LOG.debug("Slivers are not yet Provisioned. Will wait before calling PerformOperationalAction geni_start until they are.");
                    sliverInfos = amWrapper.status_v3(this.slice.getUrn(), this.slice.getCredentials());
                    Thread.sleep(5000L);
                }
            }
            amWrapper.poaStart(this.slice.getUrn(), this.slice.getCredentials());
            this.provisionedSlivers = new HashSet<Sliver>();
            List<Sliver> manifestSlivers = SfaModelAbstractListener.findSliversInManifest(this.sfaModel, this.auth, this.slice.getUrn(), new ManifestRspecSource(this.manifestRspec, ModelRspecType.FX));
            if (manifestSlivers != null) {
                this.provisionedSlivers.addAll(manifestSlivers);
            }
            this.provisionedSlivers.addAll(this.slice.getSliversStream().filter(sliver -> Objects.equals(sliver.getServer(), this.auth)).collect(Collectors.toSet()));
            ArrayList<Sliver> updatedSlivers = new ArrayList<Sliver>(this.provisionedSlivers);
            this.provisionedSlivers.removeAll(existingSlivers);
            updatedSlivers.removeIf(sliver -> {
                Optional<Sliver> orig = existingSlivers.stream().filter(s -> Objects.equals(s.getUrn(), sliver.getUrn())).findAny();
                LOG.debug("POSTProv SLIVER_INFO: updatedSlivers creation looked for " + String.valueOf(sliver.getUrn()) + " in existingSlivers and found " + String.valueOf(orig));
                if (orig.isPresent()) {
                    LOG.debug("POSTProv SLIVER_INFO: sliver.getExpirationDate()=" + String.valueOf(sliver.getExpirationDate()) + " orig.get().getExpirationDate()=" + String.valueOf(orig.get().getExpirationDate()));
                    return Objects.equals(orig.get().getExpirationDate(), sliver.getExpirationDate());
                }
                return true;
            });
            LOG.debug("POSTProv SLIVER_INFO: provisionedSlivers=" + String.valueOf(this.provisionedSlivers));
            LOG.debug("POSTProv SLIVER_INFO: existingSlivers=" + String.valueOf(existingSlivers));
            LOG.debug("POSTProv SLIVER_INFO: updatedSlivers=" + String.valueOf(updatedSlivers));
            if (!this.provisionedSlivers.isEmpty()) {
                this.sliceRegistryUtil.registerSliversAtSATaskExecution(this.provisionedSlivers, this.expirationTime, this, new ResultListener[0]);
                LOG.info("POSTProv SLIVER_INFO: Found new slivers during the Provision-call!");
            } else {
                LOG.debug("POSTProv SLIVER_INFO: Could not find any slivers that were newly created in Provision call. This is OK, as they are typically created during the Allocate-call.");
            }
            if (!updatedSlivers.isEmpty()) {
                this.sliceRegistryUtil.updateSliversAtSATaskExecution(updatedSlivers, this.expirationTime, this, new ResultListener[0]);
                LOG.info("POSTProv SLIVER_INFO: Found updated slivers during the Provision-call");
            } else {
                LOG.debug("POSTProv SLIVER_INFO: Could not find any updated slivers in Provision call. This is OK.");
            }
        }
        catch (AggregateManagerWrapper.NotEnoughFreeResourcesException e) {
            this.failedDueToNotEnoughFreeResources = true;
            this.manifestRspec = null;
            throw new JFedHighLevelException("Creation of the sliver failed: could not map to resources (resource shortage or unsupported topology)", e);
        }
        catch (AggregateManagerWrapper.TermsAndConditionsException e) {
            this.failedDueToTermAndConditionsNotAccepted = true;
            this.manifestRspec = null;
            throw new JFedHighLevelException("Creation of the sliver failed: Testbed access refused due to Terms & Conditions not accepted", e);
        }
        catch (AggregateManagerWrapper.ReservationProblemException e) {
            this.failedDueToReservationProblem = true;
            this.manifestRspec = null;
            throw new JFedHighLevelException("Creation of the sliver failed: Problem related to reservation of resources.", e);
        }
    }

    private boolean isProvisioned(@Nonnull List<AggregateManager3.SliverInfo> sliverInfos) {
        for (AggregateManager3.SliverInfo sliverInfo : sliverInfos) {
            if (sliverInfo.getAllocationStatus().equalsIgnoreCase("geni_allocated")) {
                return false;
            }
            if (!sliverInfo.getOperationalStatus().equalsIgnoreCase("geni_pending_allocation")) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getSliceCredential(this.slice));
    }

    @Nonnull
    public Slice getSlice() {
        return this.slice;
    }

    @Override
    @Nonnull
    public Server getServer() {
        return this.auth;
    }

    @Override
    @Nonnull
    public Collection<Sliver> getCreatedSlivers() {
        return this.provisionedSlivers != null ? Collections.unmodifiableSet(this.provisionedSlivers) : Collections.emptySet();
    }
}

