/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.RenewTask;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.LoggerFactory;

public final class RenewSliceTask
extends RenewTask {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(RenewSliceTask.class);
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final Instant newExpirationDate;

    public RenewSliceTask(@Nonnull Slice slice, @Nonnull Instant newExpirationDate, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull JavaFXLogger logger, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super("Renew Slice", slice, newExpirationDate, userAndSliceApiWrapper, logger, highLevelTaskFactory);
        this.slice = slice;
        this.newExpirationDate = newExpirationDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        if (this.slice.getExpirationDate() == null || this.slice.getExpirationDate().isBefore(this.newExpirationDate)) {
            try {
                this.userAndSliceApiWrapper.renewSlice((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.slice.getCredentials(), Date.from(this.newExpirationDate));
                return;
            }
            catch (Exception e) {
                LOG.error("Failed to renew slice: " + e.getMessage(), (Throwable)e);
                LOG.error("slice.getExpirationDate()={} newExpirationDate={}", (Object)this.slice.getExpirationDate(), (Object)this.newExpirationDate);
                if (this.slice.getExpirationDate() != null && !this.slice.getExpirationDate().isBefore(this.newExpirationDate)) return;
                if (!(e instanceof JFedException)) throw new JFedException("Failed to renew slice " + String.valueOf(this.slice.getUrn()), (Throwable)e);
                throw (JFedException)((Object)e);
            }
        } else {
            LOG.info("Not renewing slice: new expiration date (" + String.valueOf(this.newExpirationDate) + ") is not after current expiration date (" + String.valueOf(this.slice.getExpirationDate()) + ")");
        }
    }

    @Override
    @Nonnull
    public List<Task> initAlwaysDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getAggregatesForSlice(this.slice));
    }
}

