/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.RenewTask;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AMv3Wrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenewSliversTask
extends RenewTask {
    private static final Logger LOG = LoggerFactory.getLogger(RenewSliversTask.class);
    private final Server auth;
    @Nullable
    private final Collection<Sliver> slivers;
    private final boolean onlyIfNeeded;
    private final SfaModel sfaModel;
    private final Collection<Task> extraDependencies = new ArrayList<Task>();
    @Nonnull
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;

    RenewSliversTask(@Nonnull Slice slice, @Nonnull Instant newExpirationDate, @Nonnull Server auth, @Nullable Collection<Sliver> slivers, boolean onlyIfNeeded, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull JavaFXLogger logger, @Nonnull HighLevelTaskFactory highLevelTaskFactory, @Nonnull SfaModel sfaModel) {
        super("Renew Slivers @ " + auth.getName(), slice, newExpirationDate, userAndSliceApiWrapper, logger, highLevelTaskFactory);
        this.auth = auth;
        this.slivers = slivers;
        this.onlyIfNeeded = onlyIfNeeded;
        this.sfaModel = sfaModel;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
    }

    void addExtraDependency(@Nonnull Task t) {
        this.extraDependencies.add(t);
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws AMv3Wrapper.RenewRefusedException, JFedException, InterruptedException {
        ArrayList<GeniUrn> renewedSlivers;
        if (this.onlyIfNeeded) {
            boolean needed = false;
            Instant newExpirationDateNoSubSecond = Instant.ofEpochSecond(this.newExpirationDate.getEpochSecond());
            ArrayList<Sliver> sliversToRenew = new ArrayList<Sliver>();
            if (this.slivers == null) {
                sliversToRenew.addAll(this.slice.getSliversCopy());
            } else {
                sliversToRenew.addAll(this.slivers);
            }
            if (sliversToRenew.isEmpty()) {
                needed = true;
            }
            for (Sliver sliver : sliversToRenew) {
                if (sliver.getExpirationDate() != null && !Objects.equals(sliver.getExpirationDate(), newExpirationDateNoSubSecond)) {
                    LOG.debug("RenewSliversTask task needs Renew for sliver " + String.valueOf(sliver.getUrn()) + " expiring at " + String.valueOf(sliver.getExpirationDate()));
                    needed = true;
                    break;
                }
                LOG.debug("RenewSliversTask task does not need renew for sliver " + String.valueOf(sliver.getUrn()) + " expiring at " + String.valueOf(sliver.getExpirationDate()));
            }
            if (!needed) {
                LOG.info("RenewSliversTask task running for date " + String.valueOf(this.newExpirationDate) + ", but none of the " + sliversToRenew.size() + " slivers need to be renewed: will do nothing.");
                return;
            }
            LOG.info("RenewSliversTask task running for date " + String.valueOf(this.newExpirationDate) + ", and at least one sliver (of " + sliversToRenew.size() + ") needs to be renewed: will continue.");
        }
        ArrayList<GeniUrn> sliverUrns = new ArrayList<GeniUrn>();
        if (this.slivers != null) {
            for (Sliver sliver : this.slivers) {
                if (Objects.equals(sliver.getStatus().getGlobalStatus(), StatusDetails.SliverStatus.READY) || Objects.equals(sliver.getStatus().getGlobalStatus(), StatusDetails.SliverStatus.CHANGING) || Objects.equals(sliver.getStatus().getGlobalStatus(), StatusDetails.SliverStatus.NOTREADY) || Objects.equals(sliver.getStatus().getGlobalStatus(), StatusDetails.SliverStatus.FAIL)) {
                    sliverUrns.add(sliver.getUrn());
                    continue;
                }
                LOG.info("Ignoring renew request for sliver {}, as it's status is {}", (Object)sliver.getUrnString(), (Object)sliver.getStatus().getGlobalStatus());
            }
        }
        LOG.debug("Executing Renew Slivers @ " + this.auth.getName() + " -> slivers=" + String.valueOf(this.slivers == null ? "null" : Integer.valueOf(this.slivers.size())) + " sliverUrns=" + String.valueOf(sliverUrns) + " newExpirationDate=" + String.valueOf(this.newExpirationDate));
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.auth);
        List updatedSliverUrns = amWrapper.renewSlivers(this.slice.getUrn(), !sliverUrns.isEmpty() ? sliverUrns : null, this.slice.getCredentials(), Date.from(this.newExpirationDate));
        if (updatedSliverUrns != null) {
            renewedSlivers = new HashSet(updatedSliverUrns);
            renewedSlivers.addAll(this.slice.getSliversStream().filter(Sliver::isFake).map(Sliver::getUrn).collect(Collectors.toList()));
            renewedSlivers.addAll(this.slice.getSliversStream().filter(Sliver::isVirtual).map(Sliver::getUrn).collect(Collectors.toList()));
        } else {
            renewedSlivers = sliverUrns;
            if (sliverUrns.isEmpty()) {
                renewedSlivers = this.slice.getSliversStream().map(Sliver::getUrn).collect(Collectors.toList());
            }
        }
        if (this.slice.getSliversStream().allMatch(Sliver::isFake)) {
            amWrapper.describe(this.slice.getUrn(), this.slice.getCredentials());
        }
        if (!renewedSlivers.isEmpty()) {
            try {
                this.updateSlivers(this.auth, renewedSlivers, taskExecution);
            }
            catch (JFedException e) {
                LOG.error("Error while trying to update SLIVER_INFO. Will ignore this.");
            }
            for (GeniUrn sliverUrn : renewedSlivers) {
                Sliver sliver = this.sfaModel.getSliver(sliverUrn);
                if (sliver == null || sliver.getExpirationDate() != null && !sliver.getExpirationDate().isBefore(this.newExpirationDate)) continue;
                Platform.runLater(() -> sliver.setExpirationDate(this.newExpirationDate));
            }
        }
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        ArrayList<Task> res = new ArrayList<Task>();
        res.add(this.highLevelTaskFactory.getSliceCredential(this.slice));
        res.addAll(this.extraDependencies);
        return res;
    }
}

