/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javax.annotation.Nonnull;

public class ResolveUserAndSlicesTask
extends Task {
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    private final JavaFXLogger logger;
    private final GeniUserProvider geniUserProvider;
    private final SfaModel sfaModel;
    private final TaskThread tt;
    private final HighLevelTaskFactory highLevelTaskFactory;

    public ResolveUserAndSlicesTask(UserAndSliceApiWrapper userAndSliceApiWrapper, JavaFXLogger logger, GeniUserProvider geniUserProvider, SfaModel sfaModel, TaskThread tt, HighLevelTaskFactory highLevelTaskFactory) {
        super("Resolve User & Slices");
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.tt = tt;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        List sliceUrns = this.userAndSliceApiWrapper.getSlicesForUser((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.geniUserProvider.getLoggedInGeniUser().getUserUrn());
        for (GeniUrn sliceUrn : sliceUrns) {
            Platform.runLater(() -> {
                Slice slice = this.sfaModel.getSlice(sliceUrn);
                assert (slice != null);
                this.tt.addTask(this.highLevelTaskFactory.getAggregatesForSlice(slice));
            });
        }
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getUserCredential());
    }
}

