/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatusTask
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(StatusTask.class);
    @Nonnull
    private final Server auth;
    @Nonnull
    private final Slice slice;
    private boolean busy = false;
    private boolean softFailure = false;
    private boolean hardFailure = false;
    @Nullable
    private StatusDetails statusDetails;
    @Nonnull
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;

    public StatusTask(@Nonnull Server auth, @Nonnull Slice slice, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super("Status @ " + auth.getDefaultComponentManagerUrn());
        this.auth = auth;
        this.slice = slice;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.auth);
        if (!ApiInfo.hasService((Server)this.auth, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_AM)) {
            throw new JFedHighLevelException("Tried to get Status for slice \"" + this.slice.getUrnString() + "\", at authority \"" + this.auth.getDefaultComponentManagerUrn() + "\", but that authority has no AM URL: cannot continue.");
        }
        this.busy = false;
        this.statusDetails = null;
        try {
            this.statusDetails = amWrapper.status(this.slice.getUrn(), this.slice.getCredentials());
            if (this.statusDetails != null && this.statusDetails.getGlobalStatus() != null && this.statusDetails.getGlobalStatus() == StatusDetails.SliverStatus.UNALLOCATED) {
                LOG.info("Received UNALLOCATED status. This is probably a server bug, we should stop checking status in any case.");
                this.hardFailure = true;
            }
        }
        catch (JFedException ex) {
            if (ex.getGeniResponseCode() != null && ex.getGeniResponseCode().isBusy()) {
                LOG.warn("Got an busy-error while fetching status of sliver. Skipping...");
                this.busy = true;
            }
            this.hardFailure = true;
            throw ex;
        }
        this.softFailure = !this.busy && this.statusDetails == null;
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getSliceCredential(this.slice));
    }

    @Nullable
    public StatusDetails getStatusDetails() {
        return this.statusDetails;
    }

    @Nonnull
    public Server getAuthority() {
        return this.auth;
    }

    public boolean isHardFailure() {
        return this.hardFailure;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public boolean isSoftFailure() {
        return this.softFailure;
    }
}

