/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserAuthorityGetVersionTask
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(UserAuthorityGetVersionTask.class);
    private final Server userAuthority;
    private boolean supportSliverRegistration;
    private boolean known;
    private final JavaFXLogger logger;
    private final GeniUserProvider geniUserProvider;
    private final JFedConnectionProvider connectionProvider;
    private final JFedPreferences jFedPreferences;

    public UserAuthorityGetVersionTask(Server userAuthority, JavaFXLogger logger, GeniUserProvider geniUserProvider, JFedConnectionProvider connectionProvider, JFedPreferences jFedPreferences) {
        super("GetVersion Info @ " + userAuthority.getName());
        this.userAuthority = userAuthority;
        this.logger = logger;
        this.geniUserProvider = geniUserProvider;
        this.connectionProvider = connectionProvider;
        this.jFedPreferences = jFedPreferences;
        this.supportSliverRegistration = false;
        this.known = false;
        boolean hasFedMAApiv2 = ApiInfo.hasService((Server)userAuthority, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_CH_MA, (int)2);
        boolean hasFedSAApiv2 = ApiInfo.hasService((Server)userAuthority, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_CH_SA, (int)2);
        if (!hasFedSAApiv2) {
            this.known = true;
            this.supportSliverRegistration = false;
        }
        LOG.debug("UserAuthorityGetVersionTask: init done known={} supportSliverRegistration={} hasFedMAApiv2={} hasFedSAApiv2={}", new Object[]{this.known, this.supportSliverRegistration, hasFedMAApiv2, hasFedSAApiv2});
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        JFedConnection con;
        FederationSliceAuthorityApi2 sa = new FederationSliceAuthorityApi2((be.iminds.ilabt.jfed.log.Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.jFedPreferences);
        AbstractFederationApi.FederationApiReply gv = sa.getVersion((SfaConnection)(con = this.connectionProvider.getConnectionByAuthority(this.geniUserProvider.getLoggedInGeniUser(), this.userAuthority, FederationSliceAuthorityApi2.class)));
        if (!gv.getGeniResponseCode().isSuccess()) {
            this.known = true;
            this.supportSliverRegistration = false;
            throw new JFedException("GetVersion call failed", (XMLRPCCallDetails)gv.getXmlRpcCallDetailsWithCodeValueError(), (GeniResponseCode)gv.getGeniResponseCode());
        }
        FederationSliceAuthorityApi2.GetVersionSAResult r = (FederationSliceAuthorityApi2.GetVersionSAResult)gv.getValue();
        if (r == null) {
            this.known = true;
            this.supportSliverRegistration = false;
            throw new JFedException("null reply for GetVersion call", (XMLRPCCallDetails)gv.getXmlRpcCallDetailsWithCodeValueError(), (GeniResponseCode)gv.getGeniResponseCode());
        }
        this.known = true;
        this.supportSliverRegistration = r.getServices().contains("SLIVER_INFO");
    }

    public boolean isKnown() {
        return this.known;
    }

    public boolean isSupportSliverRegistration() {
        return this.supportSliverRegistration;
    }
}

