/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ESpecMetaFileCreator {
    private final Experiment experiment;
    private final GeniUser geniUser;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public ESpecMetaFileCreator(Experiment experiment, GeniUser geniUser) {
        this.experiment = experiment;
        this.geniUser = geniUser;
    }

    public byte[] getManifestXml() {
        if (this.experiment.getSlice().getManifestRspec() == null) {
            throw new IllegalStateException("There is no manifest while uploading manifest.xml to node");
        }
        String manifestString = this.experiment.getSlice().getManifestRspec().getRspecXmlString();
        if (manifestString == null) {
            throw new IllegalStateException("There is no manifest string while uploading manifest.xml to node");
        }
        return manifestString.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] getExperimentInfoJson() {
        if (this.experiment.getSlice().getManifestRspec() == null) {
            throw new IllegalStateException("There is no manifest while uploading manifest.xml to node");
        }
        ModelRspec modelRspec = this.experiment.getSlice().getManifestRspec().getModelRspec(ModelRspecType.IMMUTABLE, new ProgressHandler[0]);
        if (modelRspec == null) {
            throw new IllegalStateException("There is no parsable manifest while generating meta experiment-info.json");
        }
        HashMap<String, Cloneable> res = new HashMap<String, Cloneable>();
        HashMap nodes = new HashMap();
        res.put("nodes", nodes);
        for (RspecNode node : modelRspec.getNodes()) {
            if (node.getClientId() == null) continue;
            HashMap<String, Object> nodeInfo = new HashMap<String, Object>();
            nodes.put(node.getClientId(), nodeInfo);
            nodeInfo.put("client_id", node.getClientId());
            if (node.getAnsibleGroups() == null || node.getAnsibleGroups().isEmpty()) {
                nodeInfo.put("ansible_groups", Collections.emptyList());
            } else {
                nodeInfo.put("ansible_groups", new ArrayList(node.getAnsibleGroups()));
            }
            if (node.getInterfaces() == null || node.getInterfaces().isEmpty()) {
                nodeInfo.put("internal_ips", Collections.emptyList());
                nodeInfo.put("connected_nodes", Collections.emptyList());
            } else {
                List ips = node.getInterfaces().stream().map(RspecInterface::getIpAddresses).filter(Objects::nonNull).flatMap(Collection::stream).map(RspecInterface.IpAddress::getAddress).filter(Objects::nonNull).collect(Collectors.toList());
                nodeInfo.put("internal_ips", ips);
                ArrayList connectedNodes = new ArrayList();
                nodeInfo.put("connected_nodes", connectedNodes);
                for (Object iface : node.getInterfaces()) {
                    ArrayList otherIfaces = new ArrayList(iface.getLink().getInterfaces());
                    otherIfaces.remove(iface);
                    for (RspecInterface otherIface : otherIfaces) {
                        HashMap<String, Object> conNodeInfo = new HashMap<String, Object>();
                        conNodeInfo.put("node", otherIface.getNode().getClientId());
                        conNodeInfo.put("local_iface", iface.getClientId());
                        conNodeInfo.put("remote_iface", otherIface.getClientId());
                        conNodeInfo.put("local_ips", iface.getIpAddresses() == null ? Collections.emptyList() : iface.getIpAddresses().stream().filter(Objects::nonNull).map(RspecInterface.IpAddress::getAddress).filter(Objects::nonNull).collect(Collectors.toList()));
                        conNodeInfo.put("remote_ips", otherIface.getIpAddresses() == null ? Collections.emptyList() : otherIface.getIpAddresses().stream().filter(Objects::nonNull).map(RspecInterface.IpAddress::getAddress).filter(Objects::nonNull).collect(Collectors.toList()));
                        connectedNodes.add(conNodeInfo);
                    }
                }
            }
            if (node.getLoginServices() == null || node.getLoginServices().isEmpty()) {
                nodeInfo.put("ssh_login", Collections.emptyList());
                continue;
            }
            List sshLogins = node.getLoginServices().stream().filter(Objects::nonNull).filter(ls -> Objects.equals(ls.getAuthentication(), "ssh-keys")).map(ls -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("hostname", ls.getHostname());
                map.put("username", ls.getUsername());
                map.put("port", ls.getIntPort());
                map.put("hostandport", ls.getHostname() + ":" + ls.getPort());
                map.put("all", ls.getUsername() + "@" + ls.getHostname() + ":" + ls.getPort());
                return map;
            }).collect(Collectors.toList());
            nodeInfo.put("ssh_login", sshLogins);
        }
        HashMap<String, String> user = new HashMap<String, String>();
        ArrayList sshUsers = new ArrayList();
        HashMap<String, String> slice = new HashMap<String, String>();
        HashMap<String, String> project = new HashMap<String, String>();
        res.put("user", user);
        res.put("ssh_users", sshUsers);
        res.put("slice", slice);
        res.put("project", project);
        GeniUrn sliceUrn = this.experiment.getSlice().getUrn();
        slice.put("name", this.experiment.getSlice().getName());
        slice.put("urn", this.experiment.getSlice().getUrnString());
        GeniUrn projectUrn = GeniUrn.createGeniUrnFromEncodedParts((String)sliceUrn.getEncodedTopLevelAuthority(), (String)"project", (String)this.experiment.getSlice().getSubAuthorityName());
        project.put("name", this.experiment.getSlice().getSubAuthorityName());
        project.put("urn", projectUrn.getValue());
        user.put("name", this.geniUser.getUserUrn().getResourceName());
        user.put("urn", this.geniUser.getUserUrnString());
        if (this.experiment.getUserSpecs() != null) {
            for (UserSpec userSpec : this.experiment.getUserSpecs()) {
                HashMap<String, Object> userSpecInfo = new HashMap<String, Object>();
                sshUsers.add(userSpecInfo);
                userSpecInfo.put("urn", userSpec.getUrn());
                userSpecInfo.put("ssh_keys", userSpec.getSshKey());
                GeniUrn urn = GeniUrn.parse((String)userSpec.getUrn());
                if (urn == null) continue;
                userSpecInfo.put("name", urn.getResourceName());
            }
        }
        try {
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsBytes(res);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Problem generating JSON while generating meta experiment-info.json", e);
        }
    }
}

