/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.text.ParseException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public class ExpirationChecker {
    @Nullable
    public static Instant getEarliestExpiration(@Nonnull Collection<Sliver> slivers) {
        Instant earliestSliverExpiration = null;
        for (Sliver sliver : slivers) {
            if (sliver.getExpirationDate() == null || sliver.isFake() || earliestSliverExpiration != null && !earliestSliverExpiration.isAfter(sliver.getExpirationDate())) continue;
            earliestSliverExpiration = sliver.getExpirationDate();
        }
        return earliestSliverExpiration;
    }

    @Nullable
    public static Instant getEarliestExpiration(@Nonnull Slice slice) {
        Instant earliestSliverExp = ExpirationChecker.getEarliestSliverExpiration(slice);
        if (earliestSliverExp == null) {
            return null;
        }
        if (slice.getExpirationDate() == null) {
            return null;
        }
        if (slice.getExpirationDate().isBefore(earliestSliverExp)) {
            return slice.getExpirationDate();
        }
        return earliestSliverExp;
    }

    @Nullable
    public static Instant getEarliestSliverExpiration(@Nonnull Slice slice) {
        List<Sliver> slivers = slice.getSliversCopy();
        Instant earliestSliverExp = ExpirationChecker.getEarliestExpiration(slivers);
        if (earliestSliverExp == null) {
            if (slivers.isEmpty() || slivers.stream().allMatch(Sliver::isFake)) {
                ImmutableModelRspec modelRspec;
                if (slice.getManifestRspec() != null && (modelRspec = slice.getManifestRspec().getImmutableModelRspec()) != null && modelRspec.getExpiresString() != null) {
                    try {
                        return RFC3339Util.rfc3339StringToInstant((String)modelRspec.getExpiresString());
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                return null;
            }
            return null;
        }
        return earliestSliverExp;
    }

    @Nullable
    public static Instant getEarliestExpiration(@Nonnull Experiment experiment) {
        return ExpirationChecker.getEarliestExpiration(experiment.getSlice());
    }

    @Nullable
    @Contract(value="!null,!null -> !null;_,null->null;null,_->null")
    public static Instant getEarliestOrNull(@Nullable Instant a, @Nullable Instant b) {
        if (a == null || b == null) {
            return null;
        }
        return a.isBefore(b) ? a : b;
    }

    @Nullable
    @Contract(value="!null,!null -> !null;null,null->null;null,!null->!null;!null,null->!null")
    public static Instant getEarliestNonNull(@Nullable Instant a, @Nullable Instant b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.isBefore(b) ? a : b;
    }

    @Contract(value="_,null -> true")
    public static boolean isEarlyExpire(@Nonnull Instant requestedExpiration, @Nullable Instant actualExpiration) {
        long requestedMillis;
        if (actualExpiration == null) {
            return true;
        }
        if (requestedExpiration == null) {
            throw new IllegalStateException("requestedExpiration is null");
        }
        long actualMillis = actualExpiration.toEpochMilli();
        return actualMillis + 5000L < (requestedMillis = requestedExpiration.toEpochMilli());
    }

    @Contract(value="_,null -> true")
    public static boolean isEarlyExpire(@Nonnull Experiment experiment, @Nullable Instant timeToCheck) {
        return ExpirationChecker.isEarlyExpire(experiment.getRequestedEndTime(), timeToCheck);
    }

    public static boolean isEarlyExpire(@Nonnull Experiment experiment, @Nonnull Slice slice) {
        return ExpirationChecker.isEarlyExpire(experiment.getRequestedEndTime(), ExpirationChecker.getEarliestExpiration(slice));
    }

    public static boolean isEarlyExpire(@Nonnull Experiment experiment) {
        return ExpirationChecker.isEarlyExpire(experiment.getRequestedEndTime(), ExpirationChecker.getEarliestExpiration(experiment.getSlice()));
    }
}

