/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.SliceAuthorityTaskFactory;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceRegistryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SliceRegistryUtil.class);
    protected final UserAndSliceApiWrapper userAndSliceApiWrapper;
    protected final TaskThread tt;
    protected final Provider<SliceAuthorityTaskFactory> sliceAuthorityTaskFactoryProvider;

    @Inject
    public SliceRegistryUtil(UserAndSliceApiWrapper userAndSliceApiWrapper, TaskThread tt, Provider<SliceAuthorityTaskFactory> sliceAuthorityTaskFactoryProvider) {
        this.tt = tt;
        this.sliceAuthorityTaskFactoryProvider = sliceAuthorityTaskFactoryProvider;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
    }

    public TaskExecution registerSliversAtSATaskExecution(@Nonnull Collection<Sliver> slivers, @Nonnull Instant endTime, Task extraTaskToDependOn, ResultListener ... extraResultListeners) {
        if (!this.userAndSliceApiWrapper.isRegisterAggregatesForSliceSupported()) {
            LOG.info("Ignoring sliver register request, as this is not supported by the SA");
            return null;
        }
        if (slivers.isEmpty()) {
            LOG.warn("Received an empty list of slivers to register. Ignoring!");
            return null;
        }
        Collection sliverUrns = slivers.stream().map(Sliver::getUrn).collect(Collectors.toList());
        assert (sliverUrns != null);
        Instant sliverExpirationDate = null;
        Slice slice = null;
        Server auth = null;
        for (Sliver sliver : slivers) {
            if (sliver.getExpirationDate() != null) {
                if (sliverExpirationDate == null) {
                    sliverExpirationDate = sliver.getExpirationDate();
                } else if (!Objects.equals(sliverExpirationDate, sliver.getExpirationDate())) {
                    LOG.warn("The slivers should expire at same time, they were created with single call. sliverExpirationDate={} sliver.getExpirationDate()={} for {}", new Object[]{sliverExpirationDate, sliver.getExpirationDate(), sliver.getUrnString() + String.valueOf(sliver.getExpirationDate())});
                }
            }
            assert (slice == null || slice.getUrn().equals((Object)sliver.getSlice().getUrn())) : "All slivers provided to this call should be on the same slice";
            slice = sliver.getSlice();
            assert (auth == null || auth.getDefaultComponentManagerUrn().equals(sliver.getServer().getDefaultComponentManagerUrn())) : "All slivers provided to this call should be on the same authority";
            auth = sliver.getServer();
            if (sliverExpirationDate != null) continue;
            sliverExpirationDate = endTime;
        }
        assert (slice != null);
        assert (auth != null);
        if (sliverExpirationDate == null) {
            LOG.error("Cannot register slivers, because no sliver has an expiration date!");
            return null;
        }
        LOG.info("Will register SLIVER_INFO with sliverExpirationDate=" + String.valueOf(sliverExpirationDate) + " (" + RFC3339Util.instantToRFC3339String(sliverExpirationDate) + ") (" + RFC3339Util.instantToRFC3339String((Instant)sliverExpirationDate, (boolean)true, (boolean)true, (boolean)true) + ") (endTime=" + RFC3339Util.instantToRFC3339String((Instant)endTime) + ")");
        return this.tt.addTask(((SliceAuthorityTaskFactory)this.sliceAuthorityTaskFactoryProvider.get()).registerSlivers(slice, auth, sliverUrns, sliverExpirationDate, extraTaskToDependOn, extraResultListeners));
    }

    public TaskExecution updateSliversAtSATaskExecution(@Nonnull Collection<Sliver> slivers, @Nonnull Instant endTime, Task extraTaskToDependOn, ResultListener ... extraResultListeners) {
        if (!this.userAndSliceApiWrapper.isRegisterAggregatesForSliceSupported()) {
            LOG.info("Ignoring sliver register request, as this is not supported by the SA");
            return null;
        }
        if (slivers.isEmpty()) {
            LOG.warn("Received an empty list of slivers to register. Ignoring!");
            return null;
        }
        Collection sliverUrns = slivers.stream().map(Sliver::getUrn).collect(Collectors.toList());
        assert (sliverUrns != null);
        Instant sliverExpirationDate = null;
        Slice slice = null;
        Server auth = null;
        for (Sliver sliver : slivers) {
            if (sliver.getExpirationDate() != null) {
                if (sliverExpirationDate == null) {
                    sliverExpirationDate = sliver.getExpirationDate();
                } else if (!Objects.equals(sliverExpirationDate, sliver.getExpirationDate())) {
                    LOG.warn("The slivers should expire at same time, they were created with single call. sliverExpirationDate={} sliver.getExpirationDate()={} for {}", new Object[]{sliverExpirationDate, sliver.getExpirationDate(), sliver.getUrnString() + String.valueOf(sliver.getExpirationDate())});
                }
            }
            assert (slice == null || slice.getUrn().equals((Object)sliver.getSlice().getUrn())) : "All slivers provided to this call should be on the same slice";
            slice = sliver.getSlice();
            assert (auth == null || auth.getDefaultComponentManagerUrn().equals(sliver.getServer().getDefaultComponentManagerUrn())) : "All slivers provided to this call should be on the same authority";
            auth = sliver.getServer();
            if (sliverExpirationDate != null) continue;
            sliverExpirationDate = endTime;
        }
        assert (slice != null);
        assert (auth != null);
        if (sliverExpirationDate == null) {
            LOG.error("Cannot update slivers, because no sliver has an expiration date!");
            return null;
        }
        LOG.info("Will update SLIVER_INFO with sliverExpirationDate=" + String.valueOf(sliverExpirationDate) + " (" + RFC3339Util.instantToRFC3339String(sliverExpirationDate) + ") (" + RFC3339Util.instantToRFC3339String((Instant)sliverExpirationDate, (boolean)true, (boolean)true, (boolean)true) + ") (endTime=" + RFC3339Util.instantToRFC3339String((Instant)endTime) + ")");
        return this.tt.addTask(((SliceAuthorityTaskFactory)this.sliceAuthorityTaskFactoryProvider.get()).updateSlivers(slice, auth, sliverUrns, sliverExpirationDate, extraTaskToDependOn, extraResultListeners));
    }

    public TaskExecution unregisterSliversAtSATaskExecution(@Nonnull Slice slice, @Nonnull Server auth, ResultListener ... extraResultListeners) {
        return this.unregisterSliversAtSATaskExecution(slice, auth, (Task)null, extraResultListeners);
    }

    public TaskExecution unregisterSliversAtSATaskExecution(@Nonnull Slice slice, @Nonnull Server auth, @Nullable Task extraTaskToDependOn, ResultListener ... extraResultListeners) {
        List<GeniUrn> sliversToUnregister = slice.getSliversStream().filter(s -> Objects.equals(s.getUrn().getEncodedTopLevelAuthority_withoutSubAuth(), auth.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority_withoutSubAuth())).map(Sliver::getUrn).collect(Collectors.toList());
        return this.unregisterSliversAtSATaskExecution(slice, auth, sliversToUnregister, extraTaskToDependOn, extraResultListeners);
    }

    public TaskExecution unregisterSliversAtSATaskExecution(@Nonnull Slice slice, @Nonnull Server auth, @Nonnull Collection<GeniUrn> sliversToUnregister, @Nullable Task extraTaskToDependOn, ResultListener ... extraResultListeners) {
        if (!this.userAndSliceApiWrapper.isRegisterAggregatesForSliceSupported()) {
            LOG.info("Ignoring sliver unregister request, as this is not supported by the SA");
            return null;
        }
        if (sliversToUnregister.isEmpty()) {
            LOG.warn("Could not find any slivers of authority {} in slice {} to unregister. Skipping!", (Object)auth.getDefaultComponentManagerUrn(), (Object)slice.getUrnString());
            return null;
        }
        return this.tt.addTask(((SliceAuthorityTaskFactory)this.sliceAuthorityTaskFactoryProvider.get()).unregisterSlivers(slice, auth, sliversToUnregister, extraTaskToDependOn, extraResultListeners));
    }

    public TaskExecution registerSliceAtSA(@Nonnull AbstractFederationApi.SliceRspecType type, @Nonnull Slice slice, @Nullable Server auth, @Nonnull String rspec, @Nonnull Instant sliceProvisionDate, @Nullable Task extraTaskToDependOn, ResultListener ... extraResultListeners) {
        if (auth != null && !auth.hasFlag(Server.Flag.featureSASliceRSpec)) {
            LOG.info("Ignoring SLICE_RSPEC request, as the auth AM (" + auth.getName() + ") does not have the flag featureSASliceRSpec");
            return null;
        }
        if (!this.userAndSliceApiWrapper.isSliceRspecSupported()) {
            LOG.info("Ignoring SLICE_RSPEC request, as this is not supported by the SA");
            return null;
        }
        return this.tt.addTask(((SliceAuthorityTaskFactory)this.sliceAuthorityTaskFactoryProvider.get()).registerSliceRspec(type, slice, auth, rspec, sliceProvisionDate, extraTaskToDependOn, extraResultListeners));
    }
}

