/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.base_gui.util;

import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class StringConverterListCell<T>
extends ListCell<T> {
    private final StringConverter<T> converter;
    private final Label label = new Label();

    public StringConverterListCell(StringConverter<T> converter) {
        this.converter = converter;
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null) {
            this.label.setText("");
            this.setGraphic(null);
        } else {
            this.label.setText(this.converter.toString(item));
            this.setGraphic((Node)this.label);
        }
    }

    public static <T> Callback<ListView<T>, ListCell<T>> getListViewCellFactory(StringConverter<T> converter) {
        return listView -> new StringConverterListCell(converter);
    }
}

