/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class BugReportAppender
extends AppenderBase<ILoggingEvent> {
    public static final String DEFAULT_NAME = "BUGREPORT";
    private static final int MAX_SIZE = 2048;
    private final Queue<ILoggingEvent> buffer;
    private final List<LoggingEventListener> listeners;

    public BugReportAppender() {
        this.setName(DEFAULT_NAME);
        this.buffer = Queues.synchronizedQueue((Queue)EvictingQueue.create((int)2048));
        this.listeners = new ArrayList<LoggingEventListener>();
    }

    protected void append(ILoggingEvent e) {
        this.buffer.add(e);
        this.listeners.forEach(l -> l.onLoggingEvent(e));
    }

    public int getMaxSize() {
        return 2048;
    }

    public synchronized List<ILoggingEvent> getListCopy() {
        return new ArrayList<ILoggingEvent>(this.buffer);
    }

    public int getLength() {
        return this.buffer.size();
    }

    public void addListeners(LoggingEventListener l) {
        this.listeners.add(l);
    }

    public void removeListeners(LoggingEventListener l) {
        this.listeners.remove(l);
    }

    public static interface LoggingEventListener {
        public void onLoggingEvent(ILoggingEvent var1);
    }
}

