/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.logging;

import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.logging.BugReportAppender;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.DefaultJoranConfigurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JFedLoggerManager {
    private static final Logger LOG = LoggerFactory.getLogger(JFedLoggerManager.class);
    private final JFedHLPreferences preferences;

    @Inject
    public JFedLoggerManager(JFedHLPreferences preferences) {
        this.preferences = preferences;
        this.tryInitializeBugReportAppender();
        this.updateLoggers();
    }

    private static Level getLevel(String levelName) {
        if (levelName == null) {
            return null;
        }
        if (levelName.equalsIgnoreCase("trace")) {
            return Level.TRACE;
        }
        if (levelName.equalsIgnoreCase("debug")) {
            return Level.DEBUG;
        }
        if (levelName.equalsIgnoreCase("info")) {
            return Level.INFO;
        }
        if (levelName.equalsIgnoreCase("warn")) {
            return Level.WARN;
        }
        if (levelName.equalsIgnoreCase("error")) {
            return Level.ERROR;
        }
        return null;
    }

    public void testLogging() {
        LOG.trace("TRACE test");
        LOG.debug("DEBUG test");
        LOG.info("INFO test");
        LOG.warn("WARN test");
        LOG.error("ERROR test");
    }

    public BugReportAppender getBugReportMemoryAppender() {
        Logger rootLogger = LoggerFactory.getLogger((String)"ROOT");
        if (!(rootLogger instanceof ch.qos.logback.classic.Logger)) {
            LOG.error("rootLogger is not instance of ch.qos.logback.classic.Logger but of " + rootLogger.getClass().getName());
            return null;
        }
        ch.qos.logback.classic.Logger logbackRoot = (ch.qos.logback.classic.Logger)rootLogger;
        Appender appender = logbackRoot.getAppender("BUGREPORT");
        if (appender == null) {
            LOG.error("BUGREPORT appender is not found");
            return null;
        }
        if (!(appender instanceof BugReportAppender)) {
            LOG.error("BUGREPORT appender is not a BugReportAppender but a " + appender.getClass().getName());
            return null;
        }
        return (BugReportAppender)appender;
    }

    public void updateLoggers() {
        if (!this.preferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_LOGGING_OVERWRITE).booleanValue()) {
            LOG.info("jFed is configured not to change the automatic logging configuration: Will reload default config.");
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            DefaultJoranConfigurator configurator = new DefaultJoranConfigurator();
            loggerContext.reset();
            configurator.setContext((Context)loggerContext);
            configurator.configure(loggerContext);
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
        } else {
            Level lowlevelConnectionLevel;
            LOG.info("jFed will update the logging configuration.");
            Logger rootLogger = LoggerFactory.getLogger((String)"ROOT");
            if (!(rootLogger instanceof ch.qos.logback.classic.Logger)) {
                LOG.error("rootLogger is not instance of ch.qos.logback.classic.Logger but of " + rootLogger.getClass().getName());
                System.out.println("NOTE: logging cannot be modified by jFed: rootLogger is not instance of ch.qos.logback.classic.Logger but of " + rootLogger.getClass().getName());
                return;
            }
            ch.qos.logback.classic.Logger logbackRoot = (ch.qos.logback.classic.Logger)rootLogger;
            Level rootLevel = JFedLoggerManager.getLevel(this.preferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_LOGGING_ROOT_LEVEL));
            Level terminalLevel = JFedLoggerManager.getLevel(this.preferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_LOGGING_EXTTERM_LEVEL));
            if (rootLevel != null) {
                Level origLevel = logbackRoot.getLevel();
                if (origLevel.toInt() != rootLevel.toInt()) {
                    LOG.info("jFed changes the root log level from " + origLevel.toString() + " to " + rootLevel.toString());
                    logbackRoot.setLevel(rootLevel);
                } else {
                    LOG.info("jFed leaves the root log level unchanged at " + String.valueOf(rootLevel));
                }
            } else {
                LOG.info("No root level specified in config: " + this.preferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_LOGGING_ROOT_LEVEL));
            }
            if (terminalLevel != null) {
                Logger logger = LoggerFactory.getLogger((String)"be.iminds.ilabt.jfed.ssh_terminal_tool");
                if (logger instanceof ch.qos.logback.classic.Logger) {
                    ch.qos.logback.classic.Logger termLogger = (ch.qos.logback.classic.Logger)logger;
                    Level origLevel = termLogger.getLevel();
                    if (origLevel.toInt() != terminalLevel.toInt()) {
                        LOG.debug("Changing external terminal log level from " + String.valueOf(origLevel) + " to " + String.valueOf(terminalLevel));
                        termLogger.setLevel(terminalLevel);
                    } else {
                        LOG.debug("Leaving external terminal log level unchanged at " + String.valueOf(terminalLevel));
                    }
                } else {
                    LOG.error("external terminal Logger is not instance of ch.qos.logback.classic.Logger but of " + logger.getClass().getName() + " -> Cannot be changed.");
                }
            }
            Object object = lowlevelConnectionLevel = this.preferences.getBoolean((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_DEBUG_CPU) != false ? rootLevel : null;
            if (lowlevelConnectionLevel != null) {
                Logger logger = LoggerFactory.getLogger((String)"be.iminds.ilabt.jfed.lowlevel.connection");
                if (logger instanceof ch.qos.logback.classic.Logger) {
                    ch.qos.logback.classic.Logger termLogger = (ch.qos.logback.classic.Logger)logger;
                    Level origLevel = termLogger.getLevel();
                    if (origLevel.toInt() != lowlevelConnectionLevel.toInt()) {
                        LOG.debug("Changing lowlevel connection log level from " + String.valueOf(origLevel) + " to " + String.valueOf(lowlevelConnectionLevel));
                        termLogger.setLevel(lowlevelConnectionLevel);
                    } else {
                        LOG.debug("Leaving lowlevel connection log level unchanged at " + String.valueOf(lowlevelConnectionLevel));
                    }
                } else {
                    LOG.error("lowlevel connection Logger is not instance of ch.qos.logback.classic.Logger but of " + logger.getClass().getName() + " -> Cannot be changed.");
                }
            }
        }
        this.tryInitializeBugReportAppender();
    }

    private void tryInitializeBugReportAppender() {
        Logger rootLogger = LoggerFactory.getLogger((String)"ROOT");
        if (!(rootLogger instanceof ch.qos.logback.classic.Logger)) {
            LOG.error("rootLogger is not instance of ch.qos.logback.classic.Logger but of " + rootLogger.getClass().getName());
            System.out.println("NOTE: logging cannot be modified by jFed: rootLogger is not instance of ch.qos.logback.classic.Logger but of " + rootLogger.getClass().getName());
            return;
        }
        ch.qos.logback.classic.Logger logbackRootLogger = (ch.qos.logback.classic.Logger)rootLogger;
        if (logbackRootLogger.getAppender("BUGREPORT") != null) {
            LOG.trace("An existing BugReportAppender has been found. Not registering again");
            return;
        }
        BugReportAppender bugReportAppender = new BugReportAppender();
        bugReportAppender.setContext((Context)logbackRootLogger.getLoggerContext());
        logbackRootLogger.addAppender((Appender)bugReportAppender);
        bugReportAppender.start();
        LOG.debug("Registered bugReportAppender on the rootLogger");
    }
}

