/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ssh_terminal_tool;

import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.util.common.OSDetector;
import be.iminds.ilabt.jfed.util.lib.LocalForwardUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.controlsfx.dialog.ExceptionDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExternalRdpApp {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalRdpApp.class);
    private final GeniUserProvider geniUserProvider;
    private final JFedHLPreferences jFedPreferences;
    private final ProxyPreferencesManager proxyPreferencesManager;
    private final LocalForwardUtil localForwardUtil;

    @Inject
    public ExternalRdpApp(GeniUserProvider geniUserProvider, ProxyPreferencesManager proxyPreferencesManager, JFedHLPreferences jFedPreferences, LocalForwardUtil localForwardUtil) {
        this.geniUserProvider = geniUserProvider;
        this.proxyPreferencesManager = proxyPreferencesManager;
        this.jFedPreferences = jFedPreferences;
        this.localForwardUtil = localForwardUtil;
    }

    public boolean isConfigured() {
        LOG.debug("ExternalRdpApp.isConfigured");
        if (OSDetector.os == OSDetector.OS.WIN) {
            File puttyDir = this.jFedPreferences.getFile((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_DIRECTORY);
            LOG.debug("ExternalRdpApp.isConfigured WIN puttyDir=" + String.valueOf(puttyDir));
            if (puttyDir == null) {
                return false;
            }
            boolean valid = JFedHLPreferences.isValidPuttyDir((File)puttyDir);
            LOG.debug("ExternalRdpApp.isConfigured WIN puttyDir=" + String.valueOf(puttyDir) + " valid=" + valid);
            return valid;
        }
        if (OSDetector.os == OSDetector.OS.UNIX) {
            return this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_UNIX_TERMINAL) != null;
        }
        if (OSDetector.os == OSDetector.OS.MAC) {
            return this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_UNIX_TERMINAL) != null;
        }
        return true;
    }

    public void launch(@Nullable String targetServerUserName, @Nonnull String hostName, int port, @Nullable String password, @Nullable JFedConnection.ProxyInfo customProxyInfo) {
        JFedConnection.SshProxyInfo jFedProxyInfo;
        GeniUser geniUser = this.geniUserProvider.getLoggedInGeniUser();
        JFedConnection.SshProxyInfo usedProxyInfo = jFedProxyInfo = geniUser.getUserAuthorityServer() == null ? null : this.proxyPreferencesManager.getSshProxySettings(geniUser.getUserAuthorityServer().getTestbed().getProxies(), geniUser);
        if (customProxyInfo != null) {
            usedProxyInfo = (JFedConnection.SshProxyInfo)customProxyInfo;
        }
        if (usedProxyInfo == null) {
            LOG.info("ExternalRdpApp: No proxy will be used.");
        } else {
            LOG.info("ExternalRdpApp: Proxy will be used: " + String.valueOf(usedProxyInfo));
            int forwardPort = 0;
            try {
                forwardPort = this.localForwardUtil.forwardOverSshProxy(usedProxyInfo, hostName, port);
            }
            catch (IOException e) {
                this.showSshPortForwardingFailureDialog(e, null);
                return;
            }
            hostName = "localhost";
            port = forwardPort;
        }
        if (OSDetector.os == OSDetector.OS.WIN) {
            this.launchWindowsRemoteDesktop(targetServerUserName, hostName, port, password);
            return;
        }
        this.launchShellRdpApp(targetServerUserName, hostName, port, password);
    }

    private void showSshPortForwardingFailureDialog(Exception e, Stage stage) {
        ExceptionDialog exceptionDialog = new ExceptionDialog((Throwable)e);
        if (stage != null) {
            exceptionDialog.initOwner((Window)stage);
        }
        String headerText = "SSH Port Forwarding Failure";
        String contentText = "jFed encountered an exception while setting up SSH port forwarding to be used for the Remote Desktop Session.This is likely caused by a connectivity issue or an error at the server. Consult the stacktrace or the logs for more details.Please send the jFed developers a bug report if this is a bug in jFed.";
        exceptionDialog.setHeaderText(headerText);
        exceptionDialog.setContentText(contentText);
        exceptionDialog.show();
    }

    private void showWindowsRemoteDesktopDetails(@Nullable String targetServerUserName, @Nonnull String hostName, int port, @Nullable String password) {
        VBox pane = new VBox();
        pane.setPrefWidth(750.0);
        pane.setSpacing(5.0);
        Object text = String.format("jFed is not configured to open an RDP application.\n\nYou can manually open a windows Remote Desktop connection to %s:%d\n", hostName, port);
        if (targetServerUserName != null || password != null) {
            text = (String)text + "You can login ";
        }
        if (targetServerUserName != null) {
            text = (String)text + String.format(" with username \"%s\"", targetServerUserName);
        }
        if (password != null) {
            text = (String)text + String.format(" using the password \"%s\"", password);
        }
        Label textLabel = new Label((String)text);
        textLabel.setPrefHeight(75.0);
        textLabel.setWrapText(true);
        pane.getChildren().add((Object)textLabel);
        DialogPane dialogPane = new DialogPane();
        dialogPane.setContent((Node)pane);
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
        Dialog dialog = new Dialog();
        dialog.setTitle("Remote Desktop Info");
        dialog.setDialogPane(dialogPane);
        dialog.showAndWait();
    }

    private void launchWindowsRemoteDesktop(@Nullable String username, @Nonnull String hostName, int port, @Nullable String password) {
        String rdpCommandTemplate = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_RDP);
        if (rdpCommandTemplate == null || rdpCommandTemplate.trim().isEmpty()) {
            this.showWindowsRemoteDesktopDetails(username, hostName, port, password);
            return;
        }
        this.launchExternalRdpApp(rdpCommandTemplate, hostName, port, password, rdpCommandTemplate);
    }

    private void launchShellRdpApp(@Nullable String username, @Nonnull String hostName, int port, @Nullable String password) {
        String rdpCommandTemplate = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_RDP);
        if (rdpCommandTemplate == null || rdpCommandTemplate.trim().isEmpty()) {
            this.showWindowsRemoteDesktopDetails(username, hostName, port, password);
            return;
        }
        this.launchExternalRdpApp(username, hostName, port, password, rdpCommandTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchExternalRdpApp(@Nullable String username, @Nonnull String hostName, int port, @Nullable String password, String rdpCommandTemplate) {
        Runnable processOutputMonitor = () -> {
            try {
                Process p;
                LinkedList<String> commandList = new LinkedList<String>(Arrays.asList(rdpCommandTemplate.split(" ")));
                ListIterator<String> it = commandList.listIterator();
                while (it.hasNext()) {
                    String parameter = (String)it.next();
                    if (parameter.equals("$P")) {
                        if (password == null) {
                            it.remove();
                            it.previous();
                            it.remove();
                            continue;
                        }
                        it.set(password);
                    }
                    if (parameter.equals("$u")) {
                        if (username == null) {
                            it.remove();
                            it.previous();
                            it.remove();
                            continue;
                        }
                        it.set(username);
                    }
                    String replacement = parameter;
                    if (parameter.contains("$h")) {
                        replacement = replacement.replaceAll(Pattern.quote("$h"), hostName);
                        it.set(replacement);
                    }
                    if (!parameter.contains("$p")) continue;
                    replacement = replacement.replaceAll(Pattern.quote("$p"), "" + port);
                    it.set(replacement);
                }
                LOG.debug("ExternalRdpApp Thread: Starting terminal using command (list): " + String.valueOf(commandList));
                ProcessBuilder pb = new ProcessBuilder(commandList);
                pb = pb.redirectErrorStream(true);
                Instant startInstant = Instant.now();
                try {
                    String line;
                    p = pb.start();
                    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while ((line = input.readLine()) != null) {
                        LOG.debug("ExternalRdpApp Thread: External RdpApp stdout+stderr: " + line);
                    }
                    input.close();
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        LOG.warn("ExternalRdpApp Thread: processOutputMonitor thread interrupted while waiting for terminal to stop", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    LOG.error("Error launching RDP client", (Throwable)e);
                    p = null;
                }
                Instant stopInstant = Instant.now();
                if (p != null) {
                    LOG.info("ExternalRdpApp Thread: Terminal command exited with exit value: " + p.exitValue());
                }
                if (stopInstant.isBefore(startInstant.plus(2L, ChronoUnit.SECONDS))) {
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setContentText("Problem launching Windows Remote Desktop Application:\nThe application was started, but exited very soon afterwards.\n\nCheck the command in the preferences, or the jFed logs (CTRL-F10).");
                        alert.setTitle("RDP App Problem");
                        alert.setResizable(true);
                        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                        alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
                        alert.showAndWait();
                    });
                }
            }
            catch (Exception e) {
                LOG.error("Unhandled Exception in ExternalRdpApp Thread.", (Throwable)e);
            }
            catch (AssertionError e) {
                LOG.error("Unhandled AssertionError in ExternalRdpApp Thread.", (Throwable)((Object)e));
            }
        };
        try {
            Thread t = new Thread(processOutputMonitor);
            t.setName("ExternalRdpApp");
            t.setDaemon(true);
            t.start();
        }
        catch (AssertionError e) {
            LOG.error("AssertionError starting ExternalRdpApp Thread", (Throwable)((Object)e));
        }
        catch (Exception e) {
            LOG.error("Exception starting ExternalRdpApp Thread", (Throwable)e);
        }
        catch (Error e) {
            try {
                LOG.error("Error starting ExternalRdpApp Thread", (Throwable)e);
            }
            finally {
                throw e;
            }
        }
    }
}

