/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ssh_terminal_tool;

import be.iminds.ilabt.jfed.gui_preferences.DoubleProxyHandling;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.util.SshCommandBuilder;
import be.iminds.ilabt.jfed.highlevel.util.SshCommandBuilderFactory;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.ssh_terminal_tool.known_hosts.OpenSshKnownHostsFile;
import be.iminds.ilabt.jfed.ssh_terminal_tool.putty.PuttyHelper;
import be.iminds.ilabt.jfed.ssh_terminal_tool.unix.SshAgentHelper;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.OSDetector;
import be.iminds.ilabt.jfed.util.common.Pair;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpContentFile;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExternalSshTerminal {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalSshTerminal.class);
    private final GeniUserProvider geniUserProvider;
    private final JFedHLPreferences jFedPreferences;
    private final ProxyPreferencesManager proxyPreferencesManager;
    private final PuttyHelper puttyHelper;
    private final OpenSshKnownHostsFile openSshKnownHostsFile;
    private final SshCommandBuilderFactory sshCommandBuilderFactory;
    private final SshCommandBuilder.KeyPasswordRequester keyPasswordRequester;

    @Inject
    public ExternalSshTerminal(GeniUserProvider geniUserProvider, ProxyPreferencesManager proxyPreferencesManager, JFedHLPreferences jFedPreferences, PuttyHelper puttyHelper, OpenSshKnownHostsFile openSshKnownHostsFile, SshCommandBuilderFactory sshCommandBuilderFactory) {
        this.geniUserProvider = geniUserProvider;
        this.proxyPreferencesManager = proxyPreferencesManager;
        this.jFedPreferences = jFedPreferences;
        this.puttyHelper = puttyHelper;
        this.openSshKnownHostsFile = openSshKnownHostsFile;
        this.sshCommandBuilderFactory = sshCommandBuilderFactory;
        this.keyPasswordRequester = new SshCommandBuilder.KeyPasswordRequester(){

            @Nullable
            public char[] requestPassword(String text) {
                Optional<String> pass = JFDialogs.create().message(text).masthead("Password required").showPasswordInput();
                return pass.map(String::toCharArray).orElse(null);
            }
        };
        boolean terminalDebug = jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_TERMINAL_DEBUG, true);
    }

    public boolean isConfigured() {
        LOG.debug("ExternalSshTerminal.isConfigured");
        if (OSDetector.os == OSDetector.OS.WIN) {
            File puttyDir = this.jFedPreferences.getFile((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_DIRECTORY);
            LOG.debug("ExternalSshTerminal.isConfigured WIN puttyDir=" + String.valueOf(puttyDir));
            if (puttyDir == null) {
                return false;
            }
            boolean valid = JFedHLPreferences.isValidPuttyDir((File)puttyDir);
            LOG.debug("ExternalSshTerminal.isConfigured WIN puttyDir=" + String.valueOf(puttyDir) + " valid=" + valid);
            return valid;
        }
        if (OSDetector.os == OSDetector.OS.UNIX) {
            return this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_UNIX_TERMINAL) != null;
        }
        if (OSDetector.os == OSDetector.OS.MAC) {
            return this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_UNIX_TERMINAL) != null;
        }
        return true;
    }

    public String getCliSshCommand(@Nonnull String targetServerUserName, @Nonnull String hostName, int port, @Nullable JFedConnection.ProxyInfo customProxyInfo) {
        SshCommandBuilder builder = this.prepareSshCommand(targetServerUserName, hostName, port, customProxyInfo);
        return (String)builder.build(true).getKey();
    }

    public void launch(@Nonnull String targetServerUserName, @Nonnull String hostName, int port, @Nullable JFedConnection.ProxyInfo customProxyInfo) {
        SshCommandBuilder sshCommandBuilder = this.prepareSshCommand(targetServerUserName, hostName, port, customProxyInfo);
        if (sshCommandBuilder.getProxyInfo() == null) {
            LOG.info("ExternalSshTerminal: No proxy will be used.");
        } else {
            LOG.info("ExternalSshTerminal: Proxy will be used: " + String.valueOf(sshCommandBuilder.getProxyInfo()));
        }
        if (OSDetector.os == OSDetector.OS.WIN) {
            this.launchPutty(targetServerUserName, hostName, port, sshCommandBuilder.getSshKeyInfos(), sshCommandBuilder.getProxyInfo());
            return;
        }
        if (OSDetector.os == OSDetector.OS.UNIX) {
            this.launchUnixOrMacTerminal(false, sshCommandBuilder);
            return;
        }
        if (OSDetector.os == OSDetector.OS.MAC) {
            this.launchUnixOrMacTerminal(true, sshCommandBuilder);
            return;
        }
        throw new RuntimeException("No terminal known for OS \"" + String.valueOf(OSDetector.os) + "\"");
    }

    public void launchPutty(String userName, String hostName, int port, List<? extends PuTTYFilesKeyInfo> sshKeyInfos, JFedConnection.ProxyInfo proxyInfo) {
        PuttyHelper.PuttyRunParameters parameters = new PuttyHelper.PuttyRunParameters();
        parameters.setTarget(hostName, port, sshKeyInfos, userName);
        parameters.setProxy(proxyInfo);
        parameters.setEnableX11Forward(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_X11_FORWARD, true));
        parameters.setEnableAgentForward(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_AGENT_FORWARD, true));
        this.puttyHelper.runPutty(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void launchUnixOrMacTerminal(boolean isMac, SshCommandBuilder sshCommandBuilder) {
        if (isMac && this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_UNIX_TERMINAL) == null) {
            String com = "tell application \"Terminal\" to do script \"%\"";
            LOG.info("Falling back to auto-detected terminal command: " + com);
            this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_UNIX_TERMINAL, com);
        }
        ArrayList<TmpContentFile> tmpFiles = new ArrayList<TmpContentFile>();
        String hostName = sshCommandBuilder.getHostName();
        Pair sshComPair = sshCommandBuilder.build(false);
        String innerSshCommand = (String)sshComPair.getKey();
        tmpFiles.addAll((Collection)sshComPair.getValue());
        TmpContentFile tmpCommandFile = null;
        if (sshCommandBuilder.isUseSshAgent()) {
            try {
                tmpCommandFile = new TmpContentFile("openSsh", "sh", "#!/bin/bash \n\nset -v\n" + SshAgentHelper.getSshAgentEnvironment() + "\n" + innerSshCommand + "\n/bin/bash");
            }
            catch (SshAgentHelper.SshAgentHelperException e) {
                LOG.error("Problem launching SSH terminal: Failed to add SSH agent info to tmpCommandFile. Will skip using SSH agent! (this goes against user preference!)", (Throwable)e);
            }
        }
        if (tmpCommandFile == null) {
            tmpCommandFile = new TmpContentFile("openSsh", "sh", "#!/bin/bash \n\nset -v\n" + innerSshCommand + "\n/bin/bash");
        }
        tmpFiles.add(tmpCommandFile);
        String tmpCommandFilename = tmpCommandFile.getFilename();
        String callScriptCommand = "bash " + tmpCommandFilename;
        Object terminalCommand = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_COMMAND_UNIX_TERMINAL);
        if (terminalCommand == null) {
            throw new RuntimeException("No termincal command specified in jFed config. Cannot launch terminal.");
        }
        ArrayList<Object> launchTerminalCommandList = new ArrayList<Object>();
        if (isMac) {
            if (((String)terminalCommand).contains("%")) {
                terminalCommand = ((String)terminalCommand).replaceFirst("%", callScriptCommand);
            } else {
                LOG.error("command does not contain required % \"" + (String)terminalCommand + "\"");
            }
        } else {
            if (!((String)terminalCommand).contains("%")) {
                boolean mustQuote = false;
                if (innerSshCommand.contains("gnome-terminal")) {
                    mustQuote = true;
                }
                terminalCommand = mustQuote ? (String)terminalCommand + " -e '%'" : (String)terminalCommand + " -e %";
            }
            if (((String)terminalCommand).contains("'%'") || ((String)terminalCommand).contains("\"%\"")) {
                void var15_24;
                terminalCommand = ((String)terminalCommand).replaceFirst(Pattern.quote("'%'"), "%").replaceFirst(Pattern.quote("\"%\""), "%");
                String[] stringArray = finalCommandSplit = ((String)terminalCommand).split(" ");
                int n = stringArray.length;
                boolean bl = false;
                while (var15_24 < n) {
                    String string = stringArray[var15_24];
                    if (Objects.equals(string, "%")) {
                        launchTerminalCommandList.add(callScriptCommand);
                    } else {
                        launchTerminalCommandList.add(string);
                    }
                    ++var15_24;
                }
            } else {
                terminalCommand = ((String)terminalCommand).replaceFirst(Pattern.quote("%"), callScriptCommand);
                finalCommandSplit = ((String)terminalCommand).split(" ");
                Collections.addAll(launchTerminalCommandList, finalCommandSplit);
            }
        }
        String finalCommand = terminalCommand;
        LOG.debug("launchTerminal: useSshAgent=" + sshCommandBuilder.isUseSshAgent() + " proxyInfo=" + String.valueOf(sshCommandBuilder.getProxyInfo()));
        LOG.info("launchTerminal: commands={}", (Object)tmpCommandFile.getContent());
        if (isMac) {
            LOG.debug("launchTerminal: callScriptCommand: " + callScriptCommand);
        } else {
            LOG.debug("Executing command to launch terminal: {}", terminalCommand);
            LOG.debug("   internalCommand: {}", (Object)innerSshCommand);
            LOG.info("launchTerminal: commandList={}", launchTerminalCommandList);
        }
        Runnable processOutputMonitor = () -> {
            block21: {
                block20: {
                    try {
                        String line;
                        if (isMac) {
                            LOG.info("ExternalTerminal Thread: Running external terminal with command: " + finalCommand);
                            ScriptEngineManager mgr = new ScriptEngineManager();
                            ScriptEngine engine = mgr.getEngineByName("AppleScript");
                            if (engine != null) {
                                try {
                                    Object result = engine.eval(finalCommand);
                                    LOG.trace("ExternalTerminal Thread: Got output: " + String.valueOf(result));
                                    break block20;
                                }
                                catch (ScriptException e) {
                                    LOG.error("ExternalTerminal Thread: Executing external ssh-terminal failed.", (Throwable)e);
                                    throw new RuntimeException(e);
                                }
                            }
                            LOG.info("ExternalTerminal Thread: Got null when requesting AppleScript-engine, trying fallback to osascript");
                            ProcessBuilder pb = new ProcessBuilder("osascript", "-e", finalCommand);
                            try {
                                String line2;
                                Process p = pb.start();
                                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                                BufferedReader input2 = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                                while ((line2 = input.readLine()) != null) {
                                    LOG.trace("ExternalTerminal Thread: External Terminal stdout: " + line2);
                                }
                                while ((line2 = input2.readLine()) != null) {
                                    LOG.trace("ExternalTerminal Thread: External Terminal stderr: " + line2);
                                }
                                input.close();
                                input2.close();
                                break block20;
                            }
                            catch (IOException ex) {
                                LOG.error("ExternalTerminal Thread: Got exception while running ExternalTerminal-app", (Throwable)ex);
                                throw new RuntimeException(ex);
                            }
                        }
                        LOG.debug("ExternalTerminal Thread: Starting terminal using command (list): " + String.valueOf(launchTerminalCommandList));
                        ProcessBuilder pb = new ProcessBuilder(launchTerminalCommandList);
                        pb = pb.redirectErrorStream(true);
                        Process p = pb.start();
                        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        while ((line = input.readLine()) != null) {
                            LOG.debug("ExternalTerminal Thread: External Terminal stdout+stderr: " + line);
                        }
                        input.close();
                        try {
                            p.waitFor();
                        }
                        catch (InterruptedException e) {
                            LOG.warn("ExternalTerminal Thread: processOutputMonitor thread interrupted while waiting for terminal to stop", (Throwable)e);
                        }
                        LOG.info("ExternalTerminal Thread: Terminal command exited with exit value: " + p.exitValue());
                    }
                    catch (Exception e) {
                        LOG.error("Unhandled Exception in ExternalTerminal Thread.", (Throwable)e);
                    }
                    catch (AssertionError e) {
                        LOG.error("Unhandled AssertionError in ExternalTerminal Thread.", (Throwable)((Object)e));
                    }
                }
                try {
                    if (this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_TERMINAL_KEEP_TMP_FILES, true)) break block21;
                    LOG.debug("ExternalTerminal Thread: Terminal has been shown. Will now wait 30s. (and then delete temp files)");
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    LOG.info("ExternalTerminal Thread: Terminal has been shown and waited 30s and will now delete temp files");
                    for (TmpFile tmpFile : tmpFiles) {
                        tmpFile.delete();
                    }
                }
                catch (AssertionError e) {
                    LOG.error("Unhandled AssertionError in ExternalTerminal Thread.", (Throwable)((Object)e));
                }
                catch (Exception e) {
                    LOG.error("Unhandled Exception in ExternalTerminal Thread.", (Throwable)e);
                }
            }
        };
        try {
            for (TmpFile tmpFile : tmpFiles) {
                tmpFile.store();
            }
            Thread t = new Thread(processOutputMonitor);
            t.setName("ExternalTerminal");
            t.setDaemon(true);
            t.start();
        }
        catch (AssertionError e) {
            LOG.error("AssertionError starting ExternalTerminal Thread", (Throwable)((Object)e));
            if (!this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_TERMINAL_KEEP_TMP_FILES, true)) {
                LOG.warn("  because of exception starting ExternalTerminal Thread -> will delete temp files");
                for (TmpFile tmpFile : tmpFiles) {
                    tmpFile.delete();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception starting ExternalTerminal Thread", (Throwable)e);
            if (!this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_TERMINAL_KEEP_TMP_FILES, true)) {
                LOG.warn("  because of exception starting ExternalTerminal Thread -> will delete temp files");
                for (TmpFile tmpFile : tmpFiles) {
                    tmpFile.delete();
                }
            }
        }
        catch (Error e) {
            try {
                LOG.error("Error starting ExternalTerminal Thread", (Throwable)e);
                if (!this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_TERMINAL_KEEP_TMP_FILES, true)) {
                    LOG.warn("  because of exception starting ExternalTerminal Thread -> will delete temp files");
                    for (TmpFile tmpFile : tmpFiles) {
                        tmpFile.delete();
                    }
                }
            }
            finally {
                throw e;
            }
        }
        if (isMac) {
            try {
                if (this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_MAC_TERMINAL_WARNING, true)) {
                    VBox pane = new VBox();
                    pane.setPrefWidth(750.0);
                    pane.setSpacing(5.0);
                    Label label = new Label(String.format("An SSH-terminal to %s@%s:%d was launched.\nIt may however be on the background. Please switch applications to access your terminal.", sshCommandBuilder.getTargetServerUserName(), hostName, sshCommandBuilder.getPort()));
                    label.setPrefHeight(75.0);
                    label.setWrapText(true);
                    pane.getChildren().add((Object)label);
                    CheckBox checkBox = new CheckBox("Do not show this warning again");
                    pane.getChildren().add((Object)checkBox);
                    DialogPane dialogPane = new DialogPane();
                    dialogPane.setContent((Node)pane);
                    dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
                    Dialog dialog = new Dialog();
                    dialog.setTitle("Terminal was launched");
                    dialog.setDialogPane(dialogPane);
                    dialog.showAndWait();
                    this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_MAC_TERMINAL_WARNING, !checkBox.isSelected());
                }
            }
            catch (Exception e) {
                LOG.error("Exception while showing MAC terminal dialog. (will be ignored)", (Throwable)e);
            }
            catch (AssertionError e) {
                LOG.error("AssertionError while showing MAC terminal dialog. (will be ignored)", (Throwable)((Object)e));
            }
        }
    }

    @Nonnull
    private SshCommandBuilder prepareSshCommand(@Nonnull String targetServerUserName, @Nonnull String hostName, int port, @Nullable JFedConnection.ProxyInfo testbedProxyInfo) {
        SshCommandBuilder res = this.sshCommandBuilderFactory.create(this.keyPasswordRequester);
        res.setTargetServerUserName(targetServerUserName);
        res.setHostName(hostName);
        res.setPort(port);
        assert (this.geniUserProvider.isUserLoggedIn());
        GeniUser geniUser = this.geniUserProvider.getLoggedInGeniUser();
        JFedConnection.SshProxyInfo jFedProxyInfo = geniUser.getUserAuthorityServer() == null ? null : this.proxyPreferencesManager.getSshProxySettings(geniUser.getUserAuthorityServer().getTestbed().getProxies(), geniUser);
        DoubleProxyHandling doubleProxyHandling = DoubleProxyHandling.fromConfigValue((String)this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_DOUBLE_PROXY_SOLUTION, "dialog"));
        if (testbedProxyInfo != null && jFedProxyInfo != null) {
            switch (doubleProxyHandling) {
                case IGNORE_AND_USE_JFED_PROXY: {
                    LOG.warn("testbed proxy is specified '{}', however, it will be overridden by the jFed proxy", (Object)testbedProxyInfo);
                    res.setProxyInfo((JFedConnection.ProxyInfo)jFedProxyInfo);
                    break;
                }
                case IGNORE_AND_USE_TESTBED_PROXY: {
                    LOG.warn("jFed Proxy is active, however, it will be overridden by a custom testbed proxy '{}'", (Object)testbedProxyInfo);
                    res.setProxyInfo(testbedProxyInfo);
                    break;
                }
                default: {
                    LOG.warn("Proxy is active, however, so is the custom testbed proxy '{}'. Will inform user that only testbed proxy will be used.", (Object)testbedProxyInfo);
                    LOG.debug("Showing prepareSshCommand double proxy warning dialog");
                    VBox pane = new VBox();
                    pane.setPrefWidth(360.0);
                    pane.setSpacing(5.0);
                    Label textLabel = new Label("The testbed defined a proxy that has to be used to connect to the node. You also have the jFed-proxy enabled for SSH-connections.\n\nYour SSH-terminal-application only supports one proxy at a time. We will therefore try to connect by only using the proxy defined by the testbed.\n\nIf you are experiencing connectivity problems because of this, please contact support.");
                    textLabel.setWrapText(true);
                    pane.getChildren().add((Object)textLabel);
                    CheckBox checkBox = new CheckBox("Do not show this dialog again");
                    pane.getChildren().add((Object)checkBox);
                    DialogPane dialogPane = new DialogPane();
                    dialogPane.setHeaderText("2 Proxies detected");
                    dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph(FontAwesome.Glyph.TERMINAL, Color.BLACK));
                    dialogPane.setContent((Node)pane);
                    dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
                    Dialog dialog = new Dialog();
                    dialog.setTitle("Warning: 2 Proxies detected");
                    dialog.setDialogPane(dialogPane);
                    dialog.showAndWait();
                    res.setProxyInfo(testbedProxyInfo);
                    if (checkBox.isSelected()) {
                        this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_DOUBLE_PROXY_SOLUTION, DoubleProxyHandling.IGNORE_AND_USE_TESTBED_PROXY.getConfigValue());
                    } else {
                        this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_DOUBLE_PROXY_SOLUTION, DoubleProxyHandling.ASK.getConfigValue());
                    }
                    LOG.warn("jFed Proxy is active, however, it will be overridden by a custom testbed proxy '{}' after showing dialog", (Object)testbedProxyInfo);
                    res.setProxyInfo(testbedProxyInfo);
                    break;
                }
            }
        } else {
            if (testbedProxyInfo != null) {
                res.setProxyInfo(testbedProxyInfo);
            }
            if (jFedProxyInfo != null) {
                res.setProxyInfo((JFedConnection.ProxyInfo)jFedProxyInfo);
            }
        }
        res.setUseSshAgent(this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SSHAGENT_USE, true));
        return res;
    }
}

