/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ssh_terminal_tool.putty;

import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ssh_terminal_tool.putty.SshKeyInfoUnlocker;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.Identity;
import java.io.File;
import java.io.IOException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PageantHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PageantHelper.class);
    private final JFedPreferences jFedPreferences;

    @Inject
    public PageantHelper(JFedPreferences jFedPreferences) {
        this.jFedPreferences = jFedPreferences;
    }

    @Nullable
    private static AgentProxy getAgentProxy() {
        try {
            Connector agentConnector = ConnectorFactory.getDefault().createConnector();
            return new AgentProxy(agentConnector);
        }
        catch (AgentProxyException e) {
            LOG.error("Could not initialize agent connector");
            return null;
        }
    }

    public synchronized void registerKeys(Collection<? extends PuTTYFilesKeyInfo> sshKeyInfos, SshKeyInfoUnlocker unlocker) {
        if (sshKeyInfos == null || sshKeyInfos.isEmpty()) {
            return;
        }
        AgentProxy agentProxy = PageantHelper.getAgentProxy();
        if (agentProxy == null || !agentProxy.isRunning()) {
            String pageantLocation = this.jFedPreferences.getFile((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_DIRECTORY).getPath() + File.separator + "pageant.exe";
            try {
                PageantHelper.executeCommand(Collections.singletonList(pageantLocation));
            }
            catch (IOException e) {
                LOG.error("Error while executing pageant");
            }
            try {
                Thread.sleep(750L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            agentProxy = PageantHelper.getAgentProxy();
        }
        if (agentProxy != null) {
            AgentProxy finalAgentProxy = agentProxy;
            List existingPubkeys = Arrays.stream(finalAgentProxy.getIdentities()).map(Identity::getBlob).map(KeyUtil::blobToPublicKey).collect(Collectors.toList());
            sshKeyInfos.forEach(keyInfo -> {
                boolean success;
                if (keyInfo == null) {
                    LOG.warn("Skipping a null keyInfo");
                    return;
                }
                boolean alreadyLoaded = existingPubkeys.stream().anyMatch(existingKey -> Objects.equals(keyInfo.getPublicKey(), existingKey));
                if (alreadyLoaded) {
                    LOG.debug("Skipping already loaded key {}", (Object)keyInfo.getComment());
                    return;
                }
                if (keyInfo.isLocked() && !(success = unlocker.unlock((SshKeyInfo)keyInfo))) {
                    return;
                }
                if (!(keyInfo.getPrivateKey() instanceof RSAPrivateCrtKey)) {
                    LOG.warn("Skipping a private key that isn't of type RSAPrivateCrtKey");
                } else {
                    LOG.trace("Registering {} to pageant", (Object)keyInfo.getPublicKey());
                    finalAgentProxy.addIdentity(KeyUtil.keyToSshAgent((RSAPrivateCrtKey)((RSAPrivateCrtKey)keyInfo.getPrivateKey()), (String)(keyInfo.getComment() != null ? keyInfo.getComment() : "")));
                }
            });
        } else {
            LOG.error("Could not create an agent proxy. Is Pageant running?");
        }
    }

    private static void executeCommand(List<String> command) throws IOException {
        Runtime.getRuntime().exec(command.toArray(new String[command.size()]));
    }
}

