/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ssh_terminal_tool.putty;

import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.GeniUserSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty.PuTTYPrivateKeyFile;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ssh_terminal_tool.putty.PageantHelper;
import be.iminds.ilabt.jfed.ssh_terminal_tool.putty.SshKeyInfoUnlocker;
import be.iminds.ilabt.jfed.ssh_terminal_tool.putty.WinRegistry;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.SshProxySocketImplFactory;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpFile;
import com.google.common.net.InetAddresses;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PuttyHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PuttyHelper.class);
    private static final Pattern ipv6pat = Pattern.compile("([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}");
    private final JFedPreferences jFedPreferences;
    private final PageantHelper pageantHelper;
    private final SshKeyInfoUnlocker sshKeyInfoUnlocker;
    private static final Pattern PUTTY_HOSTKEY_PATTERN = Pattern.compile("(.*)@([0-9]*):(.*)");

    @Inject
    public PuttyHelper(JFedPreferences jFedPreferences, PageantHelper pageantHelper, SshKeyInfoUnlocker sshKeyInfoUnlocker) {
        this.jFedPreferences = jFedPreferences;
        this.pageantHelper = pageantHelper;
        this.sshKeyInfoUnlocker = sshKeyInfoUnlocker;
    }

    static String convertSshHostKeyToPuttyFormat(String openSshKnownHost) {
        StringBuilder res = new StringBuilder();
        String[] parts = openSshKnownHost.split(" ");
        if (parts.length < 3) {
            throw new IllegalArgumentException("The provided known host line is not in the correct format: " + openSshKnownHost);
        }
        String encodedKey = parts[2];
        byte[] all_restored = Base64.decodeBase64((String)encodedKey);
        ByteBuffer bb = ByteBuffer.wrap(all_restored).order(ByteOrder.BIG_ENDIAN);
        ArrayList<String> fields = new ArrayList<String>();
        while (bb.remaining() > 0) {
            int len = bb.getInt();
            if (len > bb.remaining()) {
                throw new IllegalArgumentException("The provided known host line is not in the correct format. field " + fields.size() + " has len=" + len + " but only " + bb.remaining() + " bytes remain. key=" + encodedKey);
            }
            StringBuilder field = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                byte b = bb.get();
                String hex = String.format("%02x", b);
                if (field.length() == 0) {
                    if (b == 0) continue;
                    if (hex.startsWith("0")) {
                        hex = hex.substring(1);
                        field.append(hex);
                        continue;
                    }
                    field.append(hex);
                    continue;
                }
                field.append(hex);
            }
            fields.add(field.toString());
        }
        if (fields.size() < 2) {
            throw new IllegalArgumentException("The provided known host line is not in the correct format. field count: " + fields.size());
        }
        for (int i = 1; i < fields.size(); ++i) {
            if (i > 1) {
                res.append(",");
            }
            res.append("0x").append((String)fields.get(i));
        }
        return res.toString();
    }

    @Nonnull
    public static String sshHostKeyToRegistryKey(@Nonnull String openSshKnownHost, int port) {
        String puttySshKeyType;
        String[] parts = openSshKnownHost.split(" ");
        if (parts.length < 3) {
            throw new IllegalArgumentException("The provided known host line is not in the correct format: " + openSshKnownHost);
        }
        String hostname = parts[0];
        String sshkeytype = parts[1];
        if (Objects.equals(sshkeytype, "ssh-rsa")) {
            puttySshKeyType = "rsa2";
        } else if (Objects.equals(sshkeytype, "dss-rsa")) {
            puttySshKeyType = "dss";
        } else {
            throw new IllegalArgumentException("The provided known host line has an unknown key type: " + sshkeytype);
        }
        return puttySshKeyType + "@" + port + ":" + hostname;
    }

    private static void storeOpenSshHostKeyToPuttyRegistry(@Nonnull String openSshKnownHost, int port) throws IOException {
        WinRegistry.setValue("HKCU\\Software\\SimonTatham\\PuTTY\\SshHostKeys", PuttyHelper.sshHostKeyToRegistryKey(openSshKnownHost, port), PuttyHelper.convertSshHostKeyToPuttyFormat(openSshKnownHost));
    }

    private static boolean hasSshHostKey(String hostname, int port) throws IOException {
        Map<String, Object> hostkeys = WinRegistry.getValues("HKCU\\Software\\SimonTatham\\PuTTY\\SshHostKeys");
        return hostkeys.keySet().stream().anyMatch(key -> {
            Matcher matcher = PUTTY_HOSTKEY_PATTERN.matcher((CharSequence)key);
            return matcher.matches() && matcher.group(2).equalsIgnoreCase((String)key);
        });
    }

    public static void createPuttySession(String sessionName, String hostname, int port, File puttyPrivateKeyFile, String username, String proxyHostname, int proxyPort, File proxyPuttyPrivateKeyFile, String proxyUsername, boolean enableX11Forward, boolean enableAgentForward) throws IOException {
        StringBuilder regContent = new StringBuilder();
        regContent.append("Windows Registry Editor Version 5.00\n").append("\n").append("[HKEY_CURRENT_USER\\Software\\SimonTatham\\PuTTY\\Sessions]\n").append("\n").append("[HKEY_CURRENT_USER\\Software\\SimonTatham\\PuTTY\\Sessions\\").append(sessionName).append("]\n");
        URL sessionTemplateUrl = PuttyHelper.class.getResource("PuttySessionRegistryTemplate");
        String sessionTemplate = IOUtils.streamToString((InputStream)sessionTemplateUrl.openStream(), (String)"UTF-8");
        regContent.append(sessionTemplate);
        if (!sessionTemplate.endsWith("\n")) {
            regContent.append("\n");
        }
        regContent.append("\"X11Forward\"=dword:0000000").append(enableX11Forward ? "1" : "0").append("\n");
        regContent.append("\"PingIntervalSecs\"=dword:").append(Integer.toHexString(120)).append("\n");
        if (hostname != null) {
            regContent.append("\"HostName\"=\"").append(hostname).append("\"").append("\n");
        } else {
            regContent.append("\"HostName\"=\"\"\n");
        }
        if (port >= 0) {
            regContent.append("\"PortNumber\"=dword:").append(Integer.toHexString(port)).append("\n");
        }
        if (puttyPrivateKeyFile != null) {
            regContent.append("\"PublicKeyFile\"=\"").append(puttyPrivateKeyFile.getPath().replace("\\", "\\\\")).append("\"\n");
        } else {
            regContent.append("\"PublicKeyFile\"=\"\"\n");
        }
        if (proxyHostname != null) {
            regContent.append("\"ProxyMethod\"=dword:00000005\n");
            regContent.append("\"ProxyHost\"=\"").append(proxyHostname).append("\"\n");
            regContent.append("\"ProxyPort\"=dword:").append(Integer.toHexString(proxyPort)).append("\n");
            if (proxyPuttyPrivateKeyFile != null) {
                regContent.append("\"ProxyTelnetCommand\"=\"plink -ssh -i \\\"").append(proxyPuttyPrivateKeyFile.getPath().replace("\\", "\\\\\\\\")).append("\\\" ").append("-l ").append(proxyUsername).append(" -P %proxyport %proxyhost -nc %host:%port\"\n");
            } else {
                regContent.append("\"ProxyTelnetCommand\"=\"plink -ssh -l ").append(proxyUsername).append(" -P %proxyport %proxyhost -nc %host:%port\"\n");
            }
        } else {
            regContent.append("\"ProxyMethod\"=dword:00000000\n");
            regContent.append("\"ProxyHost\"=\"\"\n");
            regContent.append("\"ProxyPort\"=dword:00000000\n");
            regContent.append("\"ProxyTelnetCommand\"=\"\"\n");
        }
        if (username != null) {
            regContent.append("\"UserName\"=\"").append(username).append("\"\n");
        } else {
            regContent.append("\"UserName\"=\"\"\n");
        }
        if (enableAgentForward) {
            regContent.append("\"AgentFwd\"=dword:00000001\n");
        }
        WinRegistry.importInRegistry(regContent.toString());
    }

    public void runPutty(PuttyRunParameters parameters) {
        if (parameters.hasProxy() || this.defaultSessionHasPrivateKeySet()) {
            this.runPuttyWithPartialSession(parameters);
        } else {
            this.runPuttyWithoutSession(parameters);
        }
    }

    private boolean defaultSessionHasPrivateKeySet() {
        try {
            String value = WinRegistry.getValue("HKCU\\Software\\SimonTatham\\PuTTY\\Sessions\\Default%20Settings", "PublicKeyFile");
            return value != null && !value.isEmpty();
        }
        catch (WinRegistry.RegistryException | IOException ignored) {
            return true;
        }
    }

    public void runPuttyWithFullSession(PuttyRunParameters parameters) {
        block16: {
            LOG.debug("Creating PuTTY session and starting PuTTY with it.");
            boolean usePageant = this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SSHAGENT_USE, true);
            boolean hasEncryptedPuttyPrivateKeyFile = false;
            ArrayList<TmpFile> puttyPrivateKeyFiles = new ArrayList<TmpFile>();
            if (usePageant) {
                this.pageantHelper.registerKeys(parameters.getSshKeyInfos(), this.sshKeyInfoUnlocker);
            } else {
                for (PuTTYFilesKeyInfo puTTYFilesKeyInfo : parameters.getSshKeyInfos()) {
                    if (!this.unlockIfNeeded(puTTYFilesKeyInfo)) continue;
                    TmpFile puttyPrivateKeyFile = puTTYFilesKeyInfo.getPuttyKeyFile();
                    puttyPrivateKeyFiles.add(puttyPrivateKeyFile);
                    puttyPrivateKeyFile.store();
                    try {
                        if (!PuTTYPrivateKeyFile.read((File)puttyPrivateKeyFile.getFile()).isEncrypted()) continue;
                        hasEncryptedPuttyPrivateKeyFile = true;
                    }
                    catch (IOException e) {
                        LOG.error("Error reading puttyPrivateKeyFile. Will ignore for now and assume it is an encrypted file. But this will probably case a failure later.");
                        hasEncryptedPuttyPrivateKeyFile = true;
                    }
                }
            }
            TmpFile proxyPuttyPrivateKeyFile = null;
            try {
                TmpFile puttyPrivateKeyFile;
                if (parameters.hasProxy() && (puttyPrivateKeyFiles.isEmpty() || !parameters.samePrivateKeyForProxy() || hasEncryptedPuttyPrivateKeyFile)) {
                    if (usePageant) {
                        this.pageantHelper.registerKeys(parameters.getSshKeyInfos(), this.sshKeyInfoUnlocker);
                        proxyPuttyPrivateKeyFile = null;
                    } else {
                        proxyPuttyPrivateKeyFile = parameters.getProxySshKeyInfo().getUnlockedPuttyKeyFile();
                    }
                } else {
                    proxyPuttyPrivateKeyFile = null;
                }
                TmpFile tmpFile = proxyPuttyPrivateKeyFile;
                if (tmpFile != null) {
                    tmpFile.store();
                }
                if (parameters.hasProxy()) {
                    if (parameters.getProxyOpenSshKeyHostKey() != null) {
                        PuttyHelper.storeOpenSshHostKeyToPuttyRegistry(parameters.getProxyOpenSshKeyHostKey(), parameters.getProxyPort());
                    } else {
                        this.fetchAndStoreOpenSshKeyToPuttyRegistry(parameters);
                    }
                }
                String sessionName = "jFed" + new Date().getTime();
                TmpFile tmpFile2 = puttyPrivateKeyFile = puttyPrivateKeyFiles.isEmpty() ? null : (TmpFile)puttyPrivateKeyFiles.get(0);
                if (puttyPrivateKeyFiles.size() > 1) {
                    LOG.warn("Using PuTTY with multiple keys but without pageant is not possible. Will use first key only!");
                }
                PuttyHelper.createPuttySession(sessionName, parameters.getHostname(), parameters.getPort(), puttyPrivateKeyFile == null ? null : puttyPrivateKeyFile.getFile(), parameters.getUsername(), parameters.getProxyHostname(), parameters.getProxyPort(), (File)(tmpFile == null ? (puttyPrivateKeyFile == null ? null : puttyPrivateKeyFile.getFile()) : tmpFile.getFile()), parameters.getProxyUsername(), parameters.isEnableX11Forward(), parameters.isEnableAgentForward());
                Runnable processOutputMonitor = () -> {
                    Process p = null;
                    try {
                        ArrayList<Object> command = new ArrayList<Object>();
                        command.add(this.jFedPreferences.getFile((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_DIRECTORY).getPath() + File.separator + "putty.exe");
                        command.add("-load");
                        command.add(sessionName);
                        LOG.debug("Starting PuTTY and waiting for it to stop");
                        LOG.info("PuTTY command: " + String.valueOf(command));
                        p = Runtime.getRuntime().exec(command.toArray(new String[command.size()]));
                        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String line = null;
                        while ((line = input.readLine()) != null) {
                            LOG.debug("putty.exe output: " + line);
                        }
                        input.close();
                        try {
                            p.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        LOG.debug("PuTTY stopped");
                    }
                    catch (IOException e) {
                        LOG.error("IOException while trying to launch external terminal: " + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        LOG.debug("removing unencrypted putty key files");
                        puttyPrivateKeyFiles.stream().filter(Objects::nonNull).forEach(TmpFile::delete);
                        if (finalProxyPuttyPrivateKeyFile != null) {
                            finalProxyPuttyPrivateKeyFile.delete();
                        }
                    }
                };
                Thread t = new Thread(processOutputMonitor);
                t.setName("PuTTY-Thread");
                t.setDaemon(true);
                t.start();
                LOG.debug("Started PuTTY thread.");
            }
            catch (IOException iOException) {
                puttyPrivateKeyFiles.stream().filter(Objects::nonNull).forEach(TmpFile::delete);
                if (proxyPuttyPrivateKeyFile == null) break block16;
                proxyPuttyPrivateKeyFile.delete();
            }
        }
    }

    private boolean unlockIfNeeded(PuTTYFilesKeyInfo keyInfo) {
        if (keyInfo.isLocked() && !keyInfo.canReturnLockedPuttyKeyFile()) {
            Optional<String> pass = JFDialogs.create().message("PuTTY Key requires a password to unlock (key will be ignored if no password given)").masthead("Password required").showPasswordInput();
            if (pass.isPresent()) {
                keyInfo.unlock(pass.get().toCharArray());
                return true;
            }
            return false;
        }
        return true;
    }

    private void fetchAndStoreOpenSshKeyToPuttyRegistry(PuttyRunParameters parameters) {
        try {
            if (!PuttyHelper.hasSshHostKey(parameters.getProxyHostname(), parameters.getProxyPort())) {
                LOG.debug("PuTTY already has a hostkey for {}. Skipping manual fetch", (Object)parameters.getProxyHostname());
            }
            FutureTask<PublicKey> fetchHostKeyTask = new FutureTask<PublicKey>(new HostkeyFetcher(parameters));
            new Thread(fetchHostKeyTask).start();
            PublicKey publicHostKey = fetchHostKeyTask.get(10L, TimeUnit.SECONDS);
            if (publicHostKey == null) {
                throw new IllegalStateException("Fetching ssh hostkey failed: publicHostKey=null. ");
            }
            String openSshAuthorizedKeysString = KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)publicHostKey);
            assert (openSshAuthorizedKeysString != null);
            String openSshPublicHostKey = parameters.getProxyHostname() + " " + openSshAuthorizedKeysString;
            LOG.debug("Found ssh hostkey for host {}: {}", (Object)parameters.getProxyHostname(), (Object)openSshPublicHostKey);
            PuttyHelper.storeOpenSshHostKeyToPuttyRegistry(openSshPublicHostKey, 22);
        }
        catch (IOException | InterruptedException | UnsupportedOperationException | ExecutionException | TimeoutException e) {
            LOG.debug("Exception while fetching ssh hostkey", (Throwable)e);
        }
    }

    public void runPuttyWithPartialSession(PuttyRunParameters parameters) {
        block12: {
            LOG.debug("Creating PuTTY session and starting PuTTY with it.");
            boolean usePageant = this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SSHAGENT_USE, true);
            boolean hasEncryptedPuttyPrivateKeyFile = false;
            ArrayList<TmpFile> puttyPrivateKeyFiles = new ArrayList<TmpFile>();
            if (usePageant) {
                this.pageantHelper.registerKeys(parameters.getSshKeyInfos(), this.sshKeyInfoUnlocker);
            } else {
                for (PuTTYFilesKeyInfo puTTYFilesKeyInfo : parameters.getSshKeyInfos()) {
                    if (!this.unlockIfNeeded(puTTYFilesKeyInfo)) continue;
                    TmpFile puttyPrivateKeyFile = puTTYFilesKeyInfo.getPuttyKeyFile();
                    puttyPrivateKeyFiles.add(puttyPrivateKeyFile);
                    puttyPrivateKeyFile.store();
                    try {
                        if (!PuTTYPrivateKeyFile.read((File)puttyPrivateKeyFile.getFile()).isEncrypted()) continue;
                        hasEncryptedPuttyPrivateKeyFile = true;
                    }
                    catch (IOException e) {
                        LOG.error("Error reading puttyPrivateKeyFile. Will ignore for now and assume it is an encrypted file. But this will probably case a failure later.");
                        hasEncryptedPuttyPrivateKeyFile = true;
                    }
                }
            }
            TmpFile proxyPuttyPrivateKeyFile = null;
            try {
                TmpFile puttyPrivateKeyFileForSession;
                proxyPuttyPrivateKeyFile = parameters.hasProxy() && (puttyPrivateKeyFiles.isEmpty() || !parameters.samePrivateKeyForProxy() || hasEncryptedPuttyPrivateKeyFile) ? (usePageant ? null : parameters.getProxySshKeyInfo().getUnlockedPuttyKeyFile()) : null;
                TmpFile tmpFile = proxyPuttyPrivateKeyFile;
                if (tmpFile != null) {
                    tmpFile.store();
                }
                if (parameters.hasProxy()) {
                    if (parameters.getProxyOpenSshKeyHostKey() != null) {
                        PuttyHelper.storeOpenSshHostKeyToPuttyRegistry(parameters.getProxyOpenSshKeyHostKey(), parameters.getProxyPort());
                    } else {
                        this.fetchAndStoreOpenSshKeyToPuttyRegistry(parameters);
                    }
                }
                Object sessionNameHelper = parameters.hasProxy() ? "jFed-proxy-" + parameters.getProxyHostname().replace(".", "_") : "jFed-no-proxy";
                String sessionName = sessionNameHelper;
                TmpFile tmpFile2 = puttyPrivateKeyFileForSession = puttyPrivateKeyFiles.isEmpty() ? null : (TmpFile)puttyPrivateKeyFiles.get(0);
                if (puttyPrivateKeyFiles.size() > 1) {
                    LOG.warn("Using PuTTY with multiple keys but without pageant is not possible. Will use first key only!");
                }
                PuttyHelper.createPuttySession(sessionName, null, -1, null, null, parameters.getProxyHostname(), parameters.getProxyPort(), (File)(tmpFile == null ? (puttyPrivateKeyFileForSession == null ? null : puttyPrivateKeyFileForSession.getFile()) : tmpFile.getFile()), parameters.getProxyUsername(), parameters.isEnableX11Forward(), parameters.isEnableAgentForward());
                Runnable processOutputMonitor = () -> {
                    Process p = null;
                    try {
                        String string;
                        boolean isIpv6hostName;
                        ArrayList<Object> command = new ArrayList<Object>();
                        command.add(this.jFedPreferences.getFile((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_DIRECTORY).getPath() + File.separator + "putty.exe");
                        command.add("-load");
                        command.add(sessionName);
                        boolean bl = isIpv6hostName = parameters.getHostname().contains(":") && InetAddresses.isInetAddress((String)parameters.getHostname());
                        if (isIpv6hostName) {
                            command.add(parameters.getUsername() + "@[" + parameters.getHostname() + "]");
                        } else {
                            command.add(parameters.getUsername() + "@" + parameters.getHostname());
                        }
                        command.add("-P");
                        command.add(Integer.toString(parameters.getPort()));
                        if (parameters.getSshKeyInfos().size() > 1) {
                            LOG.warn("Will add multiple -i options to PuTTY. PuTTY will probably not support this!");
                        }
                        for (PuTTYFilesKeyInfo puTTYFilesKeyInfo : parameters.getSshKeyInfos()) {
                            TmpFile puttyPrivateKeyFile;
                            if (puTTYFilesKeyInfo == null || !this.unlockIfNeeded(puTTYFilesKeyInfo) || (puttyPrivateKeyFile = puTTYFilesKeyInfo.getPuttyKeyFile()) == null) continue;
                            puttyPrivateKeyFile.store();
                            puttyPrivateKeyFiles.add(puttyPrivateKeyFile);
                            command.add("-i");
                            command.add(puttyPrivateKeyFile.getFilename());
                        }
                        LOG.debug("Starting PuTTY and waiting for it to stop");
                        LOG.info("PuTTY command: " + String.valueOf(command));
                        p = Runtime.getRuntime().exec(command.toArray(new String[command.size()]));
                        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        Object var9_11 = null;
                        while ((string = input.readLine()) != null) {
                            LOG.debug("putty.exe output: " + string);
                        }
                        input.close();
                        try {
                            p.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        LOG.debug("PuTTY stopped");
                    }
                    catch (IOException e) {
                        LOG.error("IOException while trying to launch external terminal: " + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        LOG.debug("removing unencrypted putty key files");
                        puttyPrivateKeyFiles.stream().filter(Objects::nonNull).forEach(TmpFile::delete);
                        if (finalProxyPuttyPrivateKeyFile != null) {
                            finalProxyPuttyPrivateKeyFile.delete();
                        }
                    }
                };
                Thread t = new Thread(processOutputMonitor);
                t.setName("PuTTY-Thread");
                t.setDaemon(true);
                t.start();
                LOG.debug("Started PuTTY thread.");
            }
            catch (IOException iOException) {
                puttyPrivateKeyFiles.stream().filter(Objects::nonNull).forEach(TmpFile::delete);
                if (proxyPuttyPrivateKeyFile == null) break block12;
                proxyPuttyPrivateKeyFile.delete();
            }
        }
    }

    public void runPuttyWithoutSession(PuttyRunParameters parameters) {
        LOG.debug("Starting PuTTY without session.");
        boolean usePageant = this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SSHAGENT_USE, true);
        assert (!parameters.hasProxy());
        if (usePageant) {
            this.pageantHelper.registerKeys(parameters.getSshKeyInfos(), this.sshKeyInfoUnlocker);
        }
        Runnable processOutputMonitor = () -> {
            Process p = null;
            ArrayList<TmpFile> puttyPrivateKeyFiles = new ArrayList<TmpFile>();
            try {
                String string;
                boolean isIpv6hostName;
                ArrayList<Object> command = new ArrayList<Object>();
                command.add(this.jFedPreferences.getFile((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_PUTTY_DIRECTORY).getPath() + File.separator + "putty.exe");
                command.add("-ssh");
                boolean bl = isIpv6hostName = parameters.getHostname().contains(":") && InetAddresses.isInetAddress((String)parameters.getHostname());
                if (isIpv6hostName) {
                    command.add(parameters.getUsername() + "@[" + parameters.getHostname() + "]");
                } else {
                    command.add(parameters.getUsername() + "@" + parameters.getHostname());
                }
                command.add("-P");
                command.add(Integer.toString(parameters.getPort()));
                if (parameters.isEnableX11Forward()) {
                    command.add("-X");
                }
                if (parameters.isEnableAgentForward()) {
                    command.add("-A");
                }
                if (!usePageant) {
                    if (parameters.getSshKeyInfos().size() > 1) {
                        LOG.warn("Will add multiple -i options to PuTTY. PuTTY will probably not support this!");
                    }
                    for (PuTTYFilesKeyInfo puTTYFilesKeyInfo : parameters.getSshKeyInfos()) {
                        TmpFile puttyPrivateKeyFile;
                        if (puTTYFilesKeyInfo == null || !this.unlockIfNeeded(puTTYFilesKeyInfo) || (puttyPrivateKeyFile = puTTYFilesKeyInfo.getPuttyKeyFile()) == null) continue;
                        puttyPrivateKeyFile.store();
                        puttyPrivateKeyFiles.add(puttyPrivateKeyFile);
                        command.add("-i");
                        command.add(puttyPrivateKeyFile.getFilename());
                    }
                }
                LOG.debug("Starting PuTTY and waiting for it to stop");
                LOG.info("PuTTY command: " + String.valueOf(command));
                p = Runtime.getRuntime().exec(command.toArray(new String[command.size()]));
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                Object var8_13 = null;
                while ((string = input.readLine()) != null) {
                    LOG.debug("putty.exe output: " + string);
                }
                input.close();
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOG.debug("PuTTY stopped");
            }
            catch (IOException e) {
                LOG.error("IOException while trying to launch external terminal: " + e.getMessage(), (Throwable)e);
            }
            finally {
                LOG.debug("removing unencrypted putty key files");
                for (TmpFile puttyPrivateKeyFile : puttyPrivateKeyFiles) {
                    if (puttyPrivateKeyFile == null) continue;
                    puttyPrivateKeyFile.delete();
                }
            }
        };
        Thread t = new Thread(processOutputMonitor);
        t.setName("PuTTY-Thread");
        t.setDaemon(true);
        t.start();
        LOG.debug("Started PuTTY thread.");
    }

    public static class PuttyRunParameters {
        private String hostname;
        private int port;
        private List<? extends PuTTYFilesKeyInfo> sshKeyInfos;
        private String username;
        private String proxyHostname;
        private int proxyPort;
        private PuTTYFilesKeyInfo proxySshKeyInfo;
        private String proxyUsername;
        private String proxyOpenSshKeyHostKey;
        public boolean enableX11Forward = false;
        public boolean enableAgentForward = true;

        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        public List<? extends PuTTYFilesKeyInfo> getSshKeyInfos() {
            return this.sshKeyInfos;
        }

        public String getUsername() {
            return this.username;
        }

        public String getProxyHostname() {
            return this.proxyHostname;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public PuTTYFilesKeyInfo getProxySshKeyInfo() {
            return this.proxySshKeyInfo;
        }

        public String getProxyUsername() {
            return this.proxyUsername;
        }

        public String getProxyOpenSshKeyHostKey() {
            return this.proxyOpenSshKeyHostKey;
        }

        public boolean hasProxy() {
            return this.proxyHostname != null;
        }

        public boolean samePrivateKeyForProxy() {
            if (this.proxySshKeyInfo == null) {
                return false;
            }
            if (this.sshKeyInfos == null) {
                return false;
            }
            for (PuTTYFilesKeyInfo puTTYFilesKeyInfo : this.sshKeyInfos) {
                if (puTTYFilesKeyInfo == null || puTTYFilesKeyInfo.getPrivateKey() == null || !Objects.equals(puTTYFilesKeyInfo.getPrivateKey(), this.proxySshKeyInfo.getPrivateKey())) continue;
                return true;
            }
            return false;
        }

        public void setTarget(String hostname, int port, List<? extends PuTTYFilesKeyInfo> sshKeyInfos, String username) {
            this.hostname = hostname != null && ipv6pat.matcher(hostname).matches() ? "[" + hostname + "]" : hostname;
            this.port = port;
            this.sshKeyInfos = sshKeyInfos;
            this.username = username;
        }

        public void setProxy(JFedConnection.ProxyInfo proxyInfo) {
            if (proxyInfo == null) {
                this.proxyHostname = null;
                this.proxyPort = -1;
                this.proxySshKeyInfo = null;
                this.proxyUsername = null;
                this.proxyOpenSshKeyHostKey = null;
            } else {
                assert (proxyInfo instanceof JFedConnection.SshProxyInfo);
                JFedConnection.SshProxyInfo sshProxyInfo = (JFedConnection.SshProxyInfo)proxyInfo;
                this.proxyHostname = sshProxyInfo.getHostname() != null && ipv6pat.matcher(sshProxyInfo.getHostname()).matches() ? "[" + sshProxyInfo.getHostname() + "]" : sshProxyInfo.getHostname();
                this.proxyPort = sshProxyInfo.getPort();
                if (sshProxyInfo.getSshKeyInfo() instanceof PuTTYFilesKeyInfo) {
                    this.proxySshKeyInfo = (PuTTYFilesKeyInfo)sshProxyInfo.getSshKeyInfo();
                } else if (sshProxyInfo.getSshKeyInfo() instanceof GeniUserSshKeyInfo) {
                    GeniUser geniUser = ((GeniUserSshKeyInfo)sshProxyInfo.getSshKeyInfo()).getGeniUser();
                    this.proxySshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser);
                } else {
                    if (sshProxyInfo.getSshKeyInfo() != null) {
                        throw new RuntimeException("Unsupported type of SshKeyInfo!");
                    }
                    LOG.warn("sshProxyInfo is null!");
                }
                this.proxyUsername = sshProxyInfo.getUsername();
                this.proxyOpenSshKeyHostKey = sshProxyInfo.getHostKey();
            }
        }

        public void setEnableX11Forward(boolean enableX11Forward) {
            this.enableX11Forward = enableX11Forward;
        }

        public boolean isEnableX11Forward() {
            return this.enableX11Forward;
        }

        public void setEnableAgentForward(boolean enableAgentForward) {
            this.enableAgentForward = enableAgentForward;
        }

        public boolean isEnableAgentForward() {
            return this.enableAgentForward;
        }
    }

    private static class HostkeyFetcher
    implements Callable<PublicKey> {
        private final PuttyRunParameters parameters;
        private PublicKey publicHostKey;

        private HostkeyFetcher(PuttyRunParameters parameters) {
            this.parameters = parameters;
        }

        @Override
        public PublicKey call() throws Exception {
            SSHClient connection = new SSHClient((Config)SshProxySocketImplFactory.getDefaultjFedSshConfig());
            connection.addHostKeyVerifier(new HostKeyVerifier(){

                public boolean verify(String s, int i, PublicKey publicKey) {
                    publicHostKey = publicKey;
                    return false;
                }

                public List<String> findExistingAlgorithms(String s, int i) {
                    return Collections.emptyList();
                }
            });
            try {
                connection.connect(this.parameters.getProxyHostname(), this.parameters.getProxyPort());
                connection.close();
            }
            catch (IOException ignore) {
                String key = KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)this.publicHostKey);
                LOG.debug("Got expected error while connecting to the proxy to find ssh hostkey. Result: publicHostKey=" + key, (Throwable)ignore);
            }
            return this.publicHostKey;
        }
    }
}

