/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ssh_terminal_tool.putty;

import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(WinRegistry.class);
    protected static final String REG_SZ = "REG_SZ";
    protected static final String REG_EXPAND_SZ = "REG_EXPAND_SZ";
    protected static final String REG_DWORD = "REG_DWORD";
    protected static final String REG_MULTI_SZ = "REG_MULTI_SZ";
    private static final Pattern REGEX_TOKEN = Pattern.compile("^\\s*(.*?)\\s+(REG_\\w+)\\s+(.*)");
    private static final Pattern REGEX_PARENT_PATH = Pattern.compile("[a-zA-Z_ ]+\\\\.*");

    private static File tmpFile(String baseName, String ext) {
        File tmpDir = new File(JFedUtils.getUserDataDirectoryFile(), "tmp");
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        File file = null;
        try {
            file = File.createTempFile(baseName, ext, tmpDir);
        }
        catch (IOException e) {
            LOG.error("Error while creating temporary file. Doing fallback");
            long nr = new Date().getTime();
            file = new File(tmpDir, baseName + nr + "." + ext);
        }
        file.deleteOnExit();
        return file;
    }

    public static void importInRegistry(File regFile) throws IOException {
        assert (regFile.exists());
        LOG.trace("Importing {} in registry", (Object)regFile.getPath());
        WinRegistry.executeCommand("reg", "IMPORT", "\"" + regFile.getPath() + "\"");
    }

    private static String executeCommand(String ... cmdarray) throws IOException {
        Process p = Runtime.getRuntime().exec(cmdarray);
        String output = IOUtils.streamToString((InputStream)p.getInputStream(), (String)Charset.defaultCharset().toString());
        if (LOG.isTraceEnabled()) {
            LOG.trace("reg output: {}", (Object)output);
            LOG.trace("reg error: {}", (Object)IOUtils.streamToString((InputStream)p.getErrorStream(), (String)Charset.defaultCharset().toString()));
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("reg completed");
        }
        return output;
    }

    public static void importInRegistry(String contents) throws IOException {
        File tmpFile = WinRegistry.tmpFile("jFed", ".reg");
        IOUtils.stringToFile((File)tmpFile, (String)contents.replace("\n", "\r\n"));
        WinRegistry.importInRegistry(tmpFile);
        tmpFile.delete();
    }

    public static void setValue(String parentAndKey, String value) throws IOException {
        LOG.debug("Starting reg for {}={}", (Object)parentAndKey, (Object)value);
        WinRegistry.executeCommand("reg", "ADD", "\"" + parentAndKey + "\"", "/d", "\"" + value + "\"", "/f");
    }

    public static void setValue(String parent, String key, String value) throws IOException {
        LOG.debug("Starting reg for {}\\{}={}", new Object[]{parent, key, value});
        WinRegistry.executeCommand("reg", "ADD", "\"" + parent + "\"", "/v", "\"" + key + "\"", "/d", "\"" + value + "\"", "/f");
    }

    public static Map<String, Object> getValues(String parent) throws IOException {
        LOG.trace("Performing reg QUERY for all keyvalue-pairs in {}", (Object)parent);
        String output = WinRegistry.executeCommand("reg", "QUERY", "\"" + parent + "\"");
        StringTokenizer tokenizer = new StringTokenizer(output, "\n\r");
        boolean headerFound = false;
        while (tokenizer.hasMoreTokens() && !headerFound) {
            String tok = tokenizer.nextToken().trim();
            headerFound = REGEX_PARENT_PATH.matcher(tok).matches();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken().trim();
            if (line.isEmpty()) continue;
            Matcher m = REGEX_TOKEN.matcher(line);
            if (m.matches()) {
                String name = m.group(1);
                String type = m.group(2);
                String value = m.group(3);
                switch (type) {
                    case "REG_SZ": 
                    case "REG_EXPAND_SZ": {
                        result.put(name, value);
                        break;
                    }
                    case "REG_DWORD": {
                        result.put(name, Integer.parseInt(value, 16));
                        break;
                    }
                    case "REG_MULTI_SZ": {
                        result.put(name, value.split("\u0000"));
                        break;
                    }
                    default: {
                        LOG.error("Unsupported registry type {} with name {}", (Object)type, (Object)name);
                        break;
                    }
                }
                continue;
            }
            if (!REGEX_PARENT_PATH.matcher(line).matches()) {
                LOG.warn("Could not parse line {}", (Object)line);
                continue;
            }
            LOG.info("Ignoring child {}", (Object)line);
        }
        return result;
    }

    public static Collection<String> getChildren(String parent) throws IOException {
        LOG.trace("Performing reg QUERY for children of {}", (Object)parent);
        String output = WinRegistry.executeCommand("reg", "QUERY", "\"" + parent + "\"");
        StringTokenizer tokenizer = new StringTokenizer(output, "\n\r");
        String matchableParent = parent.substring(parent.indexOf(92) + 1).toLowerCase();
        ArrayList<String> result = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken().trim();
            if (line.isEmpty()) continue;
            if (line.toLowerCase().contains(matchableParent) && REGEX_PARENT_PATH.matcher(line).matches()) {
                result.add(line);
                continue;
            }
            if (REGEX_TOKEN.matcher(line).matches()) continue;
            LOG.warn("Unmatched line while searching for children: {}", (Object)line);
        }
        return result;
    }

    public static String getValue(String parent, String key) throws IOException, RegistryException {
        LOG.trace("Performing reg QUERY for {}\\{}", (Object)parent, (Object)key);
        String output = WinRegistry.executeCommand("reg", "QUERY", "\"" + parent + "\"", "/v", "\"" + key + "\"");
        StringTokenizer tokenizer = new StringTokenizer(output, "\n\r");
        boolean headerFound = false;
        while (tokenizer.hasMoreTokens() && !headerFound) {
            String tok = tokenizer.nextToken().trim();
            headerFound = REGEX_PARENT_PATH.matcher(tok).matches();
        }
        while (tokenizer.hasMoreTokens()) {
            Matcher m;
            String line = tokenizer.nextToken().trim();
            if (line.isEmpty() || !(m = REGEX_TOKEN.matcher(line)).matches()) continue;
            String name = m.group(1);
            String type = m.group(2);
            String value = m.group(3);
            if (!Objects.equals(REG_SZ, type) && !Objects.equals(REG_EXPAND_SZ, type)) {
                throw new RegistryException("Value of " + name + " is not a String, but of type " + type);
            }
            assert (Objects.equals(name, key));
            return value;
        }
        return null;
    }

    public static class RegistryException
    extends Exception {
        public RegistryException() {
        }

        public RegistryException(String message) {
            super(message);
        }

        public RegistryException(String message, Throwable cause) {
            super(message, cause);
        }

        public RegistryException(Throwable cause) {
            super(cause);
        }

        public RegistryException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

