/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx;

import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FXMLUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FXMLUtil.class);
    private static final String FXML_SUFFIX = ".fxml";

    private FXMLUtil() {
    }

    public static void injectFXML(Object object) {
        FXMLUtil.injectFXML(object, null);
    }

    public static void injectFXML(Object object, Callback<Class<?>, Object> controllerFactory) {
        FXMLLoader fxmlLoader = new FXMLLoader(FXMLUtil.getFXMLUrl(object));
        fxmlLoader.setRoot(object);
        fxmlLoader.setController(object);
        if (controllerFactory != null) {
            fxmlLoader.setControllerFactory(controllerFactory);
        }
        try {
            fxmlLoader.load();
        }
        catch (IOException ex) {
            LOG.error("Could not load FXML-file for {}", (Object)object.getClass().getName(), (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    public static <T> T createFromFXML(Object object) {
        return FXMLUtil.createFromFXML(object, null);
    }

    public static <T> T createFromFXML(Object object, Callback<Class<?>, Object> controllerFactory) {
        FXMLLoader fxmlLoader = new FXMLLoader(FXMLUtil.getFXMLUrl(object));
        fxmlLoader.setController(object);
        if (controllerFactory != null) {
            fxmlLoader.setControllerFactory(controllerFactory);
        }
        try {
            return (T)fxmlLoader.load();
        }
        catch (IOException ex) {
            LOG.error("Could not load FXML-file for {}", (Object)object.getClass().getName(), (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    private static URL getFXMLUrl(Object object) {
        String fxmlFileName = object.getClass().getSimpleName() + FXML_SUFFIX;
        URL fxmlUrl = object.getClass().getResource(fxmlFileName);
        if (fxmlUrl == null) {
            throw new NullPointerException("Could not resolve fxml-file '" + fxmlFileName + "' for class '" + String.valueOf(object.getClass()) + "'");
        }
        return fxmlUrl;
    }
}

