/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx;

import java.io.IOException;
import java.net.URL;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceFXMLUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GuiceFXMLUtil.class);
    private static final String FXML_SUFFIX = ".fxml";
    private final Provider<FXMLLoader> fxmlLoaderProvider;

    @Inject
    GuiceFXMLUtil(Provider<FXMLLoader> fxmlLoaderProvider) {
        this.fxmlLoaderProvider = fxmlLoaderProvider;
    }

    public <R extends Parent, C> Result<R, C> createFromFXML(Class<C> clazz) {
        FXMLLoader loader = (FXMLLoader)this.fxmlLoaderProvider.get();
        loader.setLocation(GuiceFXMLUtil.getFXMLUrl(clazz));
        try {
            Parent root = (Parent)loader.load();
            Object controller = loader.getController();
            return new Result<Parent, Object>(root, controller);
        }
        catch (IOException ex) {
            LOG.error("Could not load FXML-file for {}", (Object)clazz.getName(), (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    public static URL getFXMLUrl(Class clazz) {
        String fxmlFileName = clazz.getSimpleName() + FXML_SUFFIX;
        URL fxmlUrl = clazz.getResource(fxmlFileName);
        if (fxmlUrl == null && clazz.getSimpleName().endsWith("Controller")) {
            fxmlUrl = clazz.getResource(clazz.getSimpleName().substring(0, clazz.getSimpleName().length() - 10) + FXML_SUFFIX);
        }
        if (fxmlUrl == null) {
            throw new NullPointerException("Could not resolve fxml-file '" + fxmlFileName + "' for class '" + String.valueOf(clazz) + "'");
        }
        return fxmlUrl;
    }

    public static class Result<R extends Parent, C> {
        private final R root;
        private final C controller;

        public Result(R root, C controller) {
            this.root = root;
            this.controller = controller;
        }

        public R getRoot() {
            return this.root;
        }

        public C getController() {
            return this.controller;
        }
    }
}

