/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.choosers;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerChooser {
    private static final Logger LOG = LoggerFactory.getLogger(ServerChooser.class);
    @FXML
    private VBox root;
    @FXML
    private ComboBox<Server> comboBox;
    @FXML
    private MenuButton configViewMenuButton;
    private final TestbedInfoSource testbedInfoSource;
    private ServerChooserViewConfig viewConfig = new ServerChooserViewConfig();
    private ObservableList<Server> serverObservableList;
    private final BooleanProperty editable = new SimpleBooleanProperty(true);
    private final BooleanProperty showEditListButton = new SimpleBooleanProperty(true);
    private final ObservableList<Server> filteredAuthorities = FXCollections.observableArrayList();
    private ServerFilter serverFilter;

    @Inject
    public ServerChooser(TestbedInfoSource testbedInfoSource) {
        this.testbedInfoSource = testbedInfoSource;
    }

    @FXML
    private void initialize() {
        this.comboBox.setConverter((StringConverter)new StringConverter<Server>(){

            public String toString(Server server) {
                if (server == null) {
                    return "ERROR: null";
                }
                if (server.getTestbed() == null) {
                    return "ERROR: testbed == null";
                }
                return ServerChooser.this.viewConfig.getShownName(server);
            }

            public Server fromString(String s) {
                throw new RuntimeException("unused");
            }
        });
        this.editable.addListener((observableValue, oldBoolean, newBoolean) -> this.comboBox.disableProperty().set(newBoolean == false));
        this.showEditListButton.addListener((observableValue, oldBoolean, newBoolean) -> {
            this.configViewMenuButton.setVisible(newBoolean.booleanValue());
            this.configViewMenuButton.setManaged(newBoolean.booleanValue());
        });
        assert (this.testbedInfoSource != null);
        this.serverObservableList = FXCollections.observableArrayList((Collection)this.testbedInfoSource.getServers());
        this.comboBox.setItems((ObservableList)new SortedList(this.serverObservableList, this.viewConfig.getComparator()));
        this.comboBox.getSelectionModel().selectFirst();
    }

    public Server getSelectedServer() {
        return (Server)this.comboBox.getSelectionModel().getSelectedItem();
    }

    public ReadOnlyObjectProperty<Server> selectedAuthorityProperty() {
        return this.comboBox.getSelectionModel().selectedItemProperty();
    }

    public void select(Server server) {
        assert (server != null) : "must always select something";
        this.comboBox.getSelectionModel().select((Object)server);
    }

    public void select(int serverId) {
        Server server = this.testbedInfoSource.getServerById(Integer.valueOf(serverId));
        assert (server != null) : "Server with id=" + serverId + " not found";
        this.comboBox.getSelectionModel().select((Object)server);
    }

    public void setSort(ActionEvent e) {
        MenuItem menuItem = (MenuItem)e.getSource();
        ServerChooserViewConfig.SortOrder newSortOrder = null;
        if (menuItem.getText().contains("Server ID")) {
            newSortOrder = ServerChooserViewConfig.SortOrder.SERVER_ID;
        }
        if (menuItem.getText().contains("Testbed ID")) {
            newSortOrder = ServerChooserViewConfig.SortOrder.TESTBED_ID;
        }
        if (menuItem.getText().contains("Testbed Name")) {
            newSortOrder = ServerChooserViewConfig.SortOrder.TESTBED_NAME;
        }
        if (newSortOrder == null) {
            throw new RuntimeException("BUG: did not find sort order: \"" + menuItem.getText() + "\"");
        }
        this.viewConfig = new ServerChooserViewConfig(newSortOrder, this.viewConfig.nameShown);
        this.configView();
    }

    public void setNameShown(ActionEvent e) {
        MenuItem menuItem = (MenuItem)e.getSource();
        ServerChooserViewConfig.NameShown newNameShown = null;
        if (menuItem.getText().contains("Server Name")) {
            newNameShown = ServerChooserViewConfig.NameShown.SERVER_NAME;
        }
        if (menuItem.getText().contains("Server ID")) {
            newNameShown = ServerChooserViewConfig.NameShown.SERVER_ID;
        }
        if (menuItem.getText().contains("Testbed Name")) {
            newNameShown = ServerChooserViewConfig.NameShown.TESTBED_NAME;
        }
        if (menuItem.getText().contains("Testbed ID")) {
            newNameShown = ServerChooserViewConfig.NameShown.TESTBED_ID;
        }
        if (menuItem.getText().contains("Server Name & ID")) {
            newNameShown = ServerChooserViewConfig.NameShown.SERVER_BOTH;
        }
        if (menuItem.getText().contains("Testbed Name & ID")) {
            newNameShown = ServerChooserViewConfig.NameShown.TESTBED_BOTH;
        }
        if (newNameShown == null) {
            throw new RuntimeException("BUG: did not find name to show: \"" + menuItem.getText() + "\"");
        }
        this.viewConfig = new ServerChooserViewConfig(this.viewConfig.sortOrder, newNameShown);
        this.configView();
    }

    @FXML
    public void configView() {
        Server selected = (Server)this.comboBox.getSelectionModel().getSelectedItem();
        this.comboBox.setItems(FXCollections.emptyObservableList());
        this.comboBox.setItems((ObservableList)new SortedList(this.serverObservableList, this.viewConfig.getComparator()));
        if (selected == null) {
            this.comboBox.getSelectionModel().clearSelection();
        } else {
            this.comboBox.getSelectionModel().select((Object)selected);
        }
    }

    public BooleanProperty editableProperty() {
        return this.editable;
    }

    public BooleanProperty showEditListButtonProperty() {
        return this.showEditListButton;
    }

    public void setServerFilter(ServerFilter serverFilter) {
        assert (this.testbedInfoSource.getServers() != null);
        if (serverFilter == null) {
            this.serverFilter = null;
            this.comboBox.setItems(FXCollections.observableArrayList((Collection)this.testbedInfoSource.getServers()));
            this.comboBox.getSelectionModel().selectFirst();
            return;
        }
        this.serverFilter = serverFilter;
        this.filteredAuthorities.clear();
        for (Server server : this.testbedInfoSource.getServers()) {
            if (!serverFilter.includeAuthority(server)) continue;
            this.filteredAuthorities.add((Object)server);
        }
        this.comboBox.setItems(this.filteredAuthorities);
        this.comboBox.getSelectionModel().selectFirst();
    }

    public VBox getRoot() {
        return this.root;
    }

    public static class ServerChooserViewConfig {
        private final SortOrder sortOrder;
        private final NameShown nameShown;

        public ServerChooserViewConfig(SortOrder sortOrder, NameShown nameShown) {
            this.sortOrder = sortOrder;
            this.nameShown = nameShown;
        }

        public ServerChooserViewConfig() {
            this.sortOrder = SortOrder.TESTBED_NAME;
            this.nameShown = NameShown.TESTBED_NAME;
        }

        public String getShownName(Server server) {
            assert (server != null);
            assert (server.getTestbed() != null);
            switch (this.nameShown.ordinal()) {
                case 0: {
                    return server.getName();
                }
                case 1: {
                    return server.getTestbed().getLongName();
                }
                case 2: {
                    return (String)server.getTestbed().getId();
                }
                case 3: {
                    return String.valueOf(server.getId());
                }
                case 4: {
                    return server.getTestbed().getLongName() + " (" + (String)server.getTestbed().getId() + ")";
                }
                case 5: {
                    return server.getName() + " (" + String.valueOf(server.getId()) + ")";
                }
            }
            throw new RuntimeException("NameShown not supported: " + String.valueOf((Object)this.nameShown));
        }

        public SortOrder getSortOrder() {
            return this.sortOrder;
        }

        public Comparator<Server> getComparator() {
            return (s1, s2) -> {
                Collator c = Collator.getInstance();
                switch (this.sortOrder.ordinal()) {
                    case 0: {
                        return ((Integer)s1.getId()).compareTo((Integer)s2.getId());
                    }
                    case 1: {
                        return c.compare((String)s1.getTestbed().getId(), (String)s2.getTestbed().getId());
                    }
                    case 2: {
                        return c.compare(s1.getTestbed().getLongName(), s2.getTestbed().getLongName());
                    }
                }
                throw new RuntimeException("SortOrder not supported: " + String.valueOf((Object)this.sortOrder));
            };
        }

        public static enum SortOrder {
            SERVER_ID,
            TESTBED_ID,
            TESTBED_NAME;

        }

        public static enum NameShown {
            SERVER_NAME,
            TESTBED_NAME,
            TESTBED_ID,
            SERVER_ID,
            TESTBED_BOTH,
            SERVER_BOTH;

        }
    }

    public static interface ServerFilter {
        public boolean includeAuthority(Server var1);
    }
}

