/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.dialogs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JFDialogs {
    private static final Logger LOG = LoggerFactory.getLogger(JFDialogs.class);
    private Window owner;
    private String title;
    private Node graphic;
    private String message;
    private String masthead;
    private boolean canCopyMessage;
    private final Set<ButtonType> buttonTypes = new LinkedHashSet<ButtonType>();

    public static JFDialogs create() {
        return new JFDialogs();
    }

    private JFDialogs() {
    }

    public JFDialogs owner(Window owner) {
        if (owner == null) {
            LOG.warn("Got an null Window as owner!");
        }
        this.owner = owner;
        return this;
    }

    public JFDialogs owner(Scene scene) {
        if (scene != null) {
            return this.owner(scene.getWindow());
        }
        LOG.warn("Got a null Scene as owner!");
        return this;
    }

    public JFDialogs owner(Node node) {
        if (node != null) {
            return this.owner(node.getScene());
        }
        LOG.warn("Got a null Node as owner!");
        return this;
    }

    public JFDialogs title(String title) {
        this.title = title;
        return this;
    }

    public JFDialogs graphic(Node graphic) {
        this.graphic = graphic;
        return this;
    }

    public JFDialogs message(String message) {
        this.message = message;
        return this;
    }

    public JFDialogs allowCopyMessage() {
        this.canCopyMessage = true;
        return this;
    }

    public JFDialogs allowCopyMessage(boolean canCopyMessage) {
        this.canCopyMessage = canCopyMessage;
        return this;
    }

    public JFDialogs masthead(String masthead) {
        this.masthead = masthead;
        return this;
    }

    public JFDialogs buttonTypes(Collection<? extends ButtonType> buttonTypes) {
        this.buttonTypes.clear();
        this.buttonTypes.addAll(buttonTypes);
        return this;
    }

    public JFDialogs buttonTypes(ButtonType ... buttonTypes) {
        return this.buttonTypes(Arrays.asList(buttonTypes));
    }

    public void showInformation() {
        this.showSimpleContentDialog(Type.INFORMATION);
    }

    public Optional<ButtonType> showConfirm() {
        return this.showSimpleContentDialog(Type.CONFIRMATION);
    }

    public Optional<ButtonType> showWarning() {
        return this.showSimpleContentDialog(Type.WARNING);
    }

    public Optional<ButtonType> showError() {
        return this.showSimpleContentDialog(Type.ERROR);
    }

    public void showException(Throwable exception) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        if (this.title != null) {
            alert.setTitle(this.title);
        }
        if (this.masthead != null) {
            alert.setHeaderText(this.masthead);
        }
        if (this.message != null) {
            alert.setContentText(this.message);
        }
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.setResizable(true);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        String exceptionText = sw.toString();
        Label label = new Label("The exception stacktrace was:");
        TextArea textArea = new TextArea(exceptionText);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)label, 0, 0);
        expContent.add((Node)textArea, 0, 1);
        alert.getDialogPane().setExpandableContent((Node)expContent);
        alert.show();
    }

    public Optional<String> showTextInput(String defaultValue) {
        TextInputDialog dlg = new TextInputDialog(defaultValue);
        if (this.graphic != null) {
            dlg.setGraphic(this.graphic);
        }
        if (this.message != null) {
            dlg.setContentText(this.message);
        }
        if (this.masthead != null) {
            dlg.setHeaderText(this.masthead);
        }
        if (!this.buttonTypes.isEmpty()) {
            dlg.getDialogPane().getButtonTypes().clear();
            dlg.getDialogPane().getButtonTypes().addAll(this.buttonTypes);
        }
        if (this.title != null) {
            dlg.setTitle(this.title);
        }
        return dlg.showAndWait();
    }

    public Optional<String> showPasswordInput() {
        Alert dlg = this.buildDialog(Type.INFORMATION);
        dlg.getButtonTypes().setAll(Arrays.asList(ButtonType.OK, ButtonType.CANCEL));
        PasswordField passwordField = new PasswordField();
        passwordField.setMinWidth(500.0);
        passwordField.setMaxWidth(Double.MAX_VALUE);
        passwordField.setMaxHeight(Double.MAX_VALUE);
        passwordField.setEditable(true);
        dlg.getDialogPane().setContent((Node)passwordField);
        Optional res = dlg.showAndWait();
        return res.filter(ButtonType.OK::equals).map(b -> passwordField.getText());
    }

    public <T> Optional<T> showChoices(T defaultChoice, Collection<T> choices) {
        ChoiceDialog dlg = new ChoiceDialog(defaultChoice, choices);
        if (this.graphic != null) {
            dlg.setGraphic(this.graphic);
        }
        if (this.message != null) {
            dlg.setContentText(this.message);
        }
        if (this.masthead != null) {
            dlg.setHeaderText(this.masthead);
        }
        if (!this.buttonTypes.isEmpty()) {
            dlg.getDialogPane().getButtonTypes().clear();
            dlg.getDialogPane().getButtonTypes().addAll(this.buttonTypes);
        }
        if (this.title != null) {
            dlg.setTitle(this.title);
        }
        return dlg.showAndWait();
    }

    public <T> Optional<T> showChoices(Collection<T> choices) {
        return this.showChoices(null, choices);
    }

    private Alert buildDialog(Type dlgType) {
        Alert alert = new Alert(dlgType.getAlertType());
        alert.initOwner(this.owner);
        if (this.title != null) {
            alert.setTitle(this.title);
        }
        if (this.masthead != null) {
            alert.setHeaderText(this.masthead);
        }
        if (this.graphic != null) {
            alert.setGraphic(this.graphic);
        }
        alert.setResizable(true);
        return alert;
    }

    private Optional<ButtonType> showSimpleContentDialog(Type dlgType) {
        Alert dlg = this.buildDialog(dlgType);
        if (!this.buttonTypes.isEmpty()) {
            dlg.getButtonTypes().setAll(this.buttonTypes);
        }
        if (!this.canCopyMessage) {
            dlg.setContentText(this.message);
        } else {
            TextArea textArea = new TextArea(this.message);
            textArea.setPrefColumnCount(10);
            textArea.setPrefRowCount(50);
            textArea.setMinWidth(500.0);
            textArea.setMinHeight(500.0);
            textArea.setMaxWidth(Double.MAX_VALUE);
            textArea.setMaxHeight(Double.MAX_VALUE);
            textArea.setWrapText(true);
            textArea.setEditable(false);
            dlg.getDialogPane().setContent((Node)textArea);
        }
        return dlg.showAndWait();
    }

    private static enum Type {
        ERROR(Alert.AlertType.ERROR),
        INFORMATION(Alert.AlertType.INFORMATION),
        WARNING(Alert.AlertType.WARNING),
        CONFIRMATION(Alert.AlertType.CONFIRMATION);

        private final Alert.AlertType alertType;

        private Type(Alert.AlertType alertType) {
            this.alertType = alertType;
        }

        public Alert.AlertType getAlertType() {
            return this.alertType;
        }
    }
}

