/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.log_gui;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.highlevel.history.ApiCallHistory;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.log_gui.LogPanel;
import be.iminds.ilabt.jfed.ui.javafx.style.StyleHelper;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import org.controlsfx.glyphfont.FontAwesome;

public class LogHistoryPanel
extends BorderPane {
    @FXML
    private ComboBox<SerializableApiCallDetails> logChooser;
    @FXML
    private ToggleButton showNewCheckbox;
    @FXML
    private LogPanel logPanelController;
    private ObservableList<SerializableApiCallDetails> history;
    private BooleanProperty authShowLast;
    private BooleanProperty authShowLastVisible;
    private ListChangeListener<SerializableApiCallDetails> apiChangeListener = null;

    public LogHistoryPanel() {
        FXMLUtil.injectFXML((Object)this);
    }

    @FXML
    private void initialize() {
        this.logChooser.setCellFactory(list -> new ApiCallDetailsCell());
        this.logChooser.setButtonCell((ListCell)new ApiCallDetailsCell());
        this.logPanelController.shownLogProperty().bind((ObservableValue)this.logChooser.getSelectionModel().selectedItemProperty());
        this.authShowLast = this.showNewCheckbox.selectedProperty();
        this.authShowLast.set(true);
        this.authShowLastVisible = this.showNewCheckbox.visibleProperty();
        this.authShowLastVisible.setValue(Boolean.valueOf(true));
        this.showNewCheckbox.managedProperty().bind((ObservableValue)this.showNewCheckbox.visibleProperty());
    }

    public BooleanProperty autoShowLastProperty() {
        return this.authShowLast;
    }

    public boolean isAutoShowLast() {
        return this.authShowLast.get();
    }

    public void setAutoShowLast(boolean val) {
        this.authShowLast.set(val);
    }

    public boolean getAuthShowLastVisible() {
        return this.authShowLastVisible.get();
    }

    public BooleanProperty authShowLastVisibleProperty() {
        return this.authShowLastVisible;
    }

    public void setAuthShowLastVisible(boolean authShowLastVisible) {
        this.authShowLastVisible.set(authShowLastVisible);
    }

    public void clearApiCallHistory() {
        if (this.history != null) {
            this.history.removeListener(this.apiChangeListener);
            this.apiChangeListener = null;
            this.logChooser.setItems(FXCollections.observableArrayList());
            this.history = null;
        }
    }

    public void setApiCallHistory(ApiCallHistory history) {
        assert (history != null);
        this.setApiCallHistory((ObservableList<SerializableApiCallDetails>)history.getHistory());
    }

    public void setApiCallHistory(ObservableList<SerializableApiCallDetails> history) {
        if (this.history != null) {
            this.clearApiCallHistory();
        }
        assert (history != null);
        assert (this.apiChangeListener == null);
        assert (Platform.isFxApplicationThread());
        assert (this.history == null);
        this.history = history;
        this.apiChangeListener = change -> {
            if ((this.showNewCheckbox.isSelected() || this.logChooser.getSelectionModel().isEmpty()) && !this.history.isEmpty()) {
                Platform.runLater(() -> this.logChooser.getSelectionModel().selectLast());
            }
        };
        this.logChooser.setItems(history);
        history.addListener(this.apiChangeListener);
        if (!history.isEmpty()) {
            this.logChooser.getSelectionModel().selectLast();
        }
    }

    @FXML
    public void first() {
        this.logChooser.getSelectionModel().selectFirst();
    }

    @FXML
    public void next() {
        this.logChooser.getSelectionModel().selectNext();
    }

    @FXML
    public void prev() {
        this.logChooser.getSelectionModel().selectPrevious();
    }

    @FXML
    public void last() {
        this.logChooser.getSelectionModel().selectLast();
    }

    @FXML
    public void autolast() {
        if (this.showNewCheckbox.isSelected()) {
            this.logChooser.getSelectionModel().selectLast();
        }
    }

    public void showApiCall(SerializableApiCallDetails apiCallDetails) {
        assert (this.logChooser.getItems().contains((Object)apiCallDetails));
        this.setAutoShowLast(false);
        this.logChooser.getSelectionModel().select((Object)apiCallDetails);
    }

    class ApiCallDetailsCell
    extends ListCell<SerializableApiCallDetails> {
        public ApiCallDetailsCell() {
            this.getStylesheets().add((Object)StyleHelper.getStyleUrl("log.css").toExternalForm());
            this.setPrefWidth(300.0);
            this.getStyleClass().add((Object)"select_log_label");
        }

        public void updateItem(SerializableApiCallDetails item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.setText("");
                this.setGraphic(null);
            } else {
                String text = item.getApiName() + " - " + item.getGeniMethodName();
                if (item.getAuthorityUrn() != null) {
                    GeniUrn authUrn = GeniUrn.parse((String)item.getAuthorityUrn());
                    text = authUrn == null ? text + " (@ \"" + item.getAuthorityUrn() + "\")" : text + " (@ " + authUrn.getEncodedTopLevelAuthority() + ")";
                }
                this.setText(text);
                boolean success = false;
                boolean busy = false;
                if (item.getGeniResponseCodeIsSuccess() != null && item.getGeniResponseCodeIsSuccess().booleanValue()) {
                    success = true;
                }
                if (item.getGeniResponseCodeIsSuccess() != null && item.getGeniResponseCodeIsSuccess().booleanValue()) {
                    busy = true;
                }
                if (success) {
                    this.setGraphic((Node)GlyphUtils.createSmallGlyph(FontAwesome.Glyph.CHECK, Color.GREEN));
                } else if (busy) {
                    this.setGraphic((Node)GlyphUtils.createSmallGlyph(FontAwesome.Glyph.TIMES, Color.GRAY));
                } else {
                    this.setGraphic((Node)GlyphUtils.createSmallGlyph(FontAwesome.Glyph.TIMES_CIRCLE, Color.RED));
                }
            }
        }
    }
}

