/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.log_gui;

import be.iminds.ilabt.jfed.call_log_output.HtmlLogOutput;
import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.ui.javafx.log_gui.XmlRpcPane;
import be.iminds.ilabt.jfed.ui.javafx.util.TimeUtils;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.DataConversionUtils;
import be.iminds.ilabt.jfed.util.library.JSonHelper;
import be.iminds.ilabt.jfed.util.library.XmlRpcPrintUtil;
import be.iminds.ilabt.jfed.util.library.XmlUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;
import org.jetbrains.annotations.Contract;
import org.rendersnake.HtmlCanvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class LogPanel {
    private static final Logger LOG = LoggerFactory.getLogger(LogPanel.class);
    private static final GlyphFont fontAwesome = GlyphFontRegistry.font((String)"FontAwesome");
    private final ObjectProperty<SerializableApiCallDetails> shownLog = new SimpleObjectProperty();
    @FXML
    private TextArea resultText;
    @FXML
    private TextArea resultErrorText;
    @FXML
    private TextField connectionTypeText;
    @FXML
    private TextField authorityNameText;
    @FXML
    private VBox resultTabContent;
    private boolean showingResultErrorText = true;
    private boolean showingResultText = true;
    @FXML
    private Parent resultTextGroup;
    @FXML
    private Parent resultErrorTextGroup;
    @FXML
    private Label resultCode;
    @FXML
    private Label resultLabel;
    @FXML
    private TextArea lowLevelGeniValueText;
    @FXML
    private TextArea lowLevelGeniCodeText;
    @FXML
    private TextArea lowLevelGeniOutputText;
    @FXML
    private TextField xmlRpcCommand;
    @FXML
    private TextArea xmlRpcSentText;
    @FXML
    private CheckBox xmlRpcSentTextShowCredentialsCheckBox;
    @FXML
    private CheckBox realJsonSentCheckBox;
    @FXML
    private TextArea xmlRpcReceivedText;
    @FXML
    private CheckBox xmlRpcReceivedTextShowCredentialsCheckBox;
    @FXML
    private CheckBox realJsonReceivedCheckBox;
    @FXML
    private StackPane xmlRpcSentStackPane;
    @FXML
    private StackPane xmlRpcReplyStackPane;
    @FXML
    private Button xmlRpcSentSwitchViewButton;
    @FXML
    private Button xmlRpcReplySwitchViewButton;
    @FXML
    private XmlRpcPane xmlRpcSentPane;
    @FXML
    private XmlRpcPane xmlRpcReceivedPane;
    @FXML
    private TextField baseServerUrlText;
    @FXML
    private TextField callServerUrlText;
    @FXML
    private TextField proxyText;
    @FXML
    private TextField connectionDebugIdText;
    @FXML
    private TextField connectionUserUrnText;
    @FXML
    private TextField connectionBasicHttpAuthUsernameText;
    @FXML
    private Label connectionBasicHttpAuthUsernameLabel;
    @FXML
    private TextField httpRequestLineText;
    @FXML
    private TextArea httpSentHeaders;
    @FXML
    private TextArea httpSentText;
    @FXML
    private TextField httpStatusLineText;
    @FXML
    private TextArea httpReceivedHeaders;
    @FXML
    private TextArea httpReceivedText;
    @FXML
    private TabPane logTabPane;
    @FXML
    private VBox logPanelContainer;
    @FXML
    private Tab resultTab;
    @FXML
    private Tab lowLevelValueTab;
    @FXML
    private Tab lowLevelOutputTab;
    @FXML
    private Tab XmlRpcRequestTab;
    @FXML
    private Tab XmlRpcReplyTab;
    @FXML
    private Tab connectionDetailsTab;
    @FXML
    private Tab httpRequestTab;
    @FXML
    private Tab httpReplyTab;
    @FXML
    private Tab stitchingOverviewTab;
    @FXML
    private Tab exceptionTab;
    @FXML
    private Tab xmlTab;
    @FXML
    private Tab rspecTab;
    @FXML
    private Tab spewLogTab;
    @FXML
    private Tab htmlErrorTab;
    @FXML
    private Label requestSizeLabel;
    @FXML
    private Label replySizeLabel;
    @FXML
    private Label requestSizeHeaderLabel;
    @FXML
    private Label replySizeHeaderLabel;
    @FXML
    private TextArea exceptionTextField;
    @FXML
    private TextArea stitchingOverviewTextArea;
    @FXML
    private TextField callStartTimeField;
    @FXML
    private Label callStartTimeRelativeLabel;
    @FXML
    private TextField callStopTimeField;
    @FXML
    private Label callStopTimeRelativeLabel;
    @FXML
    private TextArea xmlText;
    @FXML
    private TextArea rspecText;
    @FXML
    private HBox showRspecButtonBox;
    private String xmlToFormat;
    private final List<RspecTabContent> rspecTabContents = new ArrayList<RspecTabContent>();
    private String shownExceptionText = null;
    @FXML
    private WebView htmlWebView;
    private SerializableApiCallDetails htmlApiCallDetails;
    @FXML
    private WebView spewWebView;
    @FXML
    private Label spewWebViewLabel;
    @FXML
    private TextField spewUrl;
    @FXML
    private TextField spewUrn;
    private final ObjectProperty<SerializableApiCallDetails> shownApiCallDetails = new SimpleObjectProperty(null);
    private final ChangeListener<SerializableApiCallDetails> shownLogChangeListener = (observableValue, oldApiCallDetails, newApiCallDetails) -> {
        try {
            this.logTabPane.getTabs().removeAll((Object[])new Tab[]{this.xmlTab, this.rspecTab, this.spewLogTab, this.htmlErrorTab, this.exceptionTab, this.stitchingOverviewTab});
            this.hideRspec();
            LOG.debug("hide Rspec tab");
            this.shownApiCallDetails.set(newApiCallDetails);
            if (newApiCallDetails == null) {
                this.resultText.setText("");
                this.lowLevelGeniValueText.setText("");
                this.lowLevelGeniOutputText.setText("");
                this.lowLevelGeniCodeText.setText("");
                this.xmlRpcCommand.setText("");
                this.xmlRpcSentText.setText("");
                this.xmlRpcReceivedText.setText("");
                this.xmlRpcSentPane.setObj(null);
                this.xmlRpcReceivedPane.setObj(null);
                this.connectionTypeText.setText("");
                this.authorityNameText.setText("");
                this.baseServerUrlText.setText("");
                this.callServerUrlText.setText("");
                this.proxyText.setText("");
                this.connectionDebugIdText.setText("");
                this.connectionUserUrnText.setText("");
                this.callStartTimeField.setText("");
                this.callStartTimeRelativeLabel.setText("");
                this.callStopTimeField.setText("");
                this.callStopTimeRelativeLabel.setText("");
                this.requestSizeLabel.setVisible(false);
                this.replySizeLabel.setVisible(false);
                this.httpRequestLineText.setText("");
                this.httpSentHeaders.setText("");
                this.httpSentText.setText("");
                this.httpStatusLineText.setText("");
                this.httpReceivedHeaders.setText("");
                this.httpReceivedText.setText("");
                this.xmlText.setText("");
                this.showResultErrorText(false);
                this.showResultText(false);
                this.resultTab.setDisable(true);
                this.lowLevelValueTab.setDisable(true);
                this.lowLevelOutputTab.setDisable(true);
                this.XmlRpcRequestTab.setDisable(true);
                this.XmlRpcReplyTab.setDisable(true);
                this.connectionDetailsTab.setDisable(true);
                this.httpRequestTab.setDisable(true);
                this.httpReplyTab.setDisable(true);
            } else {
                String xmlRpcReceivedTextString;
                String xmlRpcSentTextString;
                this.resultTab.setDisable(false);
                this.lowLevelValueTab.setDisable(false);
                this.lowLevelOutputTab.setDisable(false);
                this.XmlRpcRequestTab.setDisable(false);
                this.XmlRpcReplyTab.setDisable(false);
                this.connectionDetailsTab.setDisable(false);
                this.httpRequestTab.setDisable(false);
                this.httpReplyTab.setDisable(false);
                if (newApiCallDetails.getConnectionType() != null) {
                    this.connectionTypeText.setText(newApiCallDetails.getConnectionType() + " proto=" + newApiCallDetails.getConnectionProtocol() + " auth=" + newApiCallDetails.getConnectionAuthenticationMethod());
                } else {
                    this.connectionTypeText.setText("");
                }
                if (newApiCallDetails.getAuthorityUrn() != null) {
                    this.authorityNameText.setText(newApiCallDetails.getAuthorityUrn());
                } else {
                    this.authorityNameText.setText("");
                }
                this.baseServerUrlText.setText(newApiCallDetails.getBaseServerUrl());
                this.callServerUrlText.setText(newApiCallDetails.getCallServerUrl());
                this.proxyText.setText(newApiCallDetails.getProxyInfo() == null ? "no proxy used" : newApiCallDetails.getProxyInfo().toString());
                this.connectionUserUrnText.setText(newApiCallDetails.getConnectionSslAuthUserUrn());
                if (newApiCallDetails.getConnectionBasicHttpAuthUsername() == null) {
                    this.connectionBasicHttpAuthUsernameText.setText("<not used>");
                    this.connectionBasicHttpAuthUsernameText.setDisable(true);
                    this.connectionBasicHttpAuthUsernameLabel.setDisable(true);
                } else {
                    this.connectionBasicHttpAuthUsernameText.setText(newApiCallDetails.getConnectionBasicHttpAuthUsername());
                    this.connectionBasicHttpAuthUsernameText.setDisable(false);
                    this.connectionBasicHttpAuthUsernameLabel.setDisable(false);
                }
                this.connectionDebugIdText.setText(newApiCallDetails.getConnectionId());
                Date startTime = newApiCallDetails.getStartTime();
                Date stopTime = newApiCallDetails.getStopTime();
                if (startTime == null) {
                    this.callStartTimeField.setText("");
                    this.callStartTimeRelativeLabel.setText("");
                } else {
                    this.callStartTimeField.setText(String.valueOf(startTime));
                    long millis = System.currentTimeMillis() - startTime.getTime();
                    String relString = TimeUtils.formatMillis(millis, TimeUnit.DAYS, TimeUnit.SECONDS);
                    this.callStartTimeRelativeLabel.setText("(" + relString + " ago)");
                }
                if (stopTime == null) {
                    this.callStopTimeField.setText("");
                    this.callStopTimeRelativeLabel.setText("");
                } else {
                    this.callStopTimeField.setText(String.valueOf(stopTime));
                    Object res = "(";
                    long millis = System.currentTimeMillis() - stopTime.getTime();
                    res = (String)res + TimeUtils.formatMillis(millis, TimeUnit.DAYS, TimeUnit.SECONDS) + " ago";
                    if (startTime != null) {
                        long millis2 = stopTime.getTime() - startTime.getTime();
                        res = (String)res + " = " + TimeUtils.formatMillis(millis2, TimeUnit.DAYS, TimeUnit.MILLISECONDS) + " after start";
                    }
                    res = (String)res + ")";
                    this.callStopTimeRelativeLabel.setText((String)res);
                }
                this.httpRequestLineText.setText(newApiCallDetails.getHttpRequestStatusLine() == null ? "<no data>" : newApiCallDetails.getHttpRequestStatusLine());
                this.httpSentHeaders.setText(newApiCallDetails.getHttpRequestHeaders() == null ? "<no data>" : newApiCallDetails.getHttpRequestHeaders());
                this.httpSentText.setText(newApiCallDetails.getHttpRequest() == null ? "<no data>" : newApiCallDetails.getHttpRequest());
                this.httpStatusLineText.setText(newApiCallDetails.getHttpResponseStatusLine() == null ? "<no data>" : newApiCallDetails.getHttpResponseStatusLine());
                this.httpReceivedHeaders.setText(newApiCallDetails.getHttpResponseHeaders() == null ? "<no data>" : newApiCallDetails.getHttpResponseHeaders());
                this.httpReceivedText.setText(newApiCallDetails.getHttpResponse() == null ? "<no data>" : newApiCallDetails.getHttpResponse());
                this.requestSizeLabel.setVisible(true);
                this.replySizeLabel.setVisible(true);
                long requestSizeByte = 0L;
                if (newApiCallDetails.getHttpRequestStatusLine() != null) {
                    requestSizeByte += (long)newApiCallDetails.getHttpRequestStatusLine().length();
                }
                if (newApiCallDetails.getHttpRequestHeaders() != null) {
                    requestSizeByte += (long)newApiCallDetails.getHttpRequestHeaders().length();
                }
                if (newApiCallDetails.getHttpRequest() != null) {
                    requestSizeByte += (long)newApiCallDetails.getHttpRequest().length();
                }
                this.requestSizeLabel.setText("" + requestSizeByte);
                long replySizeByte = 0L;
                if (newApiCallDetails.getHttpResponseStatusLine() != null) {
                    replySizeByte += (long)newApiCallDetails.getHttpResponseStatusLine().length();
                }
                if (newApiCallDetails.getHttpResponseHeaders() != null) {
                    replySizeByte += (long)newApiCallDetails.getHttpResponseHeaders().length();
                }
                if (newApiCallDetails.getHttpResponse() != null) {
                    replySizeByte += (long)newApiCallDetails.getHttpResponse().length();
                }
                this.replySizeLabel.setText("" + replySizeByte);
                this.xmlRpcCommand.setText(newApiCallDetails.getGeniMethodName());
                String string = xmlRpcSentTextString = !this.xmlRpcSentTextShowCredentialsCheckBox.isSelected() || this.realJsonSentCheckBox.isSelected() ? newApiCallDetails.getXmlRpcRequestJsonString() : newApiCallDetails.getXmlRpcRequestHumanReadableString();
                if (xmlRpcSentTextString == null) {
                    xmlRpcSentTextString = "null";
                }
                if (!this.xmlRpcSentTextShowCredentialsCheckBox.isSelected()) {
                    xmlRpcSentTextString = LogPanel.removeCredentialsFromJson(xmlRpcSentTextString);
                }
                this.xmlRpcSentText.setText(xmlRpcSentTextString);
                String string2 = xmlRpcReceivedTextString = !this.xmlRpcReceivedTextShowCredentialsCheckBox.isSelected() || this.realJsonReceivedCheckBox.isSelected() ? newApiCallDetails.getXmlRpcResponseJsonString() : newApiCallDetails.getXmlRpcResponseHumanReadableString();
                if (xmlRpcReceivedTextString == null) {
                    xmlRpcReceivedTextString = "null";
                }
                if (!this.xmlRpcReceivedTextShowCredentialsCheckBox.isSelected()) {
                    xmlRpcReceivedTextString = LogPanel.removeCredentialsFromJson(xmlRpcReceivedTextString);
                }
                this.xmlRpcReceivedText.setText(xmlRpcReceivedTextString);
                if (newApiCallDetails.getXmlRpcRequestJsonString() == null) {
                    this.xmlRpcSentPane.setObj(null);
                } else if (newApiCallDetails.getXmlRpcRequestJsonString().length() < 100000) {
                    this.xmlRpcSentPane.setObj(newApiCallDetails.getXmlRpcRequestJsonObject());
                } else {
                    this.xmlRpcSentPane.setObj("output too long for this view");
                }
                if (newApiCallDetails.getXmlRpcResponseJsonString() != null) {
                    if (newApiCallDetails.getXmlRpcResponseJsonString().length() < 100000) {
                        this.xmlRpcReceivedPane.setObj(newApiCallDetails.getXmlRpcResponseJsonObject());
                    } else {
                        this.xmlRpcReceivedPane.setObj("output too long for this view");
                    }
                } else {
                    this.xmlRpcReceivedPane.setObj(null);
                }
                if (this.isHtml(newApiCallDetails.getHttpResponse())) {
                    this.showHtml((SerializableApiCallDetails)newApiCallDetails);
                }
                if (newApiCallDetails.getGeniResponseCode() != null) {
                    this.resultCode.setText("GeniResponseCode=" + newApiCallDetails.getGeniResponseCode() + " = " + newApiCallDetails.getGeniResponseCodeDescription());
                    assert (newApiCallDetails.getGeniResponseCodeIsSuccess() != null);
                    if (newApiCallDetails.getGeniResponseCodeIsSuccess().booleanValue() && (newApiCallDetails.getGeniResponseOutput() == null || newApiCallDetails.getGeniResponseOutput().isEmpty())) {
                        this.resultErrorText.setText("");
                        this.showResultErrorText(false);
                    } else {
                        this.resultErrorText.setText(newApiCallDetails.getGeniResponseOutput());
                        this.showResultErrorText(true);
                    }
                } else {
                    this.resultCode.setText("ERROR: no GeniResponseCode");
                    this.showResultErrorText(true);
                }
                if (newApiCallDetails.getXmlRpcGeniResponseValue() != null) {
                    this.resultTab.setDisable(false);
                    this.showResultText(true);
                    this.resultText.setText(newApiCallDetails.getXmlRpcGeniResponseValue());
                    this.resultText.setDisable(false);
                    if (newApiCallDetails.getXmlRpcGeniResponseValue().contains("stitching")) {
                        this.showStitchingOverview((SerializableApiCallDetails)newApiCallDetails);
                    }
                    if (LogPanel.isXml(newApiCallDetails.getXmlRpcGeniResponseValue())) {
                        this.showXml(newApiCallDetails.getXmlRpcGeniResponseValue());
                    } else if (newApiCallDetails.getXmlRpcGeniResponseValue() != null && LogPanel.isXml(newApiCallDetails.getXmlRpcGeniResponseValue())) {
                        this.showXml(newApiCallDetails.getXmlRpcGeniResponseValue());
                    }
                    this.lowLevelValueTab.setDisable(false);
                    this.lowLevelOutputTab.setDisable(false);
                    if (newApiCallDetails.getXmlRpcGeniResponseValue() != null) {
                        this.lowLevelGeniValueText.setDisable(false);
                        this.lowLevelGeniValueText.setText(newApiCallDetails.getXmlRpcGeniResponseValue());
                    } else {
                        this.lowLevelGeniValueText.setDisable(true);
                        this.lowLevelGeniValueText.setText("ERROR: raw result is a Map without \"value\" field:\n\n" + newApiCallDetails.getXmlRpcGeniResponseValue());
                    }
                    if (newApiCallDetails.getXmlRpcGeniResponseCode() != null) {
                        this.lowLevelGeniCodeText.setDisable(false);
                        this.lowLevelGeniCodeText.setText(newApiCallDetails.getXmlRpcGeniResponseCode());
                    } else {
                        this.lowLevelGeniCodeText.setDisable(true);
                        this.lowLevelGeniOutputText.setText("no \"code\" field in result Map");
                    }
                    if (newApiCallDetails.getXmlRpcGeniResponseOutput() != null) {
                        this.lowLevelGeniOutputText.setDisable(false);
                        this.lowLevelGeniOutputText.setText(newApiCallDetails.getXmlRpcGeniResponseOutput());
                    } else {
                        this.lowLevelGeniOutputText.setDisable(true);
                        this.lowLevelGeniOutputText.setText("no \"output\" field in result Map");
                    }
                } else {
                    if (newApiCallDetails.getHttpRequest() != null && newApiCallDetails.getHttpRequest().contains("stitching") || newApiCallDetails.getHttpResponse() != null && newApiCallDetails.getHttpResponse().contains("stitching")) {
                        this.showStitchingOverview((SerializableApiCallDetails)newApiCallDetails);
                    }
                    this.resultCode.setText("ERROR: no reply");
                    this.showResultErrorText(false);
                    this.resultText.setText("<null>");
                    this.showResultText(false);
                    this.resultTab.setDisable(true);
                    this.lowLevelValueTab.setDisable(true);
                    this.lowLevelOutputTab.setDisable(true);
                    this.lowLevelGeniValueText.setText("ERROR: no reply");
                    this.lowLevelGeniOutputText.setText("");
                    this.lowLevelGeniCodeText.setText("");
                    this.lowLevelGeniValueText.setDisable(true);
                    this.lowLevelGeniOutputText.setDisable(true);
                    this.lowLevelGeniCodeText.setDisable(true);
                }
                if (newApiCallDetails.getXmlRpcGeniResponseValue() != null) {
                    boolean isCompressed = LogPanel.detectCompressed(newApiCallDetails.getXmlRpcRequestJsonObject());
                    String rawValue = newApiCallDetails.getXmlRpcGeniResponseValue();
                    if (isCompressed) {
                        LOG.debug("Detected Compressed raw value, will attempt decompress.");
                        try {
                            rawValue = DataConversionUtils.decompressFromBase64((String)rawValue);
                        }
                        catch (Exception e) {
                            LOG.debug("LogPanel ignores error while decompressing");
                        }
                    } else {
                        LOG.debug("Did not detected compressed raw value.");
                    }
                    if (LogPanel.isRspec(rawValue)) {
                        this.showRspec("Reply", rawValue);
                    } else if (newApiCallDetails.getXmlRpcGeniResponseValue() != null && LogPanel.isRspec(newApiCallDetails.getXmlRpcGeniResponseValue())) {
                        this.showRspec("Reply", newApiCallDetails.getXmlRpcGeniResponseValue());
                    } else if (newApiCallDetails.getXmlRpcResponseJsonString() != null) {
                        LogPanel.findRspecs(newApiCallDetails.getXmlRpcResponseJsonObject(), rspec -> this.showRspec("Reply", (String)rspec));
                    }
                }
                if (newApiCallDetails.getXmlRpcRequestJsonString() != null) {
                    LogPanel.findRspecs(newApiCallDetails.getXmlRpcRequestJsonObject(), rspec -> this.showRspec("Request", (String)rspec));
                }
                if (newApiCallDetails.getProtogeniSpewLogUrl() != null && !newApiCallDetails.getProtogeniSpewLogUrl().trim().isEmpty()) {
                    this.showSpewLogFile(newApiCallDetails.getProtogeniSpewLogUrl());
                }
                if (newApiCallDetails.getExceptionString() != null) {
                    this.showExceptionString(newApiCallDetails.getExceptionString());
                }
            }
        }
        catch (AssertionError | Exception e) {
            LOG.error("Exception while handling log panel change", (Throwable)e);
        }
    };
    private static final int MAX_REMOVE_CRED_RESUCRSE_DEPTH = 10;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public ObjectProperty<SerializableApiCallDetails> shownLogProperty() {
        return this.shownLog;
    }

    public SerializableApiCallDetails getShownLog() {
        return (SerializableApiCallDetails)this.shownLog.get();
    }

    public void setShownLog(SerializableApiCallDetails details) {
        this.shownLog.set((Object)details);
    }

    @FXML
    private void initialize() {
        this.shownLog.addListener(this.shownLogChangeListener);
        this.logTabPane.getTabs().removeAll((Object[])new Tab[]{this.stitchingOverviewTab, this.xmlTab, this.rspecTab, this.spewLogTab, this.htmlErrorTab, this.exceptionTab});
        this.hideRspec();
        LOG.debug("hide Rspec tab");
        this.logTabPane.getSelectionModel().select((Object)this.resultTab);
        this.requestSizeLabel.managedProperty().bind((ObservableValue)this.requestSizeLabel.visibleProperty());
        this.replySizeLabel.managedProperty().bind((ObservableValue)this.replySizeLabel.visibleProperty());
        this.requestSizeHeaderLabel.managedProperty().bind((ObservableValue)this.requestSizeHeaderLabel.visibleProperty());
        this.replySizeHeaderLabel.managedProperty().bind((ObservableValue)this.replySizeHeaderLabel.visibleProperty());
        this.requestSizeHeaderLabel.visibleProperty().bind((ObservableValue)this.requestSizeLabel.visibleProperty());
        this.replySizeHeaderLabel.visibleProperty().bind((ObservableValue)this.replySizeLabel.visibleProperty());
        this.xmlRpcReplySwitchViewButton.setGraphic((Node)fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.BLUE));
        for (Node node : this.xmlRpcReplyStackPane.getChildren()) {
            node.managedProperty().bind((ObservableValue)node.visibleProperty());
        }
        this.xmlRpcSentSwitchViewButton.setGraphic((Node)fontAwesome.create((Enum)FontAwesome.Glyph.EYE).color(Color.BLUE));
        for (Node node : this.xmlRpcSentStackPane.getChildren()) {
            node.managedProperty().bind((ObservableValue)node.visibleProperty());
        }
    }

    public void refreshShowCredentials() {
        this.shownLogChangeListener.changed(this.shownLog, (Object)((SerializableApiCallDetails)this.shownLog.getValue()), (Object)((SerializableApiCallDetails)this.shownLog.getValue()));
    }

    private static Map removeCredentialsFromJsonHt(Map jsonHt, int recurseDepth) {
        if (recurseDepth >= 10) {
            return jsonHt;
        }
        HashMap res = new HashMap();
        Set entrySet = jsonHt.entrySet();
        for (Map.Entry e : entrySet) {
            Object value = e.getValue();
            Object key = e.getKey();
            if (value instanceof Map) {
                Map h = (Map)value;
                res.put(key, LogPanel.removeCredentialsFromJsonHt(h, recurseDepth + 1));
                continue;
            }
            if (value instanceof List) {
                List v = (List)value;
                res.put(key, LogPanel.removeCredentialsFromJsonV(v, recurseDepth + 1));
                continue;
            }
            res.put(key, LogPanel.removeCredentialsFromJsonOtherO(value));
        }
        return res;
    }

    private static List removeCredentialsFromJsonV(List jsonV, int recurseDepth) {
        if (recurseDepth >= 10) {
            return jsonV;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        for (Object value : jsonV) {
            if (value instanceof Map) {
                Map h = (Map)value;
                res.add(LogPanel.removeCredentialsFromJsonHt(h, recurseDepth + 1));
                continue;
            }
            if (value instanceof List) {
                List v = (List)value;
                res.add(LogPanel.removeCredentialsFromJsonV(v, recurseDepth + 1));
                continue;
            }
            res.add(LogPanel.removeCredentialsFromJsonOtherO(value));
        }
        return res;
    }

    private static boolean isCredential(String text) {
        if (text == null) {
            return false;
        }
        String trimmedText = text.trim();
        if (!XmlUtil.couldBeXmlVeryQuickTest((String)trimmedText)) {
            return false;
        }
        String head = trimmedText;
        if (head.length() > 100) {
            head = head.substring(0, 100);
        }
        if (!head.toLowerCase().contains("signed-credential")) {
            return false;
        }
        return XmlUtil.isXmlLikeQuickTest((String)trimmedText);
    }

    private static Object removeCredentialsFromJsonOtherO(Object jsonO) {
        if (jsonO instanceof String && LogPanel.isCredential((String)jsonO)) {
            return "<!-- credential removed for this view. You can show them using the checkbox below. --->";
        }
        if (jsonO instanceof AnyCredential) {
            return "<!-- credential removed for this view. You can show them using the checkbox below. --->";
        }
        return jsonO;
    }

    public static String removeCredentialsFromJson(String jsonString) {
        if (jsonString == null) {
            return "null";
        }
        try {
            Object json = JSonHelper.jsonStringToXmlRpcLikeObject((String)jsonString);
            if (json != null) {
                return LogPanel.removeCredentialsFromJson(json);
            }
        }
        catch (Exception e) {
            LOG.debug("Error when processing JSon for log panel view, will ignore.");
        }
        return jsonString;
    }

    public static String removeCredentialsFromJson(Object json) {
        if (json == null) {
            return "null";
        }
        try {
            Object newjson;
            if (json instanceof Map) {
                Map h = (Map)json;
                newjson = LogPanel.removeCredentialsFromJsonHt(h, 0);
            } else if (json instanceof List) {
                List v = (List)json;
                newjson = LogPanel.removeCredentialsFromJsonV(v, 0);
            } else {
                newjson = LogPanel.removeCredentialsFromJsonOtherO(json);
            }
            return XmlRpcPrintUtil.xmlRpcObjectToString((Object)newjson);
        }
        catch (Exception e) {
            LOG.debug("Error when removing credentials from JSon for log panel view, will ignore.");
        }
        catch (StackOverflowError e) {
            LOG.debug("StackOverflowError when processing JSon for log panel view, will ignore.");
        }
        return XmlRpcPrintUtil.xmlRpcObjectToString((Object)json);
    }

    public void onXmpRpcSentSwitchView() {
        this.switchStackPaneVisibleItem(this.xmlRpcSentStackPane);
    }

    public void onXmpRpcReplySwitchView() {
        this.switchStackPaneVisibleItem(this.xmlRpcReplyStackPane);
    }

    public void switchStackPaneVisibleItem(StackPane sp) {
        int nextVisible = 0;
        ObservableList nodes = sp.getChildren();
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            if (!node.isVisible()) continue;
            nextVisible = i + 1;
            node.setVisible(false);
        }
        if (nextVisible >= nodes.size()) {
            nextVisible = 0;
        }
        if (nextVisible < nodes.size()) {
            ((Node)nodes.get(nextVisible)).setVisible(true);
        }
    }

    private void showResultText(boolean show) {
        if (this.showingResultText == show) {
            return;
        }
        this.showingResultText = show;
        if (!show) {
            this.resultTabContent.getChildren().remove((Object)this.resultTextGroup);
        } else {
            this.resultTabContent.getChildren().add((Object)this.resultTextGroup);
        }
    }

    private void showResultErrorText(boolean show) {
        if (this.showingResultErrorText == show) {
            return;
        }
        this.showingResultErrorText = show;
        if (!show) {
            this.resultTabContent.getChildren().remove((Object)this.resultErrorTextGroup);
        } else {
            this.resultTabContent.getChildren().add((Object)this.resultErrorTextGroup);
        }
    }

    public boolean isHtml(String text) {
        if (text == null) {
            return false;
        }
        String head = text.length() > 100 ? text.substring(0, 100) : text;
        return head.contains("<html") || head.contains("<HTML") || head.contains("<!DOCTYPE HTML");
    }

    private static boolean isXml(String text) {
        return text != null && XmlUtil.isXmlLikeQuickTest((String)text.trim());
    }

    @Contract(value="null -> false")
    private static boolean detectCompressed(@Nullable Object requestObject) {
        if (requestObject == null) {
            return false;
        }
        if (!(requestObject instanceof Object[])) {
            return false;
        }
        Object[] requestObjectArray = (Object[])requestObject;
        if (requestObjectArray.length < 1) {
            return false;
        }
        Object last = requestObjectArray[requestObjectArray.length - 1];
        if (!(last instanceof Map)) {
            return false;
        }
        Map options = (Map)last;
        if (!options.containsKey("geni_compressed")) {
            return false;
        }
        Object isCompressed = options.get("geni_compressed");
        return Objects.equals(isCompressed, Boolean.TRUE);
    }

    private static boolean isRspec(@Nullable String text) {
        LOG.trace("isRspec(" + TextUtil.abbreviate((String)text, (int)20) + ")");
        if (text == null) {
            return false;
        }
        String trimmedText = text.trim();
        if (!XmlUtil.couldBeXmlVeryQuickTest((String)trimmedText)) {
            return false;
        }
        String head = trimmedText;
        if (head.length() > 100) {
            head = head.substring(0, 100);
        }
        if (!head.contains("rspec")) {
            return false;
        }
        return XmlUtil.isXmlLikeQuickTest((String)trimmedText);
    }

    private static void findRspecs(@Nullable Object base, @Nonnull Consumer<String> rspecFoundHandler) {
        if (base == null) {
            return;
        }
        int ocount = 0;
        int rspecCount = 0;
        LinkedList<Object> objectsToCheck = new LinkedList<Object>();
        objectsToCheck.add(base);
        while (!objectsToCheck.isEmpty()) {
            Object o = objectsToCheck.removeLast();
            ++ocount;
            if (o instanceof Map) {
                Map h = (Map)o;
                Set entrySet = h.entrySet();
                for (Map.Entry e : entrySet) {
                    Object key = e.getKey();
                    if (key instanceof String && ((String)key).toLowerCase().endsWith("rspec") && e.getValue() instanceof String) {
                        String decodedValue;
                        String value = (String)e.getValue();
                        if (LogPanel.isRspec(value)) {
                            ++rspecCount;
                            rspecFoundHandler.accept(value);
                            continue;
                        }
                        try {
                            decodedValue = DataConversionUtils.decompressFromBase64((String)value);
                        }
                        catch (Exception ex) {
                            LOG.debug("Ignoring exception when trying to decompress Rspec reply", (Throwable)ex);
                            decodedValue = null;
                        }
                        if (decodedValue == null || !LogPanel.isRspec(decodedValue)) continue;
                        ++rspecCount;
                        rspecFoundHandler.accept(decodedValue);
                        continue;
                    }
                    objectsToCheck.add(e.getValue());
                }
            }
            if (o instanceof List) {
                for (Object val : (List)o) {
                    objectsToCheck.add(val);
                }
            }
            if (!(o instanceof String) || !LogPanel.isRspec((String)o)) continue;
            ++rspecCount;
            rspecFoundHandler.accept((String)o);
        }
        LOG.debug("Rspec find loop checked " + ocount + " objects and found " + rspecCount + " rspecs");
    }

    public void showXml(String text) {
        this.xmlToFormat = text;
        this.xmlText.setText("");
        assert (Platform.isFxApplicationThread());
        if (!this.logTabPane.getTabs().contains((Object)this.xmlTab)) {
            this.logTabPane.getTabs().add((Object)this.xmlTab);
        }
    }

    public void hideRspec() {
        assert (Platform.isFxApplicationThread());
        this.logTabPane.getTabs().removeAll((Object[])new Tab[]{this.rspecTab});
        this.rspecTabContents.clear();
        this.showRspecButtonBox.getChildren().clear();
        this.rspecText.setText("");
    }

    public void showRspec(String location, String text) {
        LOG.trace("showRspec(" + TextUtil.abbreviate((String)text, (int)20) + ")");
        RspecTabContent rspecTabContent = new RspecTabContent(location, text, this.rspecTabContents.size());
        this.rspecTabContents.add(rspecTabContent);
        this.showRspecButtonBox.getChildren().add((Object)rspecTabContent.button);
        this.rspecText.setText("");
        rspecTabContent.button.setOnAction(event -> {
            try {
                this.rspecText.setText(rspecTabContent.getFormattedRspec());
            }
            catch (Exception e) {
                LOG.warn("Exception while formatting RSpec XML, original xml: \"" + rspecTabContent.rawRspec + "\"", (Throwable)e);
                this.rspecText.setText("Exception while formatting RSpec XML:\n\n" + TextUtil.exceptionToString((Throwable)e) + "\n\nOriginal RSpec:\n" + rspecTabContent.rawRspec + "\n");
            }
        });
        assert (Platform.isFxApplicationThread());
        if (this.logTabPane.getTabs().contains((Object)this.xmlTab)) {
            this.logTabPane.getTabs().remove((Object)this.xmlTab);
        }
        if (!this.logTabPane.getTabs().contains((Object)this.rspecTab)) {
            this.logTabPane.getTabs().add((Object)this.rspecTab);
        }
    }

    @FXML
    private void showXmlTextLog() {
        if (this.xmlToFormat != null) {
            try {
                String formattedXml = XmlUtil.formatXmlFromString((String)this.xmlToFormat);
                this.xmlText.setText(formattedXml);
                this.xmlToFormat = null;
            }
            catch (Exception e) {
                LOG.warn("Exception while formatting XML, original xml: \"" + this.xmlToFormat + "\"", (Throwable)e);
                this.xmlText.setText("Exception while formatting XML:\n\n" + TextUtil.exceptionToString((Throwable)e) + "\n\nOriginal xml:\n" + this.xmlToFormat + "\n");
            }
        }
    }

    public void showStitchingOverview(SerializableApiCallDetails callDetails) {
        if (callDetails != null) {
            assert (Platform.isFxApplicationThread());
            if (!this.logTabPane.getTabs().contains((Object)this.stitchingOverviewTab)) {
                this.logTabPane.getTabs().add((Object)this.stitchingOverviewTab);
            }
            String stitchingOverviewText = HtmlLogOutput.makeStitchingOverview((SerializableApiCallDetails)callDetails);
            assert (this.stitchingOverviewTextArea != null);
            this.stitchingOverviewTextArea.setText(stitchingOverviewText);
        }
    }

    public void showExceptionString(String exceptionStackTrace) {
        if (exceptionStackTrace != null) {
            if (!this.logTabPane.getTabs().contains((Object)this.exceptionTab)) {
                this.logTabPane.getTabs().add((Object)this.exceptionTab);
            }
            String exceptionText = exceptionStackTrace + "\n";
            this.shownExceptionText = exceptionText;
            assert (this.exceptionTextField != null);
            this.exceptionTextField.setText(exceptionText);
        }
    }

    @FXML
    private void printException() {
        if (this.shownExceptionText != null) {
            System.err.println(this.shownExceptionText);
        }
    }

    public void showHtml(SerializableApiCallDetails apiCallDetails) {
        this.htmlApiCallDetails = apiCallDetails;
        if (!this.logTabPane.getTabs().contains((Object)this.htmlErrorTab)) {
            this.logTabPane.getTabs().add((Object)this.htmlErrorTab);
        }
    }

    @FXML
    private void showHtmlErrorLog() {
        if (this.htmlApiCallDetails != null) {
            WebEngine webEngine = this.htmlWebView.getEngine();
            webEngine.loadContent(this.htmlApiCallDetails.getHttpResponse());
            this.htmlApiCallDetails = null;
        }
    }

    public void showSpewLogFile(String url) {
        this.spewUrl.setText(url);
        assert (Platform.isFxApplicationThread());
        if (!this.logTabPane.getTabs().contains((Object)this.spewLogTab)) {
            this.logTabPane.getTabs().add((Object)this.spewLogTab);
        }
        this.showSpewLog();
    }

    public void showSpewLog() {
        WebEngine webEngine = this.spewWebView.getEngine();
        LOG.trace("Loading URL into spewWebView: \"" + this.spewUrl.getText() + "\"");
        webEngine.getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
            this.spewWebViewLabel.setText("ProtoGeni Error Log (HTML loading status: " + String.valueOf(newState) + "):");
            if (newState == Worker.State.FAILED) {
                if (this.spewUrl.getText().startsWith("https")) {
                    this.spewWebViewLabel.setText("ProtoGeni Error Log Failed to load. You are using SSL, perhaps the certificate is self-signed? (This is not yet supported when showing logs)");
                } else {
                    this.spewWebViewLabel.setText("ProtoGeni Error Log Failed to load.");
                }
            }
        });
        webEngine.setOnAlert(msg -> LOG.trace("Spew Log onAlert: " + String.valueOf(msg)));
        webEngine.setOnStatusChanged(msg -> LOG.trace("Spew Log onStatusChanged: " + String.valueOf(msg)));
        webEngine.load(this.spewUrl.getText());
    }

    private String getSpew() {
        WebEngine webEngine = this.spewWebView.getEngine();
        Document doc = webEngine.getDocument();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StringWriter sw = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.getBuffer().toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @FXML
    private void saveSpew() {
        this.askSave(this.getSpew(), "txt");
    }

    @FXML
    private void saveXml() {
        this.askSave(this.xmlText.getText(), "xml");
    }

    @FXML
    private void saveRspec() {
        this.askSave(this.rspecText.getText(), "xml");
    }

    @FXML
    private void saveResultText() {
        this.askSave(this.resultText.getText(), "txt");
    }

    @FXML
    private void saveResultError() {
        this.askSave(this.resultErrorText.getText(), "txt");
    }

    @FXML
    private void saveLowLevel() {
        this.askSave(this.lowLevelGeniValueText.getText(), "txt");
    }

    @FXML
    private void saveXmlRpcSent() {
        this.askSave(this.xmlRpcSentText.getText(), "txt");
    }

    @FXML
    private void saveXmlRpcRecv() {
        this.askSave(this.xmlRpcReceivedText.getText(), "txt");
    }

    @FXML
    private void saveHttpSent() {
        this.askSave(this.httpSentText.getText(), "txt");
    }

    @FXML
    private void saveHttpRecv() {
        this.askSave(this.httpReceivedText.getText(), "txt");
    }

    @FXML
    private void formatHttpReplyJson() {
        try {
            String json = this.httpReceivedText.getText();
            Object jsonO = MAPPER.readValue(json, Object.class);
            String formattedJson = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(jsonO);
            this.httpReceivedText.setText(formattedJson);
        }
        catch (IOException e) {
            LOG.warn("Error formatting received JSON for LogPanel. Will ignore. " + e.getMessage());
        }
    }

    @FXML
    private void formatHttpRequestJson() {
        try {
            String json = this.httpSentText.getText();
            Object jsonO = MAPPER.readValue(json, Object.class);
            String formattedJson = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(jsonO);
            this.httpSentText.setText(formattedJson);
        }
        catch (IOException e) {
            LOG.warn("Error formatting request JSON for LogPanel. Will ignore. " + e.getMessage());
        }
    }

    @FXML
    private void saveAll() {
        SerializableApiCallDetails apiCallDetails = (SerializableApiCallDetails)this.shownApiCallDetails.get();
        String text = "Call \"" + apiCallDetails.getGeniMethodName() + "\" in API \"" + apiCallDetails.getApiName() + "\"\n";
        text = text + "Authority: \"" + apiCallDetails.getAuthorityName() + "\" urn=" + apiCallDetails.getAuthorityUrn() + "\n";
        text = text + "Base Server URL: \"" + apiCallDetails.getBaseServerUrl() + "\"\n\n";
        text = text + "Server URL: \"" + apiCallDetails.getCallServerUrl() + "\"\n\n";
        text = text + "Proxy: \"" + String.valueOf(apiCallDetails.getProxyInfo()) + "\"\n\n";
        text = text + "Start time: \"" + String.valueOf(apiCallDetails.getStartTime()) + "\"\n\n";
        text = text + "Stop time: \"" + String.valueOf(apiCallDetails.getStopTime()) + "\"\n\n";
        text = text + "HTTP data sent:\n" + apiCallDetails.getHttpRequest() + "\n\n";
        text = text + "HTTP data recv:\n" + apiCallDetails.getHttpResponse() + "\n\n";
        text = text + "XmlRpc data sent:\n" + apiCallDetails.getXmlRpcRequestJsonString() + "\n\n";
        text = text + "XmlRpc data recv:\n" + apiCallDetails.getXmlRpcResponseJsonString() + "\n\n";
        if (apiCallDetails.getXmlRpcGeniResponseValue() != null) {
            text = text + "Reply recv:\n" + apiCallDetails.getXmlRpcGeniResponseValue() + "\n\n";
        }
        if (apiCallDetails.getProtogeniSpewLogUrl() != null) {
            text = text + "Spew log:\n" + this.getSpew() + "\n\n";
        }
        this.askSave(text, "txt");
    }

    @FXML
    private void saveAllAsXml() {
        SerializableApiCallDetails apiCallDetails = (SerializableApiCallDetails)this.shownApiCallDetails.get();
        StringWriter sw = new StringWriter();
        try {
            Marshaller m = JAXBContext.newInstance((Class[])new Class[]{SerializableApiCallDetails.class}).createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)apiCallDetails, (Writer)sw);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        String xml = sw.getBuffer().toString();
        this.askSave(xml, "xml");
    }

    @FXML
    private void saveAllAsHtml() {
        SerializableApiCallDetails apiCallDetails = (SerializableApiCallDetails)this.shownApiCallDetails.get();
        SingleCallHtmlLogOutput htmlOutput = new SingleCallHtmlLogOutput("call", apiCallDetails);
        String htmlContent = htmlOutput.toHtmlString(true, true);
        this.askSave(htmlContent, "html");
    }

    private void askSave(String text, String ext) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save " + ext);
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(ext + " Files", new String[]{"*." + ext}), new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
        File file = fileChooser.showSaveDialog(null);
        if (file != null) {
            try {
                IOUtils.stringToFileWithEx((File)file, (String)text);
            }
            catch (Exception e) {
                new Alert(Alert.AlertType.ERROR, "Failed to save file: " + e.getMessage(), new ButtonType[0]).show();
            }
        }
    }

    private class RspecTabContent {
        public final String location;
        public final String rawRspec;
        public String formattedRspec;
        public final Button button;
        public final int index;

        public RspecTabContent(String location, String rawRspec, int index) {
            this.location = location;
            this.rawRspec = rawRspec;
            this.index = index;
            this.button = new Button(this.toString());
        }

        public String getFormattedRspec() {
            if (this.formattedRspec == null) {
                this.formattedRspec = XmlUtil.formatXmlFromString((String)this.rawRspec);
            }
            return this.formattedRspec;
        }

        public String toString() {
            return this.location + " Rspec " + this.index;
        }
    }

    private static class SingleCallHtmlLogOutput
    extends HtmlLogOutput {
        private final SerializableApiCallDetails apiCallDetails;

        public SingleCallHtmlLogOutput(String reportTitle, SerializableApiCallDetails apiCallDetails) {
            super(reportTitle);
            this.apiCallDetails = apiCallDetails;
        }

        public void htmlContent(HtmlCanvas html) throws IOException {
            int index = 0;
            SingleCallHtmlLogOutput.writeGroup((HtmlCanvas)html, (int)index, (LogOutput.TestResultState)LogOutput.TestResultState.SUCCESS, (String)this.apiCallDetails.getGeniMethodName(), (String)this.apiCallDetails.getGeniResponseCodeDescription(), (long)0L, (Date)this.apiCallDetails.getStartTime(), (Date)this.apiCallDetails.getStopTime(), (String)this.apiCallDetails.getExceptionString(), Collections.singletonList(this.apiCallDetails), Collections.emptyList());
        }
    }
}

