/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.log_gui;

import be.iminds.ilabt.jfed.util.library.JSonHelper;
import be.iminds.ilabt.jfed.util.library.XmlRpcPrintUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.paint.Color;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlRpcPane
extends TreeView<javax.swing.tree.TreeNode> {
    private static final Logger LOG = LoggerFactory.getLogger(XmlRpcPane.class);
    private Object obj;
    private TreeNode rootTreeNode;
    private static final GlyphFont fontAwesome = GlyphFontRegistry.font((String)"FontAwesome");

    public Object getObj() {
        return this.obj;
    }

    public void setObj(Object obj) {
        this.obj = obj;
        this.updateObj();
    }

    public Object getObjString() {
        return XmlRpcPrintUtil.xmlRpcObjectToString((Object)this.obj);
    }

    public void setObjString(String xmlRpcString) {
        this.setObj(JSonHelper.jsonStringToXmlRpcLikeObject((String)xmlRpcString));
    }

    public void updateObj() {
        this.rootTreeNode = new TreeNode(null, this.obj);
        LinkedList<TreeNode> nodesToRecurse = new LinkedList<TreeNode>();
        if (!this.rootTreeNode.isLeaf()) {
            nodesToRecurse.add(this.rootTreeNode);
        }
        while (!nodesToRecurse.isEmpty()) {
            TreeNode next = (TreeNode)nodesToRecurse.removeFirst();
            next.createChildren().stream().filter(child -> !child.isLeaf()).forEach(nodesToRecurse::addLast);
        }
        this.rootProperty().setValue((Object)this.rootTreeNode.treeItem);
        this.expandOrCollapseBasedOnItemLength();
    }

    private static Node getIcon(Object o) {
        if (o == null) {
            return fontAwesome.create((Enum)FontAwesome.Glyph.BOMB).color(Color.RED);
        }
        if (o instanceof String) {
            return fontAwesome.create((Enum)FontAwesome.Glyph.PENCIL).color(Color.GREEN);
        }
        if (o instanceof Map) {
            return fontAwesome.create((Enum)FontAwesome.Glyph.TH_LIST).color(Color.BLUE);
        }
        if (o instanceof Map.Entry) {
            return fontAwesome.create((Enum)FontAwesome.Glyph.TH_LIST).color(Color.BLUE);
        }
        if (o instanceof List) {
            return fontAwesome.create((Enum)FontAwesome.Glyph.LIST_ALT).color(Color.BLUE);
        }
        if (o instanceof Integer) {
            return fontAwesome.create((Enum)FontAwesome.Glyph.LIST_OL).color(Color.GREEN);
        }
        if (o instanceof Double) {
            return fontAwesome.create((Enum)FontAwesome.Glyph.LIST_OL).color(Color.GREEN);
        }
        if (o instanceof Boolean) {
            return fontAwesome.create((Enum)FontAwesome.Glyph.STOP).color(Color.GREEN);
        }
        return fontAwesome.create((Enum)FontAwesome.Glyph.BOMB).color(Color.RED);
    }

    private static String objectToString(Object o) {
        if (o == null) {
            return "empty";
        }
        if (o instanceof Map.Entry) {
            Object key = ((Map.Entry)o).getKey();
            Object value = ((Map.Entry)o).getValue();
            if (value instanceof Map || value instanceof List) {
                return XmlRpcPane.objectToString(key);
            }
            String valueAsString = XmlRpcPane.objectToString(value);
            if (valueAsString.length() < 100) {
                return XmlRpcPane.objectToString(key) + " -> " + valueAsString;
            }
            return XmlRpcPane.objectToString(key);
        }
        if (o instanceof String) {
            return "\"" + String.valueOf(o) + "\"";
        }
        if (o instanceof Map) {
            return "struct with " + ((Map)o).size() + " items";
        }
        if (o instanceof List) {
            return "list with " + ((List)o).size() + " items";
        }
        if (o instanceof Integer) {
            return String.valueOf(o);
        }
        if (o instanceof Double) {
            return String.valueOf(o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? "true" : "false";
        }
        return "unknown! toString=\"" + String.valueOf(o) + "\"";
    }

    public void expandAll() {
        LinkedList<TreeNode> nodesToCheck = new LinkedList<TreeNode>();
        nodesToCheck.add(this.rootTreeNode);
        while (!nodesToCheck.isEmpty()) {
            TreeNode n = (TreeNode)nodesToCheck.removeFirst();
            n.treeItem.setExpanded(true);
            for (TreeNode c : n.children) {
                nodesToCheck.add(c);
            }
        }
    }

    public void collapseAll() {
        LinkedList<TreeNode> nodesToCheck = new LinkedList<TreeNode>();
        nodesToCheck.add(this.rootTreeNode);
        while (!nodesToCheck.isEmpty()) {
            TreeNode n = (TreeNode)nodesToCheck.removeFirst();
            n.treeItem.setExpanded(false);
            for (TreeNode c : n.children) {
                nodesToCheck.add(c);
            }
        }
    }

    public void collapseOnlyLongItems() {
        LinkedList<TreeNode> nodesToCheck = new LinkedList<TreeNode>();
        nodesToCheck.add(this.rootTreeNode);
        while (!nodesToCheck.isEmpty()) {
            TreeNode n = (TreeNode)nodesToCheck.removeFirst();
            if (n.isLong()) {
                n.treeItem.setExpanded(false);
            }
            for (TreeNode c : n.children) {
                nodesToCheck.add(c);
            }
        }
    }

    public void expandOnlyShortItems() {
        LinkedList<TreeNode> nodesToCheck = new LinkedList<TreeNode>();
        nodesToCheck.add(this.rootTreeNode);
        while (!nodesToCheck.isEmpty()) {
            TreeNode n = (TreeNode)nodesToCheck.removeFirst();
            if (!n.isLong()) {
                n.treeItem.setExpanded(true);
            }
            for (TreeNode c : n.children) {
                nodesToCheck.add(c);
            }
        }
    }

    public void expandOrCollapseBasedOnItemLength() {
        LinkedList<TreeNode> nodesToCheck = new LinkedList<TreeNode>();
        nodesToCheck.add(this.rootTreeNode);
        while (!nodesToCheck.isEmpty()) {
            TreeNode n = (TreeNode)nodesToCheck.removeFirst();
            n.treeItem.setExpanded(!n.isLong());
            for (TreeNode c : n.children) {
                nodesToCheck.add(c);
            }
        }
    }

    private static class TreeNode {
        private final TreeItem treeItem;
        private final TreeNode parent;
        private final List<TreeNode> children = new ArrayList<TreeNode>();
        private final Object o;
        private final String typeText;
        private final String text;
        private final boolean leaf;

        private TreeNode(TreeNode parent, Object o) {
            this.o = o;
            this.parent = parent;
            Object t = null;
            String tt = null;
            Node icon = XmlRpcPane.getIcon(o);
            boolean leaf = true;
            if (o == null) {
                t = "empty";
                tt = "empty";
            } else {
                if (o instanceof Map.Entry) {
                    tt = "entry";
                    Object key = ((Map.Entry)o).getKey();
                    Object value = ((Map.Entry)o).getValue();
                    if (value instanceof Map || value instanceof List) {
                        leaf = false;
                        t = XmlRpcPane.objectToString(key);
                        icon = XmlRpcPane.getIcon(key);
                    } else {
                        String valueAsString = XmlRpcPane.objectToString(value);
                        if (valueAsString.length() < 100) {
                            leaf = true;
                            t = XmlRpcPane.objectToString(key) + " -> " + valueAsString;
                            icon = XmlRpcPane.getIcon(value);
                        } else {
                            leaf = false;
                            icon = XmlRpcPane.getIcon(key);
                            t = XmlRpcPane.objectToString(key);
                        }
                    }
                }
                if (o instanceof String) {
                    t = XmlRpcPane.objectToString(o);
                    tt = "string";
                }
                if (o instanceof Map) {
                    t = XmlRpcPane.objectToString(o);
                    tt = "struct";
                    leaf = false;
                }
                if (o instanceof List) {
                    t = XmlRpcPane.objectToString(o);
                    tt = "list";
                    leaf = false;
                }
                if (o instanceof Integer) {
                    t = XmlRpcPane.objectToString(o);
                    tt = "integer";
                }
                if (o instanceof Double) {
                    t = XmlRpcPane.objectToString(o);
                    tt = "double";
                }
                if (o instanceof Boolean) {
                    t = XmlRpcPane.objectToString(o);
                    tt = "boolean";
                }
            }
            if (t != null) {
                this.text = t;
                assert (tt != null);
                this.typeText = tt;
            } else {
                LOG.warn("Unknown type in XmlRpc object: " + o.getClass().getName());
                this.text = "unknown! toString=\"" + String.valueOf(o) + "\"";
                this.typeText = String.valueOf(o.getClass());
            }
            this.leaf = leaf;
            this.treeItem = new TreeItem((Object)this, icon);
        }

        TreeNode createChild(Object o) {
            TreeNode child = new TreeNode(this, o);
            this.children.add(child);
            this.treeItem.getChildren().add((Object)child.treeItem);
            return child;
        }

        List<TreeNode> createChildren() {
            assert (!this.isLeaf());
            ArrayList<TreeNode> children = new ArrayList<TreeNode>();
            if (this.o instanceof List) {
                List v = (List)this.o;
                for (Object e : v) {
                    children.add(this.createChild(e));
                }
            }
            if (this.o instanceof Map) {
                Map ht = (Map)this.o;
                for (Object object : ht.entrySet()) {
                    children.add(this.createChild(object));
                }
            }
            if (this.o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)this.o;
                children.add(this.createChild(e.getValue()));
                this.treeItem.setExpanded(true);
            }
            return children;
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public String getTypeText() {
            return this.typeText;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return this.text;
        }

        public boolean isLong() {
            if (this.leaf) {
                return this.text.length() > 200;
            }
            for (TreeNode child : this.children) {
                if (!child.isLeaf() || !child.isLong()) continue;
                return true;
            }
            return false;
        }
    }
}

