/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.userlogin;

import be.iminds.ilabt.jfed.base_gui.util.JFedCommonDialogs;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty.PpkHelper;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.KeyCertFileUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.KeyCertUrlUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.ManualUserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfo;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.UserLoginInfoManager;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidLoginException;
import be.iminds.ilabt.jfed.ui.javafx.choosers.ServerChooser;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.ui.javafx.x509_certificate_gui.X509CertificatePanel;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedUserLoginController {
    private static final Logger LOG = LoggerFactory.getLogger(AdvancedUserLoginController.class);
    private final UserLoginInfoManager userLoginInfoManager;
    private final UserLoginInfoFactory userLoginInfoFactory;
    private final AuthorityFinder authorityFinder;
    private final ObjectProperty<UserLoginInfo> userLoginInfo = new SimpleObjectProperty();
    private final boolean requireAllUserInfo;
    @FXML
    private Parent defaultLoginPanel;
    @FXML
    private RadioButton pemKeyCertInputFromFileRadioButton;
    @FXML
    private RadioButton pemKeyCertInputFromURLRadioButton;
    @FXML
    private RadioButton pemKeyCertInputFromStringRadioButton;
    @FXML
    private Button pemKeyCertInputFromFileLoadButton;
    @FXML
    private Button pemKeyCertInputFromURLLoadButton;
    @FXML
    private HBox defaultLoginPanelPasswordBox;
    @FXML
    private Button defaultLoginPanelPasswordButton;
    @FXML
    private TextArea pemKeyCertContentTextArea;
    @FXML
    private TextField defaultLoginPanelPassword;
    @FXML
    private TextField pemKeyCertInputFromFileField;
    @FXML
    private HBox pemKeyCertInputFromFileBox;
    @FXML
    private TextField pemKeyCertInputFromURLField;
    @FXML
    private HBox pemKeyCertInputFromURLBox;
    @FXML
    private Label defaultLoginPanelSliceAuthName;
    @FXML
    private Label defaultLoginPanelSliceAuthUrn;
    @FXML
    private Label defaultLoginPanelUsername;
    @FXML
    private Label defaultLoginPanelUserUrn;
    @FXML
    private Button loginButton;
    @FXML
    private Button logoutButton;
    @FXML
    private VBox errorLogBox;
    @FXML
    private TextArea errorLog;
    @FXML
    private Label missingInfoWarningLabel;
    @FXML
    private Label missingInfoErrorLabel;
    @FXML
    private Parent derivedCertificateDetails;
    @FXML
    private Parent manualCertificateDetails;
    @FXML
    private ServerChooser defaultLoginPanelSliceAuthNameChooserController;
    @FXML
    private TextField defaultLoginPanelUserUrnField;
    @FXML
    private RadioButton loginTypeKeyCertAutoRadioButton;
    @FXML
    private RadioButton loginTypeKeyCertManualRadioButton;
    @FXML
    private Button certificateDetailsButton;
    private boolean blockModelToGUI_eventhelper = false;
    private boolean blockTextAreaUpdate_eventhelper = false;
    private GeniUser result = null;

    @Inject
    public AdvancedUserLoginController(UserLoginInfoManager userLoginInfoManager, UserLoginInfoFactory userLoginInfoFactory, AuthorityFinder authorityFinder, @Named(value="loginRequiresAlluserInfo") Boolean loginRequiresAlluserInfo) {
        this.userLoginInfoManager = userLoginInfoManager;
        this.userLoginInfoFactory = userLoginInfoFactory;
        this.authorityFinder = authorityFinder;
        this.requireAllUserInfo = loginRequiresAlluserInfo;
    }

    @FXML
    public void initialize() {
        this.derivedCertificateDetails.visibleProperty().bind((ObservableValue)this.loginTypeKeyCertAutoRadioButton.selectedProperty());
        this.manualCertificateDetails.visibleProperty().bind((ObservableValue)this.loginTypeKeyCertManualRadioButton.selectedProperty());
        this.pemKeyCertInputFromFileBox.visibleProperty().bind((ObservableValue)this.pemKeyCertInputFromFileRadioButton.selectedProperty());
        this.pemKeyCertContentTextArea.editableProperty().bind((ObservableValue)this.pemKeyCertInputFromStringRadioButton.selectedProperty());
        this.pemKeyCertInputFromURLBox.visibleProperty().bind((ObservableValue)this.pemKeyCertInputFromURLRadioButton.selectedProperty());
        this.userLoginInfo.addListener(observable -> this.modelToGUI());
        this.defaultLoginPanelPasswordBox.managedProperty().bind((ObservableValue)this.defaultLoginPanelPasswordBox.visibleProperty());
        this.loginButton.managedProperty().bind((ObservableValue)this.loginButton.visibleProperty());
        this.pemKeyCertInputFromFileBox.managedProperty().bind((ObservableValue)this.pemKeyCertInputFromFileBox.visibleProperty());
        this.pemKeyCertInputFromURLBox.managedProperty().bind((ObservableValue)this.pemKeyCertInputFromURLBox.visibleProperty());
        this.errorLogBox.managedProperty().bind((ObservableValue)this.errorLogBox.visibleProperty());
        this.errorLog.managedProperty().bind((ObservableValue)this.errorLog.visibleProperty());
        this.errorLogBox.visibleProperty().bind((ObservableValue)this.errorLog.textProperty().isNotEmpty());
        this.derivedCertificateDetails.managedProperty().bind((ObservableValue)this.derivedCertificateDetails.visibleProperty());
        this.manualCertificateDetails.managedProperty().bind((ObservableValue)this.manualCertificateDetails.visibleProperty());
        this.missingInfoWarningLabel.managedProperty().bind((ObservableValue)this.missingInfoWarningLabel.visibleProperty());
        this.missingInfoErrorLabel.managedProperty().bind((ObservableValue)this.missingInfoErrorLabel.visibleProperty());
        this.defaultLoginPanel.managedProperty().bind((ObservableValue)this.defaultLoginPanel.visibleProperty());
        this.errorLog.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.pemKeyCertContentTextArea.textProperty().addListener(observable -> this.onPemEdit());
        this.defaultLoginPanelSliceAuthNameChooserController.selectedAuthorityProperty().addListener((observableValue, oldAuthInfo, newAuthInfo) -> {
            GeniUrn authUrn;
            if (!GeniUrn.valid((String)this.defaultLoginPanelUserUrnField.getText()) && (authUrn = GeniUrn.parse((String)newAuthInfo.getDefaultComponentManagerUrn())) != null) {
                GeniUrn templateUrn = GeniUrn.createGeniUrnFromEncodedParts((String)authUrn.getEncodedTopLevelAuthority(), (String)"user", (String)"<username>");
                this.defaultLoginPanelUserUrnField.setText(templateUrn.toString());
            }
        });
        this.defaultLoginPanelUserUrnField.textProperty().addListener((observableValue, oldUrn, newUrn) -> {
            Server newUserAuthority;
            if (this.blockModelToGUI_eventhelper) {
                return;
            }
            GeniUrn newUserUrn = GeniUrn.parse((String)newUrn);
            if (newUserUrn != null && (newUserAuthority = this.authorityFinder.findByUrn(newUserUrn, AuthorityFinder.Purpose.FIND_USERAUTH)) != null) {
                this.defaultLoginPanelSliceAuthNameChooserController.select(newUserAuthority);
            }
        });
        this.certificateDetailsButton.disableProperty().bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{AdvancedUserLoginController.this.userLoginInfo});
            }

            protected boolean computeValue() {
                return AdvancedUserLoginController.this.userLoginInfo.get() == null || ((UserLoginInfo)AdvancedUserLoginController.this.userLoginInfo.get()).getCertificateChain() == null || ((UserLoginInfo)AdvancedUserLoginController.this.userLoginInfo.get()).getCertificateChain().isEmpty();
            }
        });
        this.loadConfig();
    }

    private static void setValidationStyle(Parent p, ValidationStyle validationStyle) {
        String styleName = switch (validationStyle.ordinal()) {
            case 0 -> "validation_error";
            case 1 -> "validation_warning";
            case 2 -> null;
            case 3 -> "validation_explicit_ok";
            default -> throw new RuntimeException("Unsupported ValidationStyle");
        };
        ArrayList<String> otherStyles = new ArrayList<String>();
        otherStyles.add("validation_error");
        otherStyles.add("validation_warning");
        otherStyles.add("validation_explicit_ok");
        if (styleName != null) {
            otherStyles.remove(styleName);
        }
        p.getStyleClass().removeAll(otherStyles);
        if (styleName != null && !p.getStyleClass().contains((Object)styleName)) {
            p.getStyleClass().add((Object)styleName);
        }
    }

    private static boolean isMinimalLoginInfoAvailable(UserLoginInfo userLoginInfo) {
        if (userLoginInfo == null) {
            return false;
        }
        if (userLoginInfo.getCertificateContent() == null) {
            return false;
        }
        if (userLoginInfo.getCertificateChain() == null) {
            return false;
        }
        return !userLoginInfo.getCertificateChain().isEmpty();
    }

    @FXML
    private void selectLoginType() {
        if (this.blockModelToGUI_eventhelper) {
            return;
        }
        UserLoginInfo prevLoginInfo = (UserLoginInfo)this.userLoginInfo.get();
        ManualUserLoginInfo newLoginInfo = null;
        if (this.loginTypeKeyCertAutoRadioButton.isSelected()) {
            if (prevLoginInfo instanceof ManualUserLoginInfo) {
                newLoginInfo = this.userLoginInfoFactory.createManualUserLoginInfo(prevLoginInfo.getCertificateContent());
            } else if (prevLoginInfo instanceof KeyCertFileUserLoginInfo) {
                try {
                    newLoginInfo = this.userLoginInfoFactory.createKeyCertFileUserLoginInfo(((KeyCertFileUserLoginInfo)prevLoginInfo).getFile());
                }
                catch (IOException e) {
                    LOG.error("Could not convert File UserLoginInfo", (Throwable)e);
                }
            } else if (prevLoginInfo instanceof KeyCertUrlUserLoginInfo) {
                try {
                    newLoginInfo = this.userLoginInfoFactory.createKeyCertUrlUserLoginInfo(((KeyCertUrlUserLoginInfo)prevLoginInfo).getUrl());
                }
                catch (IOException e) {
                    LOG.error("Could not convert URL UserLoginInfo", (Throwable)e);
                }
            } else {
                newLoginInfo = this.userLoginInfoFactory.createManualUserLoginInfo((String)null);
            }
        } else if (this.loginTypeKeyCertManualRadioButton.isSelected()) {
            if (prevLoginInfo instanceof ManualUserLoginInfo) {
                newLoginInfo = this.userLoginInfoFactory.createManualUserLoginInfo(prevLoginInfo.getCertificateContent(), prevLoginInfo.getUserUrn(), prevLoginInfo.getUserAuthorityServer());
            } else if (prevLoginInfo instanceof KeyCertFileUserLoginInfo) {
                try {
                    newLoginInfo = this.userLoginInfoFactory.createKeyCertFileUserLoginInfo(((KeyCertFileUserLoginInfo)prevLoginInfo).getFile(), prevLoginInfo.getUserUrn(), prevLoginInfo.getUserAuthorityServer());
                }
                catch (IOException e) {
                    LOG.error("Could not convert File UserLoginInfo", (Throwable)e);
                }
            } else if (prevLoginInfo instanceof KeyCertUrlUserLoginInfo) {
                try {
                    newLoginInfo = this.userLoginInfoFactory.createKeyCertUrlUserLoginInfo(((KeyCertUrlUserLoginInfo)prevLoginInfo).getUrl(), prevLoginInfo.getUserUrn(), prevLoginInfo.getUserAuthorityServer());
                }
                catch (IOException e) {
                    LOG.error("Could not convert URL UserLoginInfo", (Throwable)e);
                }
            } else {
                newLoginInfo = this.userLoginInfoFactory.createManualUserLoginInfo(null, GeniUrn.parse((String)this.defaultLoginPanelUserUrnField.getText()), this.defaultLoginPanelSliceAuthNameChooserController.getSelectedServer());
            }
        }
        this.userLoginInfo.set(newLoginInfo);
        this.modelToGUI();
    }

    private void clearError() {
        this.errorLog.setText("");
    }

    protected void guiToModel() {
        if (this.loginTypeKeyCertAutoRadioButton.isSelected()) {
            if (this.pemKeyCertInputFromFileRadioButton.isSelected()) {
                File keyCertFile = new File(this.pemKeyCertInputFromFileField.getText());
                try {
                    this.userLoginInfo.set((Object)this.userLoginInfoFactory.createKeyCertFileUserLoginInfo(keyCertFile));
                }
                catch (IOException e) {
                    LOG.error("Could not read keyCertFile", (Throwable)e);
                }
            } else {
                this.userLoginInfo.set((Object)this.userLoginInfoFactory.createManualUserLoginInfo(this.pemKeyCertContentTextArea.getText()));
            }
        } else {
            GeniUrn userUrn = GeniUrn.parse((String)this.defaultLoginPanelUserUrnField.getText());
            Server userAuthority = this.defaultLoginPanelSliceAuthNameChooserController.getSelectedServer();
            if (this.pemKeyCertInputFromFileRadioButton.isSelected()) {
                File keyCertFile = new File(this.pemKeyCertInputFromFileField.getText());
                try {
                    this.userLoginInfo.set((Object)this.userLoginInfoFactory.createKeyCertFileUserLoginInfo(keyCertFile, userUrn, userAuthority));
                }
                catch (IOException e) {
                    LOG.error("Could not read KeyCertFile", (Throwable)e);
                }
            } else {
                this.userLoginInfo.set((Object)this.userLoginInfoFactory.createManualUserLoginInfo(this.pemKeyCertContentTextArea.getText(), userUrn, userAuthority));
            }
        }
    }

    protected void modelToGUI() {
        if (this.blockModelToGUI_eventhelper) {
            return;
        }
        this.blockModelToGUI_eventhelper = true;
        this.modelToGUI_input();
        this.modelToGUI_derived();
        this.blockModelToGUI_eventhelper = false;
    }

    protected void modelToGUI_input() {
        UserLoginInfo userLoginInfo = (UserLoginInfo)this.userLoginInfo.get();
        if (userLoginInfo == null) {
            this.loginTypeKeyCertAutoRadioButton.setSelected(true);
            this.pemKeyCertInputFromFileRadioButton.setSelected(true);
            this.pemKeyCertInputFromFileField.setText("");
            this.pemKeyCertInputFromURLField.setText("");
            this.pemKeyCertContentTextArea.setText("");
            return;
        }
        if (userLoginInfo.isUserAndAuthorityProvidedSeperately()) {
            this.loginTypeKeyCertManualRadioButton.setSelected(true);
        } else {
            this.loginTypeKeyCertAutoRadioButton.setSelected(true);
        }
        if (userLoginInfo instanceof KeyCertFileUserLoginInfo) {
            this.pemKeyCertInputFromFileRadioButton.setSelected(true);
            KeyCertFileUserLoginInfo keyCertFileUserLoginInfo = (KeyCertFileUserLoginInfo)userLoginInfo;
            if (keyCertFileUserLoginInfo.getFile() != null) {
                this.pemKeyCertInputFromFileField.setText(keyCertFileUserLoginInfo.getFile().getAbsolutePath());
            } else {
                this.pemKeyCertInputFromFileField.setText("");
            }
        } else if (userLoginInfo instanceof KeyCertUrlUserLoginInfo) {
            this.pemKeyCertInputFromURLRadioButton.setSelected(true);
            KeyCertUrlUserLoginInfo keyCertUrlUserLoginInfo = (KeyCertUrlUserLoginInfo)userLoginInfo;
            if (keyCertUrlUserLoginInfo.getUrl() != null) {
                this.pemKeyCertInputFromURLField.setText(keyCertUrlUserLoginInfo.getUrl().toExternalForm());
            } else {
                this.pemKeyCertInputFromURLField.setText("");
            }
        } else if (userLoginInfo instanceof ManualUserLoginInfo) {
            this.pemKeyCertInputFromStringRadioButton.setSelected(true);
            this.pemKeyCertInputFromFileField.setText("");
            this.pemKeyCertInputFromURLField.setText("");
        }
        if (!this.blockTextAreaUpdate_eventhelper) {
            this.pemKeyCertContentTextArea.setText(userLoginInfo.getCertificateContent());
        }
        if (userLoginInfo.getUserUrn() != null) {
            this.defaultLoginPanelUserUrnField.setText(userLoginInfo.getUserUrn().toString());
        }
        if (userLoginInfo.getUserAuthorityServer() != null) {
            this.defaultLoginPanelSliceAuthNameChooserController.select(userLoginInfo.getUserAuthorityServer());
        }
        if (userLoginInfo.getError() != null) {
            this.showError(userLoginInfo.getError());
        } else {
            this.clearError();
        }
    }

    protected void modelToGUI_derived() {
        boolean missingInfo;
        UserLoginInfo userLoginInfo = (UserLoginInfo)this.userLoginInfo.get();
        if (userLoginInfo != null) {
            if (userLoginInfo.getUserUrn() != null) {
                this.defaultLoginPanelUserUrn.setText(userLoginInfo.getUserUrn().toString());
                this.defaultLoginPanelUsername.setText(userLoginInfo.getUserUrn().getEncodedResourceName());
            } else {
                this.defaultLoginPanelUserUrn.setText("-");
                this.defaultLoginPanelUsername.setText("-");
            }
            if (userLoginInfo.getUserAuthorityServer() != null) {
                this.defaultLoginPanelSliceAuthUrn.setText(userLoginInfo.getUserAuthorityServer().getDefaultComponentManagerUrn());
                this.defaultLoginPanelSliceAuthName.setText(userLoginInfo.getUserAuthorityServer().getName());
            } else {
                this.defaultLoginPanelSliceAuthUrn.setText("-");
                this.defaultLoginPanelSliceAuthName.setText("-");
            }
            this.defaultLoginPanelPasswordBox.setVisible(userLoginInfo.isValid() && !userLoginInfo.isUnlocked());
        }
        boolean bl = missingInfo = userLoginInfo == null || userLoginInfo.getUserAuthorityServer() == null || userLoginInfo.getUserUrn() == null;
        if (this.requireAllUserInfo) {
            this.missingInfoWarningLabel.setVisible(false);
            this.missingInfoErrorLabel.setVisible(AdvancedUserLoginController.isMinimalLoginInfoAvailable(userLoginInfo) && missingInfo);
        } else {
            this.missingInfoWarningLabel.setVisible(AdvancedUserLoginController.isMinimalLoginInfoAvailable(userLoginInfo) && missingInfo);
            this.missingInfoErrorLabel.setVisible(false);
        }
        LOG.debug("missingInfo=" + missingInfo + " requireAllUserInfo=" + this.requireAllUserInfo);
        this.updateLoginButtonEnabled();
    }

    @FXML
    public void selectInputMethod() {
        LOG.trace("selectInputMethod blockModelToGUI_eventhelper={} userLoginInfo.class={}", (Object)this.blockModelToGUI_eventhelper, (Object)(this.userLoginInfo.get() != null ? ((UserLoginInfo)this.userLoginInfo.get()).getClass().getName() : "null"));
        if (this.blockModelToGUI_eventhelper) {
            return;
        }
        UserLoginInfo prevUserLoginInfo = (UserLoginInfo)this.userLoginInfo.get();
        if (this.pemKeyCertInputFromStringRadioButton.isSelected()) {
            if (prevUserLoginInfo != null) {
                this.userLoginInfo.set((Object)this.userLoginInfoFactory.createManualUserLoginInfo(prevUserLoginInfo));
            }
        } else if (this.pemKeyCertInputFromFileRadioButton.isSelected()) {
            File certificateFile = new File(this.pemKeyCertInputFromFileField.getText());
            if (certificateFile.exists()) {
                this.loadCertificateFile(certificateFile);
            } else {
                try {
                    this.userLoginInfo.set((Object)this.userLoginInfoFactory.createKeyCertFileUserLoginInfo(null));
                }
                catch (IOException iOException) {}
            }
        } else if (this.pemKeyCertInputFromURLRadioButton.isSelected()) {
            if (!this.pemKeyCertInputFromURLField.getText().isEmpty()) {
                this.loadCertificateURL();
            } else {
                try {
                    this.userLoginInfo.set((Object)this.userLoginInfoFactory.createKeyCertUrlUserLoginInfo(null));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void showError(Exception e) {
        this.showError(e.getMessage());
    }

    public void onPemEdit() {
        if (this.blockModelToGUI_eventhelper) {
            return;
        }
        this.blockTextAreaUpdate_eventhelper = true;
        this.guiToModel();
        this.blockTextAreaUpdate_eventhelper = false;
    }

    @FXML
    public void showCertificateDetailsWindow() {
        String keyCertContent = ((UserLoginInfo)this.userLoginInfo.get()).getCertificateContent();
        if (keyCertContent != null) {
            X509CertificatePanel.showX509Certificate(keyCertContent);
        }
    }

    @FXML
    public void unlockAndLogin() {
        try {
            char[] password = ((UserLoginInfo)this.userLoginInfo.get()).isUnlocked() ? null : this.defaultLoginPanelPassword.getText().toCharArray();
            GeniUser loggedInUser = ((UserLoginInfo)this.userLoginInfo.get()).login(password);
            if (password != null) {
                PpkHelper.makePpkIfNeeded((GeniUser)loggedInUser, (String)new String(password));
            }
            this.processLoggedInUser(loggedInUser);
        }
        catch (InvalidLoginException e) {
            UserLoginInfo userLoginInfo = (UserLoginInfo)this.userLoginInfo.get();
            LOG.debug("userLoginInfoManager.unlockAndLogin() not successful unlocked={}\n\tgetClass().getName()={}\n\tisMinimalLoginInfoAvailable()={}\n\tm.getUserAuthority() == null={}\n\tm.getUserUrn() == null={}\n\trequireAllUserInfo={}", new Object[]{userLoginInfo.isUnlocked(), userLoginInfo.getClass().getName(), AdvancedUserLoginController.isMinimalLoginInfoAvailable(userLoginInfo), userLoginInfo.getUserAuthorityServer() == null, userLoginInfo.getUserUrn() == null, this.requireAllUserInfo, e});
        }
    }

    private boolean loginWithoutPasswordAllowed() {
        UserLoginInfo userLoginInfo = (UserLoginInfo)this.userLoginInfo.get();
        if (userLoginInfo == null) {
            return false;
        }
        LOG.debug("loginWithoutPasswordAllowed() ->  isMinimalLoginInfoAvailable={} (getUserUrn() == null) = {} (getUserAuthorityServer() == null) = {} requireAllUserInfo={}", new Object[]{AdvancedUserLoginController.isMinimalLoginInfoAvailable(userLoginInfo), userLoginInfo.getUserUrn() == null, userLoginInfo.getUserAuthorityServer() == null, this.requireAllUserInfo});
        if (!AdvancedUserLoginController.isMinimalLoginInfoAvailable(userLoginInfo)) {
            return false;
        }
        if (this.requireAllUserInfo) {
            if (userLoginInfo.getUserUrn() == null) {
                return false;
            }
            if (userLoginInfo.getUserAuthorityServer() == null) {
                return false;
            }
        }
        return userLoginInfo.isUnlocked() || this.defaultLoginPanelPassword.getText() != null;
    }

    public void updateLoginButtonEnabled() {
        this.loginButton.setDisable(!this.loginWithoutPasswordAllowed());
    }

    private void showError(String error) {
        if (error != null) {
            this.errorLog.setText(error);
        } else {
            this.clearError();
        }
    }

    private void processLoggedInUser(GeniUser loggedInUser) {
        String problem;
        LOG.debug("Advanced User Login window 'login'");
        UserLoginInfo newUserLoginInfo = (UserLoginInfo)this.userLoginInfo.get();
        UserLoginInfo prevUserLoginInfo = null;
        try {
            prevUserLoginInfo = this.userLoginInfoManager.load();
        }
        catch (InvalidLoginException e) {
            LOG.debug("Could not load saved user login info. Ignoring", (Throwable)e);
        }
        if (!Objects.equals(newUserLoginInfo, prevUserLoginInfo)) {
            JFDialogs.create().message("Save login details now? (password is never saved)").buttonTypes(ButtonType.YES, ButtonType.NO).showWarning().filter(response -> response == ButtonType.YES).ifPresent(response -> this.userLoginInfoManager.save(newUserLoginInfo));
        }
        boolean success = true;
        try {
            for (X509Certificate cert : loggedInUser.getClientCertificateChain()) {
                cert.checkValidity();
            }
            problem = null;
        }
        catch (CertificateExpiredException e) {
            problem = "certificate has expired.";
        }
        catch (CertificateNotYetValidException e) {
            problem = "certificate is not yet valid";
        }
        if (problem != null) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Certificate problem");
            alert.setHeaderText("Warning: " + problem);
            alert.setContentText("There is a problem with your certificate, which will likely cause all calls to fail.\nSince this is an advanced login dialog, you can continue if you really wish.\nThe problem is: " + problem + "\n\nDo you really want to continue login?");
            alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            alert.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO, ButtonType.CANCEL});
            alert.setResizable(true);
            Optional reply = alert.showAndWait();
            if (!reply.isPresent() || reply.get() != ButtonType.YES) {
                success = false;
            }
        }
        if (success) {
            this.result = loggedInUser;
            this.close();
        }
        LOG.debug("Advanced User Login window 'login' handled: success={}", (Object)success);
    }

    @FXML
    public void nologin() {
        LOG.debug("Advanced User Login window 'skip login' button pressed: skipping login");
        this.result = null;
        this.close();
    }

    private void close() {
        ((Stage)this.loginButton.getScene().getWindow()).close();
    }

    @FXML
    public void saveConfig() {
        this.userLoginInfoManager.save((UserLoginInfo)this.userLoginInfo.get());
    }

    @FXML
    public void loadConfig() {
        try {
            this.userLoginInfo.set((Object)this.userLoginInfoManager.load());
        }
        catch (InvalidLoginException e) {
            LOG.error("Loading previous UserLoginInfo failed", (Throwable)e);
            this.userLoginInfo.set(null);
        }
    }

    @FXML
    public void resetConfig() {
        this.userLoginInfo.set((Object)this.userLoginInfoManager.reset());
        new Alert(Alert.AlertType.INFORMATION, "User Login settings were reset to defaults", new ButtonType[0]).showAndWait();
    }

    @FXML
    private void browseForCertificateFile() {
        FileChooser fileChooser = new FileChooser();
        File file = fileChooser.showOpenDialog(null);
        if (file != null) {
            this.pemKeyCertInputFromFileField.setText(file.getAbsolutePath());
            this.blockTextAreaUpdate_eventhelper = true;
            this.guiToModel();
            this.blockTextAreaUpdate_eventhelper = false;
            this.modelToGUI_input();
        }
    }

    private void loadCertificateFile(@Nonnull File file) {
        try {
            if (this.loginTypeKeyCertAutoRadioButton.isSelected()) {
                this.userLoginInfo.set((Object)this.userLoginInfoFactory.createKeyCertFileUserLoginInfo(file));
            } else {
                GeniUrn userUrn = GeniUrn.parse((String)this.defaultLoginPanelUserUrnField.getText());
                this.userLoginInfo.set((Object)this.userLoginInfoFactory.createKeyCertFileUserLoginInfo(file, userUrn, this.defaultLoginPanelSliceAuthNameChooserController.getSelectedServer()));
            }
        }
        catch (IOException e) {
            this.showError(e);
        }
    }

    @FXML
    private void loadCertificateURL() {
        try {
            URL url = new URL(this.pemKeyCertInputFromURLField.getText());
            if (this.loginTypeKeyCertAutoRadioButton.isSelected()) {
                this.userLoginInfo.set((Object)this.userLoginInfoFactory.createKeyCertUrlUserLoginInfo(url));
            } else {
                GeniUrn userUrn = GeniUrn.parse((String)this.defaultLoginPanelUserUrnField.getText());
                this.userLoginInfo.set((Object)this.userLoginInfoFactory.createKeyCertUrlUserLoginInfo(url, userUrn, this.defaultLoginPanelSliceAuthNameChooserController.getSelectedServer()));
            }
        }
        catch (IOException e) {
            this.showError(e);
        }
    }

    @FXML
    private void showAbout() {
    }

    @FXML
    private void clearJfedDir() {
        JFedCommonDialogs.requestEraseJFedConfiguration(this.loginButton.getScene().getWindow());
    }

    public GeniUser getResult() {
        return this.result;
    }

    public UserLoginInfo getUserLoginInfo() {
        return (UserLoginInfo)this.userLoginInfo.get();
    }

    private static enum ValidationStyle {
        ERROR,
        WARNING,
        OK,
        EXPLICIT_OK;

    }
}

