/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.util;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;

public class BetterTextFieldTableCell<S, T>
extends TableCell<S, T> {
    private TextField textField;
    private final ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty((Object)this, "converter");

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> forTableColumn() {
        return BetterTextFieldTableCell.forTableColumn(new DefaultStringConverter());
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> converter) {
        return list -> new TextFieldTableCell(converter);
    }

    public BetterTextFieldTableCell() {
        this(null);
    }

    public BetterTextFieldTableCell(StringConverter<T> converter) {
        this.getStyleClass().add((Object)"text-field-table-cell");
        this.setConverter(converter);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public void startEdit() {
        if (!(this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable())) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            if (this.textField == null) {
                this.textField = BetterTextFieldTableCell.createTextField(this, this.getConverter());
            }
            BetterTextFieldTableCell.startEdit(this, this.getConverter(), null, null, this.textField);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        BetterTextFieldTableCell.cancelEdit(this, this.getConverter(), null);
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        BetterTextFieldTableCell.updateItem(this, this.getConverter(), null, null, this.textField);
    }

    private static <T> void updateItem(Cell<T> cell, StringConverter<T> converter, TextField textField) {
        BetterTextFieldTableCell.updateItem(cell, converter, null, null, textField);
    }

    private static <T> void updateItem(Cell<T> cell, StringConverter<T> converter, HBox hbox, Node graphic, TextField textField) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setGraphic(null);
        } else if (cell.isEditing()) {
            if (textField != null) {
                textField.setText(BetterTextFieldTableCell.getItemText(cell, converter));
            }
            cell.setText(null);
            if (graphic != null) {
                hbox.getChildren().setAll((Object[])new Node[]{graphic, textField});
                cell.setGraphic((Node)hbox);
            } else {
                cell.setGraphic((Node)textField);
            }
        } else {
            cell.setText(BetterTextFieldTableCell.getItemText(cell, converter));
            cell.setGraphic(graphic);
        }
    }

    private static <T> TextField createTextField(Cell<T> cell, StringConverter<T> converter) {
        TextField textField = new TextField(BetterTextFieldTableCell.getItemText(cell, converter));
        textField.setOnAction(event -> {
            if (converter == null) {
                throw new IllegalStateException("Attempting to convert text input into Object, but provided StringConverter is null. Be sure to set a StringConverter in your cell factory.");
            }
            cell.commitEdit(converter.fromString(textField.getText()));
            event.consume();
        });
        textField.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                cell.cancelEdit();
                t.consume();
            }
        });
        textField.focusedProperty().addListener(observable -> {
            if (!textField.isFocused()) {
                cell.commitEdit(converter.fromString(textField.getText()));
            }
        });
        return textField;
    }

    private static <T> void startEdit(Cell<T> cell, StringConverter<T> converter, HBox hbox, Node graphic, TextField textField) {
        if (textField != null) {
            textField.setText(BetterTextFieldTableCell.getItemText(cell, converter));
        }
        cell.setText(null);
        if (graphic != null) {
            hbox.getChildren().setAll((Object[])new Node[]{graphic, textField});
            cell.setGraphic((Node)hbox);
        } else {
            cell.setGraphic((Node)textField);
        }
        textField.selectAll();
        textField.requestFocus();
    }

    private static <T> void cancelEdit(Cell<T> cell, StringConverter<T> converter, Node graphic) {
        cell.setText(BetterTextFieldTableCell.getItemText(cell, converter));
        cell.setGraphic(graphic);
    }

    private static <T> String getItemText(Cell<T> cell, StringConverter<T> converter) {
        return converter == null ? (cell.getItem() == null ? "" : cell.getItem().toString()) : converter.toString(cell.getItem());
    }
}

