/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.util;

import java.io.File;
import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class BindingsUtil {
    public static BooleanBinding instanceOfBinding(final ObservableValue observableValue, final Class clazz) {
        if (observableValue == null) {
            throw new NullPointerException("ObservableValue cannot be null");
        }
        if (clazz == null) {
            throw new NullPointerException("Class cannot be null");
        }
        return new BooleanBinding(){
            {
                super.bind(new Observable[]{observableValue});
            }

            public void dispose() {
                super.unbind(new Observable[]{observableValue});
            }

            protected boolean computeValue() {
                return clazz.isInstance(observableValue.getValue());
            }

            public ObservableList<?> getDependencies() {
                return FXCollections.singletonObservableList((Object)observableValue);
            }
        };
    }

    public static BooleanBinding matchesRegexBinding(final ObservableStringValue observableStringValue, final Pattern pattern) {
        return new BooleanBinding(){
            {
                super.bind(new Observable[]{observableStringValue});
            }

            protected boolean computeValue() {
                return pattern.matcher((CharSequence)observableStringValue.get()).matches();
            }
        };
    }

    public static BooleanBinding isValidNewFileName(final ObservableStringValue observableStringValue) {
        return new BooleanBinding(){
            {
                super.bind(new Observable[]{observableStringValue});
            }

            protected boolean computeValue() {
                String value = (String)observableStringValue.get();
                if (value == null) {
                    return false;
                }
                File file = new File(value);
                return file.getParentFile() != null && file.getParentFile().exists();
            }
        };
    }
}

