/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.util;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javax.inject.Inject;

public class EditableStringListPanel
extends BorderPane {
    private final ListProperty<String> list = new SimpleListProperty(FXCollections.observableArrayList());
    private final BooleanProperty editable = new SimpleBooleanProperty(true);
    @FXML
    protected Button addButton;
    @FXML
    protected Button deleteButton;
    @FXML
    protected ListView<String> listView;

    @Inject
    public EditableStringListPanel() {
    }

    public BooleanProperty editableProperty() {
        return this.editable;
    }

    public boolean getEditable() {
        return this.editable.get();
    }

    public void setEditable(boolean edit) {
        this.editable.set(edit);
    }

    @FXML
    private void initialize() {
        this.listView.setItems(this.list);
        this.listView.setEditable(true);
        this.listView.setCellFactory(stringListView -> new StringEditingCell());
        this.addButton.visibleProperty().bind((ObservableValue)this.editable);
        this.deleteButton.visibleProperty().bind((ObservableValue)this.editable);
    }

    public ListProperty<String> listProperty() {
        return this.list;
    }

    @FXML
    private void add() {
        String newItem = "new item";
        this.list.add((Object)newItem);
        this.listView.edit(this.list.indexOf((Object)newItem));
    }

    @FXML
    private void delete() {
        int selectedIndex = this.listView.getSelectionModel().getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.list.size()) {
            this.list.remove(selectedIndex);
        }
    }

    class StringEditingCell
    extends ListCell<String> {
        private TextField textField;

        public void startEdit() {
            if (!this.isEmpty()) {
                super.startEdit();
                this.createTextField();
                this.setText(null);
                this.setGraphic((Node)this.textField);
                this.textField.selectAll();
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(null);
            }
        }

        private void createTextField() {
            this.textField = new TextField(this.getString());
            this.textField.editableProperty().bind((ObservableValue)EditableStringListPanel.this.editable);
            this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
            this.textField.focusedProperty().addListener((arg0, arg1, arg2) -> {
                if (!arg2.booleanValue()) {
                    this.commitEdit(this.textField.getText());
                }
            });
        }

        private String getString() {
            return this.getItem() == null ? "" : (String)this.getItem();
        }
    }
}

