/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.util;

import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;

public class ExpandableHelp
extends HBox {
    private final StringProperty text = new SimpleStringProperty();
    private final Label iconLabel;
    private final Label textLabel;
    private final BooleanProperty expanded = new SimpleBooleanProperty(false);
    private final boolean popup;

    public ExpandableHelp() {
        this("", false);
    }

    public ExpandableHelp(String helpText) {
        this(helpText, false);
    }

    public ExpandableHelp(String helpText, boolean showInitially) {
        this.text.set((Object)helpText);
        this.expanded.set(showInitially);
        this.popup = helpText.length() > 200;
        this.iconLabel = new Label("help");
        this.iconLabel.getStyleClass().add((Object)"helpIco");
        this.iconLabel.managedProperty().bind((ObservableValue)this.iconLabel.visibleProperty());
        this.textLabel = new Label();
        this.textLabel.getStyleClass().add((Object)"helpLabel");
        this.textLabel.setWrapText(true);
        this.textLabel.managedProperty().bind((ObservableValue)this.textLabel.visibleProperty());
        this.textLabel.setVisible(showInitially);
        if (this.popup) {
            this.textLabel.setText("Click to see help");
        } else {
            this.textLabel.textProperty().bind((ObservableValue)this.text);
        }
        this.getChildren().addAll((Object[])new Node[]{this.iconLabel, this.textLabel});
        this.iconLabel.setOnMouseClicked(mouseEvent -> {
            if (!this.popup) {
                this.expanded.set(!this.expanded.get());
            } else {
                JFDialogs.create().owner((Node)this.textLabel).message((String)this.text.get()).showInformation();
            }
        });
        this.iconLabel.setOnMouseEntered(mouseEvent -> this.textLabel.setVisible(true));
        this.iconLabel.setOnMouseExited(mouseEvent -> {
            if (!this.expanded.get()) {
                this.textLabel.setVisible(false);
            }
        });
        this.expanded.addListener((observableValue, aBoolean, aBoolean1) -> this.textLabel.setVisible(this.expanded.get()));
    }

    public String getText() {
        return (String)this.text.get();
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setExpanded(boolean expanded) {
        this.expanded.set(expanded);
    }

    public boolean getExpanded() {
        return this.expanded.get();
    }

    public BooleanProperty expandedProperty() {
        return this.expanded;
    }
}

