/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.util;

import be.iminds.ilabt.jfed.util.library.ExtraInfoCallback;
import be.iminds.ilabt.jfed.util.library.LoginInfo;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtraInfoCallBackGUIs {
    private static final Logger LOG = LoggerFactory.getLogger(ExtraInfoCallBackGUIs.class);
    private static boolean prepared = false;

    public static void prepareExtraInfoCallback(final Window window) {
        if (prepared) {
            return;
        }
        ExtraInfoCallback.setAnyLoginCallback((ExtraInfoCallback.AnyLoginCallback)new ExtraInfoCallback.AnyLoginCallback(){
            private LoginInfo cachedLogin = null;
            private boolean loginScreenShown = false;

            private Pair<String, String> showLoginScreen(String friendlyServiceName) {
                HBox hboxUserName = new HBox(10.0);
                hboxUserName.getChildren().add((Object)new ImageView(ExtraInfoCallBackGUIs.class.getResource("images/user.png").toExternalForm()));
                TextField txUserName = new TextField();
                txUserName.setPromptText("User Name");
                hboxUserName.getChildren().add((Object)txUserName);
                HBox hboxPassword = new HBox(10.0);
                hboxPassword.getChildren().add((Object)new ImageView(ExtraInfoCallBackGUIs.class.getResource("images/lock.png").toExternalForm()));
                PasswordField txPassword = new PasswordField();
                txPassword.setPromptText("Password");
                hboxPassword.getChildren().add((Object)txPassword);
                VBox content = new VBox(10.0);
                Label lbMessage = new Label("Please enter your " + friendlyServiceName + " credentials:");
                content.getChildren().add((Object)lbMessage);
                content.getChildren().add((Object)hboxUserName);
                content.getChildren().add((Object)hboxPassword);
                Dialog dlg = new Dialog();
                dlg.initOwner(window);
                dlg.setTitle(friendlyServiceName + " Login");
                DialogPane dlgPane = new DialogPane();
                dlgPane.setContent((Node)content);
                dlgPane.setGraphic((Node)new ImageView(ExtraInfoCallBackGUIs.class.getResource("images/login.png").toExternalForm()));
                ButtonType loginButtonType = new ButtonType("Login", ButtonBar.ButtonData.OK_DONE);
                ButtonType noAccountButtonType = new ButtonType("I don't have a " + friendlyServiceName + " account", ButtonBar.ButtonData.CANCEL_CLOSE);
                dlgPane.getButtonTypes().setAll((Object[])new ButtonType[]{loginButtonType, noAccountButtonType});
                dlg.setDialogPane(dlgPane);
                Platform.runLater(() -> ((TextField)txUserName).requestFocus());
                Optional response = dlg.showAndWait();
                return response.isPresent() && response.get() == loginButtonType ? new Pair((Object)txUserName.getText(), (Object)txPassword.getText()) : null;
            }

            public LoginInfo getLogin(String serviceName, String friendlyServiceName) {
                if (!this.loginScreenShown) {
                    Pair res = null;
                    if (Platform.isFxApplicationThread()) {
                        res = this.showLoginScreen(friendlyServiceName);
                    } else {
                        FutureTask<Pair> futureTask = new FutureTask<Pair>(() -> this.showLoginScreen(friendlyServiceName));
                        Platform.runLater(futureTask);
                        try {
                            res = futureTask.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            LOG.error("Error while showing " + friendlyServiceName + " login screen", (Throwable)e);
                        }
                    }
                    this.cachedLogin = res == null ? null : new LoginInfo(serviceName, (String)res.getKey(), (String)res.getValue());
                    this.loginScreenShown = true;
                }
                if (this.cachedLogin == null) {
                    throw new ExtraInfoCallback.NoAccountException();
                }
                return this.cachedLogin;
            }
        });
        prepared = true;
    }
}

